/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.geom.Vec2;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.util.Scaling;
import arc.util.Tmp;
import mindustry.graphics.Pal;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Tile;

public class MirrorFilter
extends GenerateFilter {
    private static final Vec2 v1 = new Vec2();
    private static final Vec2 v2 = new Vec2();
    private static final Vec2 v3 = new Vec2();
    public int angle = 45;
    public boolean rotate = false;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("angle", () -> this.angle, f -> {
            this.angle = (int)f;
        }, 0.0f, 360.0f, 15.0f), new FilterOption.ToggleOption("rotate", () -> this.rotate, f -> {
            this.rotate = f;
        })};
    }

    @Override
    public char icon() {
        return '\uf8ce';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        v1.trnsExact(this.angle - 90, 1.0f);
        v2.set(v1).scl(-1.0f);
        v1.add((float)in.width / 2.0f - 0.5f, (float)in.height / 2.0f - 0.5f);
        v2.add((float)in.width / 2.0f - 0.5f, (float)in.height / 2.0f - 0.5f);
        v3.set(in.x, in.y);
        if (!this.left(v1, v2, v3)) {
            this.mirror(in.width, in.height, v3, MirrorFilter.v1.x, MirrorFilter.v1.y, MirrorFilter.v2.x, MirrorFilter.v2.y);
            Tile tile = in.tile(MirrorFilter.v3.x, MirrorFilter.v3.y);
            in.floor = tile.floor();
            if (!tile.block().synthetic()) {
                in.block = tile.block();
            }
            in.overlay = tile.overlay();
        }
    }

    @Override
    public void draw(Image image) {
        super.draw(image);
        float imageGetWidth = image.getWidth() / 2.0f;
        float imageGetHeight = image.getHeight() / 2.0f;
        float size = Math.max(imageGetWidth, imageGetHeight);
        Vec2 vsize = Scaling.fit.apply(image.getDrawable().getMinWidth(), image.getDrawable().getMinHeight(), imageGetWidth, imageGetHeight);
        Tmp.v1.trns(this.angle - 90, size);
        this.clipHalfLine(Tmp.v1, -vsize.x, -vsize.y, vsize.x, vsize.y);
        Tmp.v2.set(Tmp.v1).scl(-1.0f);
        Tmp.v1.add(imageGetWidth + image.x, imageGetHeight + image.y);
        Tmp.v2.add(imageGetWidth + image.x, imageGetHeight + image.y);
        Lines.stroke(Scl.scl(3.0f), Pal.accent);
        Lines.line(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y);
        Draw.reset();
    }

    void mirror(int width, int height, Vec2 p, float x0, float y0, float x1, float y1) {
        if (width != height && this.angle % 90 != 0 || this.rotate) {
            p.x = (float)width - p.x - 1.0f;
            p.y = (float)height - p.y - 1.0f;
        } else {
            float dx = x1 - x0;
            float dy = y1 - y0;
            float a = (dx * dx - dy * dy) / (dx * dx + dy * dy);
            float b = 2.0f * dx * dy / (dx * dx + dy * dy);
            p.set(a * (p.x - x0) + b * (p.y - y0) + x0, b * (p.x - x0) - a * (p.y - y0) + y0);
        }
    }

    boolean left(Vec2 a, Vec2 b, Vec2 c) {
        return (b.x - a.x) * (c.y - a.y) > (b.y - a.y) * (c.x - a.x);
    }

    void clipHalfLine(Vec2 v, float xmin, float ymin, float xmax, float ymax) {
        v.scl(1.0f / Math.max(Math.abs(v.x < 0.0f ? v.x / xmin : v.x / xmax), Math.abs(v.y < 0.0f ? v.y / ymin : v.y / ymax)));
    }
}

