/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.audio.Sound;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Func;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.ControlPathfinder;
import mindustry.ai.Pathfinder;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.core.UI;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Leg;
import mindustry.entities.abilities.Ability;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Crawlc;
import mindustry.gen.EntityMapping;
import mindustry.gen.Legsc;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Sounds;
import mindustry.gen.Tankc;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import mindustry.gen.WaterMovec;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.logic.LAccess;
import mindustry.logic.Senseable;
import mindustry.type.AmmoType;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.PayloadStack;
import mindustry.type.StatusEffect;
import mindustry.type.Weapon;
import mindustry.type.ammo.ItemAmmoType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class UnitType
extends UnlockableContent
implements Senseable {
    public static final float shadowTX = -12.0f;
    public static final float shadowTY = -13.0f;
    private static final Vec2 legOffset = new Vec2();
    public int envRequired = 0;
    public int envEnabled = 1;
    public int envDisabled = 16;
    public float speed = 1.1f;
    public float boostMultiplier = 1.0f;
    public float rotateSpeed = 5.0f;
    public float baseRotateSpeed = 5.0f;
    public float drag = 0.3f;
    public float accel = 0.5f;
    public float hitSize = 6.0f;
    public float stepShake = -1.0f;
    public float rippleScale = 1.0f;
    public float riseSpeed = 0.08f;
    public float fallSpeed = 0.018f;
    public float missileAccelTime = 0.0f;
    public float health = 200.0f;
    public float armor = 0.0f;
    public float range = -1.0f;
    public float maxRange = -1.0f;
    public float mineRange = 70.0f;
    public float buildRange = 220.0f;
    public float crashDamageMultiplier = 1.0f;
    public float dpsEstimate = -1.0f;
    public float clipSize = -1.0f;
    public float drownTimeMultiplier = 1.0f;
    public float strafePenalty = 0.5f;
    public float researchCostMultiplier = 50.0f;
    public float groundLayer = 60.0f;
    public float payloadCapacity = 8.0f;
    public float buildSpeed = -1.0f;
    public float aimDst = -1.0f;
    public float buildBeamOffset = 3.8f;
    public float targetPriority = 0.0f;
    public float shadowElevation = -1.0f;
    public float shadowElevationScl = 1.0f;
    public float engineOffset = 5.0f;
    public float engineSize = 2.5f;
    public float engineLayer = -1.0f;
    public float itemOffsetY = 3.0f;
    public float lightRadius = -1.0f;
    public float lightOpacity = 0.6f;
    public float fogRadius = -1.0f;
    public float waveTrailX = 4.0f;
    public float waveTrailY = -3.0f;
    public float trailScl = 1.0f;
    public boolean isEnemy = true;
    public boolean flying = false;
    public boolean targetAir = true;
    public boolean targetGround = true;
    public boolean faceTarget = true;
    public boolean circleTarget = false;
    public boolean canBoost = false;
    public boolean logicControllable = true;
    public boolean playerControllable = true;
    public boolean allowedInPayloads = true;
    public boolean hittable = true;
    public boolean killable = true;
    public boolean targetable = true;
    public boolean vulnerableWithPayloads = false;
    public boolean pickupUnits = true;
    public boolean physics = true;
    public boolean canDrown = true;
    public boolean useUnitCap = true;
    public boolean coreUnitDock = false;
    public boolean createWreck = true;
    public boolean createScorch = true;
    public boolean lowAltitude = false;
    public boolean rotateToBuilding = true;
    public boolean allowLegStep = false;
    public boolean legPhysicsLayer = true;
    public boolean hovering = false;
    public boolean omniMovement = true;
    public boolean rotateMoveFirst = false;
    public boolean healFlash = true;
    public boolean canHeal = false;
    public boolean singleTarget = false;
    public boolean forceMultiTarget = false;
    public boolean canAttack = true;
    public boolean hidden = false;
    public boolean internal = false;
    public boolean bounded = true;
    public boolean naval = false;
    public boolean autoFindTarget = true;
    public boolean alwaysShootWhenMoving = false;
    public boolean hoverable = true;
    public boolean alwaysCreateOutline = false;
    public boolean squareShape = false;
    public boolean drawBuildBeam = true;
    public boolean drawCell = true;
    public boolean drawItems = true;
    public boolean drawShields = true;
    public boolean drawBody = true;
    public boolean drawMinimap = true;
    public Prov<? extends UnitController> aiController = () -> !this.flying ? new GroundAI() : new FlyingAI();
    public Func<Unit, ? extends UnitController> controller = u -> !this.playerControllable || u.team.isAI() && !u.team.rules().rtsAi ? this.aiController.get() : new CommandAI();
    public Prov<? extends Unit> constructor;
    public Seq<Ability> abilities = new Seq();
    public Seq<Weapon> weapons = new Seq();
    public ObjectSet<StatusEffect> immunities = new ObjectSet();
    public Color healColor = Pal.heal;
    public Color lightColor = Pal.powerLight;
    public Sound deathSound = Sounds.bang;
    public Sound loopSound = Sounds.none;
    public float loopSoundVolume = 0.5f;
    public Effect fallEffect = Fx.fallSmoke;
    public Effect fallEngineEffect = Fx.fallSmoke;
    public Effect deathExplosionEffect = Fx.dynamicExplosion;
    @Nullable
    public Effect treadEffect;
    public Seq<DrawPart> parts = new Seq(DrawPart.class);
    public Seq<UnitEngine> engines = new Seq();
    public boolean useEngineElevation = true;
    @Nullable
    public Color engineColor = null;
    public Color engineColorInner = Color.white;
    public int trailLength = 0;
    @Nullable
    public Color trailColor;
    @Nullable
    public Pathfinder.PathCost pathCost;
    @Nullable
    public Unit sample;
    public BlockFlag[] targetFlags = new BlockFlag[]{null};
    public UnitCommand[] commands = new UnitCommand[0];
    @Nullable
    public UnitCommand defaultCommand;
    public Color outlineColor = Pal.darkerMetal;
    public int outlineRadius = 3;
    public boolean outlines = true;
    public int itemCapacity = -1;
    public int ammoCapacity = -1;
    public AmmoType ammoType = new ItemAmmoType(Items.copper);
    public int mineTier = -1;
    public float mineSpeed = 1.0f;
    public boolean mineWalls = false;
    public boolean mineFloor = true;
    public boolean mineHardnessScaling = true;
    public Sound mineSound = Sounds.minebeam;
    public float mineSoundVolume = 0.6f;
    public Seq<Item> mineItems = Seq.with(Items.copper, Items.lead, Items.titanium, Items.thorium);
    public int legCount = 4;
    public int legGroupSize = 2;
    public float legLength = 10.0f;
    public float legSpeed = 0.1f;
    public float legForwardScl = 1.0f;
    public float legBaseOffset = 0.0f;
    public float legMoveSpace = 1.0f;
    public float legExtension = 0.0f;
    public float legPairOffset = 0.0f;
    public float legLengthScl = 1.0f;
    public float legStraightLength = 1.0f;
    public float legMaxLength = 1.75f;
    public float legMinLength = 0.0f;
    public float legSplashDamage = 0.0f;
    public float legSplashRange = 5.0f;
    public float baseLegStraightness = 0.0f;
    public float legStraightness = 0.0f;
    public boolean lockLegBase = false;
    public boolean legContinuousMove;
    public boolean flipBackLegs = true;
    public boolean flipLegSide = false;
    public float mechLandShake = 0.0f;
    public float mechSideSway = 0.54f;
    public float mechFrontSway = 0.1f;
    public float mechStride = -1.0f;
    public boolean mechStepParticles = false;
    public Color mechLegColor = Pal.darkMetal;
    public Rect[] treadRects = new Rect[0];
    public int treadFrames = 18;
    public int treadPullOffset = 0;
    public int segments = 0;
    public float segmentMag = 2.0f;
    public float segmentScl = 4.0f;
    public float segmentPhase = 5.0f;
    public float segmentRotSpeed = 1.0f;
    public float segmentMaxRot = 30.0f;
    public float crawlSlowdown = 0.5f;
    public float crushDamage = 0.0f;
    public float crawlSlowdownFrac = 0.55f;
    public float lifetime = 300.0f;
    public float homingDelay = 10.0f;
    public TextureRegion baseRegion;
    public TextureRegion legRegion;
    public TextureRegion region;
    public TextureRegion previewRegion;
    public TextureRegion shadowRegion;
    public TextureRegion cellRegion;
    public TextureRegion itemCircleRegion;
    public TextureRegion softShadowRegion;
    public TextureRegion jointRegion;
    public TextureRegion footRegion;
    public TextureRegion legBaseRegion;
    public TextureRegion baseJointRegion;
    public TextureRegion outlineRegion;
    public TextureRegion treadRegion;
    public TextureRegion[] wreckRegions;
    public TextureRegion[] segmentRegions;
    public TextureRegion[] segmentOutlineRegions;
    public TextureRegion[][] treadRegions;
    protected float buildTime = -1.0f;
    @Nullable
    protected ItemStack[] totalRequirements;
    @Nullable
    protected ItemStack[] cachedRequirements;
    @Nullable
    protected ItemStack[] firstRequirements;

    public UnitType(String name) {
        super(name);
        this.constructor = EntityMapping.map(this.name);
        this.selectionSize = 30.0f;
    }

    public UnitController createController(Unit unit) {
        return this.controller.get(unit);
    }

    public Unit create(Team team) {
        Unit unit = this.constructor.get();
        unit.team = team;
        unit.setType(this);
        unit.ammo = this.ammoCapacity;
        unit.elevation = this.flying ? 1.0f : 0.0f;
        unit.heal();
        if (unit instanceof TimedKillc) {
            TimedKillc u = (TimedKillc)((Object)unit);
            u.lifetime(this.lifetime);
        }
        return unit;
    }

    public Unit spawn(Team team, float x, float y) {
        Unit out = this.create(team);
        out.set(x, y);
        out.add();
        return out;
    }

    public Unit spawn(float x, float y) {
        return this.spawn(Vars.state.rules.defaultTeam, x, y);
    }

    public Unit spawn(Team team, Position pos) {
        return this.spawn(team, pos.getX(), pos.getY());
    }

    public Unit spawn(Position pos) {
        return this.spawn(Vars.state.rules.defaultTeam, pos);
    }

    public Unit spawn(Position pos, Team team) {
        return this.spawn(team, pos);
    }

    public boolean hasWeapons() {
        return this.weapons.size > 0;
    }

    public boolean targetable(Unit unit, Team targeter) {
        Payloadc p;
        return this.targetable || this.vulnerableWithPayloads && unit instanceof Payloadc && (p = (Payloadc)((Object)unit)).hasPayload();
    }

    public boolean hittable(Unit unit) {
        Payloadc p;
        return this.hittable || this.vulnerableWithPayloads && unit instanceof Payloadc && (p = (Payloadc)((Object)unit)).hasPayload();
    }

    public void update(Unit unit) {
    }

    public void updatePayload(Unit unit, @Nullable Unit unitHolder, @Nullable Building buildingHolder) {
    }

    public void killed(Unit unit) {
    }

    public void landed(Unit unit) {
    }

    public void display(Unit unit, Table table) {
        table.table(t -> {
            t.left();
            t.add(new Image(this.uiIcon)).size(32.0f).scaling(Scaling.fit);
            t.labelWrap(unit.isPlayer() ? unit.getPlayer().coloredName() + "\n[lightgray]" + this.localizedName : this.localizedName).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
        table.row();
        table.table(bars -> {
            bars.defaults().growX().height(20.0f).pad(4.0f);
            bars.add(new Bar("stat.health", Pal.health, unit::healthf).blink(Color.white));
            bars.row();
            if (Vars.state.rules.unitAmmo) {
                bars.add(new Bar(this.ammoType.icon() + " " + Core.bundle.get("stat.ammo"), this.ammoType.barColor(), () -> unit.ammo / (float)this.ammoCapacity));
                bars.row();
            }
            for (Ability ability : unit.abilities) {
                ability.displayBars(unit, (Table)bars);
            }
            if (this.payloadCapacity > 0.0f && unit instanceof Payloadc) {
                Payloadc payload = (Payloadc)((Object)unit);
                bars.add(new Bar("stat.payloadcapacity", Pal.items, () -> payload.payloadUsed() / unit.type().payloadCapacity));
                bars.row();
                float[] count = new float[]{-1.0f};
                bars.table().update((T t) -> {
                    if (count[0] != payload.payloadUsed()) {
                        payload.contentInfo((Table)t, 16.0f, 270.0f);
                        count[0] = payload.payloadUsed();
                    }
                }).growX().left().height(0.0f).pad(0.0f);
            }
        }).growX();
        UnitController unitController = unit.controller();
        if (unitController instanceof LogicAI) {
            LogicAI ai = (LogicAI)unitController;
            table.row();
            table.add(Blocks.microProcessor.emoji() + " " + Core.bundle.get("units.processorcontrol")).growX().wrap().left();
            if (ai.controller != null && (Core.settings.getBool("mouseposition") || Core.settings.getBool("position"))) {
                table.row();
                table.add("[lightgray](" + ai.controller.tileX() + ", " + ai.controller.tileY() + ")").growX().wrap().left();
            }
            table.row();
            table.label(() -> "\ue87c " + (long)unit.flag + "").color(Color.lightGray).growX().wrap().left();
            if (Vars.net.active() && ai.controller != null && ai.controller.lastAccessed != null) {
                table.row();
                table.add(Core.bundle.format("lastaccessed", ai.controller.lastAccessed)).growX().wrap().left();
            }
        } else if (Vars.net.active() && unit.lastCommanded != null) {
            table.row();
            table.add(Core.bundle.format("lastcommanded", unit.lastCommanded)).growX().wrap().left();
        }
        table.row();
    }

    public boolean supportsEnv(int env) {
        return (this.envEnabled & env) != 0 && (this.envDisabled & env) == 0 && (this.envRequired == 0 || (this.envRequired & env) == this.envRequired);
    }

    public boolean isBanned() {
        return Vars.state.rules.isBanned(this);
    }

    @Override
    public void getDependencies(Cons<UnlockableContent> cons) {
        for (Block block : Vars.content.blocks()) {
            if (!(block instanceof Reconstructor)) continue;
            Reconstructor r = (Reconstructor)block;
            for (UnitType[] recipe : r.upgrades) {
                if (recipe[1] != this) continue;
                cons.get(block);
            }
        }
        for (ItemStack stack : this.researchRequirements()) {
            cons.get(stack.item);
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setStats() {
        ItemStack[] reqs;
        this.stats.add(Stat.health, this.health);
        this.stats.add(Stat.armor, this.armor);
        this.stats.add(Stat.speed, this.speed * 60.0f / 8.0f, StatUnit.tilesSecond);
        this.stats.add(Stat.size, StatValues.squared(this.hitSize / 8.0f, StatUnit.blocks));
        this.stats.add(Stat.itemCapacity, this.itemCapacity);
        this.stats.add(Stat.range, (int)(this.maxRange / 8.0f), StatUnit.blocks);
        if (this.abilities.any()) {
            this.stats.add(Stat.abilities, StatValues.abilities(this.abilities));
        }
        this.stats.add(Stat.flying, this.flying);
        if (!this.flying) {
            this.stats.add(Stat.canBoost, this.canBoost);
        }
        if (this.mineTier >= 1) {
            this.stats.addPercent(Stat.mineSpeed, this.mineSpeed);
            this.stats.add(Stat.mineTier, StatValues.drillables(this.mineSpeed, 1.0f, 1.0f, null, b -> {
                block3: {
                    block2: {
                        if (b.itemDrop == null) return false;
                        if (!(b instanceof Floor)) break block2;
                        Floor f = (Floor)b;
                        if (f.wallOre && this.mineWalls || !f.wallOre && this.mineFloor) break block3;
                    }
                    if (b instanceof Floor) return false;
                    if (!this.mineWalls) return false;
                }
                if (b.itemDrop.hardness > this.mineTier) return false;
                if (!b.playerUnmineable) return true;
                if (!Core.settings.getBool("doubletapmine")) return false;
                return true;
            }));
        }
        if (this.buildSpeed > 0.0f) {
            this.stats.addPercent(Stat.buildSpeed, this.buildSpeed);
        }
        if (this.sample instanceof Payloadc) {
            this.stats.add(Stat.payloadCapacity, StatValues.squared(Mathf.sqrt(this.payloadCapacity / 64.0f), StatUnit.blocks));
        }
        if ((reqs = this.getFirstRequirements()) != null) {
            this.stats.add(Stat.buildCost, StatValues.items(reqs));
        }
        if (this.weapons.any()) {
            this.stats.add(Stat.weapons, StatValues.weapons(this, this.weapons));
        }
        if (this.immunities.size > 0) {
            Seq<StatusEffect> imm = this.immunities.toSeq().sort();
            if (this.naval) {
                imm.remove(StatusEffects.wet);
            }
            this.stats.add(Stat.immunities, StatValues.statusEffects(imm));
        }
    }

    protected void validateWeapons() {
        for (int i = 0; i < this.weapons.size; ++i) {
            Weapon wep = this.weapons.get(i);
            if (wep.bullet != Bullets.placeholder && wep.bullet != null) continue;
            throw new RuntimeException("Unit: " + this.name + ": weapon #" + i + " ('" + wep.name + "') does not have a bullet defined. Make sure you have a bullet: (JSON) or `bullet = ` field in your unit definition.");
        }
    }

    @Override
    public void init() {
        boolean skipWeapons;
        if (this.constructor == null) {
            throw new IllegalArgumentException("no constructor set up for unit '" + this.name + "'");
        }
        Unit example = this.constructor.get();
        this.allowLegStep = example instanceof Legsc;
        if (example instanceof WaterMovec) {
            this.naval = true;
            this.canDrown = false;
            this.omniMovement = false;
            this.immunities.add(StatusEffects.wet);
            if (this.shadowElevation < 0.0f) {
                this.shadowElevation = 0.11f;
            }
        }
        if (this.pathCost == null) {
            Pathfinder.PathCost pathCost = this.naval ? ControlPathfinder.costNaval : (this.allowLegStep || example instanceof Crawlc ? ControlPathfinder.costLegs : (this.pathCost = this.hovering ? ControlPathfinder.costHover : ControlPathfinder.costGround));
        }
        if (this.flying) {
            this.envEnabled |= 2;
        }
        if (this.lightRadius == -1.0f) {
            this.lightRadius = Math.max(60.0f, this.hitSize * 2.3f);
        }
        this.autoFindTarget = !this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.shootStatus.speedMultiplier < 0.99f))) || this.alwaysShootWhenMoving;
        this.clipSize = Math.max(this.clipSize, this.lightRadius * 1.1f);
        boolean bl = this.singleTarget = this.weapons.size <= 1 && !this.forceMultiTarget;
        if (this.itemCapacity < 0) {
            this.itemCapacity = Math.max(Mathf.round((int)(this.hitSize * 4.0f), 10), 10);
        }
        float margin = 4.0f;
        boolean bl2 = skipWeapons = !this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> !w.useAttackRange)));
        if (this.range < 0.0f) {
            this.range = Float.MAX_VALUE;
            for (Weapon weapon : this.weapons) {
                if (!weapon.useAttackRange && skipWeapons) continue;
                this.range = Math.min(this.range, weapon.range() - margin);
                this.maxRange = Math.max(this.maxRange, weapon.range() - margin);
            }
        }
        if (this.maxRange < 0.0f) {
            this.maxRange = Math.max(0.0f, this.range);
            for (Weapon weapon : this.weapons) {
                if (!weapon.useAttackRange && skipWeapons) continue;
                this.maxRange = Math.max(this.maxRange, weapon.range() - margin);
            }
        }
        if (this.fogRadius < 0.0f) {
            this.fogRadius = Math.max(174.0f, this.hitSize * 2.0f) / 8.0f;
        }
        if (this.weapons.isEmpty()) {
            this.range = this.maxRange = this.mineRange;
        }
        if (this.mechStride < 0.0f) {
            this.mechStride = 4.0f + (this.hitSize - 8.0f) / 2.1f;
        }
        if (this.aimDst < 0.0f) {
            float f = this.aimDst = this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> !w.rotate))) ? this.hitSize * 2.0f : this.hitSize / 2.0f;
        }
        if (this.stepShake < 0.0f) {
            this.stepShake = Mathf.round((this.hitSize - 11.0f) / 9.0f);
            boolean bl3 = this.mechStepParticles = this.hitSize > 15.0f;
        }
        if (this.engineSize > 0.0f) {
            this.engines.add(new UnitEngine(0.0f, -this.engineOffset, this.engineSize, -90.0f));
        }
        if (this.treadEffect == null) {
            this.treadEffect = new Effect(50.0f, e -> {
                Draw.color(Tmp.c1.set(e.color).mul(1.5f));
                Fx.rand.setSeed(e.id);
                for (int i = 0; i < 3; ++i) {
                    Fx.v.trns(e.rotation + Fx.rand.range(40.0f), Fx.rand.random(6.0f * e.finpow()));
                    Fill.circle(e.x + Fx.v.x + Fx.rand.range(4.0f), e.y + Fx.v.y + Fx.rand.range(4.0f), Math.min(e.fout(), e.fin() * e.lifetime / 8.0f) * this.hitSize / 28.0f * 3.0f * Fx.rand.random(0.8f, 1.1f) + 0.3f);
                }
            }).layer(20.0f);
        }
        for (Ability ability : this.abilities) {
            ability.init(this);
        }
        Seq<Weapon> mapped = new Seq<Weapon>();
        for (Weapon w2 : this.weapons) {
            if (w2.recoilTime < 0.0f) {
                w2.recoilTime = w2.reload;
            }
            mapped.add(w2);
            if (!w2.mirror) continue;
            Weapon copy = w2.copy();
            copy.flip();
            mapped.add(copy);
            w2.recoilTime *= 2.0f;
            copy.recoilTime *= 2.0f;
            w2.reload *= 2.0f;
            copy.reload *= 2.0f;
            w2.otherSide = mapped.size - 1;
            copy.otherSide = mapped.size - 2;
        }
        this.weapons = mapped;
        this.weapons.each(Weapon::init);
        this.canHeal = this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.heals())));
        this.canAttack = this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> !w.noAttack)));
        if (this.commands.length == 0) {
            Seq<UnitCommand> seq = new Seq<UnitCommand>(UnitCommand.class);
            seq.add(UnitCommand.moveCommand);
            if (this.canBoost) {
                seq.add(UnitCommand.boostCommand);
            }
            if (this.flying) {
                if (this.canHeal) {
                    seq.add(UnitCommand.repairCommand);
                }
                if (this.buildSpeed > 0.0f) {
                    seq.add(UnitCommand.rebuildCommand, UnitCommand.assistCommand);
                }
                if (this.mineTier > 0) {
                    seq.add(UnitCommand.mineCommand);
                }
            }
            this.commands = (UnitCommand[])seq.toArray();
        }
        if (this.ammoCapacity < 0) {
            float f = this.weapons.sumf(w -> w.useAmmo ? 60.0f / w.reload : 0.0f);
            float targetSeconds = 35.0f;
            this.ammoCapacity = Math.max(1, (int)(f * targetSeconds));
        }
        this.estimateDps();
        this.sample = this.constructor.get();
    }

    public float estimateDps() {
        if (this.dpsEstimate < 0.0f) {
            this.dpsEstimate = this.weapons.sumf(Weapon::dps);
            if (this.weapons.contains((Weapon)((Object)((Boolf<Weapon>)w -> w.bullet.killShooter)))) {
                this.dpsEstimate /= 25.0f;
            }
        }
        return this.dpsEstimate;
    }

    @Override
    public void load() {
        int i;
        super.load();
        for (DrawPart part : this.parts) {
            part.load(this.name);
        }
        this.weapons.each(Weapon::load);
        this.region = Core.atlas.find(this.name);
        this.previewRegion = Core.atlas.find(this.name + "-preview", this.name);
        this.legRegion = Core.atlas.find(this.name + "-leg");
        this.jointRegion = Core.atlas.find(this.name + "-joint");
        this.baseJointRegion = Core.atlas.find(this.name + "-joint-base");
        this.footRegion = Core.atlas.find(this.name + "-foot");
        this.treadRegion = Core.atlas.find(this.name + "-treads");
        this.itemCircleRegion = Core.atlas.find("ring-item");
        if (this.treadRegion.found()) {
            this.treadRegions = new TextureRegion[this.treadRects.length][this.treadFrames];
            for (int r = 0; r < this.treadRects.length; ++r) {
                for (int i2 = 0; i2 < this.treadFrames; ++i2) {
                    this.treadRegions[r][i2] = Core.atlas.find(this.name + "-treads" + r + "-" + i2);
                }
            }
        }
        this.legBaseRegion = Core.atlas.find(this.name + "-leg-base", this.name + "-leg");
        this.baseRegion = Core.atlas.find(this.name + "-base");
        this.cellRegion = Core.atlas.find(this.name + "-cell", Core.atlas.find("power-cell"));
        this.softShadowRegion = this.squareShape ? Core.atlas.find("square-shadow") : (this.hitSize <= 10.0f || Core.settings != null && Core.settings.getBool("linear", true) ? Core.atlas.find("particle") : Core.atlas.find("circle-shadow"));
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
        this.shadowRegion = this.fullIcon;
        this.wreckRegions = new TextureRegion[3];
        for (i = 0; i < this.wreckRegions.length; ++i) {
            this.wreckRegions[i] = Core.atlas.find(this.name + "-wreck" + i);
        }
        this.segmentRegions = new TextureRegion[this.segments];
        this.segmentOutlineRegions = new TextureRegion[this.segments];
        for (i = 0; i < this.segments; ++i) {
            this.segmentRegions[i] = Core.atlas.find(this.name + "-segment" + i);
            this.segmentOutlineRegions[i] = Core.atlas.find(this.name + "-segment-outline" + i);
        }
        this.clipSize = Math.max((float)this.region.width * 2.0f, this.clipSize);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        for (Weapon weapon : this.weapons) {
            for (DrawPart part : weapon.parts) {
                part.getOutlines(out);
            }
        }
        for (DrawPart part : this.parts) {
            part.getOutlines(out);
        }
    }

    public boolean needsBodyOutline() {
        return this.alwaysCreateOutline;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        if (this.constructor == null) {
            throw new IllegalArgumentException("No constructor set up for unit '" + this.name + "'. Make sure you assign a valid value to `constructor`, e.g. `constructor = UnitEntity::new`");
        }
        this.sample = this.constructor.get();
        Seq<TextureRegion> toOutline = new Seq<TextureRegion>();
        this.getRegionsToOutline(toOutline);
        for (TextureRegion textureRegion : toOutline) {
            if (!(textureRegion instanceof TextureAtlas.AtlasRegion)) continue;
            TextureAtlas.AtlasRegion atlas = (TextureAtlas.AtlasRegion)textureRegion;
            String regionName = atlas.name;
            Pixmap outlined = Pixmaps.outline(Core.atlas.getPixmap(textureRegion), this.outlineColor, this.outlineRadius);
            Drawf.checkBleed(outlined);
            packer.add(MultiPacker.PageType.main, regionName + "-outline", outlined);
        }
        if (this.outlines) {
            Seq<TextureRegion> outlineSeq = Seq.with(this.region, this.jointRegion, this.footRegion, this.baseJointRegion, this.legRegion, this.treadRegion);
            if (Core.atlas.has(this.name + "-leg-base")) {
                outlineSeq.add(this.legBaseRegion);
            }
            for (TextureRegion outlineTarget : outlineSeq) {
                if (!outlineTarget.found()) continue;
                this.makeOutline(MultiPacker.PageType.main, packer, outlineTarget, this.alwaysCreateOutline && this.region == outlineTarget, this.outlineColor, this.outlineRadius);
            }
            if (this.sample instanceof Crawlc) {
                void var4_7;
                boolean bl = false;
                while (var4_7 < this.segments) {
                    this.makeOutline(packer, this.segmentRegions[var4_7], this.name + "-segment-outline" + (int)var4_7, this.outlineColor, this.outlineRadius);
                    ++var4_7;
                }
            }
            for (Weapon weapon : this.weapons) {
                if (weapon.name.isEmpty() || this.minfo.mod != null && !weapon.name.startsWith(this.minfo.mod.name) || !weapon.top && packer.isOutlined(weapon.name) && !weapon.parts.contains((DrawPart)((Object)((Boolf<DrawPart>)p -> p.under)))) continue;
                this.makeOutline(MultiPacker.PageType.main, packer, weapon.region, !weapon.top || weapon.parts.contains((DrawPart)((Object)((Boolf<DrawPart>)p -> p.under))), this.outlineColor, this.outlineRadius);
            }
        }
        if (this.sample instanceof Tankc) {
            void var4_11;
            PixmapRegion pix = Core.atlas.getPixmap(this.treadRegion);
            boolean bl = false;
            while (var4_11 < this.treadRects.length) {
                Rect treadRect = this.treadRects[var4_11];
                Pixmap slice = pix.crop((int)(treadRect.x + (float)pix.width / 2.0f), (int)(treadRect.y + (float)pix.height / 2.0f), 1, (int)treadRect.height);
                int frames = this.treadFrames;
                for (int i = 0; i < frames; ++i) {
                    int pullOffset = this.treadPullOffset;
                    Pixmap frame = new Pixmap(slice.width, slice.height);
                    for (int y = 0; y < slice.height; ++y) {
                        int idx = y + i;
                        if (idx >= slice.height) {
                            idx -= slice.height;
                            idx += pullOffset;
                            idx = Mathf.mod(idx, slice.height);
                        }
                        frame.setRaw(0, y, slice.getRaw(0, idx));
                    }
                    packer.add(MultiPacker.PageType.main, this.name + "-treads" + (int)var4_11 + "-" + i, frame);
                }
                ++var4_11;
            }
        }
    }

    public float getBuildTime() {
        this.getTotalRequirements();
        return this.buildTime;
    }

    public ItemStack[] getTotalRequirements() {
        if (this.totalRequirements == null) {
            UnitType[] ret = new UnitType[]{null};
            float[] timeret = new float[]{0.0f};
            ItemStack[] result = this.getRequirements(ret, timeret);
            this.totalRequirements = ItemStack.empty;
            if (result != null) {
                ItemSeq total = new ItemSeq();
                total.add(result);
                if (ret[0] != null) {
                    total.add(ret[0].getTotalRequirements());
                }
                this.totalRequirements = total.toArray();
            }
            for (ItemStack stack : this.totalRequirements) {
                this.buildTime += stack.item.cost * (float)stack.amount;
            }
        }
        return this.totalRequirements;
    }

    @Nullable
    public ItemStack[] getRequirements(@Nullable UnitType[] prevReturn, @Nullable float[] timeReturn) {
        Object t;
        Reconstructor rec = (Reconstructor)Vars.content.blocks().find(b -> {
            if (!(b instanceof Reconstructor)) return false;
            Reconstructor re = (Reconstructor)b;
            if (!re.upgrades.contains((UnitType[])((Boolf<UnitType[]>)u -> u[1] == this))) return false;
            return true;
        });
        if (rec != null && (t = rec.findConsumer(i -> i instanceof ConsumeItems)) instanceof ConsumeItems) {
            ConsumeItems ci = (ConsumeItems)t;
            if (prevReturn != null) {
                prevReturn[0] = rec.upgrades.find(u -> u[1] == this)[0];
            }
            if (timeReturn != null) {
                timeReturn[0] = rec.constructTime;
            }
            return ci.items;
        }
        UnitFactory factory = (UnitFactory)Vars.content.blocks().find(u -> {
            if (!(u instanceof UnitFactory)) return false;
            UnitFactory uf = (UnitFactory)u;
            if (!uf.plans.contains((UnitFactory.UnitPlan)((Object)((Boolf<UnitFactory.UnitPlan>)p -> p.unit == this)))) return false;
            return true;
        });
        if (factory != null) {
            UnitFactory.UnitPlan plan = factory.plans.find(p -> p.unit == this);
            if (timeReturn != null) {
                timeReturn[0] = plan.time;
            }
            return plan.requirements;
        }
        UnitAssembler assembler = (UnitAssembler)Vars.content.blocks().find(u -> {
            if (!(u instanceof UnitAssembler)) return false;
            UnitAssembler a = (UnitAssembler)u;
            if (!a.plans.contains((UnitAssembler.AssemblerUnitPlan)((Object)((Boolf<UnitAssembler.AssemblerUnitPlan>)p -> p.unit == this)))) return false;
            return true;
        });
        if (assembler != null) {
            UnitAssembler.AssemblerUnitPlan plan = assembler.plans.find(p -> p.unit == this);
            if (timeReturn != null) {
                timeReturn[0] = plan.time;
            }
            ItemSeq reqs = new ItemSeq();
            for (PayloadStack bstack : plan.requirements) {
                UnlockableContent unlockableContent = bstack.item;
                if (unlockableContent instanceof Block) {
                    Block block = (Block)unlockableContent;
                    for (ItemStack stack : block.requirements) {
                        reqs.add(stack.item, stack.amount * bstack.amount);
                    }
                    continue;
                }
                UnlockableContent unlockableContent2 = bstack.item;
                if (!(unlockableContent2 instanceof UnitType)) continue;
                UnitType unit = (UnitType)unlockableContent2;
                for (ItemStack stack : unit.getTotalRequirements()) {
                    reqs.add(stack.item, stack.amount * bstack.amount);
                }
            }
            return reqs.toArray();
        }
        return null;
    }

    @Nullable
    public ItemStack[] getFirstRequirements() {
        if (this.firstRequirements == null) {
            this.firstRequirements = this.getRequirements(null, null);
        }
        return this.firstRequirements;
    }

    @Override
    public ItemStack[] researchRequirements() {
        if (this.cachedRequirements != null) {
            return this.cachedRequirements;
        }
        ItemStack[] stacks = this.getRequirements(null, null);
        if (stacks != null) {
            ItemStack[] out = new ItemStack[stacks.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = new ItemStack(stacks[i].item, UI.roundAmount((int)(Math.pow(stacks[i].amount, 1.1) * (double)this.researchCostMultiplier)));
            }
            out = Structs.filter(ItemStack.class, out, stack -> stack.amount > 0);
            this.cachedRequirements = out;
            return out;
        }
        return super.researchRequirements();
    }

    @Override
    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case health: 
            case maxHealth: {
                d = this.health;
                break;
            }
            case size: {
                d = this.hitSize / 8.0f;
                break;
            }
            case itemCapacity: {
                d = this.itemCapacity;
                break;
            }
            case speed: {
                d = this.speed * 60.0f / 8.0f;
                break;
            }
            case id: {
                d = this.getLogicId();
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        if (sensor == LAccess.name) {
            return this.name;
        }
        return noSensed;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.unit;
    }

    public void setEnginesMirror(UnitEngine ... array) {
        for (UnitEngine base : array) {
            this.engines.add(base);
            UnitEngine engine = base.copy();
            engine.x *= -1.0f;
            engine.rotation = 180.0f - engine.rotation;
            if (engine.rotation < 0.0f) {
                engine.rotation += 360.0f;
            }
            this.engines.add(engine);
        }
    }

    public void draw(Unit unit) {
        float z;
        Mechc mech;
        if (unit.inFogTo(Vars.player.team())) {
            return;
        }
        boolean isPayload = !unit.isAdded();
        Mechc mechc = mech = unit instanceof Mechc ? (Mechc)((Object)unit) : null;
        float f = isPayload ? Draw.z() : (unit.elevation > 0.5f ? (this.lowAltitude ? 90.0f : 115.0f) : (z = this.groundLayer + Mathf.clamp(this.hitSize / 4000.0f, 0.0f, 0.01f)));
        if (unit.controller().isBeingControlled(Vars.player.unit())) {
            this.drawControl(unit);
        }
        if (!isPayload && (unit.isFlying() || this.shadowElevation > 0.0f)) {
            Draw.z(Math.min(80.0f, z - 1.0f));
            this.drawShadow(unit);
        }
        Draw.z(z - 0.02f);
        if (mech != null) {
            this.drawMech(mech);
            legOffset.trns(mech.baseRotation(), 0.0f, Mathf.lerp(Mathf.sin(mech.walkExtend(true), 0.63661975f, 1.0f) * this.mechSideSway, 0.0f, unit.elevation));
            legOffset.add(Tmp.v1.trns(mech.baseRotation() + 90.0f, 0.0f, Mathf.lerp(Mathf.sin(mech.walkExtend(true), 0.31830987f, 1.0f) * this.mechFrontSway, 0.0f, unit.elevation)));
            unit.trns(UnitType.legOffset.x, UnitType.legOffset.y);
        }
        if (unit instanceof Tankc) {
            this.drawTank((Unit)((Object)((Tankc)((Object)unit))));
        }
        if (unit instanceof Legsc && !isPayload) {
            this.drawLegs((Unit)((Object)((Legsc)((Object)unit))));
        }
        Draw.z(Math.min(z - 0.01f, 99.0f));
        if (unit instanceof Payloadc) {
            this.drawPayload((Unit)((Object)((Payloadc)((Object)unit))));
        }
        this.drawSoftShadow(unit);
        Draw.z(z);
        if (unit instanceof Crawlc) {
            Crawlc c = (Crawlc)((Object)unit);
            this.drawCrawl(c);
        }
        if (this.drawBody) {
            this.drawOutline(unit);
        }
        this.drawWeaponOutlines(unit);
        if (this.engineLayer > 0.0f) {
            Draw.z(this.engineLayer);
        }
        if (!(this.trailLength <= 0 || this.naval || !unit.isFlying() && this.useEngineElevation)) {
            this.drawTrail(unit);
        }
        if (this.engines.size > 0) {
            this.drawEngines(unit);
        }
        Draw.z(z);
        if (this.drawBody) {
            this.drawBody(unit);
        }
        if (this.drawCell) {
            this.drawCell(unit);
        }
        this.drawWeapons(unit);
        if (this.drawItems) {
            this.drawItems(unit);
        }
        this.drawLight(unit);
        if (unit.shieldAlpha > 0.0f && this.drawShields) {
            this.drawShield(unit);
        }
        if (this.parts.size > 0) {
            for (int i = 0; i < this.parts.size; ++i) {
                WeaponMount first;
                DrawPart part = this.parts.get(i);
                WeaponMount weaponMount = first = unit.mounts.length > part.weaponIndex ? unit.mounts[part.weaponIndex] : null;
                if (first != null) {
                    DrawPart.params.set(first.warmup, first.reload / this.weapons.first().reload, first.smoothReload, first.heat, first.recoil, first.charge, unit.x, unit.y, unit.rotation);
                } else {
                    DrawPart.params.set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, unit.x, unit.y, unit.rotation);
                }
                if (unit instanceof Scaled) {
                    Scaled s = (Scaled)((Object)unit);
                    DrawPart.params.life = s.fin();
                }
                part.draw(DrawPart.params);
            }
        }
        if (!isPayload) {
            for (Ability a : unit.abilities) {
                Draw.reset();
                a.draw(unit);
            }
        }
        if (mech != null) {
            unit.trns(-UnitType.legOffset.x, -UnitType.legOffset.y);
        }
        Draw.reset();
    }

    public <T extends Unit> void drawPayload(T unit) {
        if (((Payloadc)((Object)unit)).hasPayload()) {
            Payload pay = ((Payloadc)((Object)unit)).payloads().first();
            pay.set(unit.x, unit.y, unit.rotation);
            pay.draw();
        }
    }

    public void drawShield(Unit unit) {
        float alpha = unit.shieldAlpha();
        float radius = unit.hitSize() * 1.3f;
        Fill.light(unit.x, unit.y, Lines.circleVertices(radius), radius, Color.clear, Tmp.c2.set(unit.team.color).lerp(Color.white, Mathf.clamp(unit.hitTime() / 2.0f)).a(0.7f * alpha));
    }

    public void drawControl(Unit unit) {
        Draw.z(unit.isFlying() ? 90.0f : 58.0f);
        Draw.color(Pal.accent, Color.white, Mathf.absin(4.0f, 0.3f));
        Lines.poly(unit.x, unit.y, 4, unit.hitSize + 1.5f);
        Draw.reset();
    }

    public void drawShadow(Unit unit) {
        float e = Mathf.clamp(unit.elevation, this.shadowElevation, 1.0f) * this.shadowElevationScl * (1.0f - unit.drownTime);
        float x = unit.x + -12.0f * e;
        float y = unit.y + -13.0f * e;
        Floor floor = Vars.world.floorWorld(x, y);
        float dest = floor.canShadow ? 1.0f : 0.0f;
        unit.shadowAlpha = unit.shadowAlpha < 0.0f ? dest : Mathf.approachDelta(unit.shadowAlpha, dest, 0.11f);
        Draw.color(Pal.shadow, Pal.shadow.a * unit.shadowAlpha);
        Draw.rect(this.shadowRegion, unit.x + -12.0f * e, unit.y + -13.0f * e, unit.rotation - 90.0f);
        Draw.color();
    }

    public void drawSoftShadow(Unit unit) {
        this.drawSoftShadow(unit, 1.0f);
    }

    public void drawSoftShadow(Unit unit, float alpha) {
        this.drawSoftShadow(unit.x, unit.y, unit.rotation, alpha);
    }

    public void drawSoftShadow(float x, float y, float rotation, float alpha) {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f * alpha);
        float rad = 1.6f;
        float size = (float)Math.max(this.region.width, this.region.height) * this.region.scl();
        Draw.rect(this.softShadowRegion, x, y, size * rad * Draw.xscl, size * rad * Draw.yscl, rotation - 90.0f);
        Draw.color();
    }

    public void drawItems(Unit unit) {
        this.applyColor(unit);
        if (unit.item() != null && unit.itemTime > 0.01f) {
            float size = (5.0f + Mathf.absin(Time.time, 5.0f, 1.0f)) * unit.itemTime;
            Draw.mixcol(Pal.accent, Mathf.absin(Time.time, 5.0f, 0.1f));
            Draw.rect(unit.item().fullIcon, unit.x + Angles.trnsx(unit.rotation + 180.0f, this.itemOffsetY), unit.y + Angles.trnsy(unit.rotation + 180.0f, this.itemOffsetY), size, size, unit.rotation);
            Draw.mixcol();
            size = ((3.0f + Mathf.absin(Time.time, 5.0f, 1.0f)) * unit.itemTime + 0.5f) * 2.0f;
            Draw.color(Pal.accent);
            Draw.rect(this.itemCircleRegion, unit.x + Angles.trnsx(unit.rotation + 180.0f, this.itemOffsetY), unit.y + Angles.trnsy(unit.rotation + 180.0f, this.itemOffsetY), size, size);
            if (unit.isLocal() && !Vars.renderer.pixelator.enabled()) {
                Fonts.outline.draw(unit.stack.amount + "", unit.x + Angles.trnsx(unit.rotation + 180.0f, this.itemOffsetY), unit.y + Angles.trnsy(unit.rotation + 180.0f, this.itemOffsetY) - 3.0f, Pal.accent, 0.25f * unit.itemTime / Scl.scl(1.0f), false, 1);
            }
            Draw.reset();
        }
    }

    public void drawTrail(Unit unit) {
        if (unit.trail == null) {
            unit.trail = new Trail(this.trailLength);
        }
        Trail trail = unit.trail;
        trail.draw(this.trailColor == null ? unit.team.color : this.trailColor, (this.engineSize + Mathf.absin(Time.time, 2.0f, this.engineSize / 4.0f) * (this.useEngineElevation ? unit.elevation : 1.0f)) * this.trailScl);
    }

    public void drawEngines(Unit unit) {
        float f = this.useEngineElevation ? unit.elevation : 1.0f;
        if (f <= 1.0E-4f) {
            return;
        }
        for (UnitEngine engine : this.engines) {
            engine.draw(unit);
        }
        Draw.color();
    }

    public void drawWeapons(Unit unit) {
        this.applyColor(unit);
        for (WeaponMount mount : unit.mounts) {
            mount.weapon.draw(unit, mount);
        }
        Draw.reset();
    }

    public void drawWeaponOutlines(Unit unit) {
        this.applyColor(unit);
        this.applyOutlineColor(unit);
        for (WeaponMount mount : unit.mounts) {
            if (mount.weapon.top) continue;
            float z = Draw.z();
            Draw.z(z + mount.weapon.layerOffset);
            mount.weapon.drawOutline(unit, mount);
            Draw.z(z);
        }
        Draw.reset();
    }

    public void drawOutline(Unit unit) {
        Draw.reset();
        if (Core.atlas.isFound(this.outlineRegion)) {
            this.applyColor(unit);
            this.applyOutlineColor(unit);
            Draw.rect(this.outlineRegion, unit.x, unit.y, unit.rotation - 90.0f);
            Draw.reset();
        }
    }

    public void drawBody(Unit unit) {
        this.applyColor(unit);
        Draw.rect(this.region, unit.x, unit.y, unit.rotation - 90.0f);
        Draw.reset();
    }

    public void drawCell(Unit unit) {
        this.applyColor(unit);
        Draw.color(this.cellColor(unit));
        Draw.rect(this.cellRegion, unit.x, unit.y, unit.rotation - 90.0f);
        Draw.reset();
    }

    public Color cellColor(Unit unit) {
        float f = Mathf.clamp(unit.healthf());
        return Tmp.c1.set(Color.black).lerp(unit.team.color, f + Mathf.absin(Time.time, Math.max(f * 5.0f, 1.0f), 1.0f - f));
    }

    public void drawLight(Unit unit) {
        if (this.lightRadius > 0.0f) {
            Drawf.light(unit.x, unit.y, this.lightRadius, this.lightColor, this.lightOpacity);
        }
    }

    public <T extends Unit> void drawTank(T unit) {
        Draw.rect(this.treadRegion, unit.x, unit.y, unit.rotation - 90.0f);
        if (this.treadRegion.found()) {
            int frame = (int)((Tankc)((Object)unit)).treadTime() % this.treadFrames;
            for (int i = 0; i < this.treadRects.length; ++i) {
                TextureRegion region = this.treadRegions[i][frame];
                Rect treadRect = this.treadRects[i];
                float xOffset = -(treadRect.x + treadRect.width / 2.0f);
                float yOffset = -(treadRect.y + treadRect.height / 2.0f);
                for (int side : Mathf.signs) {
                    Tmp.v1.set(xOffset * (float)side, yOffset).rotate(unit.rotation - 90.0f);
                    Draw.rect(region, unit.x + Tmp.v1.x / 4.0f, unit.y + Tmp.v1.y / 4.0f, treadRect.width / 4.0f, (float)region.height * region.scale / 4.0f, unit.rotation - 90.0f);
                }
            }
        }
    }

    public <T extends Unit> void drawLegs(T unit) {
        int j;
        this.applyColor(unit);
        Tmp.c3.set(Draw.getMixColor());
        Leg[] legs = ((Legsc)((Object)unit)).legs();
        float ssize = (float)this.footRegion.width * this.footRegion.scl() * 1.5f;
        float rotation = ((Legsc)((Object)unit)).baseRotation();
        float invDrown = 1.0f - unit.drownTime;
        if (this.footRegion.found()) {
            for (Leg leg : legs) {
                Drawf.shadow(leg.base.x, leg.base.y, ssize, invDrown);
            }
        }
        for (j = legs.length - 1; j >= 0; --j) {
            int i = j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2;
            Leg leg = legs[i];
            boolean flip = (float)i >= (float)legs.length / 2.0f;
            int flips = Mathf.sign(flip);
            Vec2 position = ((Legsc)((Object)unit)).legOffset(legOffset, i).add(unit);
            Tmp.v1.set(leg.base).sub(leg.joint).inv().setLength(this.legExtension);
            if (this.footRegion.found() && leg.moving && this.shadowElevation > 0.0f) {
                float scl = this.shadowElevation * invDrown;
                float elev = Mathf.slope(1.0f - leg.stage) * scl;
                Draw.color(Pal.shadow);
                Draw.rect(this.footRegion, leg.base.x + -12.0f * elev, leg.base.y + -13.0f * elev, position.angleTo(leg.base));
                Draw.color();
            }
            Draw.mixcol(Tmp.c3, Tmp.c3.a);
            if (this.footRegion.found()) {
                Draw.rect(this.footRegion, leg.base.x, leg.base.y, position.angleTo(leg.base));
            }
            Lines.stroke((float)this.legRegion.height * this.legRegion.scl() * (float)flips);
            Lines.line(this.legRegion, position.x, position.y, leg.joint.x, leg.joint.y, false);
            Lines.stroke((float)this.legBaseRegion.height * this.legRegion.scl() * (float)flips);
            Lines.line(this.legBaseRegion, leg.joint.x + Tmp.v1.x, leg.joint.y + Tmp.v1.y, leg.base.x, leg.base.y, false);
            if (!this.jointRegion.found()) continue;
            Draw.rect(this.jointRegion, leg.joint.x, leg.joint.y);
        }
        if (this.baseJointRegion.found()) {
            for (j = legs.length - 1; j >= 0; --j) {
                Vec2 position = ((Legsc)((Object)unit)).legOffset(legOffset, j % 2 == 0 ? j / 2 : legs.length - 1 - j / 2).add(unit);
                Draw.rect(this.baseJointRegion, position.x, position.y, rotation);
            }
        }
        if (this.baseRegion.found()) {
            Draw.rect(this.baseRegion, unit.x, unit.y, rotation - 90.0f);
        }
        Draw.reset();
    }

    public void drawCrawl(Crawlc crawl) {
        Unit unit = (Unit)((Object)crawl);
        this.applyColor(unit);
        for (int p = 0; p < 2; ++p) {
            TextureRegion[] regions = p == 0 ? this.segmentOutlineRegions : this.segmentRegions;
            for (int i = 0; i < this.segments; ++i) {
                float trns = Mathf.sin(crawl.crawlTime() + (float)i * this.segmentPhase, this.segmentScl, this.segmentMag);
                float rot = Mathf.slerp(crawl.segmentRot(), unit.rotation, (float)i / (float)(this.segments - 1));
                float tx = Angles.trnsx(rot, trns);
                float ty = Angles.trnsy(rot, trns);
                Draw.color(0.0f, 0.0f, 0.0f, 0.2f);
                this.applyColor(unit);
                Draw.rect(regions[i], unit.x + tx, unit.y + ty, rot - 90.0f);
            }
        }
    }

    public void drawMech(Mechc mech) {
        Floor floor;
        Unit unit = (Unit)((Object)mech);
        Draw.reset();
        float e = unit.elevation;
        float sin = Mathf.lerp(Mathf.sin(mech.walkExtend(true), 0.63661975f, 1.0f), 0.0f, e);
        float extension = Mathf.lerp(mech.walkExtend(false), 0.0f, e);
        float boostTrns = e * 2.0f;
        Floor floor2 = floor = unit.isFlying() ? Blocks.air.asFloor() : unit.floorOn();
        if (floor.isLiquid) {
            Draw.color(Color.white, floor.mapColor, 0.5f);
        }
        for (int i : Mathf.signs) {
            Draw.mixcol(Tmp.c1.set(this.mechLegColor).lerp(Color.white, Mathf.clamp(unit.hitTime)), Math.max(Math.max(0.0f, (float)i * extension / this.mechStride), unit.hitTime));
            Draw.rect(this.legRegion, unit.x + Angles.trnsx(mech.baseRotation(), extension * (float)i - boostTrns, -boostTrns * (float)i), unit.y + Angles.trnsy(mech.baseRotation(), extension * (float)i - boostTrns, -boostTrns * (float)i), (float)this.legRegion.width * this.legRegion.scl() * (float)i, (float)this.legRegion.height * this.legRegion.scl() * (1.0f - Math.max(-sin * (float)i, 0.0f) * 0.5f), mech.baseRotation() - 90.0f + 35.0f * (float)i * e);
        }
        Draw.mixcol(Color.white, unit.hitTime);
        if (unit.lastDrownFloor != null) {
            Draw.color(Color.white, Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.83f), unit.drownTime * 0.9f);
        } else {
            Draw.color(Color.white);
        }
        Draw.rect(this.baseRegion, unit, mech.baseRotation() - 90.0f);
        Draw.mixcol();
    }

    public void applyOutlineColor(Unit unit) {
        if (unit.drownTime > 0.0f && unit.lastDrownFloor != null) {
            Draw.color(Color.white, Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.8f), unit.drownTime * 0.9f);
        }
    }

    public void applyColor(Unit unit) {
        Draw.color();
        if (this.healFlash) {
            Tmp.c1.set(Color.white).lerp(this.healColor, Mathf.clamp(unit.healTime - unit.hitTime));
        }
        Draw.mixcol(Tmp.c1, Math.max(unit.hitTime, !this.healFlash ? 0.0f : Mathf.clamp(unit.healTime)));
        if (unit.drownTime > 0.0f && unit.lastDrownFloor != null) {
            Draw.mixcol(Tmp.c1.set(unit.lastDrownFloor.mapColor).mul(0.83f), unit.drownTime * 0.9f);
        }
    }

    public static class UnitEngine
    implements Cloneable {
        public float x;
        public float y;
        public float radius;
        public float rotation;

        public UnitEngine(float x, float y, float radius, float rotation) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.rotation = rotation;
        }

        public UnitEngine() {
        }

        public void draw(Unit unit) {
            float scale;
            UnitType type = unit.type;
            float f = scale = type.useEngineElevation ? unit.elevation : 1.0f;
            if (scale <= 1.0E-4f) {
                return;
            }
            float rot = unit.rotation - 90.0f;
            Color color = type.engineColor == null ? unit.team.color : type.engineColor;
            Tmp.v1.set(this.x, this.y).rotate(rot);
            float ex = Tmp.v1.x;
            float ey = Tmp.v1.y;
            Draw.color(color);
            Fill.circle(unit.x + ex, unit.y + ey, (this.radius + Mathf.absin(Time.time, 2.0f, this.radius / 4.0f)) * scale);
            Draw.color(type.engineColorInner);
            Fill.circle(unit.x + ex - Angles.trnsx(rot + this.rotation, 1.0f), unit.y + ey - Angles.trnsy(rot + this.rotation, 1.0f), (this.radius + Mathf.absin(Time.time, 2.0f, this.radius / 4.0f)) / 2.0f * scale);
        }

        public UnitEngine copy() {
            try {
                return (UnitEngine)this.clone();
            }
            catch (CloneNotSupportedException awful) {
                throw new RuntimeException("fantastic", awful);
            }
        }
    }
}

