/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.graphics.Color;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.type.Liquid;
import mindustry.ui.Styles;
import mindustry.world.meta.StatUnit;

public class LiquidDisplay
extends Table {
    public final Liquid liquid;
    public final float amount;
    public final boolean perSecond;

    public LiquidDisplay(final Liquid liquid, final float amount, boolean perSecond) {
        this.liquid = liquid;
        this.amount = amount;
        this.perSecond = perSecond;
        this.add(new Stack(){
            {
                this.add(new Image(liquid.uiIcon).setScaling(Scaling.fit));
                if (amount != 0.0f) {
                    Table t = new Table().left().bottom();
                    t.add(Strings.autoFixed(amount, 2)).style(Styles.outlineLabel);
                    this.add(t);
                }
            }
        }).size(32.0f).padRight(3 + (amount != 0.0f && Strings.autoFixed(amount, 2).length() > 2 ? 8 : 0));
        if (perSecond) {
            this.add(StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).color(Color.lightGray).style(Styles.outlineLabel);
        }
        this.add(liquid.localizedName);
    }
}

