/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.event.ClickListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;

public class DatabaseDialog
extends BaseDialog {
    private TextField search;
    private Table all = new Table();

    public DatabaseDialog() {
        super("@database");
        this.shouldPause = true;
        this.addCloseButton();
        this.shown(this::rebuild);
        this.onResize(this::rebuild);
        this.all.margin(20.0f).marginTop(0.0f);
        this.cont.table((Table s) -> {
            s.image(Icon.zoom).padRight(8.0f);
            this.search = s.field(null, text -> this.rebuild()).growX().get();
            this.search.setMessageText("@players.search");
        }).fillX().padBottom(4.0f).row();
        this.cont.pane(this.all).scrollX(false);
    }

    void rebuild() {
        this.all.clear();
        String text = this.search.getText();
        Seq<Content>[] allContent = Vars.content.getContentMap();
        for (int j = 0; j < allContent.length; ++j) {
            ContentType type = ContentType.all[j];
            Seq array = allContent[j].select(c -> {
                UnlockableContent u;
                return c instanceof UnlockableContent && !(u = (UnlockableContent)c).isHidden() && (text.isEmpty() || u.localizedName.toLowerCase().contains(text.toLowerCase()));
            }).as();
            if (array.size == 0) continue;
            this.all.add("@content." + type.name() + ".name").growX().left().color(Pal.accent);
            this.all.row();
            this.all.image().growX().pad(5.0f).padLeft(0.0f).padRight(0.0f).height(3.0f).color(Pal.accent);
            this.all.row();
            this.all.table((Table list) -> {
                list.left();
                int cols = (int)Mathf.clamp(((float)Core.graphics.getWidth() - Scl.scl(30.0f)) / Scl.scl(44.0f), 1.0f, 22.0f);
                int count = 0;
                for (int i = 0; i < array.size; ++i) {
                    Block b;
                    UnitType u;
                    Image image;
                    UnlockableContent unlock = (UnlockableContent)array.get(i);
                    Image image2 = image = this.unlocked(unlock) ? new Image(unlock.uiIcon).setScaling(Scaling.fit) : new Image((Drawable)Icon.lock, Pal.gray);
                    if (Vars.state.isGame() && (unlock instanceof UnitType && (u = (UnitType)unlock).isBanned() || unlock instanceof Block && Vars.state.rules.isBanned(b = (Block)unlock))) {
                        list.stack(image, new Image(Icon.cancel){
                            {
                                this.setColor(Color.scarlet);
                                this.touchable = Touchable.disabled;
                            }
                        }).size(32.0f).pad(3.0f);
                    } else {
                        list.add(image).size(32.0f).pad(3.0f);
                    }
                    ClickListener listener = new ClickListener();
                    image.addListener(listener);
                    if (!Vars.mobile && this.unlocked(unlock)) {
                        image.addListener(new HandCursorListener());
                        image.update(() -> image.color.lerp(!listener.isOver() ? Color.lightGray : Color.white, Mathf.clamp(0.4f * Time.delta)));
                    }
                    if (this.unlocked(unlock)) {
                        image.clicked(() -> {
                            if (Core.input.keyDown(KeyCode.shiftLeft) && Fonts.getUnicode(unlock.name) != 0) {
                                Core.app.setClipboardText((char)Fonts.getUnicode(unlock.name) + "");
                                Vars.ui.showInfoFade("@copied");
                            } else {
                                Vars.ui.content.show(unlock);
                            }
                        });
                        image.addListener(new Tooltip(t -> t.background(Tex.button).add(unlock.localizedName + (Core.settings.getBool("console") ? "\n[gray]" + unlock.name : ""))));
                    }
                    if (++count % cols != 0) continue;
                    list.row();
                }
            }).growX().left().padBottom(10.0f);
            this.all.row();
        }
        if (this.all.getChildren().isEmpty()) {
            this.all.add("@none.found");
        }
    }

    boolean unlocked(UnlockableContent content) {
        return !Vars.state.isCampaign() && !Vars.state.isMenu() || content.unlocked();
    }
}

