/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.math.Interp;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.gen.Building;

public class BlockConfigFragment {
    Table table = new Table();
    Building selected;

    public void build(Group parent) {
        this.table.visible = false;
        parent.addChild(this.table);
        Events.on(EventType.ResetEvent.class, e -> this.forceHide());
    }

    public void forceHide() {
        this.table.visible = false;
        this.selected = null;
    }

    public boolean isShown() {
        return this.table.visible && this.selected != null;
    }

    public Building getSelected() {
        return this.selected;
    }

    public void showConfig(Building tile) {
        if (this.selected != null) {
            this.selected.onConfigureClosed();
        }
        if (tile.configTapped()) {
            this.selected = tile;
            this.table.visible = true;
            this.table.clear();
            tile.buildConfiguration(this.table);
            this.table.pack();
            this.table.setTransform(true);
            this.table.actions(Actions.scaleTo(0.0f, 1.0f), Actions.visible(true), Actions.scaleTo(1.0f, 1.0f, 0.07f, Interp.pow3Out));
            this.table.update(() -> {
                if (this.selected != null && this.selected.shouldHideConfigure(Vars.player)) {
                    this.hideConfig();
                    return;
                }
                this.table.setOrigin(1);
                if (this.selected == null || this.selected.block == Blocks.air || !this.selected.isValid()) {
                    this.hideConfig();
                } else {
                    this.selected.updateTableAlign(this.table);
                }
            });
        }
    }

    public boolean hasConfigMouse() {
        Element e = Core.scene.hit(Core.input.mouseX(), Core.graphics.getHeight() - Core.input.mouseY(), true);
        return e != null && (e == this.table || e.isDescendantOf(this.table));
    }

    public void hideConfig() {
        if (this.selected != null) {
            this.selected.onConfigureClosed();
        }
        this.selected = null;
        this.table.actions(Actions.scaleTo(0.0f, 1.0f, 0.06f, Interp.pow3Out), Actions.visible(false));
    }
}

