/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.ItemBuffer;
import mindustry.world.blocks.distribution.ItemBridge;

public class BufferedItemBridge
extends ItemBridge {
    public final int timerAccept;
    public float speed;
    public int bufferCapacity;

    public BufferedItemBridge(String name) {
        super(name);
        this.timerAccept = this.timers++;
        this.speed = 40.0f;
        this.bufferCapacity = 50;
        this.hasPower = false;
        this.hasItems = true;
        this.canOverdrive = true;
    }

    public class BufferedItemBridgeBuild
    extends ItemBridge.ItemBridgeBuild {
        ItemBuffer buffer;

        public BufferedItemBridgeBuild() {
            super(BufferedItemBridge.this);
            this.buffer = new ItemBuffer(BufferedItemBridge.this.bufferCapacity);
        }

        @Override
        public void updateTransport(Building other) {
            if (this.buffer.accepts() && this.items.total() > 0) {
                this.buffer.accept(this.items.take());
            }
            Item item = this.buffer.poll(BufferedItemBridge.this.speed / this.timeScale);
            if (this.timer(BufferedItemBridge.this.timerAccept, 4.0f / this.timeScale) && item != null && other.acceptItem(this, item)) {
                this.moved = true;
                other.handleItem(this, item);
                this.buffer.remove();
            }
        }

        @Override
        public void doDump() {
            this.dump();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            this.buffer.write(write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.buffer.read(read);
        }
    }
}

