/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.content.Blocks;
import mindustry.content.UnitTypes;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.meta.BlockGroup;

public class Router
extends Block {
    public float speed = 8.0f;

    public Router(String name) {
        super(name);
        this.solid = false;
        this.underBullets = true;
        this.update = true;
        this.hasItems = true;
        this.itemCapacity = 1;
        this.group = BlockGroup.transportation;
        this.unloadable = false;
        this.noUpdateDisabled = true;
    }

    public class RouterBuild
    extends Building
    implements ControlBlock {
        public Item lastItem;
        public Tile lastInput;
        public float time;
        @Nullable
        public BlockUnitc unit;

        @Override
        public Unit unit() {
            if (this.unit == null) {
                this.unit = (BlockUnitc)((Object)UnitTypes.block.create(this.team));
                this.unit.tile(this);
            }
            return (Unit)((Object)this.unit);
        }

        @Override
        public boolean canControl() {
            return Router.this.size == 1;
        }

        @Override
        public boolean shouldAutoTarget() {
            return false;
        }

        @Override
        public void updateTile() {
            if (this.lastItem == null && this.items.any()) {
                this.lastItem = this.items.first();
            }
            if (this.lastItem != null) {
                this.time += 1.0f / Router.this.speed * this.delta();
                Building target = this.getTileTarget(this.lastItem, this.lastInput, false);
                if (target != null && (this.time >= 1.0f || !(target.block instanceof Router) && !target.block.instantTransfer)) {
                    this.getTileTarget(this.lastItem, this.lastInput, true);
                    target.handleItem(this, this.lastItem);
                    this.items.remove(this.lastItem, 1);
                    this.lastItem = null;
                }
            }
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return 0;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.team == source.team && this.lastItem == null && this.items.total() == 0;
        }

        @Override
        public void handleItem(Building source, Item item) {
            this.items.add(item, 1);
            this.lastItem = item;
            this.time = 0.0f;
            this.lastInput = source.tile();
        }

        @Override
        public int removeStack(Item item, int amount) {
            int result = super.removeStack(item, amount);
            if (result != 0 && item == this.lastItem) {
                this.lastItem = null;
            }
            return result;
        }

        public Building getTileTarget(Item item, Tile from, boolean set) {
            if (this.unit != null && this.isControlled()) {
                Building other;
                this.unit.health(this.health);
                this.unit.ammo((float)this.unit.type().ammoCapacity * (this.items.total() > 0 ? 1.0f : 0.0f));
                this.unit.team(this.team);
                this.unit.set(this.x, this.y);
                int angle = Mathf.mod((int)((this.angleTo(this.unit.aimX(), this.unit.aimY()) + 45.0f) / 90.0f), 4);
                if (this.unit.isShooting() && (other = this.nearby(this.rotation = angle)) != null && other.acceptItem(this, item)) {
                    return other;
                }
                return null;
            }
            int counter = this.rotation;
            for (int i = 0; i < this.proximity.size; ++i) {
                Building other = (Building)this.proximity.get((i + counter) % this.proximity.size);
                if (set) {
                    this.rotation = (byte)((this.rotation + 1) % this.proximity.size);
                }
                if (other.tile == from && from.block() == Blocks.overflowGate || !other.acceptItem(this, item)) continue;
                return other;
            }
            return null;
        }
    }
}

