/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.logic.LAccess;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawPumpLiquid;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Pump
extends LiquidBlock {
    public float pumpAmount = 0.2f;
    public float consumeTime = 300.0f;
    public float warmupSpeed = 0.019f;
    public DrawBlock drawer = new DrawMulti(new DrawDefault(), new DrawPumpLiquid());

    public Pump(String name) {
        super(name);
        this.group = BlockGroup.liquids;
        this.floating = true;
        this.envEnabled = 1;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, 60.0f * this.pumpAmount * (float)this.size * (float)this.size, StatUnit.liquidSecond);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        float amount = 0.0f;
        Liquid liquidDrop = null;
        for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
            if (!this.canPump(other)) continue;
            if (liquidDrop != null && other.floor().liquidDrop != liquidDrop) {
                liquidDrop = null;
                break;
            }
            liquidDrop = other.floor().liquidDrop;
            amount += other.floor().liquidMultiplier;
        }
        if (liquidDrop != null) {
            float width = this.drawPlaceText(Core.bundle.formatFloat("bar.pumpspeed", amount * this.pumpAmount * 60.0f, 0), x, y, valid);
            float dx = (float)(x * 8) + this.offset - width / 2.0f - 4.0f;
            float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 5.0f;
            float s = 6.0f;
            float ratio = (float)liquidDrop.fullIcon.width / (float)liquidDrop.fullIcon.height;
            Draw.mixcol(Color.darkGray, 1.0f);
            Draw.rect(liquidDrop.fullIcon, dx, dy - 1.0f, s * ratio, s);
            Draw.reset();
            Draw.rect(liquidDrop.fullIcon, dx, dy, s * ratio, s);
        }
    }

    @Override
    public void load() {
        super.load();
        this.drawer.load(this);
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.finalIcons(this);
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (this.isMultiblock()) {
            Liquid last = null;
            for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
                if (other.floor().liquidDrop == null) continue;
                if (other.floor().liquidDrop != last && last != null) {
                    return false;
                }
                last = other.floor().liquidDrop;
            }
            return last != null;
        }
        return this.canPump(tile);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addLiquidBar((T build) -> build.liquidDrop);
    }

    protected boolean canPump(Tile tile) {
        return tile != null && tile.floor().liquidDrop != null;
    }

    public class PumpBuild
    extends LiquidBlock.LiquidBuild {
        public float warmup;
        public float totalProgress;
        public float consTimer;
        public float amount = 0.0f;
        @Nullable
        public Liquid liquidDrop = null;

        @Override
        public void draw() {
            Pump.this.drawer.draw(this);
        }

        @Override
        public void drawLight() {
            super.drawLight();
            Pump.this.drawer.drawLight(this);
        }

        @Override
        public void pickedUp() {
            this.amount = 0.0f;
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.efficiency) {
                return this.shouldConsume() ? (double)this.efficiency : 0.0;
            }
            if (sensor == LAccess.totalLiquids) {
                return this.liquidDrop == null ? 0.0 : (double)this.liquids.get(this.liquidDrop);
            }
            return super.sense(sensor);
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.amount = 0.0f;
            this.liquidDrop = null;
            for (Tile other : this.tile.getLinkedTiles(tempTiles)) {
                if (!Pump.this.canPump(other)) continue;
                this.liquidDrop = other.floor().liquidDrop;
                this.amount += other.floor().liquidMultiplier;
            }
        }

        @Override
        public boolean shouldConsume() {
            return this.liquidDrop != null && this.liquids.get(this.liquidDrop) < Pump.this.liquidCapacity - 0.01f && this.enabled;
        }

        @Override
        public void updateTile() {
            if (this.efficiency > 0.0f && this.liquidDrop != null) {
                float f;
                float maxPump = Math.min(Pump.this.liquidCapacity - this.liquids.get(this.liquidDrop), this.amount * Pump.this.pumpAmount * this.edelta());
                this.liquids.add(this.liquidDrop, maxPump);
                this.consTimer += this.delta();
                if (f >= Pump.this.consumeTime) {
                    this.consume();
                    this.consTimer %= 1.0f;
                }
                this.warmup = Mathf.approachDelta(this.warmup, maxPump > 0.001f ? 1.0f : 0.0f, Pump.this.warmupSpeed);
            } else {
                this.warmup = Mathf.approachDelta(this.warmup, 0.0f, Pump.this.warmupSpeed);
            }
            this.totalProgress += this.warmup * Time.delta;
            if (this.liquidDrop != null) {
                this.dumpLiquid(this.liquidDrop);
            }
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public float progress() {
            return Mathf.clamp(this.consTimer / Pump.this.consumeTime);
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }
    }
}

