/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockFlag;

public class UnitCargoUnloadPoint
extends Block {
    public float staleTimeDuration = 360.0f;
    public TextureRegion topRegion;

    public UnitCargoUnloadPoint(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.configurable = true;
        this.saveConfig = true;
        this.clearOnDoubleTap = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.unitCargoUnloadPoint});
        this.config(Item.class, (build, item) -> {
            build.item = item;
        });
        this.configClear(build -> {
            build.item = null;
        });
    }

    public class UnitCargoUnloadPointBuild
    extends Building {
        public Item item;
        public float staleTimer;
        public boolean stale;

        @Override
        public void draw() {
            super.draw();
            if (this.item != null) {
                Draw.color(this.item.color);
                Draw.rect(UnitCargoUnloadPoint.this.topRegion, this.x, this.y);
                Draw.color();
            }
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.items.total() < UnitCargoUnloadPoint.this.itemCapacity) {
                this.staleTimer = 0.0f;
                this.stale = false;
            }
            if (this.dumpAccumulate()) {
                this.staleTimer = 0.0f;
                this.stale = false;
            } else if (this.items.total() >= UnitCargoUnloadPoint.this.itemCapacity) {
                float f;
                this.staleTimer += Time.delta;
                if (f >= UnitCargoUnloadPoint.this.staleTimeDuration) {
                    this.stale = true;
                }
            }
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return Math.min(UnitCargoUnloadPoint.this.itemCapacity - this.items.total(), amount);
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(UnitCargoUnloadPoint.this, table, Vars.content.items(), () -> this.item, this::configure);
        }

        @Override
        public Object config() {
            return this.item;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.item == null ? -1 : (int)this.item.id);
            write.bool(this.stale);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.item = Vars.content.item(read.s());
            this.stale = read.bool();
        }
    }
}

