/*
    ZEsarUX  ZX Second-Emulator And Released for UniX
    Copyright (C) 2013 Cesar Hernandez Bano

    This file is part of ZEsarUX.

    ZEsarUX is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

//Para poder usar NULL
#include <stdio.h>
#include <string.h>

#include <dirent.h>

#if defined(__APPLE__)
        #include <sys/syslimits.h>
#endif

#include "charset.h"
#include "zxvision.h"

//Charset usado en la carga de custom file
unsigned char char_set_customfile[TOTAL_ASCII_CHARSET_ELEMENTS];

//Ruta al custom file que contiene un charset
char char_set_customfile_path[PATH_MAX]="";

/*

Nota sobre charsets y caracteres especiales de ventana (cierre, minimizar, maximizar etc):
Se han definido los charsets de tal manera que un icono de ventana (por ejemplo el 171 de minimizar ventana en ZEsarUX plus)
sea un caracter de minimizar ventana en cualquier charset, ya sea el mismo idéntico u otro equivalente de minimizar con otro estilo
Por ejemplo ese 171 es idéntico en todos los charsets, pero en cambio el 152 que es maximizar en amiga es otro de maximizar diferente en Beos.
O sea, se trata que el número de caracter en todos los estilos tengan el mismo significado: si es cerrar, que sea cerrar en todos,
si es maximizar, que sea maximizar en todos, aunque sea estilo diferente, pero que no cambie el significado del caracter

*/

//Puntero NULL: indica final
struct s_charset_list charset_list[]={
    {"AmigaOS",char_set_amigaos},
    {"AtariTOS",char_set_ataritos},
    {"BeOS",char_set_beos},
    {"CPC",char_set_cpc},
    {"DOS",char_set_dos},
    {"Man Software",char_set_mansoftware},
    {"MSX",char_set_msx},
    {"QL",char_set_ql},
    {"RetroMac",char_set_retromac},
    {"Sam Coupe",char_set_sam},
    {"TempleOS",char_set_templeos},
    {"Z88",char_set_z88},
    {"ZX Spectrum",char_set_spectrum},
    {"CustomFile",char_set_customfile},

    {"",NULL}
};

//char set por defecto, que corresponde a estilo gui por defecto (ZEsarUX plus)
unsigned char *char_set=char_set_ataritos;

//charset alterado por el usuario
int user_charset=-1;

void charset_retorna_nombres(void)
{
	int i;

	for (i=0;charset_list[i].puntero!=NULL;i++) {
		printf ("%s",charset_list[i].nombre);
        //coma si no es el ultimo item
        if (charset_list[i+1].puntero!=NULL) printf(",");

        printf(" ");
	}
}

//Retorna -1 si no encontrado
int get_charset_id_by_name(char *nombre)
{
    int i;

	for (i=0;charset_list[i].puntero!=NULL;i++) {
        if (!strcasecmp(charset_list[i].nombre,nombre)) {
            return i;
        }

	}

    return -1;

}

void set_user_charset(void)
{

    if (user_charset>=0) {
        unsigned char *puntero=charset_list[user_charset].puntero;
        if (puntero==char_set_customfile) {
            //Cargar el charset de un archivo
            //Primero copiamos el charset de otro, para incluir los iconos, acentos, etc
            //Lo escogemos del DOS que es mas "estandar"
            int longitud=sizeof(char_set_customfile);
            memcpy(char_set_customfile,char_set_dos,longitud);

            //Y cargar el contenido del archivo
            if (char_set_customfile_path[0]!=0) {
                util_load_file_bytes(char_set_customfile,char_set_customfile_path,768);
            }

        }
        char_set=charset_list[user_charset].puntero;
    }
    else {
        set_charset_from_gui();
    }
}


//Se puede obtener volcado con:
//hexdump -C -v archivo.bin |cut -d ' ' -f2-|cut -d '|' -f1|sed 's/  / /g'|cut -d ' ' -f2-|sed 's/ $/,/'|sed 's/ /,0x/g'|sed 's/^/0x/'


//Charset de zx81, con ordenacion codigos no ascii (el de zx81). 64 caracteres
//Esto NO se usa como charset para estilos de menu, solo para convertir de archivos .P a .SCR
unsigned char char_set_zx81_no_ascii[]={

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,
0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,
0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,
0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0x00,0x00,0x00,0x00,0xaa,0x55,0xaa,0x55,
0xaa,0x55,0xaa,0x55,0x00,0x00,0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x00,0x00,0x00,
0x00,0x1c,0x22,0x78,0x20,0x20,0x7e,0x00,0x00,0x08,0x3e,0x28,0x3e,0x0a,0x3e,0x08,
0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x3c,0x42,0x04,0x08,0x00,0x08,0x00,
0x00,0x04,0x08,0x08,0x08,0x08,0x04,0x00,0x00,0x20,0x10,0x10,0x10,0x10,0x20,0x00,
0x00,0x00,0x10,0x08,0x04,0x08,0x10,0x00,0x00,0x00,0x04,0x08,0x10,0x08,0x04,0x00,
0x00,0x00,0x00,0x3e,0x00,0x3e,0x00,0x00,0x00,0x00,0x08,0x08,0x3e,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,0x14,0x08,0x3e,0x08,0x14,0x00,
0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x10,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,
0x00,0x3c,0x46,0x4a,0x52,0x62,0x3c,0x00,0x00,0x18,0x28,0x08,0x08,0x08,0x3e,0x00,
0x00,0x3c,0x42,0x02,0x3c,0x40,0x7e,0x00,0x00,0x3c,0x42,0x0c,0x02,0x42,0x3c,0x00,
0x00,0x08,0x18,0x28,0x48,0x7e,0x08,0x00,0x00,0x7e,0x40,0x7c,0x02,0x42,0x3c,0x00,
0x00,0x3c,0x40,0x7c,0x42,0x42,0x3c,0x00,0x00,0x7e,0x02,0x04,0x08,0x10,0x10,0x00,
0x00,0x3c,0x42,0x3c,0x42,0x42,0x3c,0x00,0x00,0x3c,0x42,0x42,0x3e,0x02,0x3c,0x00,
0x00,0x3c,0x42,0x42,0x7e,0x42,0x42,0x00,0x00,0x7c,0x42,0x7c,0x42,0x42,0x7c,0x00,
0x00,0x3c,0x42,0x40,0x40,0x42,0x3c,0x00,0x00,0x78,0x44,0x42,0x42,0x44,0x78,0x00,
0x00,0x7e,0x40,0x7c,0x40,0x40,0x7e,0x00,0x00,0x7e,0x40,0x7c,0x40,0x40,0x40,0x00,
0x00,0x3c,0x42,0x40,0x4e,0x42,0x3c,0x00,0x00,0x42,0x42,0x7e,0x42,0x42,0x42,0x00,
0x00,0x3e,0x08,0x08,0x08,0x08,0x3e,0x00,0x00,0x02,0x02,0x02,0x42,0x42,0x3c,0x00,
0x00,0x44,0x48,0x70,0x48,0x44,0x42,0x00,0x00,0x40,0x40,0x40,0x40,0x40,0x7e,0x00,
0x00,0x42,0x66,0x5a,0x42,0x42,0x42,0x00,0x00,0x42,0x62,0x52,0x4a,0x46,0x42,0x00,
0x00,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x7c,0x42,0x42,0x7c,0x40,0x40,0x00,
0x00,0x3c,0x42,0x42,0x52,0x4a,0x3c,0x00,0x00,0x7c,0x42,0x42,0x7c,0x44,0x42,0x00,
0x00,0x3c,0x40,0x3c,0x02,0x42,0x3c,0x00,0x00,0xfe,0x10,0x10,0x10,0x10,0x10,0x00,
0x00,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x42,0x42,0x42,0x42,0x24,0x18,0x00,
0x00,0x42,0x42,0x42,0x42,0x5a,0x24,0x00,0x00,0x42,0x24,0x18,0x18,0x24,0x42,0x00,
0x00,0x82,0x44,0x28,0x10,0x10,0x10,0x00,0x00,0x7e,0x04,0x08,0x10,0x20,0x7e,0x00

};



unsigned char char_set_spectrum[TOTAL_ASCII_CHARSET_ELEMENTS]={		0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	16
	,	16
	,	16
	,	16
	,	0
	,	16
	,	0
	,	0
	,	36
	,	36
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	36
	,	126
	,	36
	,	36
	,	126
	,	36
	,	0
	,	0
	,	8
	,	62
	,	40
	,	62
	,	10
	,	62
	,	8
	,	0
	,	98
	,	100
	,	8
	,	16
	,	38
	,	70
	,	0
	,	0
	,	16
	,	40
	,	16
	,	42
	,	68
	,	58
	,	0
	,	0
	,	8
	,	16
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	4
	,	8
	,	8
	,	8
	,	8
	,	4
	,	0
	,	0
	,	32
	,	16
	,	16
	,	16
	,	16
	,	32
	,	0
	,	0
	,	0
	,	20
	,	8
	,	62
	,	8
	,	20
	,	0
	,	0
	,	0
	,	8
	,	8
	,	62
	,	8
	,	8
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	8
	,	8
	,	16
	,	0
	,	0
	,	0
	,	0
	,	62
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	24
	,	24
	,	0
	,	0
	,	0
	,	2
	,	4
	,	8
	,	16
	,	32
	,	0
	,	0
	,	60
	,	70
	,	74
	,	82
	,	98
	,	60
	,	0
	,	0
	,	24
	,	40
	,	8
	,	8
	,	8
	,	62
	,	0
	,	0
	,	60
	,	66
	,	2
	,	60
	,	64
	,	126
	,	0
	,	0
	,	60
	,	66
	,	12
	,	2
	,	66
	,	60
	,	0
	,	0
	,	8
	,	24
	,	40
	,	72
	,	126
	,	8
	,	0
	,	0
	,	126
	,	64
	,	124
	,	2
	,	66
	,	60
	,	0
	,	0
	,	60
	,	64
	,	124
	,	66
	,	66
	,	60
	,	0
	,	0
	,	126
	,	2
	,	4
	,	8
	,	16
	,	16
	,	0
	,	0
	,	60
	,	66
	,	60
	,	66
	,	66
	,	60
	,	0
	,	0
	,	60
	,	66
	,	66
	,	62
	,	2
	,	60
	,	0
	,	0
	,	0
	,	0
	,	16
	,	0
	,	0
	,	16
	,	0
	,	0
	,	0
	,	16
	,	0
	,	0
	,	16
	,	16
	,	32
	,	0
	,	0
	,	4
	,	8
	,	16
	,	8
	,	4
	,	0
	,	0
	,	0
	,	0
	,	62
	,	0
	,	62
	,	0
	,	0
	,	0
	,	0
	,	16
	,	8
	,	4
	,	8
	,	16
	,	0
	,	0
	,	60
	,	66
	,	4
	,	8
	,	0
	,	8
	,	0
	,	0
	,	60
	,	74
	,	86
	,	94
	,	64
	,	60
	,	0
	,	0
	,	60
	,	66
	,	66
	,	126
	,	66
	,	66
	,	0
	,	0
	,	124
	,	66
	,	124
	,	66
	,	66
	,	124
	,	0
	,	0
	,	60
	,	66
	,	64
	,	64
	,	66
	,	60
	,	0
	,	0
	,	120
	,	68
	,	66
	,	66
	,	68
	,	120
	,	0
	,	0
	,	126
	,	64
	,	124
	,	64
	,	64
	,	126
	,	0
	,	0
	,	126
	,	64
	,	124
	,	64
	,	64
	,	64
	,	0
	,	0
	,	60
	,	66
	,	64
	,	78
	,	66
	,	60
	,	0
	,	0
	,	66
	,	66
	,	126
	,	66
	,	66
	,	66
	,	0
	,	0
	,	62
	,	8
	,	8
	,	8
	,	8
	,	62
	,	0
	,	0
	,	2
	,	2
	,	2
	,	66
	,	66
	,	60
	,	0
	,	0
	,	68
	,	72
	,	112
	,	72
	,	68
	,	66
	,	0
	,	0
	,	64
	,	64
	,	64
	,	64
	,	64
	,	126
	,	0
	,	0
	,	66
	,	102
	,	90
	,	66
	,	66
	,	66
	,	0
	,	0
	,	66
	,	98
	,	82
	,	74
	,	70
	,	66
	,	0
	,	0
	,	60
	,	66
	,	66
	,	66
	,	66
	,	60
	,	0
	,	0
	,	124
	,	66
	,	66
	,	124
	,	64
	,	64
	,	0
	,	0
	,	60
	,	66
	,	66
	,	82
	,	74
	,	60
	,	0
	,	0
	,	124
	,	66
	,	66
	,	124
	,	68
	,	66
	,	0
	,	0
	,	60
	,	64
	,	60
	,	2
	,	66
	,	60
	,	0
	,	0
	,	254
	,	16
	,	16
	,	16
	,	16
	,	16
	,	0
	,	0
	,	66
	,	66
	,	66
	,	66
	,	66
	,	60
	,	0
	,	0
	,	66
	,	66
	,	66
	,	66
	,	36
	,	24
	,	0
	,	0
	,	66
	,	66
	,	66
	,	66
	,	90
	,	36
	,	0
	,	0
	,	66
	,	36
	,	24
	,	24
	,	36
	,	66
	,	0
	,	0
	,	130
	,	68
	,	40
	,	16
	,	16
	,	16
	,	0
	,	0
	,	126
	,	4
	,	8
	,	16
	,	32
	,	126
	,	0
	,	0
	,	14
	,	8
	,	8
	,	8
	,	8
	,	14
	,	0
	,	0
	,	0
	,	64
	,	32
	,	16
	,	8
	,	4
	,	0
	,	0
	,	112
	,	16
	,	16
	,	16
	,	16
	,	112
	,	0
	,	0
	,	16
	,	56
	,	84
	,	16
	,	16
	,	16
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	0
	,	255
	,	0
	,	28
	,	34
	,	120
	,	32
	,	32
	,	126
	,	0
	,	0
	,	0
	,	56
	,	4
	,	60
	,	68
	,	60
	,	0
	,	0
	,	32
	,	32
	,	60
	,	34
	,	34
	,	60
	,	0
	,	0
	,	0
	,	28
	,	32
	,	32
	,	32
	,	28
	,	0
	,	0
	,	4
	,	4
	,	60
	,	68
	,	68
	,	60
	,	0
	,	0
	,	0
	,	56
	,	68
	,	120
	,	64
	,	60
	,	0
	,	0
	,	12
	,	16
	,	24
	,	16
	,	16
	,	16
	,	0
	,	0
	,	0
	,	60
	,	68
	,	68
	,	60
	,	4
	,	56
	,	0
	,	64
	,	64
	,	120
	,	68
	,	68
	,	68
	,	0
	,	0
	,	16
	,	0
	,	48
	,	16
	,	16
	,	56
	,	0
	,	0
	,	4
	,	0
	,	4
	,	4
	,	4
	,	36
	,	24
	,	0
	,	32
	,	40
	,	48
	,	48
	,	40
	,	36
	,	0
	,	0
	,	16
	,	16
	,	16
	,	16
	,	16
	,	12
	,	0
	,	0
	,	0
	,	104
	,	84
	,	84
	,	84
	,	84
	,	0
	,	0
	,	0
	,	120
	,	68
	,	68
	,	68
	,	68
	,	0
	,	0
	,	0
	,	56
	,	68
	,	68
	,	68
	,	56
	,	0
	,	0
	,	0
	,	120
	,	68
	,	68
	,	120
	,	64
	,	64
	,	0
	,	0
	,	60
	,	68
	,	68
	,	60
	,	4
	,	6
	,	0
	,	0
	,	28
	,	32
	,	32
	,	32
	,	32
	,	0
	,	0
	,	0
	,	56
	,	64
	,	56
	,	4
	,	120
	,	0
	,	0
	,	16
	,	56
	,	16
	,	16
	,	16
	,	12
	,	0
	,	0
	,	0
	,	68
	,	68
	,	68
	,	68
	,	56
	,	0
	,	0
	,	0
	,	68
	,	68
	,	40
	,	40
	,	16
	,	0
	,	0
	,	0
	,	68
	,	84
	,	84
	,	84
	,	40
	,	0
	,	0
	,	0
	,	68
	,	40
	,	16
	,	40
	,	68
	,	0
	,	0
	,	0
	,	68
	,	68
	,	68
	,	60
	,	4
	,	56
	,	0
	,	0
	,	124
	,	8
	,	16
	,	32
	,	124
	,	0
	,	0
	,	14
	,	8
	,	48
	,	8
	,	8
	,	14
	,	0
	,	0
	,	8
	,	8
	,	8
	,	8
	,	8
	,	8
	,	0
	,	0
	,	112
	,	16
	,	12
	,	16
	,	16
	,	112
	,	0
	,	0
	,	20
	,	40
	,	0
	,	0
	,	0
	,	0
	,	0
	,	60
	,	66
	,	153
	,	161
	,	161
	,	153
	,	66
	,	60

//caracter adicional para menu - franja de color de spectrum

	,	1
	,	3
	,	7
	,	15
	,	31
	,	63
	,	127
	,	255

//caracter adicional para menu - enye minuscula
	,0x38
	,0x00
	,0x58
	,0x64
	,0x44
	,0x44
	,0x44
	,0x00


//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x08,0x10,0x38,0x04,0x3C,0x44,0x3C,0x00,

//é e acentuada - 143
0x08,0x10,0x38,0x44,0x78,0x40,0x3C,0x00,

//í i acentuada - 144
0x08,0x10,0x00,0x30,0x10,0x10,0x38,0x00,

//ó o acentuada - 145
0x08,0x10,0x38,0x44,0x44,0x44,0x38,0x00,

//ú u acentuada - 146
0x08,0x10,0x44,0x44,0x44,0x44,0x38,0x00,

//Ñ enye mayuscula - 147
0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter enviar a background
2+8+32+128,
1+4+16+64,
2+8+32+128,
1+4+16+64,
2+8+32+128,
1+4+16+64,
2+8+32+128,
1+4+16+64,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x1C,0x20,0x20,0x20,0x1C,0x10,0x20,

//à a acentuada abierta - 159
0x20,0x10,0x38,0x04,0x3C,0x44,0x3C,0x00,

//è e acentuada abierta - 160
0x20,0x10,0x38,0x44,0x78,0x40,0x3C,0x00,

//ò o acentuada abierta - 161
0x20,0x10,0x38,0x44,0x44,0x44,0x38,0x00,

//ü u con dieresis 162
0x44,0x00,0x44,0x44,0x44,0x44,0x38,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x00,0x28,0x00,0x30,0x10,0x10,0x38,0x00,

//Á A mayúscula acento cerrado - 168
0x08,0x10,0x3C,0x42,0x42,0x7E,0x42,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_cpc[TOTAL_ASCII_CHARSET_ELEMENTS]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x00   //32
,0x6c,0x6c,0x6c,0x00,0x00,0x00,0x00,0x00,0x6c,0x6c,0xfe,0x6c,0xfe,0x6c,0x6c,0x00
,0x18,0x3e,0x58,0x3c,0x1a,0x7c,0x18,0x00,0x00,0xc6,0xcc,0x18,0x30,0x66,0xc6,0x00
,0x38,0x6c,0x38,0x76,0xdc,0xcc,0x76,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00,0x00
,0x0c,0x18,0x30,0x30,0x30,0x18,0x0c,0x00,0x30,0x18,0x0c,0x0c,0x0c,0x18,0x30,0x00
,0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,0x00,0x18,0x18,0x7e,0x18,0x18,0x00,0x00  //42
,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00
,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00
,0x7c,0xc6,0xce,0xd6,0xe6,0xc6,0x7c,0x00,0x18,0x38,0x18,0x18,0x18,0x18,0x7e,0x00
,0x3c,0x66,0x06,0x3c,0x60,0x66,0x7e,0x00,0x3c,0x66,0x06,0x1c,0x06,0x66,0x3c,0x00
,0x1c,0x3c,0x6c,0xcc,0xfe,0x0c,0x1e,0x00,0x7e,0x62,0x60,0x7c,0x06,0x66,0x3c,0x00  //52
,0x3c,0x66,0x60,0x7c,0x66,0x66,0x3c,0x00,0x7e,0x66,0x06,0x0c,0x18,0x18,0x18,0x00
,0x3c,0x66,0x66,0x3c,0x66,0x66,0x3c,0x00,0x3c,0x66,0x66,0x3e,0x06,0x66,0x3c,0x00
,0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x30
,0x0c,0x18,0x30,0x60,0x30,0x18,0x0c,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00
,0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,0x3c,0x66,0x66,0x0c,0x18,0x00,0x18,0x00  //62
,0x7c,0xc6,0xde,0xde,0xde,0xc0,0x7c,0x00,0x18,0x3c,0x66,0x66,0x7e,0x66,0x66,0x00
,0xfc,0x66,0x66,0x7c,0x66,0x66,0xfc,0x00,0x3c,0x66,0xc0,0xc0,0xc0,0x66,0x3c,0x00
,0xf8,0x6c,0x66,0x66,0x66,0x6c,0xf8,0x00,0xfe,0x62,0x68,0x78,0x68,0x62,0xfe,0x00
,0xfe,0x62,0x68,0x78,0x68,0x60,0xf0,0x00,0x3c,0x66,0xc0,0xc0,0xce,0x66,0x3e,0x00
,0x66,0x66,0x66,0x7e,0x66,0x66,0x66,0x00,0x7e,0x18,0x18,0x18,0x18,0x18,0x7e,0x00  //72
,0x1e,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,0x00,0xe6,0x66,0x6c,0x78,0x6c,0x66,0xe6,0x00
,0xf0,0x60,0x60,0x60,0x62,0x66,0xfe,0x00,0xc6,0xee,0xfe,0xfe,0xd6,0xc6,0xc6,0x00
,0xc6,0xe6,0xf6,0xde,0xce,0xc6,0xc6,0x00,0x38,0x6c,0xc6,0xc6,0xc6,0x6c,0x38,0x00
,0xfc,0x66,0x66,0x7c,0x60,0x60,0xf0,0x00,0x38,0x6c,0xc6,0xc6,0xda,0xcc,0x76,0x00
,0xfc,0x66,0x66,0x7c,0x6c,0x66,0xe6,0x00,0x3c,0x66,0x60,0x3c,0x06,0x66,0x3c,0x00  //82
,0x7e,0x5a,0x18,0x18,0x18,0x18,0x3c,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x3c,0x00
,0x66,0x66,0x66,0x66,0x66,0x3c,0x18,0x00,0xc6,0xc6,0xc6,0xd6,0xfe,0xee,0xc6,0x00
,0xc6,0x6c,0x38,0x38,0x6c,0xc6,0xc6,0x00,0x66,0x66,0x66,0x3c,0x18,0x18,0x3c,0x00
,0xfe,0xc6,0x8c,0x18,0x32,0x66,0xfe,0x00,0x3c,0x30,0x30,0x30,0x30,0x30,0x3c,0x00
,0xc0,0x60,0x30,0x18,0x0c,0x06,0x02,0x00,0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,0x3c,0x00  //92
,0x18,0x3c,0x7e,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff
,0x30,0x18,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x0c,0x7c,0xcc,0x76,0x00
,0xe0,0x60,0x7c,0x66,0x66,0x66,0xdc,0x00,0x00,0x00,0x3c,0x66,0x60,0x66,0x3c,0x00
,0x1c,0x0c,0x7c,0xcc,0xcc,0xcc,0x76,0x00,0x00,0x00,0x3c,0x66,0x7e,0x60,0x3c,0x00
,0x1c,0x36,0x30,0x78,0x30,0x30,0x78,0x00,0x00,0x00,0x3e,0x66,0x66,0x3e,0x06,0x7c  //102
,0xe0,0x60,0x6c,0x76,0x66,0x66,0xe6,0x00,0x18,0x00,0x38,0x18,0x18,0x18,0x3c,0x00
,0x06,0x00,0x0e,0x06,0x06,0x66,0x66,0x3c,0xe0,0x60,0x66,0x6c,0x78,0x6c,0xe6,0x00
,0x38,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,0x00,0x00,0x6c,0xfe,0xd6,0xd6,0xc6,0x00
,0x00,0x00,0xdc,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x3c,0x66,0x66,0x66,0x3c,0x00
,0x00,0x00,0xdc,0x66,0x66,0x7c,0x60,0xf0,0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0x1e  //112
,0x00,0x00,0xdc,0x76,0x60,0x60,0xf0,0x00,0x00,0x00,0x3c,0x60,0x3c,0x06,0x7c,0x00
,0x30,0x30,0x7c,0x30,0x30,0x36,0x1c,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x3e,0x00
,0x00,0x00,0x66,0x66,0x66,0x3c,0x18,0x00,0x00,0x00,0xc6,0xd6,0xd6,0xfe,0x6c,0x00
,0x00,0x00,0xc6,0x6c,0x38,0x6c,0xc6,0x00,0x00,0x00,0x66,0x66,0x66,0x3e,0x06,0x7c
,0x00,0x00,0x7e,0x4c,0x18,0x32,0x7e,0x00,0x0e,0x18,0x18,0x70,0x18,0x18,0x0e,0x00
,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x70,0x18,0x18,0x0e,0x18,0x18,0x70,0x00
,0x76,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,0xcc,0x33,0xcc,0x33,0xcc,0x33,0xcc,0x33


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//129
//caracter adicional para menu - enye minuscula
,0x3C,0x00,0xdc,0x66,0x66,0x66,0x66,0x00

//CYRILLIC SMALL LETTER I и. 130
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x08,0x10,0x78,0x0c,0x7c,0xcc,0x76,0x00,

//é e acentuada - 143
0x08,0x10,0x3c,0x66,0x7e,0x60,0x3c,0x00,

//í i acentuada - 144
0x08,0x10,0x00,0x38,0x18,0x18,0x3c,0x00,

//ó o acentuada - 145
0x08,0x10,0x3c,0x66,0x66,0x66,0x3c,0x00,

//ú u acentuada - 146
0x08,0x10,0x66,0x66,0x66,0x66,0x3e,0x00,

//Ñ enye mayuscula - 147
0x7c,0x00,0xc6,0xe6,0xf6,0xde,0xce,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x1C,0x20,0x20,0x20,0x1C,0x10,0x20,

//à a acentuada abierta - 159
0x20,0x10,0x78,0x0c,0x7c,0xcc,0x76,0x00,

//è e acentuada abierta - 160
0x20,0x10,0x3c,0x66,0x7e,0x60,0x3c,0x00,

//ò o acentuada abierta - 161
0x20,0x10,0x3c,0x66,0x66,0x66,0x3c,0x00,

//ü u con dieresis 162
0x66,0x00,0x66,0x66,0x66,0x66,0x3e,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x28,0x00,0x38,0x18,0x18,0x18,0x3c,0x00,

//Á A mayúscula acento cerrado - 168
0x08,0x10,0x18,0x3c,0x66,0x7e,0x66,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_z88[TOTAL_ASCII_CHARSET_ELEMENTS]={

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x0c,0x00,
0x1b,0x1b,0x1b,0x00,0x00,0x00,0x00,0x00,
0x0a,0x1f,0x1f,0x0a,0x1f,0x1f,0x0a,0x00,
0x0c,0x1f,0x2c,0x1e,0x0d,0x3e,0x0c,0x00,
0x30,0x33,0x06,0x0c,0x18,0x33,0x03,0x00,
0x1c,0x36,0x36,0x18,0x35,0x32,0x1d,0x00,
0x06,0x0c,0x18,0x00,0x00,0x00,0x00,0x00,
0x06,0x0c,0x18,0x18,0x18,0x0c,0x06,0x00,
0x18,0x0c,0x06,0x06,0x06,0x0c,0x18,0x00,
0x00,0x0c,0x3f,0x1e,0x3f,0x0c,0x00,0x00,  //42
0x00,0x0c,0x0c,0x3f,0x3f,0x0c,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x18,
0x00,0x00,0x00,0x1f,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,
0x00,0x03,0x06,0x0c,0x18,0x30,0x00,0x00,
0x0e,0x19,0x1b,0x1d,0x19,0x19,0x0e,0x00,
0x0c,0x1c,0x0c,0x0c,0x0c,0x0c,0x0c,0x00,
0x0e,0x1b,0x03,0x06,0x0c,0x18,0x1f,0x00,
0x1f,0x03,0x06,0x03,0x03,0x1b,0x0e,0x00,
0x06,0x0e,0x16,0x26,0x3f,0x06,0x06,0x00,  //52
0x1f,0x18,0x1e,0x03,0x03,0x1b,0x0e,0x00,
0x06,0x0c,0x18,0x1e,0x1b,0x1b,0x0e,0x00,
0x1f,0x03,0x03,0x06,0x0c,0x0c,0x0c,0x00,
0x0e,0x1b,0x1b,0x0e,0x1b,0x1b,0x0e,0x00,
0x0e,0x1b,0x1b,0x0f,0x03,0x06,0x0c,0x00,
0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x00,
0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x18,
0x03,0x06,0x0c,0x18,0x0c,0x06,0x03,0x00,
0x00,0x1f,0x1f,0x00,0x1f,0x1f,0x00,0x00,
0x18,0x0c,0x06,0x03,0x06,0x0c,0x18,0x00,  //62
0x0e,0x1b,0x03,0x06,0x06,0x00,0x06,0x00,
0x1e,0x33,0x37,0x35,0x37,0x30,0x1e,0x00,
0x0e,0x1b,0x1b,0x1f,0x1b,0x1b,0x1b,0x00,
0x1e,0x1b,0x1b,0x1e,0x1b,0x1b,0x1e,0x00,
0x0e,0x1b,0x18,0x18,0x18,0x1b,0x0e,0x00,
0x1c,0x1a,0x1b,0x1b,0x1b,0x1a,0x1c,0x00,
0x1f,0x18,0x18,0x1e,0x18,0x18,0x1f,0x00,
0x1f,0x18,0x18,0x1e,0x18,0x18,0x18,0x00,
0x0f,0x18,0x18,0x1b,0x19,0x19,0x0f,0x00,
0x19,0x19,0x19,0x1f,0x19,0x19,0x19,0x00,  //72
0x0f,0x06,0x06,0x06,0x06,0x06,0x0f,0x00,
0x1f,0x06,0x06,0x06,0x06,0x16,0x0c,0x00,
0x19,0x1a,0x1c,0x1c,0x1c,0x1a,0x19,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x1f,0x00,
0x11,0x1b,0x1f,0x1f,0x15,0x15,0x11,0x00,
0x11,0x19,0x1d,0x1f,0x1b,0x19,0x19,0x00,
0x0e,0x1b,0x1b,0x1b,0x1b,0x1b,0x0e,0x00,
0x1e,0x1b,0x1b,0x1e,0x18,0x18,0x18,0x00,
0x0e,0x19,0x19,0x19,0x1d,0x1a,0x0d,0x00,
0x1e,0x1b,0x1b,0x1e,0x1c,0x1a,0x19,0x00,  //82
0x0e,0x1b,0x18,0x0e,0x03,0x1b,0x0e,0x00,
0x3f,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x00,
0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x0e,0x00,
0x1b,0x1b,0x1b,0x1b,0x1b,0x0a,0x04,0x00,
0x11,0x11,0x15,0x15,0x1f,0x1f,0x0a,0x00,
0x1b,0x1b,0x0a,0x04,0x0a,0x1b,0x1b,0x00,
0x1b,0x1b,0x1b,0x0a,0x04,0x04,0x04,0x00,
0x1f,0x03,0x06,0x0c,0x18,0x18,0x1f,0x00,
0x1e,0x18,0x18,0x18,0x18,0x18,0x1e,0x00,
0x00,0x30,0x18,0x0c,0x06,0x03,0x00,0x00,  //92
0x1e,0x06,0x06,0x06,0x06,0x06,0x1e,0x00,
0x0c,0x1e,0x33,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x3f,0x00,
0x18,0x0c,0x06,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0e,0x03,0x0f,0x1b,0x0f,0x00,
0x18,0x18,0x1e,0x1b,0x1b,0x1b,0x1e,0x00,
0x00,0x00,0x0e,0x18,0x18,0x18,0x0e,0x00,
0x03,0x03,0x0f,0x1b,0x1b,0x1b,0x0f,0x00,
0x00,0x00,0x0e,0x1b,0x1f,0x18,0x0e,0x00,
0x06,0x0d,0x0c,0x1e,0x0c,0x0c,0x0c,0x00,  //102
0x00,0x00,0x0e,0x1b,0x1b,0x0f,0x03,0x0e,
0x18,0x18,0x1e,0x1b,0x1b,0x1b,0x1b,0x00,
0x06,0x00,0x0e,0x06,0x06,0x06,0x0f,0x00,
0x06,0x00,0x06,0x06,0x06,0x06,0x16,0x0c,
0x18,0x18,0x1b,0x1e,0x1e,0x1b,0x19,0x00,
0x1c,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,
0x00,0x00,0x0a,0x1f,0x1f,0x15,0x15,0x00,
0x00,0x00,0x1e,0x1b,0x1b,0x1b,0x1b,0x00,
0x00,0x00,0x0e,0x1b,0x1b,0x1b,0x0e,0x00,
0x00,0x00,0x1e,0x1b,0x1b,0x1e,0x18,0x18,  //112
0x00,0x00,0x1e,0x36,0x36,0x1e,0x06,0x07,
0x00,0x00,0x1b,0x1c,0x18,0x18,0x18,0x00,
0x00,0x00,0x0f,0x18,0x0e,0x03,0x1e,0x00,
0x00,0x0c,0x1f,0x0c,0x0c,0x0d,0x06,0x00,
0x00,0x00,0x1b,0x1b,0x1b,0x1b,0x0f,0x00,
0x00,0x00,0x1b,0x1b,0x1b,0x0a,0x04,0x00,
0x00,0x00,0x15,0x15,0x1f,0x1f,0x0a,0x00,
0x00,0x00,0x1b,0x0a,0x04,0x0a,0x1b,0x00,
0x00,0x00,0x1b,0x1b,0x1b,0x0f,0x03,0x0e,
0x00,0x00,0x1f,0x06,0x0c,0x18,0x1f,0x00,  //122
0x06,0x0c,0x0c,0x18,0x0c,0x0c,0x06,0x00,
0x0c,0x0c,0x0c,0x00,0x0c,0x0c,0x0c,0x00,
0x18,0x0c,0x0c,0x06,0x0c,0x0c,0x18,0x00,
0x00,0x18,0x2d,0x06,0x00,0x00,0x00,0x00,
0x0e,0x19,0x3c,0x18,0x3c,0x19,0x0e,0x00


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
,0x1E,0x00,0x1e,0x1b,0x1b,0x1b,0x1b,0x00


//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x02,0x04,0x0e,0x03,0x0f,0x1b,0x0f,0x00,

//é e acentuada - 143
0x02,0x04,0x0e,0x1b,0x1f,0x18,0x0e,0x00,

//í i acentuada - 144
0x02,0x04,0x00,0x0e,0x06,0x06,0x0f,0x00,

//ó o acentuada - 145
0x02,0x04,0x0e,0x1b,0x1b,0x1b,0x0e,0x00,

//ú u acentuada - 146
0x02,0x04,0x1b,0x1b,0x1b,0x1b,0x0f,0x00,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,
//0x1f,0x00,0x11,0x19,0x1d,0x1f,0x1b,0x00,
0x1f,0x00,0x19,0x1d,0x1f,0x1b,0x19,0x00,
//0x11,0x19,0x1d,0x1f,0x1b,0x19,0x19,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x0e,0x18,0x18,0x18,0x0e,0x04,0x08,

//à a acentuada abierta - 159
0x08,0x04,0x0e,0x03,0x0f,0x1b,0x0f,0x00,

//è e acentuada abierta - 160
0x08,0x04,0x0e,0x1b,0x1f,0x18,0x0e,0x00,

//ò o acentuada abierta - 161
0x08,0x04,0x0e,0x1b,0x1b,0x1b,0x0e,0x00,

//ü u con dieresis 162
0x1b,0x00,0x1b,0x1b,0x1b,0x1b,0x0f,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x0C,0x0C,0x0C,0x0C,0x3F,0x1E,0x0C,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x0C,0x1E,0x3F,0x0C,0x0C,0x0C,0x0C,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x08,0x0C,0x3E,0x3E,0x0C,0x08,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x04,0x0C,0x1F,0x1F,0x0C,0x04,0x00,

//ï i con dieresis - 167
0x0A,0x00,0x0e,0x06,0x06,0x06,0x0f,0x00,

//Á A mayúscula acento cerrado - 168
0x02,0x04,0x0e,0x1b,0x1b,0x1f,0x1b,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_sam[TOTAL_ASCII_CHARSET_ELEMENTS]={



0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x08,0x08,0x08,0x08,0x08,0x00,0x08,0x00,
0x14,0x14,0x00,0x00,0x00,0x00,0x00,0x00,
0x14,0x14,0x3e,0x14,0x3e,0x14,0x14,0x00,
0x1c,0x28,0x28,0x1c,0x0a,0x0a,0x1c,0x00,
0x32,0x32,0x04,0x08,0x10,0x26,0x26,0x00,
0x10,0x28,0x28,0x10,0x2a,0x24,0x1a,0x00,
0x0c,0x04,0x08,0x00,0x00,0x00,0x00,0x00,
0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00,
0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,
0x08,0x2a,0x1c,0x3e,0x1c,0x2a,0x08,0x00,  //42
0x00,0x08,0x08,0x3e,0x08,0x08,0x00,0x00,
0x00,0x00,0x00,0x00,0x0c,0x0c,0x04,0x08,
0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,
0x02,0x02,0x04,0x08,0x10,0x20,0x20,0x00,
0x1c,0x22,0x26,0x2a,0x32,0x22,0x1c,0x00,
0x08,0x18,0x08,0x08,0x08,0x08,0x1c,0x00,
0x1c,0x22,0x02,0x04,0x08,0x10,0x3e,0x00,
0x1c,0x22,0x02,0x0c,0x02,0x22,0x1c,0x00,
0x04,0x0c,0x14,0x24,0x3e,0x04,0x04,0x00,  //52
0x3e,0x20,0x3c,0x02,0x02,0x22,0x1c,0x00,
0x0c,0x10,0x20,0x3c,0x22,0x22,0x1c,0x00,
0x3e,0x02,0x04,0x08,0x10,0x20,0x20,0x00,
0x1c,0x22,0x22,0x1c,0x22,0x22,0x1c,0x00,
0x1c,0x22,0x22,0x1e,0x02,0x04,0x18,0x00,
0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x00,
0x00,0x00,0x0c,0x0c,0x00,0x0c,0x04,0x08,
0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,
0x00,0x00,0x3e,0x00,0x3e,0x00,0x00,0x00,
0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x00,  //62
0x1c,0x22,0x02,0x04,0x08,0x00,0x08,0x00,
0x1c,0x22,0x26,0x2a,0x2e,0x20,0x1c,0x00,
0x1c,0x22,0x22,0x3e,0x22,0x22,0x22,0x00,
0x3c,0x22,0x22,0x3c,0x22,0x22,0x3c,0x00,
0x1c,0x22,0x20,0x20,0x20,0x22,0x1c,0x00,
0x3c,0x22,0x22,0x22,0x22,0x22,0x3c,0x00,
0x3e,0x20,0x20,0x3c,0x20,0x20,0x3e,0x00,
0x3e,0x20,0x20,0x3c,0x20,0x20,0x20,0x00,
0x1c,0x22,0x20,0x20,0x26,0x22,0x1c,0x00,
0x22,0x22,0x22,0x3e,0x22,0x22,0x22,0x00,  //72
0x1c,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,
0x02,0x02,0x02,0x02,0x02,0x22,0x1c,0x00,
0x22,0x24,0x28,0x30,0x28,0x24,0x22,0x00,
0x20,0x20,0x20,0x20,0x20,0x20,0x3e,0x00,
0x22,0x36,0x2a,0x22,0x22,0x22,0x22,0x00,
0x22,0x22,0x32,0x2a,0x26,0x22,0x22,0x00,
0x1c,0x22,0x22,0x22,0x22,0x22,0x1c,0x00,
0x3c,0x22,0x22,0x3c,0x20,0x20,0x20,0x00,
0x1c,0x22,0x22,0x22,0x2a,0x24,0x1a,0x00,
0x3c,0x22,0x22,0x3c,0x28,0x24,0x22,0x00,  //82
0x1c,0x22,0x20,0x1c,0x02,0x22,0x1c,0x00,
0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
0x22,0x22,0x22,0x22,0x22,0x22,0x1c,0x00,
0x22,0x22,0x22,0x22,0x22,0x14,0x08,0x00,
0x22,0x22,0x22,0x22,0x2a,0x2a,0x14,0x00,
0x22,0x22,0x14,0x08,0x14,0x22,0x22,0x00,
0x22,0x22,0x14,0x08,0x08,0x08,0x08,0x00,
0x3e,0x02,0x04,0x08,0x10,0x20,0x3e,0x00,
0x0e,0x08,0x08,0x08,0x08,0x08,0x0e,0x00,
0x20,0x20,0x10,0x08,0x04,0x02,0x02,0x00,  //92
0x38,0x08,0x08,0x08,0x08,0x08,0x38,0x00,
0x08,0x1c,0x2a,0x08,0x08,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x0c,0x12,0x10,0x38,0x10,0x10,0x3e,0x00,
0x00,0x00,0x1c,0x02,0x1e,0x22,0x1e,0x00,
0x20,0x20,0x3c,0x22,0x22,0x22,0x3c,0x00,
0x00,0x00,0x1e,0x20,0x20,0x20,0x1e,0x00,
0x02,0x02,0x1e,0x22,0x22,0x22,0x1e,0x00,
0x00,0x00,0x1c,0x22,0x3e,0x20,0x1e,0x00,
0x0c,0x12,0x10,0x3c,0x10,0x10,0x10,0x00,  //102
0x00,0x00,0x1e,0x22,0x22,0x1e,0x02,0x1c,
0x20,0x20,0x3c,0x22,0x22,0x22,0x22,0x00,
0x08,0x00,0x08,0x08,0x08,0x08,0x04,0x00,
0x08,0x00,0x08,0x08,0x08,0x08,0x08,0x10,
0x20,0x20,0x22,0x24,0x38,0x24,0x22,0x00,
0x08,0x08,0x08,0x08,0x08,0x08,0x0c,0x00,
0x00,0x00,0x34,0x2a,0x2a,0x2a,0x2a,0x00,
0x00,0x00,0x3c,0x22,0x22,0x22,0x22,0x00,
0x00,0x00,0x1c,0x22,0x22,0x22,0x1c,0x00,
0x00,0x00,0x3c,0x22,0x22,0x3c,0x20,0x20,  //112
0x00,0x00,0x1e,0x22,0x22,0x1e,0x02,0x02,
0x00,0x00,0x2c,0x32,0x20,0x20,0x20,0x00,
0x00,0x00,0x1e,0x20,0x1c,0x02,0x3c,0x00,
0x08,0x08,0x1e,0x08,0x08,0x08,0x06,0x00,
0x00,0x00,0x22,0x22,0x22,0x22,0x1e,0x00,
0x00,0x00,0x22,0x22,0x22,0x14,0x08,0x00,
0x00,0x00,0x22,0x22,0x22,0x2a,0x14,0x00,
0x00,0x00,0x22,0x14,0x08,0x14,0x22,0x00,
0x00,0x00,0x22,0x22,0x22,0x1e,0x02,0x1c,
0x00,0x00,0x3e,0x04,0x08,0x10,0x3e,0x00,  //122
0x04,0x08,0x08,0x10,0x08,0x08,0x04,0x00,
0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
0x10,0x08,0x08,0x04,0x08,0x08,0x10,0x00,
0x0a,0x14,0x00,0x00,0x00,0x00,0x00,0x00,
0x3c,0x42,0x5a,0x52,0x5a,0x42,0x3c,0x00



//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
,0x3C,0x00,0x3c,0x22,0x22,0x22,0x22,0x00

//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x04,0x08,0x1c,0x02,0x1e,0x22,0x1e,0x00,

//é e acentuada - 143
0x04,0x08,0x1c,0x22,0x3e,0x20,0x1e,0x00,

//í i acentuada - 144
0x04,0x08,0x00,0x08,0x08,0x08,0x04,0x00,

//ó o acentuada - 145
0x04,0x08,0x1c,0x22,0x22,0x22,0x1c,0x00,

//ú u acentuada - 146
0x04,0x08,0x22,0x22,0x22,0x22,0x1e,0x00,

//Ñ enye mayuscula - 147
0x3E,0x00,0x22,0x32,0x2a,0x26,0x22,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x1e,0x20,0x20,0x20,0x1e,0x10,0x20,

//à a acentuada abierta - 159
0x10,0x08,0x1c,0x02,0x1e,0x22,0x1e,0x00,

//è e acentuada abierta - 160
0x10,0x08,0x1c,0x22,0x3e,0x20,0x1e,0x00,

//ò o acentuada abierta - 161
0x10,0x08,0x1c,0x22,0x22,0x22,0x1c,0x00,

//ü u con dieresis 162
0x22,0x00,0x22,0x22,0x22,0x22,0x1e,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x08,0x0C,0x7E,0x7E,0x0C,0x08,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x08,0x18,0x3F,0x3F,0x18,0x08,0x00,

//ï i con dieresis - 167
0x14,0x00,0x08,0x08,0x08,0x08,0x04,0x00,

//Á A mayúscula acento cerrado - 168
0x04,0x08,0x1c,0x22,0x22,0x3e,0x22,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_mansoftware[TOTAL_ASCII_CHARSET_ELEMENTS]={

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x70,0x70,0x70,0x70,0x00,0x70,0x70, //32,33
0x00,0x36,0x6c,0x00,0x00,0x00,0x00,0x00, 0x00,0x24,0x24,0x7e,0x24,0x7e,0x24,0x24,
0x00,0x24,0x3f,0x64,0x3e,0x25,0x7e,0x24, 0x00,0x63,0x66,0x0c,0x18,0x33,0x63,0x00,
0x00,0x18,0x24,0x19,0x3a,0x44,0x3a,0x00, 0x00,0x06,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x1e,0x20,0x40,0x40,0x40,0x20,0x1e, 0x00,0x78,0x04,0x02,0x02,0x02,0x04,0x78, //40,41
0x00,0x42,0x24,0x08,0x10,0x24,0x42,0x00, 0x00,0x18,0x18,0x7e,0x7e,0x18,0x18,0x00,
0x00,0x00,0x00,0x00,0x02,0x04,0x08,0x00, 0x00,0x00,0x00,0x7e,0x7e,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00, 0x00,0x02,0x06,0x0c,0x18,0x30,0x60,0x00,
0x00,0x3e,0x46,0x4a,0x52,0x62,0x7c,0x00, 0x00,0x0e,0x1e,0x06,0x06,0x06,0x06,0x00,
0x00,0x38,0x44,0x08,0x10,0x20,0x7e,0x00, 0x00,0x7c,0x02,0x7c,0x7c,0x02,0x7c,0x00, //50,51
0x00,0x66,0x66,0x66,0x7e,0x7e,0x06,0x00, 0x00,0x7e,0x40,0x40,0x7e,0x02,0x02,0x7c,
0x00,0x1e,0x30,0x60,0x60,0x7c,0x66,0x3c, 0x00,0x7e,0x7e,0x06,0x0e,0x0e,0x06,0x06,
0x00,0x3c,0x7e,0x24,0x18,0x24,0x7e,0x3c, 0x00,0x1e,0x32,0x32,0x1e,0x06,0x06,0x06,
0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00, 0x00,0x18,0x18,0x00,0x00,0x08,0x30,0x00,
0x00,0x02,0x04,0x08,0x08,0x04,0x02,0x00, 0x00,0x7e,0x7e,0x00,0x00,0x7e,0x7e,0x00, //60,61
0x00,0x40,0x20,0x10,0x10,0x20,0x40,0x00, 0x00,0x3c,0x42,0x04,0x18,0x10,0x00,0x10,
0x00,0x3e,0x42,0x5a,0x5a,0x5c,0x40,0x3e, 0x00,0x3c,0x7e,0x66,0x7e,0x7e,0x66,0x66,
0x00,0x7c,0x7c,0x62,0x64,0x62,0x7c,0x7c, 0x00,0x3e,0x7e,0x60,0x60,0x60,0x7e,0x3e,
0x00,0x78,0x7c,0x66,0x66,0x66,0x7c,0x78, 0x00,0x7e,0x7e,0x40,0x7e,0x40,0x7e,0x7e,
0x00,0x7e,0x7e,0x60,0x78,0x78,0x60,0x60, 0x00,0x3e,0x7e,0x60,0x6c,0x62,0x7e,0x3c, //70,71
0x00,0x63,0x63,0x7f,0x7f,0x7f,0x63,0x63, 0x00,0x38,0x38,0x00,0x38,0x38,0x38,0x38,
0x00,0x06,0x06,0x06,0x06,0x66,0x7e,0x7c, 0x00,0x62,0x64,0x68,0x70,0x68,0x64,0x62,
0x00,0x60,0x60,0x60,0x60,0x60,0x7f,0x7f, 0x00,0x63,0x77,0x6b,0x63,0x63,0x63,0x63,
0x00,0x63,0x73,0x6b,0x67,0x63,0x63,0x63, 0x00,0x3e,0x7f,0x77,0x63,0x77,0x7f,0x3e, //78,79
0x00,0x7e,0x73,0x73,0x7e,0x60,0x60,0x60, 0x00,0x3c,0x42,0x42,0x52,0x4a,0x46,0x3e, //80,81
0x00,0x7c,0x62,0x62,0x7c,0x68,0x64,0x62, 0x00,0x3e,0x7e,0x40,0x3c,0x02,0x7e,0x7c,
0x00,0x7e,0x7e,0x18,0x18,0x18,0x18,0x18, 0x00,0x63,0x63,0x63,0x63,0x63,0x7f,0x3e,
0x00,0x63,0x63,0x63,0x63,0x63,0x36,0x1c, 0x00,0x63,0x63,0x63,0x63,0x6b,0x77,0x63,
0x00,0x41,0x63,0x36,0x1c,0x1c,0x36,0x63, 0x00,0x63,0x36,0x1c,0x1c,0x1c,0x1c,0x1c,
0x00,0x3f,0x7f,0x06,0x0c,0x18,0x3f,0x7e, 0x00,0x0E,0x08,0x08,0x08,0x08,0x0E,0x00, //90,91
0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x00, 0x00,0x70,0x10,0x10,0x10,0x10,0x70,0x00, //92,93
0x00,0x00,0x18,0x3c,0x5a,0x18,0x18,0x18, 0x00,0x00,0x00,0x00,0x00,0x7f,0x7f,0x00, //94,95
0x00,0x60,0x30,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x3c,0x42,0x1e,0x22,0x46,0x39,
0x00,0x30,0x30,0x30,0x3c,0x32,0x32,0x3c, 0x00,0x00,0x00,0x3e,0x40,0x40,0x40,0x3e,
0x00,0x06,0x06,0x06,0x1e,0x26,0x26,0x1e, 0x00,0x00,0x3c,0x42,0x7c,0x40,0x42,0x3c, //100,101
0x00,0x0c,0x10,0x20,0x20,0x78,0x20,0x20, 0x00,0x3c,0x42,0x42,0x3c,0x04,0x28,0x30,
0x00,0x40,0x40,0x40,0x40,0x78,0x44,0x44, 0x00,0x10,0x00,0x10,0x10,0x10,0x10,0x10, //104,105
0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x38, 0x00,0x00,0x48,0x50,0x60,0x60,0x50,0x48,
0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x1c, 0x00,0x00,0x00,0x28,0x54,0x54,0x54,0x54,
0x00,0x00,0x00,0x70,0x48,0x48,0x48,0x48, 0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x3c, //110,111
0x00,0x00,0x00,0x70,0x48,0x48,0x70,0x40, 0x00,0x00,0x00,0x1c,0x24,0x24,0x1c,0x06,
0x00,0x00,0x00,0x38,0x40,0x40,0x40,0x40, 0x00,0x00,0x00,0x3e,0x40,0x3c,0x02,0x7c,
0x00,0x00,0x20,0x70,0x20,0x20,0x20,0x18, 0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x3c, //116,117
0x00,0x00,0x00,0x00,0x41,0x22,0x14,0x08, 0x00,0x00,0x00,0x41,0x41,0x41,0x5d,0x22,
0x00,0x00,0x00,0x41,0x22,0x1c,0x22,0x41, 0x00,0x00,0x41,0x22,0x14,0x08,0x10,0x20, //120
0x00,0x00,0x00,0x7f,0x02,0x04,0x08,0x7f, 0x06,0x0c,0x0c,0x18,0x0c,0x0c,0x06,0x00, //122
0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x00, 0x18,0x0c,0x0c,0x06,0x0c,0x0c,0x18,0x00, //124
0x00,0x00,0x00,0x11,0x2a,0x44,0x00,0x00, 0x00,0x3e,0x41,0x5d,0x51,0x5d,0x41,0x3e

//A este charset se le aplicaron varias correcciones:
//Correccion \ y ] . charset original contiene enye mayuscula (Ñ) y simbolo inicio interrogación ¿
//Correccion |. charset original contiene enye minuscula ñ
//Correccion [ . charset original contiene simbolo inicio exclamacion ¡
//Y otras dos correcciones en 123 { y 125 }, donde habían ç y ü


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
,0x00,0x78,0x00,0x70,0x48,0x48,0x48,0x48

//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x04,0x08,0x3c,0x42,0x1e,0x22,0x46,0x39,

//é e acentuada - 143
0x08,0x10,0x3c,0x42,0x7c,0x40,0x42,0x3c,

//í i acentuada - 144
0x08,0x10,0x00,0x10,0x10,0x10,0x10,0x10,

//ó o acentuada - 145
0x08,0x10,0x00,0x3c,0x42,0x42,0x42,0x3c,

//ú u acentuada - 146
0x08,0x10,0x00,0x42,0x42,0x42,0x42,0x3c,

//Ñ enye mayuscula - 147
0x7F,0x00,0x63,0x73,0x6b,0x67,0x63,0x63,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x3e,0x40,0x40,0x40,0x3e,0x10,0x20,

//à a acentuada abierta - 159
0x10,0x08,0x3c,0x42,0x1e,0x22,0x46,0x39,

//è e acentuada abierta - 160
0x20,0x10,0x3c,0x42,0x7c,0x40,0x42,0x3c,

//ò o acentuada abierta - 161
0x20,0x10,0x00,0x3c,0x42,0x42,0x42,0x3c,

//ü u con dieresis 162
0x00,0x42,0x00,0x42,0x42,0x42,0x42,0x3c,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x00,0x28,0x00,0x10,0x10,0x10,0x10,0x10,

//Á A mayúscula acento cerrado - 168
0x04,0x08,0x3c,0x7e,0x66,0x7e,0x7e,0x66,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


//Nota: Charset de QL es originalmente de 9 pixels de alto, he tenido que ignorar el ultimo byte de cada caracter para poder tener fuente de 8 pixeles
//Es por eso que hay letras, como la g, que se ven cortadas
unsigned char char_set_ql[TOTAL_ASCII_CHARSET_ELEMENTS]={

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00,
0x28,0x28,0x00,0x00,0x00,0x00,0x00,0x00,
0x28,0x28,0x7c,0x28,0x7c,0x28,0x28,0x00,
0x38,0x50,0x50,0x38,0x14,0x14,0x38,0x00,
0x64,0x64,0x08,0x10,0x20,0x4c,0x4c,0x00,
0x20,0x50,0x50,0x20,0x54,0x48,0x34,0x00,
0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,
0x40,0x20,0x10,0x10,0x10,0x20,0x40,0x00,
0x10,0x54,0x38,0x10,0x38,0x54,0x10,0x00,  //42
0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x08,
0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,
0x04,0x04,0x08,0x10,0x20,0x40,0x40,0x00,
0x38,0x44,0x4c,0x54,0x64,0x44,0x38,0x00,
0x10,0x30,0x10,0x10,0x10,0x10,0x38,0x00,
0x38,0x44,0x04,0x08,0x10,0x20,0x7c,0x00,
0x38,0x44,0x04,0x18,0x04,0x44,0x38,0x00,
0x08,0x18,0x28,0x48,0x7c,0x08,0x08,0x00,  //52
0x7c,0x40,0x78,0x04,0x04,0x44,0x38,0x00,
0x18,0x20,0x40,0x78,0x44,0x44,0x38,0x00,
0x7c,0x04,0x08,0x10,0x20,0x40,0x40,0x00,
0x38,0x44,0x44,0x38,0x44,0x44,0x38,0x00,
0x38,0x44,0x44,0x3c,0x04,0x08,0x30,0x00,
0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x00,
0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x08,
0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00,
0x00,0x00,0x7c,0x00,0x7c,0x00,0x00,0x00,
0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,  //62
0x38,0x44,0x04,0x08,0x10,0x00,0x10,0x00,
0x38,0x44,0x4c,0x54,0x4c,0x40,0x30,0x00,
0x38,0x44,0x44,0x7c,0x44,0x44,0x44,0x00,
0x78,0x44,0x44,0x78,0x44,0x44,0x78,0x00,
0x38,0x44,0x40,0x40,0x40,0x44,0x38,0x00,
0x78,0x44,0x44,0x44,0x44,0x44,0x78,0x00,
0x7c,0x40,0x40,0x78,0x40,0x40,0x7c,0x00,
0x7c,0x40,0x40,0x78,0x40,0x40,0x40,0x00,
0x38,0x44,0x40,0x40,0x4c,0x44,0x38,0x00,
0x44,0x44,0x44,0x7c,0x44,0x44,0x44,0x00,  //72
0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,
0x04,0x04,0x04,0x04,0x04,0x44,0x38,0x00,
0x44,0x48,0x50,0x60,0x50,0x48,0x44,0x00,
0x40,0x40,0x40,0x40,0x40,0x40,0x7c,0x00,
0x44,0x6c,0x54,0x44,0x44,0x44,0x44,0x00,
0x44,0x44,0x64,0x54,0x4c,0x44,0x44,0x00,
0x38,0x44,0x44,0x44,0x44,0x44,0x38,0x00,
0x78,0x44,0x44,0x78,0x40,0x40,0x40,0x00,
0x38,0x44,0x44,0x44,0x54,0x48,0x34,0x00,
0x78,0x44,0x44,0x78,0x50,0x48,0x44,0x00,  //82
0x38,0x44,0x40,0x38,0x04,0x44,0x38,0x00,
0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,
0x44,0x44,0x44,0x44,0x44,0x44,0x38,0x00,
0x44,0x44,0x44,0x44,0x44,0x28,0x10,0x00,
0x44,0x44,0x44,0x44,0x54,0x54,0x28,0x00,
0x44,0x44,0x28,0x10,0x28,0x44,0x44,0x00,
0x44,0x44,0x28,0x10,0x10,0x10,0x10,0x00,
0x7c,0x04,0x08,0x10,0x20,0x40,0x7c,0x00,
0x1c,0x10,0x10,0x10,0x10,0x10,0x1c,0x00,
0x40,0x40,0x20,0x10,0x08,0x04,0x04,0x00,  //92
0x70,0x10,0x10,0x10,0x10,0x10,0x70,0x00,
0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,
0x18,0x24,0x20,0x70,0x20,0x20,0x7c,0x00,
0x00,0x00,0x34,0x4c,0x44,0x4c,0x34,0x00,
0x40,0x40,0x78,0x44,0x44,0x44,0x78,0x00,
0x00,0x00,0x3c,0x40,0x40,0x40,0x3c,0x00,
0x04,0x04,0x3c,0x44,0x44,0x44,0x3c,0x00,
0x00,0x00,0x38,0x44,0x7c,0x40,0x3c,0x00,
0x18,0x24,0x20,0x70,0x20,0x20,0x20,0x00,  //102
0x00,0x00,0x38,0x44,0x44,0x44,0x3c,0x04,
0x40,0x40,0x78,0x44,0x44,0x44,0x44,0x00,
0x10,0x00,0x10,0x10,0x10,0x10,0x08,0x00,
0x10,0x00,0x10,0x10,0x10,0x10,0x10,0x10,
0x40,0x40,0x44,0x48,0x70,0x48,0x44,0x00,
0x10,0x10,0x10,0x10,0x10,0x10,0x08,0x00,
0x00,0x00,0x68,0x54,0x54,0x54,0x54,0x00,
0x00,0x00,0x78,0x44,0x44,0x44,0x44,0x00,
0x00,0x00,0x38,0x44,0x44,0x44,0x38,0x00,
0x00,0x00,0x78,0x44,0x44,0x44,0x78,0x40,  //112
0x00,0x00,0x3c,0x44,0x44,0x44,0x3c,0x04,
0x00,0x00,0x58,0x64,0x40,0x40,0x40,0x00,
0x00,0x00,0x38,0x40,0x38,0x04,0x38,0x00,
0x10,0x10,0x38,0x10,0x10,0x10,0x0c,0x00,
0x00,0x00,0x44,0x44,0x44,0x44,0x3c,0x00,
0x00,0x00,0x44,0x44,0x44,0x28,0x10,0x00,
0x00,0x00,0x44,0x44,0x44,0x54,0x28,0x00,
0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00,
0x00,0x00,0x44,0x44,0x44,0x44,0x3c,0x04,
0x00,0x00,0x7c,0x08,0x10,0x20,0x7c,0x00,  //122
0x08,0x10,0x10,0x20,0x10,0x10,0x08,0x00,
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,
0x20,0x10,0x10,0x08,0x10,0x10,0x20,0x00,
0x14,0x28,0x00,0x00,0x00,0x00,0x00,0x00,
0x38,0x44,0x5c,0x64,0x5c,0x44,0x38,0x00

//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
,0x78,0x00,0x78,0x44,0x44,0x44,0x44,0x00


//CYRILLIC SMALL LETTER I и  - 130
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,


//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x08,0x10,0x34,0x4c,0x44,0x4c,0x34,0x00,

//é e acentuada - 143
0x08,0x10,0x38,0x44,0x7c,0x40,0x3c,0x00,

//í i acentuada - 144
0x08,0x10,0x00,0x10,0x10,0x10,0x08,0x00,

//ó o acentuada - 145
0x08,0x10,0x38,0x44,0x44,0x44,0x38,0x00,

//ú u acentuada - 146
0x08,0x10,0x44,0x44,0x44,0x44,0x3c,0x00,

//Ñ enye mayuscula - 147
0x7c,0x00,0x44,0x64,0x54,0x4c,0x44,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
//0x00,0x1C,0x20,0x20,0x20,0x1C,0x10,0x20,
0x00,0x3c,0x40,0x40,0x40,0x3c,0x10,0x20,

//à a acentuada abierta - 159
0x20,0x10,0x34,0x4c,0x44,0x4c,0x34,0x00,

//è e acentuada abierta - 160
0x20,0x10,0x38,0x44,0x7c,0x40,0x3c,0x00,

//ò o acentuada abierta - 161
0x20,0x10,0x38,0x44,0x44,0x44,0x38,0x00,

//ü u con dieresis 162
0x44,0x00,0x44,0x44,0x44,0x44,0x3c,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0x7C,0x7C,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7C,0x7C,0x30,0x10,0x00,

//ï i con dieresis - 167
0x28,0x00,0x10,0x10,0x10,0x10,0x08,0x00,

//Á A mayúscula acento cerrado - 168
0x08,0x10,0x38,0x44,0x44,0x7c,0x44,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_retromac[TOTAL_ASCII_CHARSET_ELEMENTS]={

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x00,
0x36,0x36,0x6C,0x00,0x00,0x00,0x00,0x00,
0x14,0x14,0x7E,0x28,0xFC,0x50,0x50,0x00,
0x08,0x3C,0x60,0x38,0x0C,0x78,0x20,0x00,
0x5C,0xA4,0x48,0x10,0x24,0x4A,0x04,0x00,
0x38,0x6C,0x60,0x32,0x6C,0x6C,0x38,0x00,
0x18,0x18,0x30,0x00,0x00,0x00,0x00,0x00,
0x0C,0x18,0x18,0x18,0x18,0x18,0x0C,0x00,
0x30,0x18,0x18,0x18,0x18,0x18,0x30,0x00,
0x00,0x10,0x54,0x38,0x54,0x10,0x00,0x00,  //42
0x00,0x10,0x10,0x7C,0x10,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30,
0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,
0x0C,0x0C,0x18,0x18,0x18,0x30,0x30,0x00,
0x38,0x6C,0x6C,0x7C,0x6C,0x6C,0x38,0x00,
0x18,0x38,0x18,0x18,0x18,0x18,0x18,0x00,
0x38,0x4C,0x0C,0x18,0x30,0x60,0x7C,0x00,
0x7C,0x0C,0x18,0x0C,0x0C,0x4C,0x38,0x00,
0x0C,0x1C,0x2C,0x4C,0x7E,0x0C,0x0C,0x00,  //52
0x7C,0x60,0x78,0x0C,0x0C,0x4C,0x38,0x00,
0x18,0x30,0x60,0x78,0x6C,0x6C,0x38,0x00,
0x7C,0x0C,0x0C,0x18,0x30,0x30,0x30,0x00,
0x38,0x6C,0x6C,0x38,0x6C,0x6C,0x38,0x00,
0x38,0x6C,0x6C,0x3C,0x0C,0x18,0x30,0x00,
0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x00,
0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x30,
0x00,0x0C,0x18,0x30,0x18,0x0C,0x00,0x00,
0x00,0x00,0x7C,0x00,0x7C,0x00,0x00,0x00,
0x00,0x30,0x18,0x0C,0x18,0x30,0x00,0x00,  //62
0x38,0x4C,0x0C,0x18,0x30,0x00,0x30,0x00,
0x38,0x6C,0x7C,0x6C,0x70,0x64,0x38,0x00,
0x38,0x6C,0x6C,0x7C,0x6C,0x6C,0x6C,0x00,
0x78,0x6C,0x6C,0x78,0x6C,0x6C,0x78,0x00,
0x38,0x64,0x60,0x60,0x60,0x64,0x38,0x00,
0x78,0x6C,0x6C,0x6C,0x6C,0x6C,0x78,0x00,
0x7C,0x60,0x60,0x78,0x60,0x60,0x7C,0x00,
0x7C,0x60,0x60,0x78,0x60,0x60,0x60,0x00,
0x38,0x64,0x60,0x60,0x6C,0x6C,0x3C,0x00,
0x6C,0x6C,0x6C,0x7C,0x6C,0x6C,0x6C,0x00,  //72
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x0C,0x0C,0x0C,0x0C,0x6C,0x6C,0x38,0x00,
0x6C,0x6C,0x6C,0x78,0x6C,0x6C,0x6C,0x00,
0x60,0x60,0x60,0x60,0x60,0x60,0x7C,0x00,
0x82,0xC6,0xEE,0xBE,0x96,0x86,0x86,0x00,
0x44,0x64,0x74,0x7C,0x5C,0x4C,0x44,0x00,
0x38,0x6C,0x6C,0x6C,0x6C,0x6C,0x38,0x00,
0x78,0x6C,0x6C,0x78,0x60,0x60,0x60,0x00,
0x38,0x6C,0x6C,0x6C,0x6C,0x6C,0x38,0x0C,
0x78,0x6C,0x6C,0x78,0x6C,0x6C,0x6C,0x00,  //82
0x38,0x64,0x30,0x18,0x0C,0x4C,0x38,0x00,
0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x38,0x00,
0x6C,0x6C,0x6C,0x6C,0x6C,0x68,0x70,0x00,
0xD6,0xD6,0xD6,0xD6,0xD6,0xD6,0xFC,0x00,
0x6C,0x6C,0x6C,0x38,0x6C,0x6C,0x6C,0x00,
0xCC,0xCC,0xCC,0x78,0x30,0x30,0x30,0x00,
0x7C,0x0C,0x18,0x30,0x60,0x60,0x7C,0x00,
0x70,0x60,0x60,0x60,0x60,0x60,0x70,0x00,
0x30,0x30,0x18,0x18,0x18,0x0C,0x0C,0x00,  //92
0x70,0x30,0x30,0x30,0x30,0x30,0x70,0x00,
0x18,0x3C,0x18,0x18,0x18,0x18,0x18,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x38,0x64,0x60,0x70,0x60,0x60,0x7C,0x00,
0x00,0x38,0x4C,0x3C,0x6C,0x6C,0x3C,0x00,
0x60,0x60,0x78,0x6C,0x6C,0x6C,0x78,0x00,
0x00,0x38,0x64,0x60,0x60,0x64,0x38,0x00,
0x0C,0x0C,0x3C,0x6C,0x6C,0x6C,0x3C,0x00,
0x00,0x38,0x6C,0x7C,0x60,0x64,0x38,0x00,
0x1C,0x30,0x78,0x30,0x30,0x30,0x30,0x00,  //102
0x00,0x3C,0x6C,0x6C,0x6C,0x3C,0x4C,0x38,
0x60,0x60,0x78,0x6C,0x6C,0x6C,0x6C,0x00,
0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,
0x0C,0x00,0x0C,0x0C,0x0C,0x0C,0x4C,0x38,
0x60,0x6C,0x6C,0x78,0x6C,0x6C,0x6C,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x00,0xFC,0xD6,0xD6,0xD6,0xD6,0xD6,0x00,
0x00,0x78,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,
0x00,0x38,0x6C,0x6C,0x6C,0x6C,0x38,0x00,
0x00,0x78,0x6C,0x6C,0x6C,0x78,0x60,0x60,  //112
0x00,0x3C,0x6C,0x6C,0x6C,0x3C,0x0C,0x0C,
0x00,0x6C,0x70,0x60,0x60,0x60,0x60,0x00,
0x00,0x38,0x64,0x30,0x18,0x4C,0x38,0x00,
0x18,0x18,0x3C,0x18,0x18,0x18,0x0C,0x00,
0x00,0x6C,0x6C,0x6C,0x6C,0x6C,0x3C,0x00,
0x00,0x6C,0x6C,0x6C,0x6C,0x68,0x70,0x00,
0x00,0xD6,0xD6,0xD6,0xD6,0xD6,0xFC,0x00,
0x00,0x6C,0x6C,0x38,0x6C,0x6C,0x6C,0x00,
0x00,0x6C,0x6C,0x6C,0x6C,0x3C,0x4C,0x38,
0x00,0x7C,0x0C,0x18,0x30,0x60,0x7C,0x00,  //122
0x1C,0x18,0x18,0x70,0x18,0x18,0x1C,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x70,0x30,0x30,0x1C,0x30,0x30,0x70,0x00,
0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00,
0x3C,0x42,0x99,0xB1,0xB1,0x99,0x42,0x3C



//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
,0x78,0x00,0x78,0x6C,0x6C,0x6C,0x6C,0x00

//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
//0x10,0x78,0xFC,0xF8,0xF8,0xFC,0x78,0x00
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x08,0x10,0x38,0x4C,0x3C,0x6C,0x3C,0x00,

//é e acentuada - 143
0x08,0x10,0x38,0x6C,0x7C,0x60,0x38,0x00,

//í i acentuada - 144
0x08,0x10,0x00,0x18,0x18,0x18,0x18,0x00,

//ó o acentuada - 145
0x08,0x10,0x38,0x6C,0x6C,0x6C,0x38,0x00,

//ú u acentuada - 146
0x08,0x10,0x6C,0x6C,0x6C,0x6C,0x3C,0x00,

//Ñ enye mayuscula - 147
0x7C,0x00,0x64,0x74,0x7C,0x5C,0x4C,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
255,137,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,189,129,189,129,255,0,

//Caracter maximizar - 152
255,129+8,129+8,129+8+16+32+64,129,129,255,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x38,0x64,0x60,0x64,0x38,0x10,0x20,

//à a acentuada abierta - 159
0x20,0x10,0x38,0x4C,0x3C,0x6C,0x3C,0x00,

//è e acentuada abierta - 160
0x20,0x10,0x38,0x6C,0x7C,0x60,0x38,0x00,

//ò o acentuada abierta - 161
0x20,0x10,0x38,0x6C,0x6C,0x6C,0x38,0x00,

//ü u con dieresis 162
0x6C,0x00,0x6C,0x6C,0x6C,0x6C,0x3C,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x14,0x00,0x18,0x18,0x18,0x18,0x18,0x00,

//Á A mayúscula acento cerrado - 168
0x08,0x10,0x38,0x6C,0x6C,0x7C,0x6C,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};

//Tipo de letra "topaz" de amiga500, workbench version 1.3
unsigned char char_set_amigaos[TOTAL_ASCII_CHARSET_ELEMENTS]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, //32
0x18,0x3C,0x3C,0x18,0x18,0x00,0x18,0x00,
0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,
0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00,
0x18,0x3E,0x60,0x3C,0x06,0x7C,0x18,0x00,
0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00,
0x38,0x6C,0x68,0x76,0xDC,0xCC,0x76,0x00,
0x18,0x18,0x30,0x00,0x00,0x00,0x00,0x00,
0x0C,0x18,0x30,0x30,0x30,0x18,0x0C,0x00,
0x30,0x18,0x0C,0x0C,0x0C,0x18,0x30,0x00,
0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00, //42
0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30,
0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,
0x03,0x06,0x0C,0x18,0x30,0x60,0xC0,0x00,
0x3C,0x66,0x6E,0x7E,0x76,0x66,0x3C,0x00,
0x18,0x38,0x18,0x18,0x18,0x18,0x7E,0x00,
0x3C,0x66,0x06,0x1C,0x30,0x66,0x7E,0x00,
0x3C,0x66,0x06,0x1C,0x06,0x66,0x3C,0x00,
0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00, //52
0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00,
0x1C,0x30,0x60,0x7C,0x66,0x66,0x3C,0x00,
0x7E,0x66,0x06,0x0C,0x18,0x18,0x18,0x00,
0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00,
0x3C,0x66,0x66,0x3E,0x06,0x0C,0x38,0x00,
0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,
0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x30,
0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00,
0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,
0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00, //62
0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00,
0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00,
0x18,0x3C,0x3C,0x66,0x7E,0xC3,0xC3,0x00,
0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00,
0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00,
0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00,
0xFE,0x66,0x60,0x78,0x60,0x66,0xFE,0x00,
0xFE,0x66,0x60,0x78,0x60,0x60,0xF0,0x00,
0x3C,0x66,0xC0,0xCE,0xC6,0x66,0x3E,0x00,
0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00, //72
0x7E,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,
0x0E,0x06,0x06,0x06,0x66,0x66,0x3C,0x00,
0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00,
0xF0,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,
0x82,0xC6,0xEE,0xFE,0xD6,0xC6,0xC6,0x00,
0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00,
0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00,
0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00,
0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x3C,0x06,
0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE3,0x00, //82
0x3C,0x66,0x70,0x38,0x0E,0x66,0x3C,0x00,
0x7E,0x5A,0x18,0x18,0x18,0x18,0x3C,0x00,
0x66,0x66,0x66,0x66,0x66,0x66,0x3E,0x00,
0xC3,0xC3,0x66,0x66,0x3C,0x3C,0x18,0x00,
0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00,
0xC3,0x66,0x3C,0x18,0x3C,0x66,0xC3,0x00,
0xC3,0xC3,0x66,0x3C,0x18,0x18,0x3C,0x00,
0xFE,0xC6,0x8C,0x18,0x32,0x66,0xFE,0x00,
0x3C,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,
0xC0,0x60,0x30,0x18,0x0C,0x06,0x03,0x00, //92
0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,
0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,
0x18,0x18,0x0C,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x3C,0x06,0x1E,0x66,0x3B,0x00,
0xE0,0x60,0x6C,0x76,0x66,0x66,0x3C,0x00,
0x00,0x00,0x3C,0x66,0x60,0x66,0x3C,0x00,
0x0E,0x06,0x36,0x6E,0x66,0x66,0x3B,0x00,
0x00,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00,
0x1C,0x36,0x30,0x78,0x30,0x30,0x78,0x00, //102
0x00,0x00,0x3B,0x66,0x66,0x3C,0xC6,0x7C,
0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00,
0x18,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,
0x06,0x00,0x06,0x06,0x06,0x06,0x66,0x3C,
0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00,
0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,
0x00,0x00,0x66,0x77,0x6B,0x63,0x63,0x00,
0x00,0x00,0x7C,0x66,0x66,0x66,0x66,0x00,
0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00,
0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0, //112
0x00,0x00,0x3D,0x66,0x66,0x3E,0x06,0x07,
0x00,0x00,0xEC,0x76,0x66,0x60,0xF0,0x00,
0x00,0x00,0x3E,0x60,0x3C,0x06,0x7C,0x00,
0x08,0x18,0x3E,0x18,0x18,0x1A,0x0C,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x3B,0x00,
0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x00,
0x00,0x00,0x63,0x6B,0x6B,0x36,0x36,0x00,
0x00,0x00,0x63,0x36,0x1C,0x36,0x63,0x00,
0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x70,
0x00,0x00,0x7E,0x4C,0x18,0x32,0x7E,0x00,
0x0E,0x18,0x18,0x70,0x18,0x18,0x0E,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x70,0x18,0x18,0x0E,0x18,0x18,0x70,0x00,
0x72,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,
0x0F,0x3C,0xF0,0xC3,0x0F,0x3C,0xF0,0x00


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//129
//caracter adicional para menu - enye minuscula
//,0xfe ,0x00 ,0xdc ,0x66 ,0x66 ,0x66 ,0x66 ,0x00
,0x3C,0x00,0x7C,0x66,0x66,0x66,0x66,0x00

//CYRILLIC SMALL LETTER I и. 130
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter cerrar ventana - 141 - Este 141 se uso por primera vez en RetroMac
0,126,66,90,90,66,126,0,

//á a acentuada - 142
0x04,0x08,0x3C,0x06,0x1E,0x66,0x3B,0x00,

//é e acentuada - 143
0x04,0x08,0x3C,0x66,0x7E,0x60,0x3C,0x00,

//í i acentuada - 144
0x08,0x10,0x00,0x38,0x18,0x18,0x3C,0x00,

//ó o acentuada - 145
0x04,0x08,0x3C,0x66,0x66,0x66,0x3C,0x00,

//ú u acentuada - 146
0x04,0x08,0x66,0x66,0x66,0x66,0x3B,0x00,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,
0x7C,0x00,0xC6,0xE6,0xF6,0xDE,0xCE,0x00,

//Caracter fondo titulo AmigaOS - 148. Este 148 se uso por primera vez en RetroMac
0,255,255,0,0,255,255,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,126,66,95,95,127,31,0,

//Caracter minimizar - 150
//255,129,129,255,129,129,255,0,
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
//0,126,66+8,66+8,66+8+16+32,66,126,0, //alternativo
0,126,66+16,66+16+32,66,66,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
//0x00,0x1C,0x20,0x20,0x20,0x1C,0x10,0x20,
0x00,0x3C,0x66,0x60,0x66,0x3C,0x10,0x20,

//à a acentuada abierta - 159
0x10,0x08,0x3C,0x06,0x1E,0x66,0x3B,0x00,

//è e acentuada abierta - 160
0x10,0x08,0x3C,0x66,0x7E,0x60,0x3C,0x00,

//ò o acentuada abierta - 161
0x10,0x08,0x3C,0x66,0x66,0x66,0x3C,0x00,

//ü u con dieresis 162
0x66,0x00,0x66,0x66,0x66,0x66,0x3B,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x28,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,

//Á A mayúscula acento cerrado - 168
0x04,0x08,0x3C,0x3C,0x66,0x7E,0xC3,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_ataritos[TOTAL_ASCII_CHARSET_ELEMENTS]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x00,
0x66,0x66,0x66,0x00,0x00,0x00,0x00,0x00,
0x00,0x6C,0xFE,0x6C,0x6C,0xFE,0x6C,0x00,
0x18,0x3E,0x60,0x3C,0x06,0x7C,0x18,0x00,
0x00,0x66,0x6C,0x18,0x30,0x66,0x46,0x00,
0x38,0x6C,0x38,0x70,0xDE,0xCC,0x76,0x00,
0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
0x0E,0x1C,0x18,0x18,0x18,0x1C,0x0E,0x00,
0x70,0x38,0x18,0x18,0x18,0x38,0x70,0x00,
0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,
0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60,
0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,
0x02,0x06,0x0C,0x18,0x30,0x60,0x40,0x00,
0x3C,0x66,0x6E,0x76,0x66,0x66,0x3C,0x00,
0x18,0x38,0x18,0x18,0x18,0x18,0x7E,0x00,
0x3C,0x66,0x06,0x0C,0x18,0x30,0x7E,0x00,
0x7E,0x0C,0x18,0x0C,0x06,0x66,0x3C,0x00,
0x0C,0x1C,0x3C,0x6C,0x7E,0x0C,0x0C,0x00,  //52
0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00,
0x3C,0x60,0x60,0x7C,0x66,0x66,0x3C,0x00,
0x7E,0x06,0x0C,0x18,0x30,0x30,0x30,0x00,
0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00,
0x3C,0x66,0x66,0x3E,0x06,0x0C,0x38,0x00,
0x00,0x18,0x18,0x00,0x18,0x18,0x00,0x00,
0x00,0x18,0x18,0x00,0x18,0x18,0x30,0x00,
0x06,0x0C,0x18,0x30,0x18,0x0C,0x06,0x00,
0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,
0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00,  //62
0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00,
0x3C,0x66,0x6E,0x6A,0x6E,0x60,0x3E,0x00,
0x18,0x3C,0x66,0x66,0x7E,0x66,0x66,0x00,
0x7C,0x66,0x66,0x7C,0x66,0x66,0x7C,0x00,
0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x00,
0x78,0x6C,0x66,0x66,0x66,0x6C,0x78,0x00,
0x7E,0x60,0x60,0x7C,0x60,0x60,0x7E,0x00,
0x7E,0x60,0x60,0x7C,0x60,0x60,0x60,0x00,
0x3E,0x60,0x60,0x6E,0x66,0x66,0x3E,0x00,
0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00, //72
0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,
0x06,0x06,0x06,0x06,0x06,0x66,0x3C,0x00,
0x66,0x6C,0x78,0x70,0x78,0x6C,0x66,0x00,
0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x00,
0xC6,0xEE,0xFE,0xD6,0xC6,0xC6,0xC6,0x00,
0x66,0x76,0x7E,0x7E,0x6E,0x66,0x66,0x00,
0x3C,0x66,0x66,0x66,0x66,0x66,0x3C,0x00,
0x7C,0x66,0x66,0x7C,0x60,0x60,0x60,0x00,
0x3C,0x66,0x66,0x66,0x76,0x6C,0x36,0x00,
0x7C,0x66,0x66,0x7C,0x6C,0x66,0x66,0x00, //82
0x3C,0x66,0x60,0x3C,0x06,0x66,0x3C,0x00,
0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x66,0x66,0x66,0x66,0x66,0x66,0x3E,0x00,
0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,
0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00,
0x66,0x66,0x3C,0x18,0x3C,0x66,0x66,0x00,
0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x00,
0x7E,0x06,0x0C,0x18,0x30,0x60,0x7E,0x00,
0x1E,0x18,0x18,0x18,0x18,0x18,0x1E,0x00,
0x40,0x60,0x30,0x18,0x0C,0x06,0x02,0x00, //92
0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,
0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,
0x00,0xC0,0x60,0x30,0x00,0x00,0x00,0x00,
0x00,0x00,0x3C,0x06,0x3E,0x66,0x3E,0x00,
0x60,0x60,0x7C,0x66,0x66,0x66,0x7C,0x00,
0x00,0x00,0x3C,0x60,0x60,0x60,0x3C,0x00,
0x06,0x06,0x3E,0x66,0x66,0x66,0x3E,0x00,
0x00,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00,
0x1C,0x30,0x7C,0x30,0x30,0x30,0x30,0x00, //102
0x00,0x00,0x3E,0x66,0x66,0x3E,0x06,0x7C,
0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x00,
0x18,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,
0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x70,
0x60,0x60,0x66,0x6C,0x78,0x6C,0x66,0x00,
0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,
0x00,0x00,0xEC,0xFE,0xD6,0xC6,0xC6,0x00,
0x00,0x00,0x7C,0x66,0x66,0x66,0x66,0x00,
0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00,
0x00,0x00,0x7C,0x66,0x66,0x66,0x7C,0x60, //112
0x00,0x00,0x3E,0x66,0x66,0x66,0x3E,0x06,
0x00,0x00,0x7C,0x66,0x60,0x60,0x60,0x00,
0x00,0x00,0x3E,0x60,0x3C,0x06,0x7C,0x00,
0x00,0x18,0x7E,0x18,0x18,0x18,0x0E,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x3E,0x00,
0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x00,
0x00,0x00,0xC6,0xC6,0xD6,0x7C,0x6C,0x00,
0x00,0x00,0x66,0x3C,0x18,0x3C,0x66,0x00,
0x00,0x00,0x66,0x66,0x66,0x3E,0x06,0x7C,
0x00,0x00,0x7E,0x0C,0x18,0x30,0x7E,0x00,
0x0E,0x18,0x18,0x30,0x18,0x18,0x0E,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x70,0x18,0x18,0x0C,0x18,0x18,0x70,0x00,
0x00,0x60,0xF2,0x9E,0x0C,0x00,0x00,0x00,
0x00,0x18,0x18,0x34,0x34,0x62,0x7E,0x00


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//129
//caracter adicional para menu - enye minuscula
,0x3C,0x00,0x7C,0x66,0x66,0x66,0x66,0x00

//CYRILLIC SMALL LETTER I и. 130
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre  - 140
0,60,90,102,102,90,60,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x04,0x08,0x3C,0x06,0x3E,0x66,0x3E,0x00,

//é e acentuada - 143
0x04,0x08,0x3C,0x66,0x7E,0x60,0x3C,0x00,

//í i acentuada - 144
0x04,0x08,0x30,0x18,0x18,0x18,0x3C,0x00,

//ó o acentuada - 145
0x04,0x08,0x3C,0x66,0x66,0x66,0x3C,0x00,

//ú u acentuada - 146
0x04,0x08,0x66,0x66,0x66,0x66,0x3E,0x00,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,

0x7E,0x00,0x66,0x76,0x7E,0x6E,0x66,0x00,

//Caracter fondo titulo estilo AtariTOS - 148
0,85,0,85,0,85,0,0,

//Caracter enviar a background estilo ZEsarUX plus - 149
//0,255,145,163,197,137,255,0,
0,1+4+16+64,2+8+32+128,1+4+16+64,2+8+32+128,1+4+16+64,2+8+32+128,0,

//Caracter minimizar estilo AtariTOS - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar estilo AtariTOS - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar estilo AtariTOS - 152
//0,126,2+64,2+64,2+64,2+64,126,0,
0,
128+64+32+8+4+2,
128+64+16+4+2,
128+32+16+8+2,
32+16+8,
128+32+16+8+2,
128+64+16+4+2,
128+64+32+8+4+2,


//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x3C,0x60,0x60,0x60,0x3C,0x10,0x20,

//à a acentuada abierta - 159
0x10,0x08,0x3C,0x06,0x3E,0x66,0x3E,0x00,

//è e acentuada abierta - 160
0x10,0x08,0x3C,0x66,0x7E,0x60,0x3C,0x00,

//ò o acentuada abierta - 161
0x10,0x08,0x3C,0x66,0x66,0x66,0x3C,0x00,

//ü u con dieresis 162
0x66,0x00,0x66,0x66,0x66,0x66,0x3E,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x28,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,

//Á A mayúscula acento cerrado - 168
0x04,0x08,0x18,0x3C,0x66,0x7E,0x66,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


//Extraido con ./bin_sprite_to_c pruebamsxchar.bin 8 96
unsigned char char_set_msx[TOTAL_ASCII_CHARSET_ELEMENTS]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x20,0x20,0x20,0x20,0x00,0x00,0x20,0x00,
0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00,
0x50,0x50,0xF8,0x50,0xF8,0x50,0x50,0x00,
0x20,0x78,0xA0,0x70,0x28,0xF0,0x20,0x00,
0xC0,0xC8,0x10,0x20,0x40,0x98,0x18,0x00,
0x40,0xA0,0x40,0xA8,0x90,0x98,0x60,0x00,
0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00,
0x10,0x20,0x40,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x10,0x10,0x10,0x20,0x40,0x00,
0x20,0xA8,0x70,0x20,0x70,0xA8,0x20,0x00,  //42
0x00,0x20,0x20,0xF8,0x20,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x20,0x20,0x40,
0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,
0x00,0x00,0x08,0x10,0x20,0x40,0x80,0x00,
0x70,0x88,0x98,0xA8,0xC8,0x88,0x70,0x00,
0x20,0x60,0xA0,0x20,0x20,0x20,0xF8,0x00,
0x70,0x88,0x08,0x10,0x60,0x80,0xF8,0x00,
0x70,0x88,0x08,0x30,0x08,0x88,0x70,0x00,
0x10,0x30,0x50,0x90,0xF8,0x10,0x10,0x00,  //52
0xF8,0x80,0xE0,0x10,0x08,0x10,0xE0,0x00,
0x30,0x40,0x80,0xF0,0x88,0x88,0x70,0x00,
0xF8,0x88,0x10,0x20,0x20,0x20,0x20,0x00,
0x70,0x88,0x88,0x70,0x88,0x88,0x70,0x00,
0x70,0x88,0x88,0x78,0x08,0x10,0x60,0x00,
0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,
0x00,0x00,0x20,0x00,0x00,0x20,0x20,0x40,
0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00,
0x00,0x00,0xF8,0x00,0xF8,0x00,0x00,0x00,
0xC0,0x60,0x30,0x18,0x30,0x60,0xC0,0x00,  //62
0x70,0x88,0x08,0x10,0x20,0x00,0x20,0x00,
0x70,0x88,0x08,0x68,0xA8,0xA8,0x70,0x00,
0x20,0x50,0x88,0x88,0xF8,0x88,0x88,0x00,
0xF0,0x48,0x48,0x70,0x48,0x48,0xF0,0x00,
0x30,0x48,0x80,0x80,0x80,0x48,0x30,0x00,
0xE0,0x50,0x48,0x48,0x48,0x50,0xE0,0x00,
0xF8,0x80,0x80,0xF0,0x80,0x80,0xF8,0x00,
0xF8,0x80,0x80,0xF0,0x80,0x80,0x80,0x00,
0x70,0x88,0x80,0xB8,0x88,0x88,0x70,0x00,
0x88,0x88,0x88,0xF8,0x88,0x88,0x88,0x00,  //72
0x70,0x20,0x20,0x20,0x20,0x20,0x70,0x00,
0x38,0x10,0x10,0x10,0x90,0x90,0x60,0x00,
0x88,0x90,0xA0,0xC0,0xA0,0x90,0x88,0x00,
0x80,0x80,0x80,0x80,0x80,0x80,0xF8,0x00,
0x88,0xD8,0xA8,0xA8,0x88,0x88,0x88,0x00,
0x88,0xC8,0xC8,0xA8,0x98,0x98,0x88,0x00,
0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00,
0xF0,0x88,0x88,0xF0,0x80,0x80,0x80,0x00,
0x70,0x88,0x88,0x88,0xA8,0x90,0x68,0x00,
0xF0,0x88,0x88,0xF0,0xA0,0x90,0x88,0x00,  //82
0x70,0x88,0x80,0x70,0x08,0x88,0x70,0x00,
0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0x00,
0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,
0x88,0x88,0x88,0x88,0x50,0x50,0x20,0x00,
0x88,0x88,0x88,0xA8,0xA8,0xD8,0x88,0x00,
0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00,
0x88,0x88,0x88,0x70,0x20,0x20,0x20,0x00,
0xF8,0x08,0x10,0x20,0x40,0x80,0xF8,0x00,
0x70,0x40,0x40,0x40,0x40,0x40,0x70,0x00,
0x00,0x00,0x80,0x40,0x20,0x10,0x08,0x00,  //92
0x70,0x10,0x10,0x10,0x10,0x10,0x70,0x00,
0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x00,
0x40,0x20,0x10,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x70,0x08,0x78,0x88,0x78,0x00,
0x80,0x80,0xB0,0xC8,0x88,0xC8,0xB0,0x00,
0x00,0x00,0x70,0x88,0x80,0x88,0x70,0x00,
0x08,0x08,0x68,0x98,0x88,0x98,0x68,0x00,
0x00,0x00,0x70,0x88,0xF8,0x80,0x70,0x00,
0x10,0x28,0x20,0xF8,0x20,0x20,0x20,0x00,  //102
0x00,0x00,0x68,0x98,0x98,0x68,0x08,0x70,
0x80,0x80,0xF0,0x88,0x88,0x88,0x88,0x00,
0x20,0x00,0x60,0x20,0x20,0x20,0x70,0x00,
0x10,0x00,0x30,0x10,0x10,0x10,0x90,0x60,
0x40,0x40,0x48,0x50,0x60,0x50,0x48,0x00,
0x60,0x20,0x20,0x20,0x20,0x20,0x70,0x00,
0x00,0x00,0xD0,0xA8,0xA8,0xA8,0xA8,0x00,
0x00,0x00,0xB0,0xC8,0x88,0x88,0x88,0x00,
0x00,0x00,0x70,0x88,0x88,0x88,0x70,0x00,
0x00,0x00,0xB0,0xC8,0xC8,0xB0,0x80,0x80,  //112
0x00,0x00,0x68,0x98,0x98,0x68,0x08,0x08,
0x00,0x00,0xB0,0xC8,0x80,0x80,0x80,0x00,
0x00,0x00,0x78,0x80,0xF0,0x08,0xF0,0x00,
0x40,0x40,0xF0,0x40,0x40,0x48,0x30,0x00,
0x00,0x00,0x90,0x90,0x90,0x90,0x68,0x00,
0x00,0x00,0x88,0x88,0x88,0x50,0x20,0x00,
0x00,0x00,0x88,0xA8,0xA8,0xA8,0x50,0x00,
0x00,0x00,0x88,0x50,0x20,0x50,0x88,0x00,
0x00,0x00,0x88,0x88,0x98,0x68,0x08,0x70,
0x00,0x00,0xF8,0x10,0x20,0x40,0xF8,0x00,
0x18,0x20,0x20,0x40,0x20,0x20,0x18,0x00,
0x20,0x20,0x20,0x00,0x20,0x20,0x20,0x00,
0xC0,0x20,0x20,0x10,0x20,0x20,0xC0,0x00,
0x40,0xA8,0x10,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x20,0x50,0xF8,0x00,0x00,0x00


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
//,0xfe ,0x00 ,0xdc ,0x66 ,0x66 ,0x66 ,0x66 ,0x00
,0x70,0x00,0xB0,0xC8,0x88,0x88,0x88,0x00

//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x10,0x20,0x70,0x08,0x78,0x88,0x78,0x00,

//é e acentuada - 143
0x10,0x20,0x70,0x88,0xF8,0x80,0x70,0x00,

//í i acentuada - 144
0x10,0x20,0x00,0x60,0x20,0x20,0x70,0x00,

//ó o acentuada - 145
0x10,0x20,0x70,0x88,0x88,0x88,0x70,0x00,

//ú u acentuada - 146
0x10,0x20,0x90,0x90,0x90,0x90,0x68,0x00,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,
0xf8,0x00,0x88,0xC8,0xC8,0xA8,0x98,0x00,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
//0x00,0x1C,0x20,0x20,0x20,0x1C,0x10,0x20,
0x00,0x70,0x88,0x80,0x88,0x70,0x20,0x40,

//à a acentuada abierta - 159
0x40,0x20,0x70,0x08,0x78,0x88,0x78,0x00,

//è e acentuada abierta - 160
0x40,0x20,0x70,0x88,0xF8,0x80,0x70,0x00,

//ò o acentuada abierta - 161
0x40,0x20,0x70,0x88,0x88,0x88,0x70,0x00,

//ü u con dieresis 162
0x90,0x00,0x90,0x90,0x90,0x90,0x68,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x30,0x30,0x30,0x30,0xFC,0x78,0x30,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x30,0x78,0xFC,0x30,0x30,0x30,0x30,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x20,0x30,0xF8,0xF8,0x30,0x20,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x20,0x60,0xF8,0xF8,0x60,0x20,0x00,

//ï i con dieresis - 167
0x50,0x00,0x60,0x20,0x20,0x20,0x70,0x00,

//Á A mayúscula acento cerrado - 168
0x04,0x08,0x20,0x50,0x88,0xF8,0x88,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


unsigned char char_set_beos[TOTAL_ASCII_CHARSET_ELEMENTS]={
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //32
0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10,
0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x28, 0x28, 0x7C, 0x28, 0x7C, 0x28, 0x28,
0x00, 0x10, 0x3C, 0x50, 0x38, 0x14, 0x78, 0x10,
0x00, 0x60, 0x64, 0x08, 0x10, 0x20, 0x4C, 0x0C,
0x00, 0x38, 0x40, 0x40, 0x20, 0x54, 0x48, 0x34,
0x18, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08,
0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20,
0x00, 0x00, 0x10, 0x54, 0x38, 0x54, 0x10, 0x00,  //42
0x00, 0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,  //44 ,
0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40,
0x38, 0x44, 0x4C, 0x54, 0x64, 0x44, 0x44, 0x38,
0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
0x38, 0x44, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7C,
0x38, 0x44, 0x04, 0x18, 0x04, 0x04, 0x44, 0x38,
0x04, 0x0C, 0x14, 0x24, 0x44, 0x7C, 0x04, 0x04,  //52
0x7C, 0x40, 0x40, 0x78, 0x04, 0x04, 0x44, 0x38,
0x18, 0x20, 0x40, 0x78, 0x44, 0x44, 0x44, 0x38,
0x7C, 0x44, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10,
0x38, 0x44, 0x44, 0x38, 0x44, 0x44, 0x44, 0x38,
0x38, 0x44, 0x44, 0x44, 0x3C, 0x04, 0x08, 0x30,
0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18,
0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x30, //59 ;
0x00, 0x00, 0x0C, 0x30, 0xC0, 0x30, 0x0C, 0x00,
0x00, 0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00,
0x00, 0x00, 0xC0, 0x30, 0x0C, 0x30, 0xC0, 0x00,  //62
0x38, 0x44, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10,
0x00, 0x38, 0x44, 0x5C, 0x5C, 0x58, 0x40, 0x38,
0x00, 0x10, 0x28, 0x44, 0x44, 0x7C, 0x44, 0x44,
0x00, 0x78, 0x44, 0x44, 0x78, 0x44, 0x44, 0x78,
0x00, 0x38, 0x44, 0x40, 0x40, 0x40, 0x44, 0x38,
0x00, 0x70, 0x48, 0x44, 0x44, 0x44, 0x48, 0x70,
0x00, 0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7C,
0x00, 0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40,
0x00, 0x38, 0x44, 0x40, 0x4C, 0x44, 0x44, 0x3C,
0x00, 0x44, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44,  //72
0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C,
0x00, 0x1C, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38,
0x00, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44,
0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7C,
0x00, 0x44, 0x6C, 0x54, 0x54, 0x44, 0x44, 0x44,
0x00, 0x44, 0x64, 0x64, 0x54, 0x4C, 0x4C, 0x44,
0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38,
0x00, 0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40,
0x00, 0x38, 0x44, 0x44, 0x44, 0x54, 0x48, 0x34,  //81 Q
0x00, 0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44,  //82
0x00, 0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x38,
0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38,
0x00, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10,
0x00, 0x44, 0x44, 0x44, 0x54, 0x54, 0x6C, 0x44,
0x00, 0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44,
0x00, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10,
0x00, 0x7C, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7C,
0x00, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1C,
0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04,  //92
0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x70,
0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E,  //95 _
0x30, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x3C, 0x44, 0x44, 0x4C, 0x34,
0x40, 0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x78,
0x00, 0x00, 0x00, 0x3C, 0x40, 0x40, 0x40, 0x3C,
0x04, 0x04, 0x04, 0x3C, 0x44, 0x44, 0x44, 0x3C,
0x00, 0x00, 0x00, 0x38, 0x44, 0x7C, 0x40, 0x38,
0x1C, 0x20, 0x20, 0x78, 0x20, 0x20, 0x20, 0x20,  //102
0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x38, //103 g
0x40, 0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x44,
0x10, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x38,
0x08, 0x08, 0x00, 0x38, 0x08, 0x08, 0x08, 0x38,  //106 j
0x40, 0x40, 0x40, 0x48, 0x50, 0x60, 0x50, 0x48,
0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
0x00, 0x00, 0x00, 0x68, 0x54, 0x54, 0x54, 0x44,
0x00, 0x00, 0x00, 0x58, 0x64, 0x44, 0x44, 0x44,
0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38,
0x00, 0x00, 0x00, 0x78, 0x44, 0x44, 0x78, 0x40, //112  "p"
0x00, 0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04,
0x00, 0x00, 0x00, 0x58, 0x60, 0x40, 0x40, 0x40,
0x00, 0x00, 0x00, 0x3C, 0x40, 0x38, 0x04, 0x78,
0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x10, 0x0C, //116 t
0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x4C, 0x34,
0x00, 0x00, 0x00, 0x6C, 0x28, 0x28, 0x10, 0x10,
0x00, 0x00, 0x00, 0x44, 0x54, 0x54, 0x54, 0x28,
0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44,
0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x3C, 0x04, //121 y
0x00, 0x00, 0x00, 0x7C, 0x08, 0x10, 0x20, 0x7C, //122
0x08, 0x08, 0x08, 0x08, 0x10, 0x08, 0x08, 0x08,
0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
0x20, 0x20, 0x20, 0x20, 0x10, 0x20, 0x20, 0x20,
0x20, 0x54, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x7C

//caracter adicional para menu - franja de color de spectrum

	,	1
	,	3
	,	7
	,	15
	,	31
	,	63
	,	127
	,	255

//caracter adicional para menu - enye minuscula
,0x00, 0x38, 0x00, 0x58, 0x64, 0x44, 0x44, 0x44,

//CYRILLIC SMALL LETTER I и
0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,126,66,66,66,66,126,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x00, 0x08, 0x10, 0x3C, 0x44, 0x44, 0x4C, 0x34,

//é e acentuada - 143
0x00, 0x08, 0x10, 0x38, 0x44, 0x7C, 0x40, 0x38,

//í i acentuada - 144
0x00, 0x08, 0x10, 0x30, 0x10, 0x10, 0x10, 0x38,

//ó o acentuada - 145
0x00, 0x08, 0x10, 0x38, 0x44, 0x44, 0x44, 0x38,

//ú u acentuada - 146
0x00, 0x08, 0x10, 0x44, 0x44, 0x44, 0x4C, 0x34,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,
0x7c, 0x00, 0x44, 0x64, 0x64, 0x54, 0x4C, 0x44,

//Caracter fondo titulo RetroMac - 148
0,255,0,255,0,255,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,254,146,162,198,138,146,254,

//Caracter minimizar - 150
0,254,130,130,254,130,130,254,

//Caracter restaurar - 151
//255,129,189,129,129,189,129,255,
0,254,130,186,130,186,130,254,

//Caracter maximizar - 152
//16+32+64,2+4+8+16+64,2+16+32+64,2+32,2+32,2+32,2+4+8+16+32,0  //alternativo algo mas pequeño
0, 16+32+64+128,16+128,2+4+8+16+128,2+16+32+64+128,    34,34,2+4+8+16+32,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00, 0x00, 0x3C, 0x40, 0x40, 0x48, 0x3C, 0x10,

//à a acentuada abierta - 159
0x00, 0x20, 0x10, 0x3C, 0x44, 0x44, 0x4C, 0x34,

//è e acentuada abierta - 160
0x00, 0x20, 0x10, 0x38, 0x44, 0x7C, 0x40, 0x38,

//ò o acentuada abierta - 161
0x00, 0x20, 0x10, 0x38, 0x44, 0x44, 0x44, 0x38,

//ü u con dieresis 162
0x00, 0x44, 0x00, 0x44, 0x44, 0x44, 0x4C, 0x34,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x00, 0x28, 0x00, 0x30, 0x10, 0x10, 0x10, 0x38,

//Á A mayúscula acento cerrado - 168
0x02, 0x04, 0x10, 0x28, 0x44, 0x44, 0x7C, 0x44,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};

//DOS 8x8 bitmap by Neil Roy
//Portado de su version png a crudo 8x8
//generado con sample_convert_gimp_c_image.c
//Usado en OS/2 y otros estilos
unsigned char char_set_dos[TOTAL_ASCII_CHARSET_ELEMENTS]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,    //32
0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00,
0x6c,0x6c,0x6c,0x00,0x00,0x00,0x00,0x00,
0x6c,0x6c,0xfe,0x6c,0xfe,0x6c,0x6c,0x00,
0x30,0x7c,0xc0,0x78,0x0c,0xf8,0x30,0x00,
0x00,0xc6,0xcc,0x18,0x30,0x66,0xc6,0x00,
0x38,0x6c,0x38,0x76,0xdc,0xcc,0x76,0x00,
0x60,0x60,0xc0,0x00,0x00,0x00,0x00,0x00,
0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00,
0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00,
0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,    //42
0x00,0x30,0x30,0xfc,0x30,0x30,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x70,0x30,0x60,
0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,
0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,
0x78,0xcc,0xdc,0xfc,0xec,0xcc,0x78,0x00,
0x30,0xf0,0x30,0x30,0x30,0x30,0xfc,0x00,
0x78,0xcc,0x0c,0x38,0x60,0xcc,0xfc,0x00,
0x78,0xcc,0x0c,0x38,0x0c,0xcc,0x78,0x00,
0x1c,0x3c,0x6c,0xcc,0xfe,0x0c,0x0c,0x00,    //52
0xfc,0xc0,0xf8,0x0c,0x0c,0xcc,0x78,0x00,
0x38,0x60,0xc0,0xf8,0xcc,0xcc,0x78,0x00,
0xfc,0xcc,0x0c,0x18,0x30,0x60,0x60,0x00,
0x78,0xcc,0xcc,0x78,0xcc,0xcc,0x78,0x00,
0x78,0xcc,0xcc,0x7c,0x0c,0x18,0x70,0x00,
0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x00,
0x00,0x00,0x30,0x30,0x00,0x70,0x30,0x60,
0x18,0x30,0x60,0xc0,0x60,0x30,0x18,0x00,
0x00,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,
0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,    //62
0x78,0xcc,0x0c,0x18,0x30,0x00,0x30,0x00,
0x7c,0xc6,0xde,0xde,0xde,0xc0,0x78,0x00,
0x30,0x78,0xcc,0xcc,0xfc,0xcc,0xcc,0x00,
0xfc,0x66,0x66,0x7c,0x66,0x66,0xfc,0x00,
0x3c,0x66,0xc0,0xc0,0xc0,0x66,0x3c,0x00,
0xfc,0x6c,0x66,0x66,0x66,0x6c,0xfc,0x00,
0xfe,0x62,0x68,0x78,0x68,0x62,0xfe,0x00,
0xfe,0x62,0x68,0x78,0x68,0x60,0xf0,0x00,
0x3c,0x66,0xc0,0xc0,0xce,0x66,0x3e,0x00,
0xcc,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0x00,    //72
0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00,
0x1e,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,0x00,
0xe6,0x66,0x6c,0x78,0x6c,0x66,0xe6,0x00,
0xf0,0x60,0x60,0x60,0x62,0x66,0xfe,0x00,
0xc6,0xee,0xfe,0xd6,0xc6,0xc6,0xc6,0x00,
0xc6,0xe6,0xf6,0xde,0xce,0xc6,0xc6,0x00,
0x38,0x6c,0xc6,0xc6,0xc6,0x6c,0x38,0x00,
0xfc,0x66,0x66,0x7c,0x60,0x60,0xf0,0x00,
0x78,0xcc,0xcc,0xcc,0xdc,0x78,0x1c,0x00,
0xfc,0x66,0x66,0x7c,0x78,0x6c,0xe6,0x00,    //82
0x78,0xcc,0xe0,0x38,0x1c,0xcc,0x78,0x00,
0xfc,0xb4,0x30,0x30,0x30,0x30,0x78,0x00,
0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xfc,0x00,
0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x30,0x00,
0xc6,0xc6,0xc6,0xd6,0xfe,0xee,0xc6,0x00,
0xc6,0xc6,0x6c,0x38,0x6c,0xc6,0xc6,0x00,
0xcc,0xcc,0xcc,0x78,0x30,0x30,0x78,0x00,
0xfe,0xcc,0x98,0x30,0x62,0xc6,0xfe,0x00,
0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00,
0xc0,0x60,0x30,0x18,0x0c,0x06,0x02,0x00,    //92
0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,
0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x0c,0x7c,0xcc,0x76,0x00,
0xe0,0x60,0x7c,0x66,0x66,0x66,0xbc,0x00,
0x00,0x00,0x78,0xcc,0xc0,0xcc,0x78,0x00,
0x1c,0x0c,0x0c,0x7c,0xcc,0xcc,0x76,0x00,
0x00,0x00,0x78,0xcc,0xfc,0xc0,0x78,0x00,
0x38,0x6c,0x60,0xf0,0x60,0x60,0xf0,0x00,    //102
0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0xf8,
0xe0,0x60,0x6c,0x76,0x66,0x66,0xe6,0x00,
0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00,
0x18,0x00,0x78,0x18,0x18,0x18,0xd8,0x70,
0xe0,0x60,0x66,0x6c,0x78,0x6c,0xe6,0x00,
0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00,
0x00,0x00,0xec,0xfe,0xd6,0xc6,0xc6,0x00,
0x00,0x00,0xf8,0xcc,0xcc,0xcc,0xcc,0x00,
0x00,0x00,0x78,0xcc,0xcc,0xcc,0x78,0x00,
0x00,0x00,0xdc,0x66,0x66,0x7c,0x60,0xf0,    //112
0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0x1e,
0x00,0x00,0xd8,0x6c,0x6c,0x60,0xf0,0x00,
0x00,0x00,0x7c,0xc0,0x78,0x0c,0xf8,0x00,
0x10,0x30,0x7c,0x30,0x30,0x34,0x18,0x00,
0x00,0x00,0xcc,0xcc,0xcc,0xcc,0x76,0x00,
0x00,0x00,0xcc,0xcc,0xcc,0x78,0x30,0x00,
0x00,0x00,0xc6,0xc6,0xd6,0xfe,0x6c,0x00,
0x00,0x00,0xc6,0x6c,0x38,0x6c,0xc6,0x00,
0x00,0x00,0xcc,0xcc,0xcc,0x7c,0x0c,0xf8,
0x00,0x00,0xfc,0x98,0x30,0x64,0xfc,0x00,    //122
0x1c,0x30,0x30,0xe0,0x30,0x30,0x1c,0x00,
0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00,
0xe0,0x30,0x30,0x1c,0x30,0x30,0xe0,0x00,
0x76,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,
0x10,0x38,0x6c,0xc6,0xc6,0xc6,0xfe,0x00

//n=110
//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//129
//caracter adicional para menu - enye minuscula
//,0xfe ,0x00 ,0xdc ,0x66 ,0x66 ,0x66 ,0x66 ,0x00
,0x78,0x00,0xf8,0xcc,0xcc,0xcc,0xcc,0x00

//CYRILLIC SMALL LETTER I и. 130
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre OS/2 - 140
//255,131,133,137,145,161,193,255,
//0,126*2,70*2,74*2,82*2,98*2,126*2,0,
0,252,120,48,0,252,0,0,

//Caracter boton cierre Turbovision - 141
0,63,63,63,63,63,63,0,

//á a acentuada - 142
0x08,0x10,0x78,0x0c,0x7c,0xcc,0x76,0x00,

//é e acentuada - 143
0x08,0x10,0x78,0xcc,0xfc,0xc0,0x78,0x00,

//í i acentuada - 144
0x08,0x10,0x00,0x70,0x30,0x30,0x78,0x00,

//ó o acentuada - 145
0x08,0x10,0x78,0xcc,0xcc,0xcc,0x78,0x00,

//ú u acentuada - 146
0x08,0x10,0xcc,0xcc,0xcc,0xcc,0x76,0x00,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,
0x7C,0x00,0xc6,0xe6,0xf6,0xde,0xce,0x00,

//Caracter botón enviar a background estilo ZEsarUX plus - 148
0,1+4+16+64,2+8+32+128,1+4+16+64,2+8+32+128,1+4+16+64,2+8+32+128,0,
//0,2+8+32+128,4+16+64,2+8+32+128,4+16+64,2+8+32+128,4+16+64,0,

//Caracter botón enviar a background - 149 estilos os/2 y otros
0,254,146,162,198,138,146,254,

//Caracter minimizar - 150
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter restaurar - 151
0,0,1+128+4+8+16+32,1+128+4+32,1+128+4+32,1+128+4+8+16+32,0,0,

//Caracter maximizar - 152
0,126*2,66*2,66*2,66*2,66*2,126*2,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60*2,90*2,102*2,102*2,90*2,60*2,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x78,0xcc,0xc0,0xcc,0x78,0x20,0x40,

//à a acentuada abierta - 159
0x20,0x10,0x78,0x0c,0x7c,0xcc,0x76,0x00,

//è e acentuada abierta - 160
0x20,0x10,0x78,0xcc,0xfc,0xc0,0x78,0x00,

//ò o acentuada abierta - 161
0x20,0x10,0x78,0xcc,0xcc,0xcc,0x78,0x00,

//ü u con dieresis 162
0xcc,0x00,0xcc,0xcc,0xcc,0xcc,0x76,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x10,0x18,0xFC,0xFC,0x18,0x10,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x10,0x30,0x7E,0x7E,0x30,0x10,0x00,

//ï i con dieresis - 167
0x50,0x00,0x70,0x30,0x30,0x30,0x78,0x00,

//Á A mayúscula acento cerrado - 168
0x04,0x08,0x30,0x78,0xcc,0xfc,0xcc,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};

//Basado en Z88 con variaciones
unsigned char char_set_templeos[TOTAL_ASCII_CHARSET_ELEMENTS]={

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  //32
0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x0c,0x00,
0x1b,0x1b,0x1b,0x00,0x00,0x00,0x00,0x00,
0x0a,0x1f,0x1f,0x0a,0x1f,0x1f,0x0a,0x00,
0x0c,0x1f,0x2c,0x1e,0x0d,0x3e,0x0c,0x00,
0x30,0x33,0x06,0x0c,0x18,0x33,0x03,0x00,
0x1c,0x36,0x36,0x18,0x35,0x32,0x1d,0x00,
0x06,0x0c,0x18,0x00,0x00,0x00,0x00,0x00,
0x06,0x0c,0x18,0x18,0x18,0x0c,0x06,0x00,
0x18,0x0c,0x06,0x06,0x06,0x0c,0x18,0x00,
0x00,0x0c,0x3f,0x1e,0x3f,0x0c,0x00,0x00,  //42
0x00,0x0c,0x0c,0x3f,0x3f,0x0c,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x18,
0x00,0x00,0x00,0x1f,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,
0x00,0x03,0x06,0x0c,0x18,0x30,0x00,0x00,
0x0e,0x19,0x1b,0x1d,0x19,0x19,0x0e,0x00,
0x0c,0x1c,0x0c,0x0c,0x0c,0x0c,0x3f,0x00,
0x0e,0x1b,0x03,0x06,0x0c,0x18,0x1f,0x00,
0x1f,0x03,0x06,0x03,0x03,0x1b,0x0e,0x00,
0x06,0x0e,0x16,0x26,0x3f,0x06,0x06,0x00,  //52
0x1f,0x18,0x1e,0x03,0x03,0x1b,0x0e,0x00,
0x06,0x0c,0x18,0x1e,0x1b,0x1b,0x0e,0x00,
0x1f,0x03,0x03,0x06,0x0c,0x0c,0x0c,0x00,
0x0e,0x1b,0x1b,0x0e,0x1b,0x1b,0x0e,0x00,
0x0e,0x1b,0x1b,0x0f,0x03,0x06,0x0c,0x00,
0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x00,
0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x18,
0x03,0x06,0x0c,0x18,0x0c,0x06,0x03,0x00,
0x00,0x1f,0x1f,0x00,0x1f,0x1f,0x00,0x00,
0x18,0x0c,0x06,0x03,0x06,0x0c,0x18,0x00,  //62
0x0e,0x1b,0x03,0x06,0x06,0x00,0x06,0x00,
0x1e,0x33,0x37,0x35,0x37,0x30,0x1e,0x00,
0x0e,0x1b,0x1b,0x1f,0x1b,0x1b,0x1b,0x00,
0x1e,0x1b,0x1b,0x1e,0x1b,0x1b,0x1e,0x00,
0x0e,0x1b,0x18,0x18,0x18,0x1b,0x0e,0x00,
0x1c,0x1a,0x1b,0x1b,0x1b,0x1a,0x1c,0x00,
0x1f,0x18,0x18,0x1e,0x18,0x18,0x1f,0x00,
0x1f,0x18,0x18,0x1e,0x18,0x18,0x18,0x00,
0x0e,0x19,0x18,0x1b,0x19,0x19,0x0e,0x00,
0x19,0x19,0x19,0x1f,0x19,0x19,0x19,0x00,  //72
0x0f,0x06,0x06,0x06,0x06,0x06,0x0f,0x00,
0x1f,0x06,0x06,0x06,0x06,0x16,0x0c,0x00,
0x19,0x1a,0x1c,0x1c,0x1c,0x1a,0x19,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x1f,0x00,
0x11,0x1b,0x1f,0x1f,0x15,0x15,0x11,0x00,
0x11,0x19,0x1d,0x1f,0x1b,0x19,0x19,0x00,
0x0e,0x1b,0x1b,0x1b,0x1b,0x1b,0x0e,0x00,
0x1e,0x1b,0x1b,0x1e,0x18,0x18,0x18,0x00,
0x0e,0x19,0x19,0x19,0x1d,0x1a,0x0d,0x00,
0x1e,0x1b,0x1b,0x1e,0x1c,0x1a,0x19,0x00,  //82
0x0e,0x1b,0x18,0x0e,0x03,0x1b,0x0e,0x00,
0x3f,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x00,
0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x0e,0x00,
0x1b,0x1b,0x1b,0x1b,0x1b,0x0a,0x04,0x00,
0x11,0x11,0x15,0x15,0x1f,0x1f,0x0a,0x00,
0x1b,0x1b,0x0a,0x04,0x0a,0x1b,0x1b,0x00,
0x1b,0x1b,0x1b,0x0a,0x04,0x04,0x04,0x00,
0x1f,0x03,0x06,0x0c,0x18,0x18,0x1f,0x00,
0x1e,0x18,0x18,0x18,0x18,0x18,0x1e,0x00,
0x00,0x30,0x18,0x0c,0x06,0x03,0x00,0x00,  //92
0x1e,0x06,0x06,0x06,0x06,0x06,0x1e,0x00,
0x0c,0x1e,0x33,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x3f,0x00,
0x18,0x0c,0x06,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x0e,0x03,0x0f,0x1b,0x0f,0x00,
0x18,0x18,0x1e,0x1b,0x1b,0x1b,0x1e,0x00,
0x00,0x00,0x0e,0x18,0x18,0x18,0x0e,0x00,
0x03,0x03,0x0f,0x1b,0x1b,0x1b,0x0f,0x00,
0x00,0x00,0x0e,0x1b,0x1f,0x18,0x0e,0x00,
0x06,0x0d,0x0c,0x1e,0x0c,0x0c,0x0c,0x00,  //102
0x00,0x00,0x0e,0x1b,0x1b,0x0f,0x03,0x0e,
0x18,0x18,0x1e,0x1b,0x1b,0x1b,0x1b,0x00,
0x06,0x00,0x0e,0x06,0x06,0x06,0x0f,0x00,
0x06,0x00,0x0e,0x06,0x06,0x06,0x06,0x1c,
0x18,0x18,0x1b,0x1e,0x1e,0x1b,0x19,0x00,
0x1c,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,
0x00,0x00,0x0a,0x1f,0x1f,0x15,0x15,0x00,
0x00,0x00,0x1e,0x1b,0x1b,0x1b,0x1b,0x00,
0x00,0x00,0x0e,0x1b,0x1b,0x1b,0x0e,0x00,
0x00,0x00,0x1e,0x1b,0x1b,0x1e,0x18,0x18,  //112
0x00,0x00,0x1e,0x36,0x36,0x1e,0x06,0x07,
0x00,0x00,0x1b,0x1c,0x18,0x18,0x18,0x00,
0x00,0x00,0x0f,0x18,0x0e,0x03,0x1e,0x00,
0x00,0x0c,0x1f,0x0c,0x0c,0x0d,0x06,0x00,
0x00,0x00,0x1b,0x1b,0x1b,0x1b,0x0f,0x00,
0x00,0x00,0x1b,0x1b,0x1b,0x0a,0x04,0x00,
0x00,0x00,0x15,0x15,0x1f,0x1f,0x0a,0x00,
0x00,0x00,0x1b,0x0a,0x04,0x0a,0x1b,0x00,
0x00,0x00,0x1b,0x1b,0x1b,0x0f,0x03,0x0e,
0x00,0x00,0x1f,0x06,0x0c,0x18,0x1f,0x00,  //122
0x06,0x0c,0x0c,0x18,0x0c,0x0c,0x06,0x00,
0x0c,0x0c,0x0c,0x00,0x0c,0x0c,0x0c,0x00,
0x18,0x0c,0x0c,0x06,0x0c,0x0c,0x18,0x00,
0x00,0x18,0x2d,0x06,0x00,0x00,0x00,0x00,
0x0e,0x19,0x3c,0x18,0x3c,0x19,0x0e,0x00


//caracter adicional para menu - franja de color de spectrum

        ,       1
        ,       3
        ,       7
        ,       15
        ,       31
        ,       63
        ,       127
        ,       255

//caracter adicional para menu - enye minuscula
,0x1E,0x00,0x1e,0x1b,0x1b,0x1b,0x1b,0x00


//CYRILLIC SMALL LETTER I и
,0x00 ,0x42  ,0x46 ,0x4a ,0x52 ,0x62 ,0x42 ,0x00,

//Cyrillic Ш - 131
0x00,0x54,0x54,0x54,0x54,0x54,0x7C,0x00,

//Cyrillic л - 132
0x00,0x00,0x1E,0x22,0x22,0x22,0x42,0x00,

//Cyrillic г - 133
0x00,0x00,0x3C,0x20,0x20,0x20,0x20,0x00,

//Cyrillic ч - 134
0x00,0x00,0x44,0x44,0x44,0x3C,0x04,0x04,

//Cyrillic д - 135
0x00,0x1C,0x24,0x24,0x44,0x7E,0x42,0x42,

//Cyrillic я - 136
0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00,

//Letra minuscula r con anzuelo ɾ - 137
0x00,0x00,0x18,0x24,0x20,0x20,0x20,0x00,

//Greek Small Letter Theta θ - 138
0x3c,0x42,0x42,0x7e,0x42,0x42,0x3c,0x00,

//Caracter boton cierre BeOS - 139
0,62,34,34,34,62,0,0,

//Caracter boton cierre Turbovision - 140
0,63,63,63,63,63,63,0,

//Caracter logo apple - 141
0x08,0x10,0x78,0xFC,0xF8,0xFC,0x78,0x00,

//á a acentuada - 142
0x02,0x04,0x0e,0x03,0x0f,0x1b,0x0f,0x00,

//é e acentuada - 143
0x02,0x04,0x0e,0x1b,0x1f,0x18,0x0e,0x00,

//í i acentuada - 144
0x02,0x04,0x00,0x0e,0x06,0x06,0x0f,0x00,

//ó o acentuada - 145
0x02,0x04,0x0e,0x1b,0x1b,0x1b,0x0e,0x00,

//ú u acentuada - 146
0x02,0x04,0x1b,0x1b,0x1b,0x1b,0x0f,0x00,

//Ñ enye mayuscula - 147
//0x7C,0x00,0x44,0x64,0x54,0x4C,0x44,0x00,
//0x1f,0x00,0x11,0x19,0x1d,0x1f,0x1b,0x00,
0x1f,0x00,0x19,0x1d,0x1f,0x1b,0x19,0x00,
//0x11,0x19,0x1d,0x1f,0x1b,0x19,0x19,0x00,

//Caracter fondo titulo TempleOS - 148
0,0,255,0,255,0,0,0,

//Caracter background titulo - 149. Este 149 se uso por primera vez en AmigaOS
0,255,145,163,197,137,255,0,

//Caracter minimizar - 150
255,129,129,255,129,129,255,0,

//Caracter restaurar - 151
255,129,255,129,255,129,255,0,

//Caracter maximizar - 152
0,126,2+64,2+64,2+64,2+64,126,0,

//Caracter franjas verticales colores titulo - 153
2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,2+4+32+64,

//Caracter boton cierre estilo ZEsarUX plus - 154
0,60,90,102,102,90,60,0,

//Caracter boton cierre estilo Risc OS - 155
4+8+32+64,2+16+128,2+128,4+64,2+128,2+16+128,4+8+32+64,0,

//Caracter boton background estilo Risc OS - 156
0xF0,0xFC,0xC4,0xC4,0xC4,0x44,0x7C,0,

//Caracter boton maximizar y restaurar estilo Risc OS - 157
0xE0,0xA0,0xE0,0x3C,0x3C,0x3C,0x3C,0,

//Cedilla 158
0x00,0x0e,0x18,0x18,0x18,0x0e,0x04,0x08,

//à a acentuada abierta - 159
0x08,0x04,0x0e,0x03,0x0f,0x1b,0x0f,0x00,

//è e acentuada abierta - 160
0x08,0x04,0x0e,0x1b,0x1f,0x18,0x0e,0x00,

//ò o acentuada abierta - 161
0x08,0x04,0x0e,0x1b,0x1b,0x1b,0x0e,0x00,

//ü u con dieresis 162
0x1b,0x00,0x1b,0x1b,0x1b,0x1b,0x0f,0x00,

//flecha abajo, para botones extender zx desktop - 163
0x00,0x0C,0x0C,0x0C,0x0C,0x3F,0x1E,0x0C,
//flecha arriba, para botones extender zx desktop - 164
0x00,0x0C,0x1E,0x3F,0x0C,0x0C,0x0C,0x0C,
//flecha derecha, para botones extender zx desktop - 165
0x00,0x08,0x0C,0x3E,0x3E,0x0C,0x08,0x00,
//flecha izquierda, para botones extender zx desktop - 166
0x00,0x04,0x0C,0x1F,0x1F,0x0C,0x04,0x00,

//ï i con dieresis - 167
0x0A,0x00,0x0e,0x06,0x06,0x06,0x0f,0x00,

//Á A mayúscula acento cerrado - 168
0x02,0x04,0x0e,0x1b,0x1b,0x1f,0x1b,0x00,

//Caracter boton minimizar QNX - 169
0,0,0,0,0,0,126,0,

//Caracter boton cierre QNX - 170
0,66,36,24,24,36,66,0,

//Caracter minimizar estilo ZEsarUX plus - 171
0,0,4+8+16+32,4+32,4+32,4+8+16+32,0,0,

//Caracter maximizar estilo ZEsarUX plus - 172
0,126*2,66*2,66*2,66*2,66*2,126*2,0,
};


char *charset_icons_text[]={

//32
"   ",
"   ",
"   ",
"   ",
"   ",

" x ",
" x ",
" x ",
"   ",
" x ",

"x x",
"x x",
"   ",
"   ",
"   ",

" x ",
"xxx",
" x ",
"xxx",
" x ",

" x ",
"xxx",
"xx ",
"xxx",
" x ",

"x x",
"  x",
" x ",
"x  ",
"x x",

" x ",
"xxx",
" xx",
"xx ",
"x x",

"  x",
"  x",
"   ",
"   ",
"   ",

"  x",
" x ",
" x ",
" x ",
"  x",

" x ",
"  x",
"  x",
"  x",
" x ",

//42
"x x",
" x ",
"xxx",
" x ",
"x x",

" x ",
" x ",
"xxx",
" x ",
" x ",

"   ",
"   ",
"  x",
"  x",
" x ",

"   ",
"   ",
"xxx",
"   ",
"   ",

"   ",
"   ",
"   ",
" xx",
" xx",

"  x",
"  x",
" x ",
"x  ",
"x  ",

//0
" x ",
"x x",
"x x",
"x x",
" x ",

"  x",
" xx",
"x x",
"  x",
"  x",

"xxx",
"  x",
"xxx",
"x  ",
"xxx",

"xxx",
"  x",
"xxx",
"  x",
"xxx",

//52
"x x",
"x x",
"xxx",
"  x",
"  x",

"xxx",
"x  ",
"xx ",
"  x",
"xx ",

"xxx",
"x  ",
"xxx",
"x x",
"xxx",

"xxx",
"  x",
"  x",
" x ",
" x ",

"xxx",
"x x",
"xxx",
"x x",
"xxx",

"xxx",
"x x",
"xxx",
"  x",
"xxx",

" xx",
" xx",
"   ",
" xx",
" xx",

" xx",
" xx",
"   ",
"  x",
" x ",

"  x",
" x ",
"x  ",
" x ",
"  x",

"   ",
"xxx",
"   ",
"xxx",
"   ",

//62
"x  ",
" x ",
"  x",
" x ",
"x  ",

"xx ",
"  x",
" x ",
"   ",
" x ",

" x ",
"xxx",
"xxx",
"x  ",
" xx",

//A
"xxx",
"x x",
"xxx",
"x x",
"x x",

"xx ",
"x x",
"xx ",
"x x",
"xx ",

"xxx",
"x  ",
"x  ",
"x  ",
"xxx",

"xx ",
"x x",
"x x",
"x x",
"xx ",

"xxx",
"x  ",
"xx ",
"x  ",
"xxx",

"xxx",
"x  ",
"xx ",
"x  ",
"x  ",

"xxx",
"x  ",
"x  ",
"x x",
"xxx",

//72
"x x",
"x x",
"xxx",
"x x",
"x x",

" x ",
" x ",
" x ",
" x ",
" x ",

"  x",
"  x",
"  x",
"x x",
"xxx",

"x x",
"xx ",
"x  ",
"xx ",
"x x",

"x  ",
"x  ",
"x  ",
"x  ",
"xxx",

"x x",
"xxx",
"xxx",
"x x",
"x x",

"x x",
"xxx",
"x x",
"x x",
"x x",

"xxx",
"x x",
"x x",
"x x",
"xxx",

"xxx",
"x x",
"xxx",
"x  ",
"x  ",

"xxx",
"x x",
"x x",
"xxx",
"xxx",

//82
"xx ",
"x x",
"xx ",
"x x",
"x x",

"xxx",
"x  ",
"xxx",
"  x",
"xxx",

"xxx",
" x ",
" x ",
" x ",
" x ",

"x x",
"x x",
"x x",
"x x",
"xxx",

"x x",
"x x",
"x x",
" x ",
" x ",

"x x",
"x x",
"x x",
"xxx",
"xxx",

"x x",
"x x",
" x ",
"x x",
"x x",

"x x",
"x x",
" x ",
" x ",
" x ",

"xxx",
"  x",
" x ",
"x  ",
"xxx",

" xx",
" x ",
" x ",
" x ",
" xx",

//92
"x  ",
"x  ",
" x ",
"  x",
"  x",

" xx",
"  x",
"  x",
"  x",
" xx",

" x ",
"x x",
"   ",
"   ",
"   ",

"   ",
"   ",
"   ",
"   ",
"xxx",

" x ",
"  x",
"   ",
"   ",
"   ",

//a
"   ",
" x ",
"x x",
"x x",
" xx",

"x  ",
"x  ",
"xxx",
"x x",
"xxx",

"   ",
"xxx",
"x  ",
"x  ",
"xxx",

"  x",
"  x",
"xxx",
"x x",
"xxx",

"   ",
"xxx",
"xxx",
"x  ",
" xx",

//102
" xx",
" x ",
"xxx",
" x ",
" x ",

"   ",
"xxx",
"xxx",
"  x",
"xxx",

"x  ",
"x  ",
"xxx",
"x x",
"x x",

" x ",
"   ",
" x ",
" x ",
" x ",

"  x",
"   ",
"  x",
"  x",
"xx ",

"   ",
"   ",
"x x",
"xx ",
"x x",

"   ",
"x  ",
"x  ",
"x  ",
" xx",

"   ",
" x ",
"xxx",
"xxx",
"x x",

"   ",
" x ",
"x x",
"x x",
"x x",

"   ",
"xxx",
"x x",
"x x",
"xxx",

//112
"   ",
" x ",
"x x",
"xx ",
"x  ",

"   ",
" x ",
"x x",
" xx",
"  x",

"   ",
" xx",
"x  ",
"x  ",
"x  ",

" xx",
"x  ",
" x ",
"  x",
"xx ",

" x ",
"xxx",
" x ",
" x ",
" xx",

"   ",
"x x",
"x x",
"x x",
"xxx",

"   ",
"x x",
"x x",
"x x",
" x ",

"   ",
"x x",
"x x",
"xxx",
" x ",

"   ",
"   ",
"x x",
" x ",
"x x",

"   ",
"x x",
"x x",
" xx",
"  x",

//122
"   ",
"xxx",
" x ",
"x  ",
"xxx",

" xx",
" x ",
"x  ",
" x ",
" xx",

" x ",
" x ",
"   ",
" x ",
" x ",

"xx ",
" x ",
"  x",
" x ",
"xx ",

//126
"   ",
"xx ",
"xxx",
"  x",
"   ",




};