//=============================================================================
//
// Adventure Game Studio (AGS)
//
// Copyright (C) 1999-2011 Chris Jones and 2011-2024 various contributors
// The full list of copyright holders can be found in the Copyright.txt
// file, which is part of this source code distribution.
//
// The AGS source code is provided under the Artistic License 2.0.
// A copy of this license can be found in the file License.txt and at
// https://opensource.org/license/artistic-2-0/
//
//=============================================================================
#include <stdio.h>              // NULL definition xD
#include "ac/actiontype.h"

// {name, flags, numArgs, {argTypes}, {argNames}, description, textscript}
ActionTypes actions[NUM_ACTION_TYPES] = {
    {"Do nothing", 0, 0, {NULL}, {NULL}, "Does nothing.", ""},
    {"Run script", AFLG_RUNSCRIPT, 0, {NULL}, {NULL}, "Runs a text script. Click the 'Edit Script' button to modify the script.", ""},
    {"Game - Add score on first execution", 0, 1, {ARG_TYPE_INT}, {"Points to add"},
    "Gives the player $$1 extra points the first time this action is run.",
    ""},
    {"Game - Add score", 0, 1, {ARG_TYPE_INT}, {"Points to add"},
    "Gives the player $$1 extra points every time this action is run.",
    "GiveScore($$1);"},
    {"Game - Display a message", AFLG_MESSAGE, 1, {ARG_TYPE_MSG}, {"Message number"},
    "Displays message $$1 to the player.",
    "DisplayMessage($$1);"},
    {"Game - Play music", 0, 1, {ARG_TYPE_INT}, {"Music number"},
    "Changes the current background music to MUSIC$$1.MP3, WAV, MID or MOD",
    "PlayMusic($$1);"},
    {"Game - Stop music", 0, 0, {NULL}, {NULL},
    "Stops the currently playing background music.",
    "StopMusic();"},
    {"Game - Play sound effect", 0, 1, {ARG_TYPE_INT}, {"Sound number"},
    "Plays SOUND$$1.MP3 or SOUND$$1.WAV",
    "PlaySound($$1);"},
    {"Game - Play Flic animation", 0, 2, {ARG_TYPE_INT, ARG_TYPE_BOOL}, {"Flic number", "Player can skip"},
    "Plays FLIC$$1.FLC or FLIC$$1.FLI",
    "PlayFlic($$1, $$2);"},
    {"Game - Run dialog", 0, 1, {ARG_TYPE_INT}, {"Dialog topic number"},
    "Starts a conversation using dialog topic $$1.",
    "dialog[$$1].Start();"},
    {"Game - Enable dialog option", 0, 2, {ARG_TYPE_INT, ARG_TYPE_INT}, {"Dialog topic number", "Option number"},
    "Enables dialog option $$2 in topic $$1 to be visible to the player.",
    "dialog[$$1].SetOptionState($$2, eOptionOn);"},
    {"Game - Disable dialog option", 0, 2, {ARG_TYPE_INT, ARG_TYPE_INT}, {"Dialog topic number", "Option number"},
    "Stops dialog option $$2 in topic $$1 from being visible to the player.",
    "dialog[$$1].SetOptionState($$2, eOptionOff);"},
    {"Player - Go to a different room", 0, 2, {ARG_TYPE_INT, ARG_TYPE_INT}, {"New room number", "Edge+offset value"},
    "Takes the player to room $$1, optionally choosing position using old-style Data column value $$2",
    "player.ChangeRoom($$1);"},
    {"Player - Give the player an inventory item", 0, 1, {ARG_TYPE_INV}, {"Inventory item number"},
    "Adds inventory item $$1 to the player character's inventory.",
    "player.AddInventory(inventory[$$1]);"},
    {"Object - Move object", 0, 5, {ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_BOOL},
    {"Object number", "Destination X location", "Destination Y location", "Move speed", "Wait for move to finish"},
    "Starts object $$1 moving towards ($$2, $$3), at speed $$4.",
    "object[$$1].Move($$2, $$3, $$4);"},
    {"Object - Remove an object from the room", 0, 1, {ARG_TYPE_INT}, {"Object number"},
    "Switches room object $$1 off so the player cannot see or interact with it.",
    "object[$$1].Visible = false;"},
    {"Object - Switch an object back on", 0, 1, {ARG_TYPE_INT}, {"Object number"},
    "Switches room object $$1 on, so that the player can see and interact with it.",
    "object[$$1].Visible = true;"},
    {"Object - Set object view number", 0, 2, {ARG_TYPE_INT, ARG_TYPE_INT}, {"Object number", "New view number"},
    "Changes object $$1's view number to $$2",
    "object[$$1].SetView($$2);"},
    {"Object - Start object animating", 0, 4, {ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_BOOL},
    {"Object number", "Loop number", "Speed", "Repeat"},
    "Starts object $$1 animating, using loop $$2 of its current view, and animating at speed $$3.",
    "object[$$1].Animate($$2, $$3);"},
    {"Character - Move character", 0, 4, {ARG_TYPE_CHAR, ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_BOOL},
    {"Character", "Destination X location", "Destination Y location", "Wait for move to finish"},
    "Starts character $$1 moving towards ($$2, $$3).",
    "character[$$1].Walk($$2, $$3);"},
    {"Conditional - If inventory item was used", AFLG_COND | AFLG_INVCHECK, 1, {ARG_TYPE_INV}, {"Inventory item number"},
    "Performs child actions if the player just used inventory item $$1 on this interaction.",
    "if (player.ActiveInventory == inventory[$$1]) {"},
    {"Conditional - If the player has an inventory item", AFLG_COND, 1, {ARG_TYPE_INV}, {"Inventory item number"},
    "Performs child actions if the player character has inventory item $$1 in their current inventory.",
    "if (player.InventoryQuantity[$$1] > 0) {"},
    {"Conditional - If a character is moving", AFLG_COND, 1, {ARG_TYPE_CHAR}, {"Character number"},
    "Performs child actions if character $$1 is currently moving",
    "if (character[$$1].Moving) {"},
    {"Conditional - If a variable is set to a certain value", AFLG_COND, 2, {ARG_TYPE_INT, ARG_TYPE_INT}, {"Variable", "Value"},
    "Performs child actions if $$1 == $$2",
    "if (GetGraphicalVariable(\"$$1\") == $$2) { "},
    {"Character - Stop character walking", 0, 1, {ARG_TYPE_CHAR}, {"Character"},
    "Immediately stops character $$1 from moving.",
    "character[$$1].StopMoving();"},
    {"Player - Go to a different room (at specific co-ordinates)", 0, 3, {ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_INT},
    {"New room number", "X co-ordinate", "Y co-ordinate"},
    "Takes the player to room $$1, and places him at ($$2, $$3)",
    "player.ChangeRoom($$1, $$2, $$3);"},
    {"Character - Move NPC to different room", 0, 2, {ARG_TYPE_CHAR, ARG_TYPE_INT},
    {"Character", "New room number"},
    "Places non-player character $$1 into room $$2.",
    "character[$$1].ChangeRoom($$2);"},
    {"Character - Set character view", 0, 2, {ARG_TYPE_CHAR, ARG_TYPE_INT},
    {"Character", "View number"},
    "Locks character $$1's view to view $$2, in preparation for doing an animation. Use 'Release Character View' afterwards to release it.",
    "character[$$1].LockView($$2);"},
    {"Character - Release character view", 0, 1, {ARG_TYPE_CHAR}, {"Character"},
    "Reverts character $$1's view back to its normal view and enables standard engine processing.",
    "character[$$1].UnlockView();"},
    {"Character - Follow another character", 0, 2, {ARG_TYPE_CHAR, ARG_TYPE_CHAR},
    {"Character", "Follow Character"},
    "Makes character $$1 follow $$2 around the screen.",
    "character[$$1].FollowCharacter($$2);"},
    {"Character - Stop following", 0, 1, {ARG_TYPE_CHAR}, {"Character"},
    "Stops character $$1 following any other characters.",
    "character[$$1].FollowCharacter(null);"},
    {"Room - Disable hotspot", 0, 1, {ARG_TYPE_INT}, {"Hotspot number"},
    "Disables hotspot $$1 in the current room.",
    "hotspot[$$1].Enabled = false;"},
    {"Room - Enable hotspot", 0, 1, {ARG_TYPE_INT}, {"Hotspot number"},
    "Re-enables hotspot $$1 in the current room.",
    "hotspot[$$1].Enabled = true;"},
    {"Game - Set variable value", 0, 2, {ARG_TYPE_VARONLY, ARG_TYPE_INT}, {"Variable", "New value"},
    "Sets variable $$1 to have the value $$2",
    "SetGraphicalVariable(\"$$1\", $$2);"},
    {"Character - Run animation loop", 0, 3, {ARG_TYPE_CHAR, ARG_TYPE_INT, ARG_TYPE_INT},
    {"Character", "Loop number", "Speed"},
    "Runs character $$1 through loop $$2 of its current view, animating at speed $$3. Waits for animation to finish before continuing.",
    ""},  
    {"Character - Quick animation", 0, 4, {ARG_TYPE_CHAR, ARG_TYPE_INT, ARG_TYPE_INT, ARG_TYPE_INT},
    {"Character", "View number", "Loop number", "Speed"},
    "Does SetCharacterView($$1, $$2), AnimateCharacter($$1, $$3, $$4), ReleaseCharacterView($$1) in order.",
    ""},
    {"Character - Set idle animation", 0, 3, {ARG_TYPE_CHAR, ARG_TYPE_INT, ARG_TYPE_INT},
    {"Character", "View number", "Delay"},
    "Sets character $$1 to use view $$2 as its idle animation, with a timeout of $$3 seconds of inactivity before the animation is played.",
    "character[$$1].SetIdleView($$2, $$3);"},
    {"Character - Disable idle animation", 0, 1, {ARG_TYPE_CHAR},
    {"Character"},
    "Disables character $$1's idle animation, so it will no longer be played.",
    "character[$$1].SetIdleView(-1, -1);"},
    {"Player - Remove an item from the inventory", 0, 1, {ARG_TYPE_INV}, {"Inventory item number"},
    "Removes inventory item $$1 from the player character's inventory.",
    "player.LoseInventory(inventory[$$1]);"},
    {"Game - Show GUI", 0, 1, {ARG_TYPE_INT}, {"GUI number"},
    "Switches on GUI number $$1 so the player can see it.",
    "gui[$$1].Visible = true;"},
    {"Game - Hide GUI", 0, 1, {ARG_TYPE_INT}, {"GUI number"},
    "Switches off GUI number $$1 so the player can no longer see it.",
    "gui[$$1].Visible = false;"},
    {"Stop running more commands", 0, 0, {NULL}, {NULL},
    "Stops running the interaction list at this point. Useful at the end of a block of actions inside a conditional.",
    "return;"},
    {"Character - Face location", 0, 3, {ARG_TYPE_CHAR, ARG_TYPE_INT, ARG_TYPE_INT},
    {"Character", "X co-ordinate", "Y co-ordinate"},
    "Turns character $$1 so that they are facing the room co-ordinates ($$2, $$3).",
    "character[$$1].FaceLocation($$2, $$3);"},
    {"Game - Pause command processor for a set time", 0, 1, {ARG_TYPE_INT},
    {"Loops to wait"},
    "Stops processing actions here and lets the game continue execution for $$1 game loops (default 40 per second) before continuing with the next command.",
    "Wait($$1);"},
    {"Character - Change character view", 0, 2, {ARG_TYPE_CHAR, ARG_TYPE_INT},
    {"Character", "New view number"},
    "Changes character $$1's normal walking view to View $$2 permanently, until you call this command again.",
    "character[$$1].ChangeView($$2);"},
    {"Conditional - If the player character is", AFLG_COND, 1, {ARG_TYPE_CHAR},
    {"Character"},
    "Performs child actions if the player character is currently $$1. Useful in games where the player can control multiple characters.",
    "if (player.ID == $$1) {"},
    {"Conditional - If mouse cursor mode is", AFLG_COND, 1, {ARG_TYPE_INT},
    {"Mouse cursor"},
    "Performs child actions if the current cursor mode is mode $$1 (from the Cursors pane).",
    "if (mouse.Mode == $$1) {"},
    {"Conditional - If the player has been in room", AFLG_COND, 1, {ARG_TYPE_INT},
    {"Room number"},
    "Performs child actions if the player has been to room $$1 during the game.",
    "if (HasPlayerBeenInRoom($$1)) {"}
};
