#include "gen_table.h"

const uint8_t lex_classes[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d,
    0x0e, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x12, 0x07, 0x07, 0x07, 0x13, 0x07,
    0x07, 0x14, 0x14, 0x14, 0x15, 0x16, 0x14, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
    0x17, 0x17, 0x17, 0x17, 0x17, 0x18, 0x17, 0x17, 0x17, 0x17, 0x17, 0x19, 0x1a, 0x1b, 0x07, 0x17,
    0x07, 0x1c, 0x1d, 0x14, 0x15, 0x1e, 0x1f, 0x17, 0x17, 0x20, 0x17, 0x17, 0x21, 0x17, 0x22, 0x17,
    0x17, 0x17, 0x23, 0x24, 0x25, 0x26, 0x17, 0x17, 0x17, 0x17, 0x17, 0x27, 0x28, 0x29, 0x07, 0x00,
    0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a,
    0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b,
    0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c,
    0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c,
    0x2d, 0x2d, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
    0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
    0x2f, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x31, 0x30, 0x30,
    0x32, 0x33, 0x33, 0x33, 0x34, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
};

const uint8_t lex_transitions[] = {
    // 0x00
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADCHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_INTERNAL,
    75,
    33,
    85,
    77,
    PN_TOK_FLAG_DONE | PN_ERROR_BADCHAR,
    79,
    2,
    84,
    3,
    1,
    1,
    4,
    5,
    5,
    5,
    11,
    55,
    1,
    1,
    1,
    1,
    1,
    80,
    PN_TOK_FLAG_DONE | PN_ERROR_BADCHAR,
    81,
    1,
    1,
    1,
    20,
    25,
    1,
    12,
    1,
    1,
    16,
    1,
    82,
    65,
    83,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    // 0x01
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x02
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    4,
    5,
    5,
    5,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    25,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x03
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    4,
    5,
    5,
    5,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    28,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x04
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    6,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    1,
    8,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    1,
    8,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    // 0x05
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    6,
    1,
    5,
    5,
    5,
    5,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    1,
    8,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    1,
    1,
    8,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INT,
    // 0x06
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    7,
    7,
    7,
    7,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x07
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    1,
    1,
    7,
    7,
    7,
    7,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    1,
    8,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    1,
    8,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    // 0x08
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    9,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    9,
    1,
    1,
    10,
    10,
    10,
    10,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x09
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    10,
    10,
    10,
    10,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x0a
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    1,
    1,
    10,
    10,
    10,
    10,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FLOAT,
    // 0x0b
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_KEY,
    // 0x0c
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    31,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    13,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x0d
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    14,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x0e
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    15,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x0f
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NULL,
    // 0x10
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    17,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x11
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    18,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x12
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    19,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x13
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_TRUE,
    // 0x14
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    21,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x15
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    22,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x16
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    23,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x17
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    24,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x18
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_FALSE,
    // 0x19
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    26,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x1a
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    27,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x1b
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_INF,
    // 0x1c
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    29,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x1d
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    30,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x1e
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NEG_INF,
    // 0x1f
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    1,
    1,
    1,
    1,
    1,
    1,
    32,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    PN_TOK_FLAG_DONE | PN_ERROR_BADWORD,
    // 0x20
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    11,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_NAN,
    // 0x21
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    33,
    53,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    41,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    40,
    34,
    39,
    35,
    36,
    38,
    37,
    // 0x22
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    40,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x23
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    40,
    40,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x24
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    39,
    39,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x25
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    39,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x26
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    39,
    39,
    39,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x27
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    40,
    40,
    40,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x28
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    33,
    33,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x29
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    42,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    33,
    48,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADESC,
    // 0x2a
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    43,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x2b
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    44,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x2c
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    46,
    45,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x2d
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    47,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x2e
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    48,
    47,
    47,
    47,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    47,
    47,
    47,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    47,
    47,
    47,
    47,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x2f
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    49,
    49,
    49,
    49,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    49,
    49,
    49,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    49,
    49,
    49,
    49,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x30
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    49,
    49,
    49,
    49,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    49,
    52,
    49,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    49,
    49,
    49,
    49,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x31
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    50,
    50,
    50,
    50,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    50,
    50,
    50,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    50,
    50,
    50,
    50,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x32
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    51,
    51,
    51,
    51,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    51,
    51,
    51,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    51,
    51,
    51,
    51,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x33
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    33,
    33,
    33,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    33,
    33,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    33,
    33,
    33,
    33,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x34
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_STREOL,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    50,
    50,
    50,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    PN_TOK_FLAG_DONE | PN_ERROR_BADUESC,
    // 0x35
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    54,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR,
    // 0x36
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_QKEY,
    // 0x37
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    63,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_WRAP_EMPTY,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    62,
    56,
    61,
    57,
    58,
    60,
    59,
    // 0x38
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    62,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x39
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    62,
    62,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x3a
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    61,
    61,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x3b
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    61,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x3c
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    61,
    61,
    61,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x3d
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    62,
    62,
    62,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x3e
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    64,
    64,
    64,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x3f
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    64,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_WRAP_EMPTY,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    62,
    56,
    61,
    57,
    58,
    60,
    59,
    // 0x40
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    64,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_WRAP,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    62,
    56,
    61,
    57,
    58,
    60,
    59,
    // 0x41
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    73,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_PIPE_EMPTY,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    72,
    66,
    71,
    67,
    68,
    70,
    69,
    // 0x42
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    72,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x43
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    72,
    72,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x44
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    71,
    71,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x45
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    71,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x46
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    71,
    71,
    71,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x47
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    72,
    72,
    72,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x48
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    74,
    74,
    74,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x49
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    74,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_PIPE_EMPTY,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    72,
    66,
    71,
    67,
    68,
    70,
    69,
    // 0x4a
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    74,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_PIPE,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    72,
    66,
    71,
    67,
    68,
    70,
    69,
    // 0x4b
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    76,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_BANG,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    // 0x4c
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STR_BANG,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_BANG_SUFFIX,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    PN_TOK_FLAG_DONE | PN_ERROR_NONASCII,
    // 0x4d
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    77,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    78,
    78,
    78,
    78,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    78,
    78,
    78,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    78,
    78,
    78,
    78,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_DATA,
    // 0x4e
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    77,
    77,
    77,
    77,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    77,
    77,
    77,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    77,
    77,
    77,
    77,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_DATACHAR,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    PN_TOK_FLAG_DONE | PN_ERROR_PARTIAL,
    // 0x4f
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_STAR,
    // 0x50
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_IN,
    // 0x51
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_ARRAY_OUT,
    // 0x52
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_IN,
    // 0x53
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_MAP_OUT,
    // 0x54
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMA,
    // 0x55
    PN_TOK_FLAG_DONE | PN_ERROR_CTRL,
    85,
    PN_TOK_FLAG_DONE | PN_TOK_FLAG_OK | PN_TOK_COMMENT,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_HEAD,
    92,
    86,
    91,
    87,
    88,
    90,
    89,
    // 0x56
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    92,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x57
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    92,
    92,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x58
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    91,
    91,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x59
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    91,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x5a
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    91,
    91,
    91,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x5b
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    92,
    92,
    92,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    // 0x5c
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    85,
    85,
    85,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
    PN_TOK_FLAG_DONE | PN_ERROR_UTF8_TAIL,
};

const uint8_t* const lex_table[] = {
    lex_transitions + 0,
    lex_transitions + 53,
    lex_transitions + 106,
    lex_transitions + 159,
    lex_transitions + 212,
    lex_transitions + 265,
    lex_transitions + 318,
    lex_transitions + 371,
    lex_transitions + 424,
    lex_transitions + 477,
    lex_transitions + 530,
    lex_transitions + 583,
    lex_transitions + 636,
    lex_transitions + 689,
    lex_transitions + 742,
    lex_transitions + 795,
    lex_transitions + 848,
    lex_transitions + 901,
    lex_transitions + 954,
    lex_transitions + 1007,
    lex_transitions + 1060,
    lex_transitions + 1113,
    lex_transitions + 1166,
    lex_transitions + 1219,
    lex_transitions + 1272,
    lex_transitions + 1325,
    lex_transitions + 1378,
    lex_transitions + 1431,
    lex_transitions + 1484,
    lex_transitions + 1537,
    lex_transitions + 1590,
    lex_transitions + 1643,
    lex_transitions + 1696,
    lex_transitions + 1749,
    lex_transitions + 1802,
    lex_transitions + 1855,
    lex_transitions + 1908,
    lex_transitions + 1961,
    lex_transitions + 2014,
    lex_transitions + 2067,
    lex_transitions + 2120,
    lex_transitions + 2173,
    lex_transitions + 2226,
    lex_transitions + 2279,
    lex_transitions + 2332,
    lex_transitions + 2385,
    lex_transitions + 2438,
    lex_transitions + 2491,
    lex_transitions + 2544,
    lex_transitions + 2597,
    lex_transitions + 2650,
    lex_transitions + 2703,
    lex_transitions + 2756,
    lex_transitions + 2809,
    lex_transitions + 2862,
    lex_transitions + 2915,
    lex_transitions + 2968,
    lex_transitions + 3021,
    lex_transitions + 3074,
    lex_transitions + 3127,
    lex_transitions + 3180,
    lex_transitions + 3233,
    lex_transitions + 3286,
    lex_transitions + 3339,
    lex_transitions + 3392,
    lex_transitions + 3445,
    lex_transitions + 3498,
    lex_transitions + 3551,
    lex_transitions + 3604,
    lex_transitions + 3657,
    lex_transitions + 3710,
    lex_transitions + 3763,
    lex_transitions + 3816,
    lex_transitions + 3869,
    lex_transitions + 3922,
    lex_transitions + 3975,
    lex_transitions + 4028,
    lex_transitions + 4081,
    lex_transitions + 4134,
    lex_transitions + 4187,
    lex_transitions + 4240,
    lex_transitions + 4293,
    lex_transitions + 4346,
    lex_transitions + 4399,
    lex_transitions + 4452,
    lex_transitions + 4505,
    lex_transitions + 4558,
    lex_transitions + 4611,
    lex_transitions + 4664,
    lex_transitions + 4717,
    lex_transitions + 4770,
    lex_transitions + 4823,
    lex_transitions + 4876,
};

pn_parser_transition_t parse_defs[] = {
    {.error = PN_ERROR_LONG},
    {.extend_count = 1, .extend0 = 1},
    {.emit = PN_PRS_EMIT_NULL},
    {.emit = PN_PRS_EMIT_TRUE},
    {.emit = PN_PRS_EMIT_FALSE},
    {.emit = PN_PRS_EMIT_INF},
    {.emit = PN_PRS_EMIT_NEG_INF},
    {.emit = PN_PRS_EMIT_NAN},
    {.emit = PN_PRS_EMIT_INT},
    {.emit = PN_PRS_EMIT_FLOAT},
    {.emit = PN_PRS_EMIT_STRING},
    {.emit = PN_PRS_EMIT_DATA},
    {.emit = PN_PRS_EMIT_SHORT_ARRAY_IN, .extend_count = 1, .extend0 = 17},
    {.emit = PN_PRS_EMIT_SHORT_MAP_IN, .extend_count = 1, .extend0 = 21},
    {.extend_count = 1, .extend0 = 2},
    {.emit = PN_PRS_EMIT_NULL, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_TRUE, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_FALSE, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_INF, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_NEG_INF, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_NAN, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_INT, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_FLOAT, .extend_count = 1, .extend0 = 3},
    {.emit = PN_PRS_EMIT_STRING, .extend_count = 1, .extend0 = 3},
    {.extend_count = 1, .extend0 = 9, .acc0 = PN_PRS_ACC_DATA},
    {.extend_count = 1, .extend0 = 13, .acc0 = PN_PRS_ACC_STRING},
    {.extend_count = 1, .extend0 = 11},
    {.extend_count = 1, .extend0 = 15},
    {.emit = PN_PRS_EMIT_SHORT_ARRAY_IN, .extend_count = 2, .extend0 = 3, .extend1 = 17},
    {.emit = PN_PRS_EMIT_LONG_ARRAY_IN, .extend_count = 2, .extend0 = 19, .extend1 = 0},
    {.emit = PN_PRS_EMIT_SHORT_MAP_IN, .extend_count = 2, .extend0 = 3, .extend1 = 21},
    {.emit = PN_PRS_EMIT_LONG_MAP_IN, .extend_count = 2, .extend0 = 24, .extend1 = 0, .key = PN_PRS_KEY_UNQUOTED},
    {.emit = PN_PRS_EMIT_LONG_MAP_IN, .extend_count = 2, .extend0 = 24, .extend1 = 0, .key = PN_PRS_KEY_QUOTED},
    {.error = PN_ERROR_SUFFIX},
    {.extend_count = 2, .extend0 = 2, .extend1 = 5},
    {.extend_count = 2, .extend0 = 3, .extend1 = 5},
    {.extend_count = 1, .extend0 = 4},
    {},
    {.extend_count = 1, .extend0 = 3},
    {.error = PN_ERROR_SIBLING},
    {.error = PN_ERROR_CHILD},
    {.extend_count = 1, .extend0 = 6},
    {.extend_count = 2, .extend0 = 6, .extend1 = 5},
    {.extend_count = 1, .extend0 = 5},
    {.error = PN_ERROR_SHORT},
    {.extend_count = 1, .extend0 = 9},
    {.extend_count = 2, .extend0 = 9, .extend1 = 5},
    {.extend_count = 1, .extend0 = 8},
    {.emit = PN_PRS_EMIT_ACC_DATA},
    {.extend_count = 1, .extend0 = 13, .acc0 = PN_PRS_ACC_NL, .acc1 = PN_PRS_ACC_STRING},
    {.extend_count = 1, .extend0 = 11, .acc0 = PN_PRS_ACC_NL},
    {.extend_count = 2, .extend0 = 11, .extend1 = 5},
    {.extend_count = 1, .extend0 = 10},
    {.emit = PN_PRS_EMIT_ACC_STRING, .acc0 = PN_PRS_ACC_NL},
    {.extend_count = 1, .extend0 = 13},
    {.extend_count = 1, .extend0 = 13, .acc0 = PN_PRS_ACC_SP, .acc1 = PN_PRS_ACC_STRING},
    {.extend_count = 2, .extend0 = 13, .extend1 = 5},
    {.extend_count = 1, .extend0 = 12},
    {.error = PN_ERROR_BANG_LAST},
    {.extend_count = 2, .extend0 = 15, .extend1 = 5},
    {.extend_count = 1, .extend0 = 14},
    {.emit = PN_PRS_EMIT_ACC_STRING},
    {.error = PN_ERROR_ARRAY_END},
    {.extend_count = 2, .extend0 = 16, .extend1 = 7},
    {.emit = PN_PRS_EMIT_SHORT_ARRAY_OUT},
    {.emit = PN_PRS_EMIT_NULL, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_TRUE, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_FALSE, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_INF, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_NEG_INF, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_NAN, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_INT, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_FLOAT, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_STRING, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_DATA, .extend_count = 1, .extend0 = 16},
    {.emit = PN_PRS_EMIT_SHORT_ARRAY_IN, .extend_count = 2, .extend0 = 16, .extend1 = 17},
    {.emit = PN_PRS_EMIT_SHORT_MAP_IN, .extend_count = 2, .extend0 = 16, .extend1 = 21},
    {.extend_count = 1, .extend0 = 19},
    {.extend_count = 2, .extend0 = 19, .extend1 = 0},
    {.extend_count = 2, .extend0 = 19, .extend1 = 5},
    {.extend_count = 1, .extend0 = 18},
    {.emit = PN_PRS_EMIT_LONG_ARRAY_OUT},
    {.error = PN_ERROR_MAP_END},
    {.extend_count = 2, .extend0 = 20, .extend1 = 22},
    {.emit = PN_PRS_EMIT_SHORT_MAP_OUT},
    {.error = PN_ERROR_MAP_KEY},
    {.extend_count = 2, .extend0 = 20, .extend1 = 7, .key = PN_PRS_KEY_UNQUOTED},
    {.extend_count = 2, .extend0 = 20, .extend1 = 7, .key = PN_PRS_KEY_QUOTED},
    {.extend_count = 1, .extend0 = 7, .key = PN_PRS_KEY_UNQUOTED},
    {.extend_count = 1, .extend0 = 7, .key = PN_PRS_KEY_QUOTED},
    {.extend_count = 1, .extend0 = 24},
    {.extend_count = 2, .extend0 = 24, .extend1 = 0, .key = PN_PRS_KEY_UNQUOTED},
    {.extend_count = 2, .extend0 = 24, .extend1 = 0, .key = PN_PRS_KEY_QUOTED},
    {.extend_count = 2, .extend0 = 24, .extend1 = 5},
    {.extend_count = 1, .extend0 = 23},
    {.emit = PN_PRS_EMIT_LONG_MAP_OUT},
};

uint8_t parse_table[][27] = {
    {1, 0, 0, 0, 12, 0, 13, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 0, 0, 8, 9, 11, 10, 0, 0, 0},
    {0, 0, 0, 29, 28, 0, 30, 0, 0, 26, 26, 27, 15, 16, 17, 18, 19, 20, 31, 32, 21, 22, 24, 23, 25, 25, 14},
    {34, 1, 0, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33},
    {35, 36, 37, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 38},
    {39, 39, 0, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 38},
    {40, 40, 0, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41},
    {42, 43, 37, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33},
    {44, 44, 44, 44, 12, 44, 13, 44, 44, 44, 44, 44, 2, 3, 4, 5, 6, 7, 44, 44, 8, 9, 11, 10, 44, 44, 44},
    {39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 24, 39, 39, 39, 45},
    {46, 47, 48, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 45},
    {39, 39, 39, 39, 39, 39, 39, 39, 39, 50, 50, 27, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 49, 49, 26},
    {51, 52, 53, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33},
    {39, 39, 39, 39, 39, 39, 39, 39, 39, 50, 50, 27, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 55, 49, 54},
    {56, 57, 53, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33},
    {39, 39, 39, 39, 39, 39, 39, 39, 39, 58, 58, 58, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 58, 58, 27},
    {59, 60, 61, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33},
    {62, 62, 62, 62, 62, 64, 62, 62, 63, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62},
    {44, 44, 44, 44, 75, 64, 76, 44, 44, 44, 44, 44, 65, 66, 67, 68, 69, 70, 44, 44, 71, 72, 74, 73, 44, 44, 44},
    {39, 39, 39, 78, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 77},
    {79, 80, 81, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 77},
    {82, 82, 82, 82, 82, 82, 82, 84, 83, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82},
    {85, 85, 85, 85, 85, 85, 85, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 86, 87, 85, 85, 85, 85, 85, 85, 85},
    {85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 88, 89, 85, 85, 85, 85, 85, 85, 85},
    {39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 91, 92, 39, 39, 39, 39, 39, 39, 90},
    {93, 94, 95, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 90},
};
