/*
BStone: Unofficial source port of Blake Stone: Aliens of Gold and Blake Stone: Planet Strike
Copyright (c) 2025 Boris I. Bendovsky (bibendovsky@hotmail.com) and Contributors
SPDX-License-Identifier: MIT
*/

// Vulkan 3D renderer: Enum string constants

#include "bstone_vk_r3r_enum_strings.h"

#define BSTONE_MACRO(x) case x: return #x

namespace bstone {

const char* VkR3rEnumStrings::get_VkResult(VkResult value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_SUCCESS);
		BSTONE_MACRO(VK_NOT_READY);
		BSTONE_MACRO(VK_TIMEOUT);
		BSTONE_MACRO(VK_EVENT_SET);
		BSTONE_MACRO(VK_EVENT_RESET);
		BSTONE_MACRO(VK_INCOMPLETE);
		BSTONE_MACRO(VK_ERROR_OUT_OF_HOST_MEMORY);
		BSTONE_MACRO(VK_ERROR_OUT_OF_DEVICE_MEMORY);
		BSTONE_MACRO(VK_ERROR_INITIALIZATION_FAILED);
		BSTONE_MACRO(VK_ERROR_DEVICE_LOST);
		BSTONE_MACRO(VK_ERROR_MEMORY_MAP_FAILED);
		BSTONE_MACRO(VK_ERROR_LAYER_NOT_PRESENT);
		BSTONE_MACRO(VK_ERROR_EXTENSION_NOT_PRESENT);
		BSTONE_MACRO(VK_ERROR_FEATURE_NOT_PRESENT);
		BSTONE_MACRO(VK_ERROR_INCOMPATIBLE_DRIVER);
		BSTONE_MACRO(VK_ERROR_TOO_MANY_OBJECTS);
		BSTONE_MACRO(VK_ERROR_FORMAT_NOT_SUPPORTED);
		BSTONE_MACRO(VK_ERROR_FRAGMENTED_POOL);
		BSTONE_MACRO(VK_ERROR_UNKNOWN);
		BSTONE_MACRO(VK_ERROR_OUT_OF_POOL_MEMORY);
		BSTONE_MACRO(VK_ERROR_INVALID_EXTERNAL_HANDLE);
		BSTONE_MACRO(VK_ERROR_FRAGMENTATION);
		BSTONE_MACRO(VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS);
		BSTONE_MACRO(VK_PIPELINE_COMPILE_REQUIRED);
		BSTONE_MACRO(VK_ERROR_NOT_PERMITTED);
		BSTONE_MACRO(VK_ERROR_SURFACE_LOST_KHR);
		BSTONE_MACRO(VK_ERROR_NATIVE_WINDOW_IN_USE_KHR);
		BSTONE_MACRO(VK_SUBOPTIMAL_KHR);
		BSTONE_MACRO(VK_ERROR_OUT_OF_DATE_KHR);
		BSTONE_MACRO(VK_ERROR_INCOMPATIBLE_DISPLAY_KHR);
		BSTONE_MACRO(VK_ERROR_VALIDATION_FAILED_EXT);
		BSTONE_MACRO(VK_ERROR_INVALID_SHADER_NV);
		BSTONE_MACRO(VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR);
		BSTONE_MACRO(VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR);
		BSTONE_MACRO(VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR);
		BSTONE_MACRO(VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR);
		BSTONE_MACRO(VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR);
		BSTONE_MACRO(VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR);
		BSTONE_MACRO(VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT);
		BSTONE_MACRO(VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT);
		BSTONE_MACRO(VK_THREAD_IDLE_KHR);
		BSTONE_MACRO(VK_THREAD_DONE_KHR);
		BSTONE_MACRO(VK_OPERATION_DEFERRED_KHR);
		BSTONE_MACRO(VK_OPERATION_NOT_DEFERRED_KHR);
		BSTONE_MACRO(VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR);
		BSTONE_MACRO(VK_ERROR_COMPRESSION_EXHAUSTED_EXT);
		BSTONE_MACRO(VK_INCOMPATIBLE_SHADER_BINARY_EXT);
		BSTONE_MACRO(VK_PIPELINE_BINARY_MISSING_KHR);
		BSTONE_MACRO(VK_ERROR_NOT_ENOUGH_SPACE_KHR);
		/* Aliases
		VK_ERROR_VALIDATION_FAILED_EXT = VK_ERROR_VALIDATION_FAILED
		VK_ERROR_OUT_OF_POOL_MEMORY_KHR = VK_ERROR_OUT_OF_POOL_MEMORY
		VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR = VK_ERROR_INVALID_EXTERNAL_HANDLE
		VK_ERROR_FRAGMENTATION_EXT = VK_ERROR_FRAGMENTATION
		VK_ERROR_NOT_PERMITTED_EXT = VK_ERROR_NOT_PERMITTED
		VK_ERROR_NOT_PERMITTED_KHR = VK_ERROR_NOT_PERMITTED
		VK_ERROR_INVALID_DEVICE_ADDRESS_EXT = VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS
		VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR = VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS
		VK_PIPELINE_COMPILE_REQUIRED_EXT = VK_PIPELINE_COMPILE_REQUIRED
		VK_ERROR_PIPELINE_COMPILE_REQUIRED_EXT = VK_PIPELINE_COMPILE_REQUIRED
		VK_ERROR_INCOMPATIBLE_SHADER_BINARY_EXT = VK_INCOMPATIBLE_SHADER_BINARY_EXT
		*/
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkVendorId(VkVendorId value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_VENDOR_ID_KHRONOS);
		BSTONE_MACRO(VK_VENDOR_ID_VIV);
		BSTONE_MACRO(VK_VENDOR_ID_VSI);
		BSTONE_MACRO(VK_VENDOR_ID_KAZAN);
		BSTONE_MACRO(VK_VENDOR_ID_CODEPLAY);
		BSTONE_MACRO(VK_VENDOR_ID_MESA);
		BSTONE_MACRO(VK_VENDOR_ID_POCL);
		BSTONE_MACRO(VK_VENDOR_ID_MOBILEYE);
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkPhysicalDeviceType(VkPhysicalDeviceType value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_PHYSICAL_DEVICE_TYPE_OTHER);
		BSTONE_MACRO(VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU);
		BSTONE_MACRO(VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU);
		BSTONE_MACRO(VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU);
		BSTONE_MACRO(VK_PHYSICAL_DEVICE_TYPE_CPU);
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkFormat(VkFormat value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_FORMAT_UNDEFINED);
		BSTONE_MACRO(VK_FORMAT_R4G4_UNORM_PACK8);
		BSTONE_MACRO(VK_FORMAT_R4G4B4A4_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_B4G4R4A4_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_R5G6B5_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_B5G6R5_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_R5G5B5A1_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_B5G5R5A1_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_A1R5G5B5_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_R8_UNORM);
		BSTONE_MACRO(VK_FORMAT_R8_SNORM);
		BSTONE_MACRO(VK_FORMAT_R8_USCALED);
		BSTONE_MACRO(VK_FORMAT_R8_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R8_UINT);
		BSTONE_MACRO(VK_FORMAT_R8_SINT);
		BSTONE_MACRO(VK_FORMAT_R8_SRGB);
		BSTONE_MACRO(VK_FORMAT_R8G8_UNORM);
		BSTONE_MACRO(VK_FORMAT_R8G8_SNORM);
		BSTONE_MACRO(VK_FORMAT_R8G8_USCALED);
		BSTONE_MACRO(VK_FORMAT_R8G8_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R8G8_UINT);
		BSTONE_MACRO(VK_FORMAT_R8G8_SINT);
		BSTONE_MACRO(VK_FORMAT_R8G8_SRGB);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_UNORM);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_SNORM);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_USCALED);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_UINT);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_SINT);
		BSTONE_MACRO(VK_FORMAT_R8G8B8_SRGB);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_UNORM);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_SNORM);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_USCALED);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_SSCALED);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_UINT);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_SINT);
		BSTONE_MACRO(VK_FORMAT_B8G8R8_SRGB);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_UNORM);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_SNORM);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_USCALED);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_UINT);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_SINT);
		BSTONE_MACRO(VK_FORMAT_R8G8B8A8_SRGB);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_UNORM);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_SNORM);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_USCALED);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_SSCALED);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_UINT);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_SINT);
		BSTONE_MACRO(VK_FORMAT_B8G8R8A8_SRGB);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_UNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_SNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_USCALED_PACK32);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_SSCALED_PACK32);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_UINT_PACK32);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_SINT_PACK32);
		BSTONE_MACRO(VK_FORMAT_A8B8G8R8_SRGB_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2R10G10B10_UNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2R10G10B10_SNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2R10G10B10_USCALED_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2R10G10B10_SSCALED_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2R10G10B10_UINT_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2R10G10B10_SINT_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2B10G10R10_UNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2B10G10R10_SNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2B10G10R10_USCALED_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2B10G10R10_SSCALED_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2B10G10R10_UINT_PACK32);
		BSTONE_MACRO(VK_FORMAT_A2B10G10R10_SINT_PACK32);
		BSTONE_MACRO(VK_FORMAT_R16_UNORM);
		BSTONE_MACRO(VK_FORMAT_R16_SNORM);
		BSTONE_MACRO(VK_FORMAT_R16_USCALED);
		BSTONE_MACRO(VK_FORMAT_R16_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R16_UINT);
		BSTONE_MACRO(VK_FORMAT_R16_SINT);
		BSTONE_MACRO(VK_FORMAT_R16_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R16G16_UNORM);
		BSTONE_MACRO(VK_FORMAT_R16G16_SNORM);
		BSTONE_MACRO(VK_FORMAT_R16G16_USCALED);
		BSTONE_MACRO(VK_FORMAT_R16G16_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R16G16_UINT);
		BSTONE_MACRO(VK_FORMAT_R16G16_SINT);
		BSTONE_MACRO(VK_FORMAT_R16G16_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_UNORM);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_SNORM);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_USCALED);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_UINT);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_SINT);
		BSTONE_MACRO(VK_FORMAT_R16G16B16_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_UNORM);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_SNORM);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_USCALED);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_SSCALED);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_UINT);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_SINT);
		BSTONE_MACRO(VK_FORMAT_R16G16B16A16_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R32_UINT);
		BSTONE_MACRO(VK_FORMAT_R32_SINT);
		BSTONE_MACRO(VK_FORMAT_R32_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R32G32_UINT);
		BSTONE_MACRO(VK_FORMAT_R32G32_SINT);
		BSTONE_MACRO(VK_FORMAT_R32G32_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R32G32B32_UINT);
		BSTONE_MACRO(VK_FORMAT_R32G32B32_SINT);
		BSTONE_MACRO(VK_FORMAT_R32G32B32_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R32G32B32A32_UINT);
		BSTONE_MACRO(VK_FORMAT_R32G32B32A32_SINT);
		BSTONE_MACRO(VK_FORMAT_R32G32B32A32_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R64_UINT);
		BSTONE_MACRO(VK_FORMAT_R64_SINT);
		BSTONE_MACRO(VK_FORMAT_R64_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R64G64_UINT);
		BSTONE_MACRO(VK_FORMAT_R64G64_SINT);
		BSTONE_MACRO(VK_FORMAT_R64G64_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R64G64B64_UINT);
		BSTONE_MACRO(VK_FORMAT_R64G64B64_SINT);
		BSTONE_MACRO(VK_FORMAT_R64G64B64_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_R64G64B64A64_UINT);
		BSTONE_MACRO(VK_FORMAT_R64G64B64A64_SINT);
		BSTONE_MACRO(VK_FORMAT_R64G64B64A64_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_B10G11R11_UFLOAT_PACK32);
		BSTONE_MACRO(VK_FORMAT_E5B9G9R9_UFLOAT_PACK32);
		BSTONE_MACRO(VK_FORMAT_D16_UNORM);
		BSTONE_MACRO(VK_FORMAT_X8_D24_UNORM_PACK32);
		BSTONE_MACRO(VK_FORMAT_D32_SFLOAT);
		BSTONE_MACRO(VK_FORMAT_S8_UINT);
		BSTONE_MACRO(VK_FORMAT_D16_UNORM_S8_UINT);
		BSTONE_MACRO(VK_FORMAT_D24_UNORM_S8_UINT);
		BSTONE_MACRO(VK_FORMAT_D32_SFLOAT_S8_UINT);
		BSTONE_MACRO(VK_FORMAT_BC1_RGB_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC1_RGB_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC1_RGBA_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC1_RGBA_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC2_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC2_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC3_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC3_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC4_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC4_SNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC5_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC5_SNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC6H_UFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC6H_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC7_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_BC7_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_EAC_R11_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_EAC_R11_SNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_EAC_R11G11_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_EAC_R11G11_SNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_4x4_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_4x4_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_5x4_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_5x4_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_5x5_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_5x5_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_6x5_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_6x5_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_6x6_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_6x6_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x5_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x5_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x6_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x6_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x8_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x8_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x5_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x5_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x6_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x6_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x8_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x8_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x10_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x10_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_12x10_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_12x10_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_12x12_UNORM_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_12x12_SRGB_BLOCK);
		BSTONE_MACRO(VK_FORMAT_G8B8G8R8_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_B8G8R8G8_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM);
		BSTONE_MACRO(VK_FORMAT_G8_B8R8_2PLANE_420_UNORM);
		BSTONE_MACRO(VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_G8_B8R8_2PLANE_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM);
		BSTONE_MACRO(VK_FORMAT_R10X6_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_R10X6G10X6_UNORM_2PACK16);
		BSTONE_MACRO(VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16);
		BSTONE_MACRO(VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16);
		BSTONE_MACRO(VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16);
		BSTONE_MACRO(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_R12X4_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_R12X4G12X4_UNORM_2PACK16);
		BSTONE_MACRO(VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16);
		BSTONE_MACRO(VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G16B16G16R16_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_B16G16R16G16_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM);
		BSTONE_MACRO(VK_FORMAT_G16_B16R16_2PLANE_420_UNORM);
		BSTONE_MACRO(VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_G16_B16R16_2PLANE_422_UNORM);
		BSTONE_MACRO(VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM);
		BSTONE_MACRO(VK_FORMAT_G8_B8R8_2PLANE_444_UNORM);
		BSTONE_MACRO(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16);
		BSTONE_MACRO(VK_FORMAT_G16_B16R16_2PLANE_444_UNORM);
		BSTONE_MACRO(VK_FORMAT_A4R4G4B4_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_A4B4G4R4_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK);
		BSTONE_MACRO(VK_FORMAT_A1B5G5R5_UNORM_PACK16);
		BSTONE_MACRO(VK_FORMAT_A8_UNORM);
		BSTONE_MACRO(VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG);
		BSTONE_MACRO(VK_FORMAT_R8_BOOL_ARM);
		BSTONE_MACRO(VK_FORMAT_R16G16_SFIXED5_NV);
		BSTONE_MACRO(VK_FORMAT_R10X6_UINT_PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R10X6G10X6_UINT_2PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R10X6G10X6B10X6A10X6_UINT_4PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R12X4_UINT_PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R12X4G12X4_UINT_2PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R12X4G12X4B12X4A12X4_UINT_4PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R14X2_UINT_PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R14X2G14X2_UINT_2PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R14X2G14X2B14X2A14X2_UINT_4PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R14X2_UNORM_PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R14X2G14X2_UNORM_2PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_R14X2G14X2B14X2A14X2_UNORM_4PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_G14X2_B14X2R14X2_2PLANE_420_UNORM_3PACK16_ARM);
		BSTONE_MACRO(VK_FORMAT_G14X2_B14X2R14X2_2PLANE_422_UNORM_3PACK16_ARM);
		/* Aliases
		VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK
		VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK
		VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK
		VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK
		VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK
		VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK
		VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK
		VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK
		VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK
		VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK
		VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK
		VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK
		VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK
		VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT = VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK
		VK_FORMAT_G8B8G8R8_422_UNORM_KHR = VK_FORMAT_G8B8G8R8_422_UNORM
		VK_FORMAT_B8G8R8G8_422_UNORM_KHR = VK_FORMAT_B8G8R8G8_422_UNORM
		VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR = VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM
		VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR = VK_FORMAT_G8_B8R8_2PLANE_420_UNORM
		VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR = VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM
		VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR = VK_FORMAT_G8_B8R8_2PLANE_422_UNORM
		VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR = VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM
		VK_FORMAT_R10X6_UNORM_PACK16_KHR = VK_FORMAT_R10X6_UNORM_PACK16
		VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR = VK_FORMAT_R10X6G10X6_UNORM_2PACK16
		VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR = VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16
		VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR = VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16
		VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR = VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16
		VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16
		VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16
		VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16
		VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16
		VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16
		VK_FORMAT_R12X4_UNORM_PACK16_KHR = VK_FORMAT_R12X4_UNORM_PACK16
		VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR = VK_FORMAT_R12X4G12X4_UNORM_2PACK16
		VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR = VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16
		VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR = VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16
		VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR = VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16
		VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16
		VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16
		VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16
		VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16
		VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16
		VK_FORMAT_G16B16G16R16_422_UNORM_KHR = VK_FORMAT_G16B16G16R16_422_UNORM
		VK_FORMAT_B16G16R16G16_422_UNORM_KHR = VK_FORMAT_B16G16R16G16_422_UNORM
		VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR = VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM
		VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR = VK_FORMAT_G16_B16R16_2PLANE_420_UNORM
		VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR = VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM
		VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR = VK_FORMAT_G16_B16R16_2PLANE_422_UNORM
		VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR = VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM
		VK_FORMAT_G8_B8R8_2PLANE_444_UNORM_EXT = VK_FORMAT_G8_B8R8_2PLANE_444_UNORM
		VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT = VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16
		VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT = VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16
		VK_FORMAT_G16_B16R16_2PLANE_444_UNORM_EXT = VK_FORMAT_G16_B16R16_2PLANE_444_UNORM
		VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT = VK_FORMAT_A4R4G4B4_UNORM_PACK16
		VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT = VK_FORMAT_A4B4G4R4_UNORM_PACK16
		VK_FORMAT_R16G16_S10_5_NV = VK_FORMAT_R16G16_SFIXED5_NV
		VK_FORMAT_A1B5G5R5_UNORM_PACK16_KHR = VK_FORMAT_A1B5G5R5_UNORM_PACK16
		VK_FORMAT_A8_UNORM_KHR = VK_FORMAT_A8_UNORM
		*/
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkPresentModeKHR(VkPresentModeKHR value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_PRESENT_MODE_IMMEDIATE_KHR);
		BSTONE_MACRO(VK_PRESENT_MODE_MAILBOX_KHR);
		BSTONE_MACRO(VK_PRESENT_MODE_FIFO_KHR);
		BSTONE_MACRO(VK_PRESENT_MODE_FIFO_RELAXED_KHR);
		BSTONE_MACRO(VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR);
		BSTONE_MACRO(VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR);
		BSTONE_MACRO(VK_PRESENT_MODE_FIFO_LATEST_READY_KHR);
		/* Aliases
		VK_PRESENT_MODE_FIFO_LATEST_READY_EXT
		*/
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkColorSpaceKHR(VkColorSpaceKHR value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_COLOR_SPACE_SRGB_NONLINEAR_KHR);
		BSTONE_MACRO(VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_BT709_LINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_BT709_NONLINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_BT2020_LINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_HDR10_ST2084_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_DOLBYVISION_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_HDR10_HLG_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_PASS_THROUGH_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT);
		BSTONE_MACRO(VK_COLOR_SPACE_DISPLAY_NATIVE_AMD);
		/* Aliases
		VK_COLORSPACE_SRGB_NONLINEAR_KHR = VK_COLOR_SPACE_SRGB_NONLINEAR_KHR,
		VK_COLOR_SPACE_DCI_P3_LINEAR_EXT = VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT,
		*/
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkFormatFeatureFlagBits(VkFormatFeatureFlagBits flag)
{
	switch (flag)
	{
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_BLIT_SRC_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_BLIT_DST_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_TRANSFER_SRC_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_TRANSFER_DST_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_DISJOINT_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR);
		BSTONE_MACRO(VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR);
		BSTONE_MACRO(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR);
		BSTONE_MACRO(VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT);
		BSTONE_MACRO(VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
		BSTONE_MACRO(VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR);
		BSTONE_MACRO(VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR);
		/* Aliases
		VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG = VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT
		VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR = VK_FORMAT_FEATURE_TRANSFER_SRC_BIT
		VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR = VK_FORMAT_FEATURE_TRANSFER_DST_BIT
		VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT = VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT
		VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR = VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT
		VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT
		VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT
		VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT
		VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT
		VK_FORMAT_FEATURE_DISJOINT_BIT_KHR = VK_FORMAT_FEATURE_DISJOINT_BIT
		VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR = VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT
		*/
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkSampleCountFlagBits(VkSampleCountFlagBits flag)
{
	switch (flag)
	{
		BSTONE_MACRO(VK_SAMPLE_COUNT_1_BIT);
		BSTONE_MACRO(VK_SAMPLE_COUNT_2_BIT);
		BSTONE_MACRO(VK_SAMPLE_COUNT_4_BIT);
		BSTONE_MACRO(VK_SAMPLE_COUNT_8_BIT);
		BSTONE_MACRO(VK_SAMPLE_COUNT_16_BIT);
		BSTONE_MACRO(VK_SAMPLE_COUNT_32_BIT);
		BSTONE_MACRO(VK_SAMPLE_COUNT_64_BIT);
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkImageUsageFlagBits(VkImageUsageFlagBits value)
{
	switch (value)
	{
		BSTONE_MACRO(VK_IMAGE_USAGE_TRANSFER_SRC_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_TRANSFER_DST_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_SAMPLED_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_STORAGE_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_HOST_TRANSFER_BIT);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT);
		BSTONE_MACRO(VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT);
		BSTONE_MACRO(VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI);
		BSTONE_MACRO(VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM);
		BSTONE_MACRO(VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM);
		BSTONE_MACRO(VK_IMAGE_USAGE_TENSOR_ALIASING_BIT_ARM);
		BSTONE_MACRO(VK_IMAGE_USAGE_TILE_MEMORY_BIT_QCOM);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR);
		BSTONE_MACRO(VK_IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR);
		/* Aliases
		VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV = VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR
		VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT = VK_IMAGE_USAGE_HOST_TRANSFER_BIT
		*/
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkMemoryHeapFlagBits(VkMemoryHeapFlagBits flag)
{
	switch (flag)
	{
		BSTONE_MACRO(VK_MEMORY_HEAP_DEVICE_LOCAL_BIT);
		BSTONE_MACRO(VK_MEMORY_HEAP_MULTI_INSTANCE_BIT);
		BSTONE_MACRO(VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM);
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkMemoryPropertyFlagBits(VkMemoryPropertyFlagBits flag)
{
	switch (flag)
	{
		BSTONE_MACRO(VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_HOST_COHERENT_BIT);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_HOST_CACHED_BIT);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_PROTECTED_BIT);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD);
		BSTONE_MACRO(VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV);
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkSurfaceTransformFlagBitsKHR(VkSurfaceTransformFlagBitsKHR flag)
{
	switch (flag)
	{
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR);
		BSTONE_MACRO(VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR);
		default: return nullptr;
	}
}

const char* VkR3rEnumStrings::get_VkCompositeAlphaFlagBitsKHR(VkCompositeAlphaFlagBitsKHR flag)
{
	switch (flag)
	{
		BSTONE_MACRO(VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR);
		BSTONE_MACRO(VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR);
		BSTONE_MACRO(VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR);
		BSTONE_MACRO(VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR);
		default: return nullptr;
	}
}

} // namespace bstone

#undef BSTONE_MACRO
