/*
BStone: Unofficial source port of Blake Stone: Aliens of Gold and Blake Stone: Planet Strike
Copyright (c) 1992-2013 Apogee Entertainment, LLC
Copyright (c) 2013-2024 Boris I. Bendovsky (bibendovsky@hotmail.com) and Contributors
SPDX-License-Identifier: GPL-2.0-or-later
*/


//
// Missing data in original source code release.
//


#include <cstdint>


// Force compiler to emit a symbol.
extern const std::uint8_t colormap[16896];


// 66 palettes, each 256 indices.
const std::uint8_t colormap[16896] =
{
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
	0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0x18,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
	0x04, 0xAF, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0F, 0xAF, 0x0F, 0x99, 0x9C, 0x9F, 0x9C, 0x99, 0xC7,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
	0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAC, 0xAD, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0x39, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0x18,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
	0x04, 0xAE, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0F, 0xAE, 0x0F, 0x99, 0x9C, 0x9F, 0x9C, 0x99, 0xC7,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0E,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x4E,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x6F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
	0x0E, 0x0F, 0xA1, 0xA2, 0xA4, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE,
	0xB0, 0x21, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0x39, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0x18,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
	0x04, 0xAE, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0F, 0xAE, 0x0F, 0x99, 0x9C, 0x9F, 0x9C, 0x99, 0xC7,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0xDD, 0xDE,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x38, 0x3A, 0x3B, 0x3C, 0x3D, 0x4D, 0x4E,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x5F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x5F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x6F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0xED, 0xEE,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0xEF,
	0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE,
	0xB0, 0x21, 0xB2, 0xB3, 0xB3, 0xB5, 0xB6, 0xB7, 0xB8, 0x39, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0x18,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xD9, 0xDB, 0xDC, 0xDD, 0xDD, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xE9, 0xEB, 0xEC, 0xED, 0xED, 0xEF,
	0x04, 0xAE, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0E, 0xAE, 0x0E, 0x99, 0x9C, 0x9F, 0x9C, 0x99, 0xC7,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0xDE,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x25, 0x26, 0x27, 0x29, 0x2A, 0x2B, 0x2B, 0xDC, 0xDD, 0xDE,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x35, 0x36, 0x37, 0x38, 0x3A, 0x3B, 0x3C, 0x4C, 0x4D, 0x4E,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4D, 0xAB,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0xAB,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6D, 0xAB,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x76, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7D, 0x6F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0x87, 0x89, 0x8A, 0x8B, 0x8B, 0xEC, 0xED, 0xEE,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x95, 0x96, 0x97, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0xEE, 0xEF,
	0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA8, 0xAA, 0xAA, 0xAB, 0xAC, 0xAD,
	0xB0, 0x21, 0xB2, 0xB3, 0xB3, 0xB4, 0xB6, 0xB6, 0xB7, 0x39, 0xBA, 0xBB, 0x28, 0xBD, 0xBE, 0x17,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC5, 0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xCB, 0xCC, 0xCE, 0xCE,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB7, 0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE,
	0x04, 0xAD, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0E, 0xAD, 0x0E, 0x99, 0x9C, 0xEF, 0x9C, 0x99, 0xC7,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x14, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0x1B, 0x1D, 0x1D, 0x1E,
	0x20, 0x21, 0xB2, 0x23, 0x23, 0x24, 0x25, 0x26, 0x27, 0x29, 0x29, 0x2B, 0x2B, 0xDC, 0xDD, 0xDE,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x4A, 0x4B, 0x4C, 0x4D, 0x3E,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x45, 0x46, 0x47, 0x49, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0xAB,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x55, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0xAA,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x65, 0x66, 0x68, 0x69, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x75, 0x76, 0x78, 0x79, 0x79, 0x7A, 0x7B, 0x6D, 0x7D, 0xEF,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 0x87, 0x89, 0x89, 0x8B, 0x8B, 0xEC, 0xED, 0xEE,
	0x90, 0x91, 0x92, 0x93, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9D, 0xEF,
	0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA7, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD,
	0xB0, 0x21, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0x38, 0xBA, 0xBB, 0x28, 0xBD, 0xBE, 0x17,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC9, 0xC9, 0xCB, 0xCB, 0xCC, 0xCD, 0xCE,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB7, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE,
	0x04, 0xAD, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0E, 0xAD, 0x0E, 0x99, 0x9C, 0xEF, 0x9C, 0x99, 0xC7,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x14, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0x1B, 0x1C, 0x1D, 0xDD,
	0x20, 0xB0, 0xB2, 0x23, 0x23, 0x24, 0x25, 0x26, 0x27, 0x29, 0x29, 0xDA, 0x2B, 0xDB, 0xDD, 0xDE,
	0x30, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0xBA, 0x4A, 0x4B, 0x4C, 0x4D, 0x4D,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0xDF,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x54, 0x55, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5C, 0x5D, 0xAA,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x64, 0x65, 0x66, 0x68, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0xAA,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x76, 0x76, 0x78, 0x79, 0x7A, 0x7B, 0x6D, 0x6D, 0xEF,
	0x80, 0x81, 0x82, 0x83, 0x83, 0x84, 0x85, 0x86, 0x87, 0x89, 0x89, 0xEA, 0x8B, 0xEB, 0xED, 0xEE,
	0x90, 0x91, 0x92, 0x93, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0x9B, 0x9C, 0xEC, 0xED, 0xEF,
	0x0E, 0x0E, 0x0F, 0xA1, 0xA3, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAA, 0xAB, 0xAC,
	0xB0, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0x38, 0x37, 0xBB, 0x28, 0x27, 0xBE, 0x17,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC9, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD3, 0xB7, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE,
	0x04, 0xAC, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0E, 0xAC, 0x0E, 0x99, 0x9C, 0xEF, 0x9C, 0x99, 0xC6,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0C, 0x0D,
	0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0x1B, 0x1C, 0x1D, 0xDD,
	0x20, 0xB0, 0xB2, 0xB4, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0xD9, 0xDA, 0xDB, 0xDC, 0xDE,
	0x30, 0x31, 0x32, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x38, 0x4A, 0x4B, 0x3C, 0x4C, 0x4D,
	0x40, 0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x46, 0x46, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0xAA,
	0x50, 0x51, 0x52, 0x53, 0x53, 0x54, 0x55, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5B, 0x5C, 0x5D, 0xAA,
	0x60, 0x61, 0x62, 0x63, 0x63, 0x64, 0x65, 0x66, 0x66, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0xAA,
	0x70, 0x71, 0x72, 0x73, 0x73, 0x74, 0x75, 0x76, 0x76, 0x78, 0x79, 0x7A, 0x7B, 0x6C, 0x6D, 0xEF,
	0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x87, 0x89, 0xE9, 0x8B, 0xEB, 0xEC, 0xEE,
	0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0x9B, 0x9B, 0xEC, 0xED, 0xEF,
	0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC,
	0xB0, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xD4, 0x38, 0x37, 0xBC, 0x27, 0x27, 0xBE, 0x17,
	0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE,
	0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE,
	0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE,
	0x04, 0xAC, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0E, 0xAC, 0x0E, 0x99, 0x9B, 0xEF, 0x9B, 0x99, 0xC6,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D,
	0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x19, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0xDD,
	0x20, 0xB0, 0xB2, 0xB3, 0x23, 0x24, 0x25, 0x26, 0x27, 0x27, 0x29, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
	0x30, 0x31, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x38, 0x4A, 0x4B, 0x3C, 0xDD, 0xDE,
	0x40, 0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x46, 0x46, 0x37, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0xAA,
	0x50, 0x51, 0x52, 0x53, 0x53, 0x54, 0x55, 0x56, 0x56, 0x59, 0x5A, 0x5A, 0x5B, 0x5C, 0x5D, 0xA9,
	0x60, 0x61, 0x62, 0x63, 0x63, 0x64, 0x65, 0x66, 0x66, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0xAA,
	0x70, 0x71, 0x72, 0x73, 0x73, 0x74, 0x75, 0x76, 0x76, 0x78, 0x79, 0x7A, 0x7B, 0x6C, 0x6D, 0xEF,
	0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x87, 0x89, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
	0x90, 0x91, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0x9A, 0x9B, 0xEC, 0xED, 0xA9,
	0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4, 0xA6, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAA, 0xAC,
	0xB0, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xD3, 0xB6, 0xD4, 0x38, 0x37, 0xBC, 0x27, 0x27, 0xBE, 0x17,
	0xC0, 0xC1, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC7, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE,
	0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDC, 0xDE,
	0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xEC, 0xEE,
	0x04, 0xAB, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0D, 0xAB, 0x0D, 0x99, 0x9B, 0xEF, 0x9B, 0x99, 0xC6,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
	0x10, 0x11, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x17, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0xDD,
	0x20, 0xB0, 0xB2, 0xB3, 0x23, 0x24, 0x25, 0x26, 0x27, 0x27, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
	0x30, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x37, 0x38, 0x4A, 0x4B, 0x4B, 0xDD, 0xDE,
	0x40, 0x41, 0x42, 0x42, 0x43, 0x44, 0x45, 0x46, 0x46, 0x37, 0x49, 0x4A, 0x4B, 0x4C, 0xDE, 0xA9,
	0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x55, 0x56, 0x56, 0x59, 0x5A, 0x5A, 0x5B, 0x5C, 0x5D, 0xA9,
	0x60, 0x61, 0x62, 0x62, 0x63, 0x64, 0x65, 0x66, 0x66, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0xA9,
	0x70, 0x71, 0x72, 0x72, 0x73, 0x74, 0x75, 0x76, 0x76, 0x78, 0x79, 0x7A, 0x6B, 0xED, 0xEE, 0xEF,
	0x80, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x87, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
	0x90, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99, 0x99, 0x9A, 0x9B, 0xEB, 0xED, 0xEE,
	0x0D, 0x0E, 0x0F, 0x0F, 0xA2, 0xA3, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xA9, 0xAA, 0xAB,
	0x20, 0xB0, 0x21, 0xB2, 0xB2, 0xB4, 0xD3, 0xB6, 0xD4, 0x38, 0x37, 0xBC, 0x27, 0x27, 0xBE, 0x17,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC7, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE,
	0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDC, 0xDD,
	0xE0, 0xE1, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE7, 0xE9, 0xEA, 0xEB, 0xEC, 0xEC, 0xED,
	0x04, 0xAB, 0x13, 0x18, 0x51, 0x57, 0x04, 0x0D, 0xAB, 0x0D, 0x99, 0x9B, 0xA9, 0x9B, 0x99, 0xC6,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
	0x10, 0x11, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x17, 0x19, 0x1A, 0x1B, 0x1C, 0xDB, 0xDC,
	0x20, 0x20, 0xB1, 0xB3, 0x23, 0x24, 0x25, 0x26, 0x27, 0x27, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
	0x41, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x35, 0x36, 0x37, 0x38, 0x4A, 0x4B, 0x4B, 0xDD, 0xDE,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x45, 0x46, 0x46, 0x36, 0x49, 0x4A, 0x4B, 0xDC, 0xDD, 0xA9,
	0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x55, 0x56, 0x56, 0x59, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0xA8,
	0x60, 0x61, 0x62, 0x62, 0x63, 0x64, 0x65, 0x66, 0x66, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0xA7, 0xA9,
	0x70, 0x71, 0x72, 0x72, 0x73, 0x74, 0x75, 0x76, 0x76, 0x76, 0x79, 0x6A, 0x6B, 0xED, 0xED, 0xA9,
	0x80, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x87, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
	0x90, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x97, 0x99, 0x9A, 0x9B, 0xEB, 0xEC, 0xEE,
	0x0D, 0x0E, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB,
	0x20, 0xB0, 0x21, 0xB2, 0xB2, 0xB4, 0xD3, 0xB6, 0xD4, 0x37, 0x37, 0xBC, 0x27, 0x26, 0xBE, 0x17,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC7, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE,
	0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xA7,
	0xE0, 0xE1, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xA7,
	0x04, 0xAB, 0x12, 0x18, 0x51, 0x57, 0x04, 0x0D, 0xAB, 0x0D, 0x99, 0x9B, 0xEE, 0x9B, 0x99, 0xC6,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0C,
	0x10, 0x11, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0xDA, 0xDB, 0xDC,
	0x20, 0x20, 0xB1, 0x22, 0x23, 0x24, 0x25, 0x25, 0x26, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
	0x41, 0x30, 0x31, 0x32, 0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x38, 0x4A, 0x4A, 0x4B, 0xDC, 0xDD,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x45, 0x46, 0x46, 0x36, 0x49, 0x4A, 0x4B, 0xDC, 0xDD, 0xA8,
	0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0xA6, 0xA8,
	0x60, 0x61, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x66, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0xA7, 0xA8,
	0x70, 0x61, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x76, 0x76, 0x69, 0x6A, 0x6B, 0xEC, 0xED, 0xA9,
	0x80, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0x87, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
	0x90, 0x90, 0x91, 0x92, 0x93, 0x94, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0x9B, 0xEB, 0xEC, 0xA8,
	0x0C, 0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA8, 0xA9, 0xAA,
	0x20, 0xB0, 0x21, 0xB1, 0xB2, 0xB3, 0xD3, 0xD3, 0xD4, 0x37, 0x37, 0xBC, 0x27, 0x26, 0x17, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC5, 0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xCB, 0xCD, 0xA6,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB8, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xA7,
	0xE0, 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xA7,
	0x04, 0xAA, 0x12, 0x18, 0x51, 0x57, 0x04, 0x0D, 0xAA, 0x0D, 0x97, 0x9B, 0xEE, 0x9B, 0x97, 0xC6,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0C,
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0xD9, 0xDB, 0xDC,
	0x20, 0x20, 0xB1, 0x22, 0x23, 0x24, 0x24, 0x25, 0x26, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD,
	0x41, 0x30, 0x31, 0x32, 0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x37, 0x4A, 0x4A, 0xDC, 0xDC, 0xDD,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x45, 0x46, 0x46, 0x36, 0x37, 0x4A, 0x4B, 0xDC, 0xDD, 0xA8,
	0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0xA5, 0xA8,
	0x60, 0x61, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x66, 0x68, 0x69, 0x6A, 0x6A, 0xEC, 0xA7, 0xA8,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x76, 0x76, 0x69, 0x6A, 0x6B, 0xEC, 0xED, 0xA8,
	0x80, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 0x87, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED,
	0x90, 0x90, 0x91, 0x92, 0x93, 0x94, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0xE9, 0xEB, 0xEC, 0xA8,
	0x0C, 0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA7, 0xA8, 0xA9, 0xAA,
	0x20, 0xB0, 0x21, 0xB1, 0xB2, 0xB3, 0xB4, 0xD3, 0xD4, 0x37, 0x36, 0xD7, 0x27, 0x26, 0x17, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC4, 0xC5, 0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xCB, 0xCD, 0xA6,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xB7, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xA6,
	0xE0, 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xA6,
	0x03, 0xAA, 0x12, 0x18, 0x51, 0x57, 0x03, 0x0C, 0xAA, 0x0C, 0x97, 0x9B, 0xEE, 0x9B, 0x97, 0xC5,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x06, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0A, 0x0B, 0x0C,
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x14, 0x15, 0x16, 0x17, 0x19, 0x1A, 0x1B, 0xD9, 0xDB, 0xDC,
	0xD0, 0x20, 0xB1, 0x22, 0x23, 0x24, 0x24, 0x25, 0x26, 0xD7, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC,
	0x41, 0x30, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x36, 0x37, 0x37, 0x49, 0xDA, 0xDC, 0xDC, 0xDD,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x45, 0x45, 0x46, 0x36, 0x37, 0x4A, 0x4A, 0xDC, 0xDD, 0xA8,
	0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0xA5, 0xA7,
	0x60, 0x61, 0x61, 0x62, 0x63, 0x64, 0x65, 0x65, 0x66, 0x66, 0x69, 0x69, 0x6A, 0xA4, 0xA6, 0xA8,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x74, 0x75, 0x75, 0x76, 0x76, 0x69, 0x6A, 0x6B, 0xEC, 0xED, 0xA8,
	0xE0, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 0x87, 0xE8, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC,
	0x90, 0x90, 0x91, 0x92, 0x93, 0x94, 0x94, 0x95, 0x96, 0x97, 0x99, 0x9A, 0xE9, 0xEB, 0xEC, 0xA7,
	0x0C, 0x0D, 0x0E, 0x0E, 0xA1, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA8, 0xAA,
	0x20, 0x20, 0x21, 0xB1, 0xB2, 0xB3, 0xB4, 0xD3, 0xB6, 0x37, 0x36, 0xD7, 0x27, 0x26, 0x16, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC4, 0xC5, 0xC6, 0xC7, 0xC9, 0xCA, 0xCA, 0xCB, 0xCC, 0xA6,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xB6, 0xB7, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xA6,
	0xE0, 0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0xE7, 0xE7, 0xE9, 0xEA, 0xEB, 0xEC, 0xA6,
	0x03, 0xA9, 0x12, 0x18, 0x51, 0x57, 0x03, 0x0C, 0xA9, 0x0C, 0x97, 0xE9, 0xEE, 0xE9, 0x97, 0xC5,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x06, 0x06, 0x07, 0x08, 0x09, 0x09, 0x0A, 0x0B, 0x0C,
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x14, 0x15, 0x16, 0x16, 0x19, 0xD7, 0xD8, 0xD9, 0xDB, 0xDC,
	0xD0, 0x20, 0xB1, 0x22, 0xB4, 0x23, 0x24, 0x25, 0x26, 0xD7, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC,
	0x41, 0x30, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x36, 0x36, 0x37, 0x49, 0xDA, 0xDB, 0xDC, 0xDD,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x44, 0x45, 0x35, 0x36, 0x37, 0x49, 0xDB, 0xDC, 0xA6, 0xA7,
	0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x54, 0x55, 0x56, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0xA5, 0xA7,
	0x60, 0x61, 0x61, 0x62, 0x63, 0x64, 0x65, 0x65, 0x66, 0x66, 0x69, 0x69, 0x6A, 0xA4, 0xA6, 0xA7,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x75, 0x76, 0x69, 0xEA, 0xEB, 0xEC, 0xED, 0xA8,
	0xE0, 0x80, 0x81, 0x82, 0x83, 0x83, 0x84, 0x85, 0x86, 0x86, 0xE8, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC,
	0x90, 0x90, 0x91, 0x92, 0x93, 0x93, 0x94, 0x95, 0x96, 0x97, 0x99, 0xE8, 0xE9, 0xEB, 0xEC, 0xA7,
	0x0C, 0x0D, 0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6, 0xA7, 0xA7, 0xA8, 0xA9,
	0x20, 0x20, 0xB0, 0xB1, 0xB2, 0xB3, 0xD2, 0xD3, 0xD3, 0x37, 0x36, 0xD7, 0x26, 0x26, 0x16, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC5, 0xC6, 0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xA4, 0xA5,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xA4, 0xA5,
	0xE0, 0xE0, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE7, 0xE9, 0xEA, 0xEB, 0xA4, 0xA5,
	0x03, 0xA9, 0x12, 0x18, 0x51, 0x57, 0x03, 0x0C, 0xA9, 0x0C, 0x97, 0xE9, 0xA7, 0xE9, 0x97, 0xC5,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x10, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x15, 0x16, 0x16, 0x19, 0xD7, 0xD8, 0xD9, 0xDB, 0xDC,
	0xD0, 0x20, 0x21, 0x22, 0xB4, 0x23, 0x24, 0x25, 0x26, 0xD7, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC,
	0x41, 0x30, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x35, 0x36, 0x37, 0x37, 0xDA, 0xDB, 0xDC, 0xDD,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x44, 0x45, 0x45, 0x36, 0x36, 0xDA, 0xDA, 0xDC, 0xA5, 0xA7,
	0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x54, 0x55, 0x55, 0x56, 0x59, 0x5A, 0x5B, 0x5C, 0xA4, 0xA7,
	0x60, 0x61, 0x61, 0x62, 0x63, 0x64, 0x64, 0x65, 0x65, 0x66, 0x68, 0x69, 0x6A, 0xA4, 0xA5, 0xA7,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x75, 0x76, 0x69, 0xEA, 0xEB, 0xEC, 0xEC, 0xA7,
	0xE0, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC,
	0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x95, 0x96, 0x96, 0x99, 0xE7, 0xE9, 0xEB, 0xEC, 0xA7,
	0x0C, 0x0C, 0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA2, 0xA3, 0xA4, 0xA4, 0xA6, 0xA6, 0xA7, 0xA8, 0xA9,
	0x20, 0x20, 0xB0, 0x21, 0xB1, 0xD2, 0xD2, 0xD3, 0xD3, 0x37, 0x36, 0xD7, 0x26, 0x26, 0x16, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xA3, 0xA5,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xD6, 0xD6, 0xD7, 0xD9, 0xD9, 0xDA, 0xA3, 0xA5,
	0xE0, 0xE0, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0xE9, 0xE9, 0xEA, 0xA3, 0xA5,
	0x03, 0xA8, 0x12, 0x18, 0x51, 0x57, 0x03, 0x0C, 0xA8, 0x0C, 0x97, 0xE9, 0xA7, 0xE9, 0x97, 0xC5,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0B,
	0x10, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x15, 0x16, 0x16, 0x19, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0xD0, 0x20, 0x21, 0x22, 0xB4, 0x23, 0x24, 0x25, 0x26, 0xD7, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC,
	0x41, 0x30, 0x31, 0x32, 0x32, 0x33, 0x34, 0x34, 0x35, 0x36, 0x37, 0x37, 0xDA, 0xDB, 0xDC, 0xDC,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x44, 0x44, 0x45, 0x45, 0x35, 0x36, 0xDA, 0xDA, 0xDB, 0xA5, 0xA7,
	0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x54, 0x55, 0x55, 0x56, 0x59, 0x5A, 0x5B, 0xA2, 0xA4, 0xA6,
	0x60, 0x61, 0x61, 0x62, 0x63, 0x64, 0x64, 0x65, 0x65, 0x66, 0x68, 0x69, 0x6A, 0xA3, 0xA5, 0xA7,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x74, 0x74, 0x75, 0x75, 0x75, 0x69, 0xEA, 0xEB, 0xEC, 0xEC, 0xA7,
	0xE0, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC,
	0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x95, 0x96, 0x96, 0x99, 0xE7, 0xE9, 0xEA, 0xEB, 0xA6,
	0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6, 0xA7, 0xA7, 0xA8,
	0x20, 0x20, 0xB0, 0x21, 0xB1, 0xD2, 0xD2, 0xD3, 0xD3, 0x36, 0x36, 0xD7, 0x26, 0x25, 0x16, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xA3, 0xA4,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xA3, 0xA5,
	0x70, 0xE0, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xA3, 0xA5,
	0x03, 0xA8, 0x12, 0x17, 0x51, 0x57, 0x03, 0x0B, 0xA8, 0x0B, 0x96, 0xE9, 0xA7, 0xE9, 0x96, 0xC5,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x0A, 0x0A, 0x0B,
	0x10, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x16, 0x17, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0xD0, 0x20, 0x21, 0xB2, 0xB3, 0x23, 0x24, 0x25, 0x25, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC,
	0x41, 0x30, 0x31, 0x32, 0x32, 0x33, 0x34, 0x34, 0x35, 0x36, 0x36, 0x37, 0xDA, 0xDB, 0xDB, 0xDC,
	0x40, 0x41, 0x30, 0x42, 0x43, 0x43, 0x44, 0x45, 0x45, 0x35, 0x36, 0xD9, 0xDA, 0xDB, 0xA5, 0xA6,
	0x50, 0x50, 0x51, 0x52, 0x53, 0x53, 0x54, 0x55, 0x55, 0x55, 0x59, 0x5A, 0x5B, 0xA2, 0xA4, 0xA6,
	0x60, 0x70, 0x61, 0x62, 0x63, 0x63, 0x64, 0x65, 0x65, 0x66, 0x66, 0x69, 0x6A, 0xA3, 0xA4, 0xA6,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x73, 0x74, 0x75, 0x75, 0x75, 0xE9, 0xEA, 0xEA, 0xEB, 0xEC, 0xA7,
	0xE0, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0x85, 0x86, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC,
	0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0x95, 0x96, 0xE6, 0xE7, 0xE9, 0xEA, 0xEB, 0xA6,
	0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA5, 0xA6, 0xA6, 0xA7, 0xA8,
	0x20, 0x20, 0xB0, 0x21, 0x21, 0xD2, 0xD2, 0xD3, 0xD3, 0x36, 0x35, 0xD7, 0x26, 0x25, 0x16, 0x16,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC5, 0xC5, 0xC6, 0xC7, 0xC9, 0xCA, 0xA1, 0xA3, 0xA4,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xA2, 0xA3, 0xA4,
	0x70, 0xE0, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xA2, 0xA3, 0xA4,
	0x03, 0xA8, 0x12, 0x17, 0x51, 0x57, 0x03, 0x0B, 0xA8, 0x0B, 0x96, 0xE9, 0xA6, 0xE9, 0x96, 0xC5,
	0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x09, 0x0A, 0x0B,
	0x10, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x15, 0x15, 0x16, 0x16, 0xD6, 0xD7, 0xD8, 0xDA, 0xDB,
	0xD0, 0x20, 0x21, 0xB2, 0xB3, 0x23, 0x24, 0x24, 0x25, 0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDB, 0xDC,
	0x41, 0x30, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x35, 0x36, 0x36, 0xD9, 0xDA, 0xDA, 0xDB, 0xDC,
	0x40, 0x41, 0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x45, 0x35, 0x36, 0xD9, 0xDA, 0xA3, 0xA4, 0xA6,
	0x50, 0x50, 0x51, 0x52, 0x53, 0x53, 0x54, 0x55, 0x55, 0x55, 0x59, 0x5A, 0x5B, 0xA2, 0xA3, 0xA5,
	0x60, 0x70, 0x61, 0x62, 0x63, 0x63, 0x64, 0x65, 0x65, 0x65, 0x66, 0x69, 0xEA, 0xA3, 0xA4, 0xA6,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x73, 0x74, 0x75, 0x75, 0x75, 0xE8, 0xEA, 0xEA, 0xEB, 0xEC, 0xA6,
	0xE0, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0x85, 0x86, 0xE7, 0xE8, 0xE9, 0xE9, 0xEB, 0xEC,
	0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0x95, 0x96, 0xE6, 0xE7, 0xE8, 0xEA, 0xEB, 0xA5,
	0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0F, 0xA1, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6, 0xA7, 0xA7,
	0x20, 0x20, 0xB0, 0x21, 0x21, 0xD2, 0xD2, 0xD3, 0xD3, 0x36, 0x35, 0xD7, 0x26, 0x25, 0x16, 0x15,
	0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC5, 0xC6, 0xC6, 0xC9, 0xCA, 0xA1, 0xA3, 0xA4,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xD4, 0xB8, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xA1, 0xA3, 0xA4,
	0x70, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE7, 0xE7, 0xE9, 0xA1, 0xA3, 0xA4,
	0x03, 0xA7, 0x12, 0x17, 0x51, 0x56, 0x03, 0x0B, 0xA7, 0x0B, 0x96, 0xE8, 0xA6, 0xE8, 0x96, 0xC5,
	0x00, 0x01, 0x01, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06, 0x06, 0x07, 0x08, 0x09, 0x09, 0x0A, 0x0B,
	0x10, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x14, 0x15, 0x16, 0x16, 0xD6, 0xD7, 0xD8, 0xD9, 0xA3,
	0xD0, 0x20, 0xB0, 0xB2, 0xB3, 0x23, 0x24, 0x24, 0x25, 0xD6, 0xD7, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB,
	0x41, 0x30, 0x31, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x35, 0x36, 0xD9, 0xDA, 0xDA, 0xDB, 0xA4,
	0x40, 0x40, 0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x45, 0x35, 0x35, 0xD9, 0xDA, 0xA3, 0xA4, 0xA5,
	0x50, 0x50, 0x51, 0x52, 0x53, 0x53, 0x54, 0x55, 0x55, 0x55, 0x59, 0x5A, 0x5A, 0xA1, 0xA3, 0xA5,
	0x60, 0x70, 0x61, 0x62, 0x63, 0x63, 0x64, 0x65, 0x65, 0x65, 0x66, 0x69, 0xA1, 0xA3, 0xA4, 0xA5,
	0x60, 0x61, 0x71, 0x72, 0x73, 0x73, 0x74, 0x75, 0x75, 0x75, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xA6,
	0xE0, 0x80, 0x81, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0xE6, 0xE7, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
	0x90, 0x90, 0x91, 0x91, 0x92, 0x93, 0x94, 0x94, 0x95, 0x96, 0xE6, 0xE7, 0xE8, 0xE9, 0xA3, 0xA5,
	0x0B, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA5, 0xA5, 0xA6, 0xA7,
	0x20, 0x20, 0x20, 0x21, 0x21, 0xD2, 0xD2, 0xD2, 0xD3, 0x36, 0x35, 0xD7, 0x26, 0x25, 0x24, 0x15,
	0x10, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC5, 0xC6, 0xC6, 0xC7, 0xC9, 0xA1, 0xA2, 0xA4,
	0xD0, 0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xB6, 0xB7, 0xB8, 0xD6, 0xD6, 0xD8, 0xD9, 0xA1, 0xA2, 0xA4,
	0x70, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0xE9, 0xA1, 0xA2, 0xA4,
	0x03, 0xA7, 0x12, 0x17, 0x51, 0x56, 0x03, 0x0B, 0xA7, 0x0B, 0x96, 0xE8, 0xA5, 0xE8, 0x96, 0xC5,
	0x00, 0x01, 0x01, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06, 0x06, 0x07, 0x08, 0x08, 0x09, 0x0A, 0x0A,
	0x10, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x14, 0x15, 0x16, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xA3,
	0xD0, 0x20, 0xB0, 0xB2, 0xB3, 0x23, 0x23, 0x24, 0x25, 0xD6, 0xD7, 0xD7, 0xD8, 0xD9, 0xDA, 0xA3,
	0xD0, 0x30, 0x31, 0x31, 0x32, 0x33, 0x33, 0x34, 0x35, 0x35, 0x36, 0xD9, 0xD9, 0xDA, 0xDB, 0xA4,
	0x40, 0x40, 0x41, 0x42, 0x43, 0x43, 0x44, 0x45, 0x45, 0x35, 0x35, 0xD9, 0xDA, 0xA2, 0xA4, 0xA5,
	0x50, 0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x55, 0x55, 0x55, 0x59, 0x5A, 0x0E, 0xA1, 0xA3, 0xA4,
	0x60, 0x70, 0x61, 0x62, 0x63, 0x63, 0x64, 0x65, 0x65, 0x65, 0x65, 0xE9, 0xA1, 0xA2, 0xA3, 0xA5,
	0x60, 0xE0, 0x71, 0x72, 0x72, 0x73, 0x74, 0x75, 0x75, 0x75, 0xE8, 0xE9, 0xEA, 0xEB, 0xA4, 0xA5,
	0xE0, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83, 0x84, 0x85, 0xE6, 0xE7, 0xE7, 0xE8, 0xE9, 0xEA, 0xA3,
	0x90, 0x90, 0x91, 0x91, 0x92, 0x93, 0x93, 0x94, 0x95, 0x96, 0xE5, 0xE7, 0xE8, 0xE9, 0xA3, 0xA4,
	0x0A, 0x0B, 0x0C, 0x0C, 0x0E, 0x0E, 0x0F, 0xA1, 0xA2, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6, 0xA7,
	0x20, 0x20, 0x20, 0x21, 0x21, 0xD2, 0xD2, 0xD2, 0xD3, 0x35, 0x35, 0xD6, 0x25, 0x25, 0x24, 0x15,
	0x10, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC5, 0xC5, 0xC6, 0xC7, 0x0E, 0x0F, 0xA2, 0xA3,
	0x02, 0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xB6, 0xB7, 0xB8, 0xD6, 0xD6, 0xD8, 0x0E, 0xA1, 0xA2, 0xA3,
	0x70, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0x0E, 0xA1, 0xA2, 0xA3,
	0x03, 0xA6, 0x12, 0x17, 0x51, 0x56, 0x03, 0x0B, 0xA6, 0x0B, 0x96, 0xE8, 0xA5, 0xE8, 0x96, 0xC4,
	0x00, 0x01, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x0A, 0x0A,
	0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x14, 0x14, 0x15, 0x15, 0xB8, 0xD6, 0xD7, 0xD8, 0xD9, 0xA2,
	0xD0, 0x20, 0xB0, 0xB1, 0xB3, 0xB4, 0x23, 0x24, 0x25, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xA3,
	0xD0, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x34, 0x34, 0x35, 0x35, 0xD8, 0xD9, 0xDA, 0xDA, 0xA4,
	0x40, 0x40, 0x41, 0x42, 0x42, 0x43, 0x44, 0x44, 0x45, 0x34, 0x35, 0xD8, 0xD9, 0xA2, 0xA3, 0xA4,
	0x50, 0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x55, 0x55, 0x55, 0x64, 0x65, 0x0E, 0x0F, 0xA2, 0xA4,
	0x60, 0x70, 0x61, 0x62, 0x62, 0x63, 0x64, 0x64, 0x65, 0x65, 0x65, 0x0E, 0x0F, 0xA2, 0xA3, 0xA4,
	0x60, 0xE0, 0x71, 0x72, 0x72, 0x73, 0x74, 0x74, 0x75, 0x75, 0xE8, 0xE9, 0xEA, 0xEA, 0xA4, 0xA5,
	0xE0, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83, 0x84, 0x85, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xA3,
	0x90, 0x90, 0x91, 0x91, 0x92, 0x93, 0x93, 0x94, 0x95, 0x96, 0xE5, 0xE6, 0xE7, 0xE9, 0xA2, 0xA4,
	0x0A, 0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6,
	0x20, 0x20, 0x20, 0x21, 0x21, 0xD2, 0xD2, 0xD2, 0xD3, 0x35, 0x35, 0xD6, 0x25, 0x25, 0x24, 0x15,
	0x10, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC5, 0xC5, 0xC6, 0xC6, 0x0E, 0x0F, 0xA1, 0xA3,
	0x02, 0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xB8, 0xD6, 0xD7, 0x0E, 0x0F, 0xA1, 0xA3,
	0x70, 0xE0, 0xE1, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE6, 0xE6, 0xE7, 0x0E, 0x0F, 0xA1, 0xA3,
	0x03, 0xA6, 0x12, 0x17, 0x50, 0x56, 0x03, 0x0A, 0xA6, 0x0A, 0x96, 0xE7, 0xA4, 0xE7, 0x96, 0xC4,
	0x00, 0x01, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x09, 0x09, 0x0A,
	0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x13, 0x14, 0x15, 0x15, 0xB8, 0xD6, 0xD6, 0xD8, 0xD9, 0xA2,
	0xD0, 0x20, 0xB0, 0xB1, 0x22, 0xB4, 0x23, 0x24, 0x25, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xA3,
	0xD0, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x34, 0x34, 0x35, 0x35, 0xD8, 0xD9, 0xDA, 0xDA, 0xA3,
	0x40, 0x40, 0x41, 0x42, 0x42, 0x43, 0x44, 0x44, 0x34, 0x34, 0x35, 0xD8, 0xD9, 0xA2, 0xA3, 0xA4,
	0x50, 0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x54, 0x55, 0x55, 0x64, 0x65, 0x0D, 0x0F, 0xA2, 0xA4,
	0x60, 0x70, 0x61, 0x62, 0x62, 0x63, 0x64, 0x64, 0x65, 0x65, 0x65, 0xE7, 0x0F, 0xA1, 0xA3, 0xA4,
	0x60, 0xE0, 0x71, 0x72, 0x72, 0x73, 0x74, 0x74, 0x74, 0x75, 0xE8, 0xE9, 0xEA, 0xEA, 0xA3, 0xA4,
	0xE0, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0xE5, 0xE6, 0xE7, 0xE7, 0xE9, 0xEA, 0xA3,
	0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0x95, 0xE5, 0xE6, 0xE7, 0xE9, 0xA2, 0xA4,
	0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0E, 0x0E, 0x0F, 0xA1, 0xA2, 0xA2, 0xA3, 0xA4, 0xA4, 0xA5, 0xA6,
	0x20, 0x20, 0x20, 0x21, 0x21, 0x21, 0xD2, 0xD2, 0xD3, 0x35, 0x34, 0xD6, 0x25, 0x24, 0x24, 0x15,
	0x10, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC5, 0xC5, 0xC6, 0xC6, 0x0D, 0x0F, 0xA1, 0xA3,
	0x02, 0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xB8, 0xD6, 0xD7, 0x0E, 0x0F, 0xA1, 0xA3,
	0x70, 0xE0, 0xE1, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE7, 0x0E, 0x0F, 0xA1, 0xA3,
	0x03, 0xA5, 0x12, 0x16, 0x50, 0x56, 0x03, 0x0A, 0xA5, 0x0A, 0x95, 0xE7, 0xA4, 0xE7, 0x95, 0xC4,
	0x00, 0x01, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09, 0x0A,
	0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x13, 0x14, 0x15, 0x15, 0x24, 0xB8, 0xD6, 0xD7, 0xD9, 0xA1,
	0xD0, 0x20, 0x20, 0xB1, 0xB2, 0xB4, 0x23, 0x24, 0x24, 0xB8, 0xD6, 0xD7, 0xD7, 0xD8, 0xD9, 0xA2,
	0xD0, 0x30, 0x30, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x35, 0x35, 0xD8, 0xD9, 0xD9, 0xDA, 0xA3,
	0x40, 0x40, 0x41, 0x42, 0x42, 0x43, 0x44, 0x44, 0x44, 0x34, 0x35, 0xD8, 0xD9, 0xA1, 0xA3, 0xA4,
	0x50, 0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x54, 0x54, 0x55, 0x64, 0x65, 0x0D, 0x0F, 0xA2, 0xA3,
	0x60, 0x70, 0x61, 0x62, 0x62, 0x63, 0x64, 0x64, 0x65, 0x65, 0x65, 0x0D, 0x0F, 0xA1, 0xA2, 0xA4,
	0x60, 0x70, 0x71, 0x72, 0x72, 0x73, 0x74, 0x74, 0x74, 0x74, 0xE7, 0xE8, 0xE9, 0xEA, 0xA3, 0xA4,
	0x70, 0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0xE5, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xA2,
	0x90, 0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0x95, 0xE5, 0xE6, 0xE7, 0xE9, 0xA1, 0xA3,
	0x0A, 0x0A, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA4, 0xA5,
	0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0xD2, 0xD2, 0xD3, 0x35, 0x34, 0xD6, 0x25, 0x24, 0x24, 0x15,
	0x10, 0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC5, 0xC5, 0xC6, 0x0D, 0x0E, 0xA1, 0xA2,
	0x02, 0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xB8, 0xD6, 0xD6, 0x0D, 0x0F, 0xA1, 0xA2,
	0x70, 0xE0, 0xE1, 0xE1, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE6, 0x0D, 0x0F, 0xA1, 0xA2,
	0x03, 0xA5, 0x11, 0x16, 0x50, 0x56, 0x03, 0x0A, 0xA5, 0x0A, 0x95, 0xE7, 0xA4, 0xE7, 0x95, 0xC4,
	0x00, 0x01, 0x01, 0x02, 0x03, 0x03, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x08, 0x08, 0x09, 0x0A,
	0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x13, 0x14, 0x14, 0x15, 0xB7, 0xB8, 0xD6, 0xD7, 0x0E, 0xA1,
	0xD0, 0x20, 0x20, 0xB1, 0xB2, 0xB4, 0x23, 0x24, 0x24, 0xB8, 0xD6, 0xD6, 0xD7, 0xD8, 0xD9, 0xA2,
	0xD0, 0x30, 0x30, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x35, 0x35, 0xD8, 0xD8, 0xD9, 0xDA, 0xA3,
	0x40, 0x40, 0x41, 0x42, 0x42, 0x43, 0x43, 0x44, 0x44, 0x34, 0x34, 0xD8, 0xD9, 0xA1, 0xA2, 0xA3,
	0x50, 0x50, 0x51, 0x52, 0x52, 0x53, 0x53, 0x54, 0x54, 0x54, 0x64, 0x65, 0x0D, 0x0E, 0xA1, 0xA3,
	0x60, 0x70, 0x61, 0x62, 0x62, 0x63, 0x63, 0x64, 0x64, 0x65, 0x65, 0xE7, 0x0E, 0xA1, 0xA2, 0xA3,
	0x60, 0x70, 0x71, 0x72, 0x72, 0x73, 0x73, 0x74, 0x74, 0x74, 0xE7, 0xE8, 0xE9, 0xEA, 0xA3, 0xA4,
	0x70, 0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0xE5, 0xE6, 0xE6, 0xE7, 0xE8, 0xE9, 0xA2,
	0x90, 0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0x94, 0xE5, 0xE6, 0xE7, 0x0E, 0xA1, 0xA3,
	0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0E, 0x0E, 0x0F, 0xA1, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4, 0xA5,
	0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0xD2, 0xD2, 0xD2, 0x35, 0x34, 0xD6, 0xB8, 0x24, 0x24, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC5, 0xC5, 0xC6, 0x0D, 0x0E, 0x0F, 0xA2,
	0x02, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD4, 0xD4, 0xB8, 0xB8, 0xD6, 0x0D, 0x0E, 0x0F, 0xA2,
	0x70, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0xE6, 0x0D, 0x0E, 0x0F, 0xA2,
	0x03, 0xA4, 0x11, 0x16, 0x50, 0x56, 0x03, 0x0A, 0xA4, 0x0A, 0x95, 0xE7, 0xA3, 0xE7, 0x95, 0xC4,
	0x00, 0x00, 0x01, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x06, 0x06, 0x07, 0x07, 0x08, 0x09, 0x09,
	0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x14, 0x14, 0x14, 0xB7, 0xB8, 0xD6, 0xD7, 0x0E, 0xA1,
	0xD0, 0x20, 0x20, 0x21, 0xB2, 0xB3, 0x23, 0x23, 0x24, 0xB8, 0xD6, 0xD6, 0xD7, 0xD8, 0x0F, 0xA1,
	0xD0, 0x41, 0x30, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x34, 0x35, 0xD7, 0xD8, 0xD9, 0xA1, 0xA2,
	0x01, 0x40, 0x41, 0x30, 0x42, 0x43, 0x43, 0x44, 0x44, 0x34, 0x34, 0xD7, 0x0E, 0xA1, 0xA2, 0xA3,
	0x50, 0x50, 0x51, 0x51, 0x52, 0x53, 0x53, 0x54, 0x54, 0x54, 0x64, 0x64, 0x0C, 0x0E, 0xA1, 0xA3,
	0x01, 0x70, 0x61, 0x61, 0x62, 0x63, 0x63, 0x64, 0x64, 0x65, 0x65, 0x0D, 0x0E, 0x0F, 0xA2, 0xA3,
	0x60, 0x70, 0x71, 0x71, 0x72, 0x73, 0x73, 0x74, 0x74, 0x74, 0xE7, 0xE8, 0xE9, 0xA1, 0xA2, 0xA3,
	0x70, 0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, 0xE5, 0xE6, 0xE6, 0xE7, 0xE7, 0x0F, 0xA1,
	0x90, 0x90, 0x90, 0x91, 0x92, 0x92, 0x93, 0x93, 0x94, 0x94, 0xE5, 0xE6, 0xE7, 0x0E, 0xA1, 0xA3,
	0x09, 0x0A, 0x0A, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2, 0xA3, 0xA3, 0xA3, 0xA4,
	0x20, 0x20, 0x20, 0x20, 0xD1, 0x21, 0xD2, 0xD2, 0xD2, 0x34, 0x34, 0xD6, 0xB7, 0x24, 0x14, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC4, 0xC4, 0xC5, 0xC6, 0x0C, 0x0E, 0x0F, 0xA1,
	0x02, 0xD0, 0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xD4, 0xD4, 0xB8, 0xB8, 0xD6, 0x0D, 0x0E, 0x0F, 0xA1,
	0x70, 0xE0, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE4, 0xE5, 0xE5, 0xE6, 0x0D, 0x0E, 0x0F, 0xA1,
	0x03, 0xA4, 0x11, 0x16, 0x50, 0x55, 0x03, 0x09, 0xA4, 0x09, 0x94, 0xE7, 0xA3, 0xE7, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09,
	0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x14, 0x14, 0x14, 0xB6, 0xB8, 0xB8, 0xD6, 0x0E, 0x0F,
	0xD0, 0x20, 0x20, 0x21, 0xB2, 0xB3, 0xB4, 0x23, 0x24, 0xB7, 0xB8, 0xD6, 0xD6, 0xD8, 0x0F, 0xA1,
	0xD0, 0x41, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x34, 0x34, 0x34, 0xD7, 0xD8, 0xD9, 0xA1, 0xA2,
	0x01, 0x40, 0x41, 0x30, 0x42, 0x43, 0x43, 0x44, 0x44, 0x44, 0x34, 0xD7, 0x0E, 0x0F, 0xA1, 0xA3,
	0x50, 0x50, 0x51, 0x51, 0x52, 0x53, 0x53, 0x54, 0x54, 0x54, 0x64, 0x64, 0x0C, 0x0E, 0x0F, 0xA2,
	0x01, 0x70, 0x61, 0x61, 0x62, 0x63, 0x63, 0x64, 0x64, 0x64, 0x65, 0x0C, 0x0E, 0x0F, 0xA1, 0xA3,
	0x60, 0x70, 0x71, 0x71, 0x72, 0x73, 0x73, 0x74, 0x74, 0x74, 0xE7, 0xE7, 0xE9, 0x0F, 0xA2, 0xA3,
	0x70, 0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, 0xE5, 0xE5, 0xE6, 0xE7, 0xE7, 0x0F, 0xA1,
	0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0xE5, 0xE5, 0xE6, 0x0E, 0x0F, 0xA2,
	0x09, 0x0A, 0x0A, 0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0E, 0x0F, 0xA1, 0xA1, 0xA2, 0xA3, 0xA3, 0xA4,
	0x20, 0x20, 0x20, 0x20, 0xD1, 0x21, 0xD1, 0xD2, 0xD2, 0x34, 0x34, 0xD6, 0xB7, 0x24, 0x14, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3, 0xC3, 0xC4, 0xC4, 0xC5, 0xC5, 0x0C, 0x0D, 0x0F, 0xA1,
	0x02, 0xD0, 0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD4, 0xB8, 0xB8, 0xD6, 0x0C, 0x0E, 0x0F, 0xA1,
	0x70, 0xE0, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0x0C, 0x0E, 0x0F, 0xA1,
	0x03, 0xA4, 0x11, 0x16, 0x50, 0x55, 0x03, 0x09, 0xA4, 0x09, 0x94, 0xE6, 0xA3, 0xE6, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09,
	0x10, 0x10, 0x10, 0x11, 0x12, 0x12, 0x13, 0x13, 0x14, 0x14, 0xB6, 0xB8, 0xB8, 0xD6, 0x0D, 0x0F,
	0xD0, 0xD0, 0x20, 0x21, 0xB1, 0xB3, 0xB4, 0x23, 0x24, 0xB7, 0xB8, 0xD6, 0xD6, 0xD7, 0x0E, 0x0F,
	0xD0, 0x41, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x34, 0xD7, 0xD8, 0xD9, 0x0F, 0xA1,
	0x01, 0x40, 0x41, 0x30, 0x42, 0x43, 0x43, 0x44, 0x44, 0x44, 0x34, 0xD6, 0x0E, 0x0F, 0xA1, 0xA2,
	0x50, 0x50, 0x51, 0x51, 0x52, 0x53, 0x53, 0x54, 0x54, 0x54, 0x64, 0x64, 0x0C, 0x0D, 0x0F, 0xA2,
	0x01, 0x60, 0x61, 0x61, 0x62, 0x63, 0x63, 0x64, 0x64, 0x64, 0x65, 0x0C, 0x0D, 0x0F, 0xA1, 0xA2,
	0x60, 0x70, 0x71, 0x71, 0x72, 0x73, 0x73, 0x74, 0x74, 0x74, 0xE7, 0xE7, 0xE8, 0x0F, 0xA1, 0xA2,
	0x70, 0xE0, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x84, 0xE5, 0xE5, 0xE6, 0xE6, 0xE7, 0x0E, 0x0F,
	0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0xE5, 0xE5, 0xE6, 0x0D, 0x0F, 0xA2,
	0x09, 0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2, 0xA2, 0xA3, 0xA3,
	0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0x34, 0x34, 0xB8, 0xB7, 0x24, 0x14, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC4, 0xC5, 0x0C, 0x0D, 0x0E, 0x0F,
	0x02, 0xD0, 0xD0, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD4, 0xD4, 0xB8, 0xB8, 0x0C, 0x0D, 0x0E, 0xA1,
	0x70, 0xE0, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0x0C, 0x0D, 0x0E, 0xA1,
	0x03, 0xA3, 0x11, 0x15, 0x50, 0x55, 0x03, 0x09, 0xA3, 0x09, 0x94, 0xE6, 0xA2, 0xE6, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x07, 0x08, 0x09,
	0x10, 0x10, 0x10, 0x11, 0x12, 0x12, 0x13, 0x13, 0x14, 0x14, 0xB6, 0xB8, 0xB8, 0xD6, 0x0D, 0x0E,
	0x10, 0xD0, 0x20, 0x21, 0xB1, 0x22, 0xB4, 0xB5, 0x24, 0xB7, 0xB8, 0xD6, 0xD6, 0xD7, 0x0E, 0x0F,
	0xD0, 0x41, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x34, 0xD6, 0xD7, 0xD8, 0x0F, 0xA1,
	0x01, 0x40, 0x41, 0x30, 0x42, 0x42, 0x43, 0x44, 0x44, 0x44, 0x34, 0xD6, 0x0D, 0x0E, 0x0F, 0xA2,
	0x01, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x54, 0x54, 0x54, 0x63, 0x64, 0x0B, 0x0D, 0x0F, 0xA1,
	0x01, 0x60, 0x61, 0x61, 0x62, 0x63, 0x63, 0x64, 0x64, 0x64, 0x65, 0x0C, 0x0D, 0x0E, 0x0F, 0xA2,
	0x60, 0x70, 0x71, 0x71, 0x72, 0x72, 0x73, 0x74, 0x74, 0x74, 0xE6, 0xE7, 0xE7, 0x0F, 0xA1, 0xA2,
	0x70, 0xE0, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x84, 0xE5, 0xE5, 0xE6, 0xE6, 0xE7, 0x0E, 0x0F,
	0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0xE4, 0xE5, 0xE6, 0x0D, 0x0E, 0xA1,
	0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0E, 0x0F, 0xA1, 0xA1, 0xA2, 0xA2, 0xA3,
	0xD0, 0x20, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD2, 0xD2, 0x34, 0x33, 0xB8, 0xB7, 0x24, 0x14, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC4, 0xC5, 0x0C, 0x0D, 0x0E, 0x0F,
	0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD3, 0xD4, 0xD4, 0xB8, 0xB8, 0x0C, 0x0D, 0x0E, 0x0F,
	0x02, 0xE0, 0xE0, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0xE5, 0xE5, 0x0C, 0x0D, 0x0E, 0x0F,
	0x03, 0xA3, 0x11, 0x15, 0x50, 0x55, 0x03, 0x09, 0xA3, 0x09, 0x94, 0xE6, 0xA2, 0xE6, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x07, 0x08, 0x08,
	0x10, 0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x13, 0x14, 0x14, 0xB6, 0xB7, 0xB8, 0xD6, 0x0D, 0x0E,
	0x10, 0xD0, 0x20, 0x21, 0xB1, 0xB2, 0xB3, 0xB5, 0x24, 0xB7, 0xB8, 0xB8, 0xD6, 0xD6, 0x0E, 0x0F,
	0xD0, 0x41, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x34, 0x34, 0xD6, 0xD7, 0xD8, 0x0E, 0x0F,
	0x01, 0x40, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x44, 0x44, 0x44, 0xD6, 0x0D, 0x0E, 0x0F, 0xA1,
	0x01, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x54, 0x54, 0x54, 0x63, 0x64, 0x0B, 0x0D, 0x0E, 0xA1,
	0x01, 0x60, 0x61, 0x61, 0x62, 0x62, 0x63, 0x64, 0x64, 0x64, 0x64, 0x0C, 0x0D, 0x0E, 0x0F, 0xA1,
	0x60, 0x70, 0x71, 0x71, 0x72, 0x72, 0x73, 0x73, 0x74, 0x74, 0xE6, 0xE7, 0xE7, 0x0E, 0x0F, 0xA1,
	0x70, 0xE0, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x84, 0xE4, 0xE5, 0xE5, 0xE6, 0xE6, 0x0E, 0x0F,
	0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0x94, 0xE4, 0xE5, 0xE6, 0x0D, 0x0E, 0xA1,
	0x08, 0x09, 0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0E, 0x0F, 0xA1, 0xA1, 0xA2, 0xA3,
	0xD0, 0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD2, 0xD2, 0x34, 0x33, 0xB8, 0xB7, 0x23, 0x14, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC4, 0xC4, 0xC4, 0xC4, 0x0B, 0x0C, 0x0E, 0x0F,
	0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD4, 0xD4, 0xD4, 0xB8, 0x0C, 0x0D, 0x0E, 0x0F,
	0x02, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE4, 0xE4, 0xE4, 0xE5, 0x0C, 0x0D, 0x0E, 0x0F,
	0x02, 0xA3, 0x11, 0x15, 0x50, 0x55, 0x02, 0x08, 0xA3, 0x08, 0x94, 0xE6, 0xA1, 0xE6, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x07, 0x07, 0x08, 0x08,
	0x01, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x14, 0x14, 0xB6, 0xB7, 0xB8, 0xB8, 0x0C, 0x0E,
	0x10, 0xD0, 0x20, 0x21, 0x21, 0xB2, 0xB3, 0xB4, 0x23, 0xB7, 0xB8, 0xB8, 0xD6, 0xD6, 0x0D, 0x0E,
	0x40, 0x41, 0x30, 0x31, 0x31, 0x32, 0x32, 0x32, 0x33, 0x33, 0x34, 0xD6, 0xD6, 0x0D, 0x0E, 0x0F,
	0x01, 0x40, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x44, 0x44, 0x44, 0xD6, 0x0D, 0x0E, 0x0F, 0xA1,
	0x01, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x54, 0x63, 0x09, 0x0B, 0x0C, 0x0E, 0x0F,
	0x01, 0x60, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x64, 0x64, 0x64, 0x0B, 0x0C, 0x0D, 0x0F, 0xA1,
	0x60, 0x70, 0x61, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0x74, 0xE6, 0xE6, 0xE7, 0x0E, 0x0F, 0xA1,
	0x70, 0xE0, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0xE4, 0xE5, 0xE5, 0xE6, 0xE6, 0x0D, 0x0E,
	0x01, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x93, 0x94, 0xE4, 0xE5, 0xE6, 0x0C, 0x0E, 0x0F,
	0x08, 0x09, 0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0D, 0x0E, 0x0F, 0x0F, 0xA1, 0xA1, 0xA2,
	0xD0, 0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD2, 0x34, 0x33, 0xB7, 0xB7, 0x23, 0x23, 0x14,
	0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC4, 0xC4, 0xC4, 0x0B, 0x0C, 0x0D, 0x0E,
	0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD4, 0xD4, 0xB8, 0x0B, 0x0C, 0x0D, 0x0E,
	0x02, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0xE5, 0x0B, 0x0C, 0x0D, 0x0E,
	0x02, 0xA2, 0x11, 0x15, 0x50, 0x55, 0x02, 0x08, 0xA2, 0x08, 0x94, 0xE6, 0xA1, 0xE6, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x01, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0x14, 0xB6, 0xB6, 0xB8, 0xB8, 0x0C, 0x0D,
	0x10, 0xD0, 0x20, 0xB0, 0x21, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB8, 0xD6, 0x0D, 0x0E,
	0x40, 0x41, 0x30, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x33, 0xD6, 0xD6, 0x0D, 0x0E, 0x0F,
	0x01, 0x40, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x43, 0x44, 0x44, 0xD6, 0x0C, 0x0D, 0x0E, 0x0F,
	0x01, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x54, 0x63, 0x63, 0x0A, 0x0C, 0x0D, 0x0F,
	0x01, 0x60, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x64, 0x64, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x01, 0x70, 0x61, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0x73, 0xE6, 0xE6, 0xE7, 0x0E, 0x0F, 0xA1,
	0x70, 0xE0, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0xE4, 0xE4, 0xE5, 0xE6, 0xE6, 0x0D, 0x0E,
	0x01, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0xE4, 0xE4, 0xE5, 0x0C, 0x0D, 0x0F,
	0x08, 0x08, 0x09, 0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0E, 0x0F, 0x0F, 0xA1, 0xA2,
	0xD0, 0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD2, 0x33, 0x33, 0xB7, 0xB6, 0x23, 0x22, 0x13,
	0x10, 0x10, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC4, 0xC4, 0xC4, 0x0B, 0x0C, 0x0D, 0x0E,
	0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD4, 0xD4, 0xB8, 0x0B, 0x0C, 0x0D, 0x0E,
	0x02, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0xE5, 0x0B, 0x0C, 0x0D, 0x0E,
	0x02, 0xA2, 0x11, 0x15, 0x50, 0x54, 0x02, 0x08, 0xA2, 0x08, 0x94, 0xE5, 0x0F, 0xE5, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x01, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0x14, 0xB6, 0xB6, 0xB8, 0xB8, 0x0C, 0x0D,
	0x10, 0xD0, 0x20, 0x20, 0x21, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB8, 0xD6, 0x0C, 0x0D,
	0x40, 0xD0, 0x30, 0x30, 0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0x33, 0xD6, 0xD6, 0x0C, 0x0D, 0x0E,
	0x01, 0x40, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x43, 0x43, 0x44, 0xB8, 0x0C, 0x0D, 0x0E, 0x0F,
	0x01, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x53, 0x63, 0x63, 0x0A, 0x0C, 0x0D, 0x0F,
	0x01, 0x60, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x64, 0x64, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	0x01, 0x70, 0x61, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0x73, 0xE5, 0xE6, 0xE6, 0x0D, 0x0E, 0x0F,
	0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0xE4, 0xE4, 0xE5, 0xE5, 0xE6, 0x0C, 0x0D,
	0x01, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x94, 0xE3, 0xE4, 0xE5, 0x0C, 0x0D, 0x0F,
	0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E, 0x0E, 0x0F, 0x0F, 0xA1,
	0xD0, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD2, 0x33, 0x33, 0xB7, 0xB6, 0xB5, 0x22, 0x13,
	0x10, 0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC4, 0xC4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD4, 0xD4, 0xD4, 0x0B, 0x0C, 0x0C, 0x0E,
	0x02, 0x70, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0xE4, 0x0B, 0x0C, 0x0C, 0x0E,
	0x02, 0xA1, 0x11, 0x15, 0x50, 0x54, 0x02, 0x08, 0xA1, 0x08, 0x94, 0xE5, 0x0F, 0xE5, 0x94, 0xC3,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0x13, 0xB4, 0xB6, 0xD4, 0xB8, 0x0B, 0x0C,
	0x40, 0xD0, 0x20, 0x20, 0x21, 0xB1, 0xB2, 0xB4, 0xB5, 0xB6, 0xD4, 0xB8, 0xB8, 0xB8, 0x0C, 0x0D,
	0x40, 0xD0, 0x30, 0x30, 0x31, 0x31, 0x32, 0x32, 0x32, 0x33, 0x33, 0xD6, 0xD6, 0x0C, 0x0D, 0x0E,
	0x01, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x43, 0x43, 0x43, 0x33, 0xB8, 0x0B, 0x0C, 0x0D, 0x0F,
	0x01, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x63, 0x63, 0x0A, 0x0B, 0x0D, 0x0E,
	0x01, 0x60, 0x70, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x63, 0x64, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x01, 0x70, 0x61, 0x71, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0xE5, 0xE6, 0xE6, 0x0D, 0x0E, 0x0F,
	0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0xE3, 0xE4, 0xE4, 0xE5, 0xE6, 0x0C, 0x0D,
	0x01, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x93, 0x93, 0xE3, 0xE4, 0xE5, 0x0B, 0x0C, 0x0E,
	0x07, 0x08, 0x08, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0E, 0x0E, 0x0F, 0xA1,
	0xD0, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD1, 0x33, 0x33, 0xB7, 0xB5, 0xB4, 0x22, 0x13,
	0x10, 0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC4, 0xC4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD3, 0xD3, 0xD4, 0xD4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0xA1, 0x11, 0x14, 0x50, 0x54, 0x02, 0x08, 0xA1, 0x08, 0x93, 0xE5, 0x0E, 0xE5, 0x93, 0xC2,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0xB4, 0xB6, 0xD4, 0xB8, 0x0B, 0x0C,
	0x10, 0xD0, 0x20, 0x20, 0x21, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xD4, 0xD4, 0xB8, 0xB8, 0x0C, 0x0D,
	0x40, 0xD0, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0x33, 0x33, 0xB8, 0xD6, 0x0C, 0x0C, 0x0D,
	0x01, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x43, 0x43, 0x43, 0x43, 0xB8, 0x0B, 0x0C, 0x0D, 0x0E,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x63, 0x63, 0x0A, 0x0B, 0x0C, 0x0E,
	0x01, 0x60, 0x70, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x63, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
	0x01, 0x70, 0x61, 0x71, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0xE5, 0xE5, 0xE6, 0x0C, 0x0D, 0x0E,
	0x70, 0x70, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0xE3, 0xE4, 0xE4, 0xE5, 0xE5, 0x0C, 0x0D,
	0x01, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x92, 0x93, 0xE3, 0xE4, 0xE5, 0x0B, 0x0C, 0x0E,
	0x07, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0E, 0x0E, 0x0F, 0x0F,
	0x10, 0xD0, 0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0x33, 0xD4, 0xB6, 0xB5, 0xB4, 0x22, 0x13,
	0x10, 0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC3, 0xC4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD4, 0xD4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0xE4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x02, 0x0F, 0x11, 0x14, 0x50, 0x54, 0x02, 0x07, 0x0F, 0x07, 0x93, 0xE5, 0x0E, 0xE5, 0x93, 0xC2,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x10, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0xB4, 0xD3, 0xD4, 0xD4, 0x0B, 0x0C,
	0x40, 0xD0, 0x20, 0x20, 0xB0, 0x21, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xD4, 0xD4, 0xB8, 0x0B, 0x0C,
	0x40, 0xD0, 0x41, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0x32, 0x33, 0xB8, 0xB8, 0x0B, 0x0C, 0x0D,
	0x01, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x43, 0x43, 0x43, 0x43, 0xD4, 0x0B, 0x0C, 0x0D, 0x0E,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x63, 0x63, 0x09, 0x0B, 0x0C, 0x0D,
	0x01, 0x60, 0x70, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x63, 0x0A, 0x0B, 0x0C, 0x0C, 0x0E,
	0x01, 0x70, 0x61, 0x71, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0x73, 0xE5, 0xE6, 0x0C, 0x0D, 0x0E,
	0x70, 0x70, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0xE3, 0xE4, 0xE4, 0xE4, 0xE5, 0x0B, 0x0C,
	0x01, 0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0x92, 0x92, 0x93, 0xE3, 0xE4, 0xE4, 0x0B, 0x0C, 0x0D,
	0x07, 0x07, 0x08, 0x08, 0x09, 0x0A, 0x0A, 0x0A, 0x0B, 0x0C, 0x0C, 0x0D, 0x0D, 0x0E, 0x0E, 0x0F,
	0x10, 0xD0, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0x33, 0x32, 0xB6, 0xB5, 0xB4, 0x22, 0x13,
	0x02, 0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC4, 0x09, 0x0A, 0x0B, 0x0C,
	0x02, 0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD3, 0xD4, 0x0A, 0x0B, 0x0B, 0x0C,
	0x02, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE3, 0xE4, 0x0A, 0x0B, 0x0B, 0x0C,
	0x02, 0x0F, 0x11, 0x14, 0x50, 0x54, 0x02, 0x07, 0x0F, 0x07, 0x93, 0xE4, 0x0E, 0xE4, 0x93, 0xC2,
	0x00, 0x00, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x10, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0xB4, 0xD3, 0xD4, 0xD4, 0x0A, 0x0B,
	0x40, 0xD0, 0xD0, 0x20, 0x20, 0x21, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xD4, 0xD4, 0xB8, 0x0B, 0x0C,
	0x40, 0xD0, 0x41, 0x30, 0x30, 0x31, 0x31, 0x32, 0x32, 0x32, 0xD4, 0xB8, 0xB8, 0x0B, 0x0C, 0x0C,
	0x01, 0x40, 0x40, 0x41, 0x30, 0x42, 0x42, 0x43, 0x43, 0x43, 0x43, 0xD4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x63, 0x63, 0x09, 0x0A, 0x0C, 0x0D,
	0x01, 0x60, 0x70, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x63, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
	0x01, 0x70, 0xE0, 0x71, 0x71, 0x72, 0x72, 0x73, 0x73, 0x73, 0xE4, 0xE5, 0xE5, 0x0C, 0x0C, 0x0D,
	0x70, 0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0xE3, 0xE3, 0xE4, 0xE4, 0xE5, 0x0B, 0x0C,
	0x01, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x92, 0xE3, 0xE3, 0xE4, 0x0A, 0x0B, 0x0D,
	0x07, 0x07, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0D, 0x0E, 0x0E,
	0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0x20, 0xD1, 0xD1, 0xD1, 0x32, 0x32, 0xB5, 0xB4, 0xB4, 0xB2, 0x13,
	0x02, 0x10, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC3, 0xC3, 0xC3, 0x09, 0x0A, 0x0B, 0x0C,
	0x02, 0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD3, 0xD4, 0x09, 0x0A, 0x0B, 0x0C,
	0x02, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0x09, 0x0A, 0x0B, 0x0C,
	0x02, 0x0E, 0x10, 0x14, 0x50, 0x54, 0x02, 0x07, 0x0E, 0x07, 0x92, 0xE4, 0x0D, 0xE4, 0x92, 0xC2,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x10, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x12, 0x13, 0xB2, 0xD3, 0xD3, 0xD4, 0x0A, 0x0B,
	0x40, 0xD0, 0xD0, 0x20, 0x20, 0x21, 0xB1, 0xB2, 0xB3, 0xB4, 0xD3, 0xD4, 0xD4, 0xD4, 0x0B, 0x0B,
	0x40, 0xD0, 0x41, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0xD4, 0xD4, 0xB8, 0x0B, 0x0B, 0x0C,
	0x01, 0x40, 0x40, 0x41, 0x41, 0x42, 0x42, 0x42, 0x43, 0x43, 0x43, 0xD4, 0x0A, 0x0B, 0x0C, 0x0D,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x52, 0x52, 0x53, 0x53, 0x53, 0x62, 0x63, 0x09, 0x0A, 0x0B, 0x0C,
	0x01, 0x60, 0x70, 0x61, 0x61, 0x62, 0x62, 0x63, 0x63, 0x63, 0x63, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
	0x01, 0x70, 0xE0, 0x71, 0x71, 0x72, 0x72, 0x72, 0x73, 0x73, 0xE4, 0xE4, 0xE5, 0x0B, 0x0C, 0x0D,
	0x70, 0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0xE3, 0xE3, 0xE4, 0xE4, 0xE4, 0x0B, 0x0B,
	0x01, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x92, 0xE3, 0xE3, 0xE4, 0x0A, 0x0B, 0x0C,
	0x07, 0x07, 0x07, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0D, 0x0E,
	0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0x20, 0xD1, 0xD1, 0xD1, 0x32, 0x32, 0xB5, 0xB4, 0xB3, 0xB2, 0x12,
	0x02, 0x10, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC2, 0xC3, 0x08, 0x09, 0x0A, 0x0B, 0x0B,
	0x02, 0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x02, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE3, 0xE3, 0xE4, 0x09, 0x0A, 0x0B, 0x0C,
	0x02, 0x0E, 0x10, 0x14, 0x50, 0x54, 0x02, 0x07, 0x0E, 0x07, 0x92, 0xE4, 0x0D, 0xE4, 0x92, 0xC2,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06, 0x06,
	0x01, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0x12, 0xB2, 0xB2, 0xD3, 0xD3, 0xD4, 0x0A, 0x0B,
	0x40, 0x10, 0xD0, 0x20, 0x20, 0x21, 0x21, 0xB2, 0xB3, 0xB4, 0xD3, 0xD3, 0xD4, 0xD4, 0x0A, 0x0B,
	0x40, 0xD0, 0x41, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0x32, 0xD4, 0xD4, 0x0A, 0x0B, 0x0C,
	0x01, 0x40, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x43, 0x43, 0xD4, 0x0A, 0x0B, 0x0B, 0x0C,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x53, 0x62, 0x07, 0x08, 0x0A, 0x0B, 0x0C,
	0x01, 0x60, 0x60, 0x61, 0x61, 0x62, 0x62, 0x62, 0x63, 0x63, 0x63, 0x09, 0x0A, 0x0A, 0x0B, 0x0C,
	0x01, 0x70, 0x70, 0x71, 0x71, 0x72, 0x72, 0x72, 0x72, 0x73, 0xE4, 0xE4, 0xE5, 0x0B, 0x0C, 0x0C,
	0x70, 0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0xE3, 0xE3, 0xE4, 0xE4, 0xE4, 0x0A, 0x0B,
	0x01, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0x92, 0x92, 0xE2, 0xE3, 0xE4, 0x0A, 0x0B, 0x0C,
	0x06, 0x07, 0x07, 0x08, 0x08, 0x09, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D, 0x0D,
	0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0x32, 0x32, 0xB5, 0xB4, 0xB3, 0xB2, 0x12,
	0x02, 0x10, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC2, 0xC2, 0x08, 0x08, 0x09, 0x0A, 0x0B,
	0x01, 0x02, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0xD3, 0xD3, 0xD3, 0x09, 0x0A, 0x0A, 0x0B,
	0x01, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0xE3, 0xE3, 0xE3, 0x09, 0x0A, 0x0A, 0x0B,
	0x02, 0x0D, 0x10, 0x13, 0x50, 0x53, 0x02, 0x06, 0x0D, 0x06, 0x92, 0xE4, 0x0C, 0xE4, 0x92, 0xC2,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0x12, 0x12, 0xB2, 0xD3, 0xD3, 0xD3, 0x09, 0x0A,
	0x40, 0x10, 0xD0, 0x20, 0x20, 0x21, 0x21, 0xB2, 0xB3, 0xB4, 0xD3, 0xD3, 0xD4, 0xD4, 0x0A, 0x0B,
	0x40, 0x40, 0x41, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0x32, 0xD4, 0xD4, 0x0A, 0x0A, 0x0B,
	0x01, 0x40, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x43, 0x32, 0xD4, 0x09, 0x0A, 0x0B, 0x0C,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x62, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x01, 0x60, 0x60, 0x61, 0x61, 0x61, 0x62, 0x62, 0x62, 0x63, 0x63, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x01, 0x70, 0x70, 0x61, 0x71, 0x71, 0x72, 0x72, 0x72, 0x72, 0xE4, 0xE4, 0xE4, 0x0A, 0x0B, 0x0C,
	0x70, 0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0xE3, 0xE3, 0xE3, 0xE4, 0xE4, 0x0A, 0x0B,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0x92, 0x92, 0xE2, 0xE3, 0xE4, 0x09, 0x0A, 0x0B,
	0x06, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0A, 0x0B, 0x0B, 0x0C, 0x0C, 0x0D,
	0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0x32, 0x32, 0xD3, 0xB4, 0xB2, 0xB2, 0x12,
	0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC2, 0xC2, 0xC2, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x01, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD2, 0xD3, 0xD3, 0x08, 0x09, 0x0A, 0x0B,
	0x01, 0x02, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE3, 0xE3, 0x08, 0x09, 0x0A, 0x0B,
	0x02, 0x0D, 0x10, 0x13, 0x50, 0x53, 0x02, 0x06, 0x0D, 0x06, 0x92, 0xE4, 0x0C, 0xE4, 0x92, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x12, 0x12, 0x12, 0xB2, 0xD2, 0xD3, 0xD3, 0x09, 0x0A,
	0x40, 0x10, 0xD0, 0x20, 0x20, 0x20, 0x21, 0xB1, 0xB2, 0xD2, 0xD3, 0xD3, 0xD3, 0xD4, 0x09, 0x0A,
	0x40, 0x40, 0xD0, 0x30, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0xD4, 0xD4, 0x09, 0x0A, 0x0B,
	0x01, 0x40, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x42, 0x32, 0xD4, 0x09, 0x0A, 0x0B, 0x0B,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x62, 0x07, 0x08, 0x09, 0x0A, 0x0B,
	0x01, 0x60, 0x60, 0x61, 0x61, 0x61, 0x62, 0x62, 0x62, 0x62, 0x72, 0x08, 0x09, 0x0A, 0x0A, 0x0B,
	0x01, 0x70, 0x70, 0x61, 0x71, 0x71, 0x72, 0x72, 0x72, 0x72, 0xE4, 0xE4, 0xE4, 0x0A, 0x0B, 0x0C,
	0x70, 0x70, 0xE0, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0xE2, 0xE3, 0xE3, 0xE3, 0xE4, 0x09, 0x0A,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0xE2, 0xE3, 0xE3, 0x09, 0x0A, 0x0B,
	0x06, 0x06, 0x07, 0x07, 0x08, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0B, 0x0C, 0x0C,
	0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0x32, 0xD3, 0xD3, 0xB3, 0xB2, 0xB2, 0x12,
	0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC2, 0x07, 0x08, 0x09, 0x09, 0x0A,
	0x01, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD2, 0xD3, 0xD3, 0x08, 0x09, 0x09, 0x0A,
	0x01, 0x02, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE2, 0xE3, 0x08, 0x09, 0x09, 0x0A,
	0x02, 0x0C, 0x10, 0x13, 0x50, 0x53, 0x02, 0x06, 0x0C, 0x06, 0x92, 0xE3, 0x0B, 0xE3, 0x92, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06,
	0x01, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0x12, 0xB2, 0xD2, 0xD3, 0xD3, 0x08, 0x09,
	0x01, 0x10, 0xD0, 0x20, 0x20, 0x20, 0x21, 0x21, 0xB2, 0xD2, 0xD3, 0xD3, 0xD3, 0xD3, 0x09, 0x0A,
	0x40, 0x40, 0xD0, 0x41, 0x30, 0x30, 0x31, 0x31, 0x31, 0x32, 0x32, 0xD4, 0xD4, 0x09, 0x0A, 0x0A,
	0x01, 0x40, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x42, 0x42, 0xD3, 0x09, 0x09, 0x0A, 0x0B,
	0x01, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x62, 0x62, 0x07, 0x09, 0x0A, 0x0B,
	0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x62, 0x62, 0x62, 0x62, 0x72, 0x08, 0x09, 0x09, 0x0A, 0x0B,
	0x01, 0x60, 0x70, 0x61, 0x71, 0x71, 0x72, 0x72, 0x72, 0x72, 0xE3, 0xE4, 0xE4, 0x0A, 0x0A, 0x0B,
	0x01, 0x70, 0xE0, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0xE2, 0xE3, 0xE3, 0xE3, 0xE4, 0x09, 0x0A,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0x92, 0xE2, 0xE2, 0xE3, 0x08, 0x09, 0x0B,
	0x06, 0x06, 0x06, 0x07, 0x07, 0x08, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0B, 0x0B, 0x0B, 0x0C,
	0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0x32, 0xD3, 0xD3, 0xD2, 0xB2, 0xB0, 0x12,
	0x01, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC2, 0xC2, 0x07, 0x08, 0x08, 0x09, 0x0A,
	0x01, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0xD2, 0xD3, 0x08, 0x08, 0x09, 0x0A,
	0x01, 0x02, 0x70, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE3, 0x08, 0x08, 0x09, 0x0A,
	0x02, 0x0C, 0x10, 0x13, 0x50, 0x53, 0x02, 0x06, 0x0C, 0x06, 0x92, 0xE3, 0x0B, 0xE3, 0x92, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x01, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0x12, 0xB2, 0xD2, 0xD2, 0xD3, 0x08, 0x09,
	0x01, 0x40, 0xD0, 0xD0, 0x20, 0x20, 0x21, 0x21, 0xB2, 0xD2, 0xD2, 0xD3, 0xD3, 0xD3, 0x09, 0x09,
	0x40, 0x40, 0xD0, 0x41, 0x30, 0x30, 0x30, 0x31, 0x31, 0x31, 0xD3, 0xD3, 0xD4, 0x09, 0x09, 0x0A,
	0x01, 0x40, 0x40, 0x41, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x42, 0xD3, 0x08, 0x09, 0x0A, 0x0A,
	0x01, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x62, 0x62, 0x07, 0x08, 0x09, 0x0A,
	0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x62, 0x62, 0x62, 0x62, 0x62, 0x07, 0x08, 0x09, 0x0A, 0x0A,
	0x01, 0x60, 0x70, 0x61, 0x71, 0x71, 0x71, 0x72, 0x72, 0x72, 0xE3, 0xE3, 0xE4, 0x09, 0x0A, 0x0B,
	0x01, 0x70, 0x70, 0xE0, 0x80, 0x80, 0x81, 0x81, 0x81, 0xE2, 0xE2, 0xE3, 0xE3, 0xE3, 0x09, 0x09,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x81, 0xE2, 0xE2, 0xE3, 0x08, 0x09, 0x0A,
	0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09, 0x09, 0x09, 0x0A, 0x0A, 0x0A, 0x0B, 0x0B,
	0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x31, 0x31, 0xD2, 0xD2, 0xB2, 0xB0, 0x12,
	0x01, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC1, 0xC2, 0x07, 0x07, 0x08, 0x09, 0x09,
	0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD2, 0xD2, 0xD2, 0x07, 0x07, 0x08, 0x09, 0x09,
	0x01, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE2, 0x07, 0x08, 0x09, 0x09,
	0x02, 0x0B, 0x10, 0x13, 0x50, 0x53, 0x02, 0x06, 0x0B, 0x06, 0x81, 0xE3, 0x0A, 0xE3, 0x81, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x01, 0x01, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x12, 0xB0, 0xB0, 0xD2, 0xD2, 0xD3, 0x08, 0x09,
	0x01, 0x40, 0xD0, 0xD0, 0x20, 0x20, 0x20, 0x21, 0xB1, 0xD2, 0xD2, 0xD2, 0xD3, 0xD3, 0x08, 0x09,
	0x40, 0x40, 0xD0, 0x41, 0x30, 0x30, 0x30, 0x31, 0x31, 0x31, 0x31, 0xD3, 0xD3, 0x08, 0x09, 0x09,
	0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x42, 0xD3, 0x08, 0x09, 0x09, 0x0A,
	0x01, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x62, 0x62, 0x07, 0x08, 0x09, 0x0A,
	0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x62, 0x62, 0x62, 0x62, 0x07, 0x08, 0x08, 0x09, 0x0A,
	0x01, 0x60, 0x70, 0xE0, 0x71, 0x71, 0x71, 0x72, 0x72, 0x72, 0xE3, 0xE3, 0xE4, 0x09, 0x09, 0x0A,
	0x01, 0x70, 0x70, 0xE0, 0x80, 0x80, 0x80, 0x81, 0x81, 0xE2, 0xE2, 0xE2, 0xE3, 0xE3, 0x08, 0x09,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0xE2, 0xE2, 0xE3, 0x08, 0x09, 0x0A,
	0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0A, 0x0B,
	0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x31, 0x31, 0xD2, 0xD2, 0xB1, 0xB0, 0x12,
	0x01, 0x02, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC2, 0x06, 0x07, 0x08, 0x08, 0x09,
	0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0x06, 0x07, 0x08, 0x08, 0x09,
	0x01, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0x07, 0x08, 0x08, 0x09,
	0x02, 0x0B, 0x10, 0x12, 0x50, 0x53, 0x02, 0x05, 0x0B, 0x05, 0x91, 0xE3, 0x0A, 0xE3, 0x91, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0xB0, 0xB0, 0xD2, 0xD2, 0xD3, 0x07, 0x08,
	0x01, 0x40, 0x10, 0xD0, 0x20, 0x20, 0x20, 0x21, 0x21, 0xD2, 0xD2, 0xD2, 0xD3, 0xD3, 0x08, 0x09,
	0x40, 0x40, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x31, 0x31, 0x31, 0xD3, 0xD3, 0x08, 0x08, 0x09,
	0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x30, 0x42, 0x42, 0x42, 0x42, 0xD3, 0x08, 0x08, 0x09, 0x0A,
	0x00, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x62, 0x62, 0x07, 0x08, 0x08, 0x09,
	0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x62, 0x62, 0x62, 0x62, 0x07, 0x07, 0x08, 0x09, 0x0A,
	0x01, 0x60, 0x70, 0xE0, 0x61, 0x71, 0x71, 0x72, 0x72, 0x72, 0xE3, 0xE3, 0xE3, 0x08, 0x09, 0x0A,
	0x01, 0x70, 0x70, 0xE0, 0x80, 0x80, 0x80, 0x81, 0x81, 0xE2, 0xE2, 0xE2, 0xE3, 0xE3, 0x08, 0x09,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0x91, 0xE2, 0xE2, 0xE2, 0x07, 0x08, 0x09,
	0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08, 0x09, 0x09, 0x0A, 0x0A, 0x0A,
	0x40, 0x40, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x31, 0x31, 0xD2, 0xD2, 0xB0, 0xB0, 0x11,
	0x01, 0x02, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC1, 0x06, 0x07, 0x07, 0x08, 0x09,
	0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0x06, 0x07, 0x07, 0x08, 0x09,
	0x01, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0x07, 0x07, 0x08, 0x09,
	0x02, 0x0A, 0x10, 0x12, 0x50, 0x52, 0x02, 0x05, 0x0A, 0x05, 0x91, 0xE2, 0x0A, 0xE2, 0x91, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11, 0xD1, 0xD2, 0xD2, 0xD2, 0x07, 0x08,
	0x01, 0x40, 0x10, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0x21, 0xD2, 0xD2, 0xD2, 0xD2, 0x07, 0x08, 0x08,
	0x40, 0x40, 0xD0, 0xD0, 0x41, 0x30, 0x30, 0x30, 0x31, 0x31, 0x31, 0xD3, 0xD3, 0x08, 0x08, 0x09,
	0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x30, 0x30, 0x42, 0x42, 0xD3, 0x07, 0x08, 0x08, 0x09,
	0x00, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x62, 0x06, 0x07, 0x08, 0x09,
	0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x62, 0x62, 0x62, 0x62, 0x06, 0x07, 0x08, 0x08, 0x09,
	0x01, 0x60, 0x70, 0x70, 0x61, 0x71, 0x71, 0x71, 0x72, 0x72, 0x72, 0xE3, 0xE3, 0x08, 0x09, 0x09,
	0x01, 0x70, 0x70, 0xE0, 0xE0, 0x80, 0x80, 0xE1, 0x81, 0xE1, 0xE2, 0xE2, 0xE2, 0x07, 0x08, 0x08,
	0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0xE1, 0xE2, 0xE2, 0x07, 0x08, 0x09,
	0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x0A,
	0x02, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x31, 0x31, 0xD2, 0x21, 0xB0, 0xB0, 0x11,
	0x01, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0x06, 0x06, 0x07, 0x08, 0x08,
	0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD2, 0x06, 0x06, 0x07, 0x08, 0x08,
	0x01, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0x06, 0x07, 0x08, 0x08,
	0x02, 0x0A, 0x10, 0x12, 0x50, 0x52, 0x02, 0x05, 0x0A, 0x05, 0x91, 0xE2, 0x09, 0xE2, 0x91, 0xC1,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11, 0xD1, 0xD1, 0xD2, 0xD2, 0x07, 0x07,
	0x01, 0x40, 0x10, 0xD0, 0xD0, 0x20, 0x20, 0x20, 0x21, 0xD1, 0xD2, 0xD2, 0xD2, 0x07, 0x07, 0x08,
	0x40, 0x40, 0x40, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x31, 0x31, 0xD2, 0xD3, 0x07, 0x08, 0x08,
	0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x30, 0x30, 0x30, 0x42, 0xD2, 0x07, 0x07, 0x08, 0x09,
	0x00, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x61, 0x05, 0x06, 0x07, 0x08, 0x08,
	0x01, 0x60, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x71, 0x62, 0x62, 0x06, 0x07, 0x07, 0x08, 0x09,
	0x01, 0x60, 0x70, 0x70, 0x61, 0x71, 0x71, 0x71, 0x71, 0xE2, 0xE2, 0xE3, 0xE3, 0x08, 0x08, 0x09,
	0x01, 0x70, 0x70, 0x70, 0xE0, 0x80, 0x80, 0x80, 0x81, 0xE1, 0xE2, 0xE2, 0xE2, 0xE2, 0x07, 0x08,
	0x01, 0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x91, 0xE1, 0xE2, 0xE2, 0x07, 0x07, 0x08,
	0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09,
	0x01, 0x40, 0x40, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x31, 0xD2, 0xD2, 0xD1, 0xB0, 0x20, 0x11,
	0x01, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD1, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x01, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0x06, 0x07, 0x07, 0x08,
	0x02, 0x09, 0x10, 0x12, 0x50, 0x52, 0x02, 0x05, 0x09, 0x05, 0x91, 0xE2, 0x09, 0xE2, 0x91, 0xC0,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0xD1, 0xD1, 0xD1, 0xD2, 0x06, 0x07,
	0x01, 0x01, 0x40, 0xD0, 0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD2, 0xD2, 0x06, 0x07, 0x07,
	0x40, 0x40, 0x40, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x31, 0x31, 0xD2, 0xD2, 0x07, 0x07, 0x08,
	0x01, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x30, 0x30, 0x30, 0x30, 0xD2, 0x07, 0x07, 0x08, 0x08,
	0x00, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x61, 0x05, 0x06, 0x06, 0x07, 0x08,
	0x01, 0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x61, 0x71, 0x71, 0x06, 0x06, 0x07, 0x08, 0x08,
	0x01, 0x60, 0x70, 0x70, 0x61, 0x71, 0x71, 0x71, 0x71, 0x71, 0xE2, 0xE2, 0x07, 0x07, 0x08, 0x08,
	0x01, 0x01, 0x70, 0x70, 0xE0, 0x80, 0x80, 0x80, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0xE2, 0x07, 0x07,
	0x01, 0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x80, 0xE1, 0xE1, 0xE2, 0x06, 0x07, 0x08,
	0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08, 0x08, 0x09,
	0x01, 0x01, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0x31, 0x30, 0xD1, 0xD1, 0x20, 0x20, 0x11,
	0x01, 0x01, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC1, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0xD1, 0x05, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x01, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0x05, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x09, 0x10, 0x12, 0x50, 0x52, 0x01, 0x04, 0x09, 0x04, 0x91, 0xE2, 0x08, 0xE2, 0x91, 0xC0,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0xD1, 0xD1, 0xD1, 0xD2, 0x06, 0x07,
	0x01, 0x01, 0x40, 0xD0, 0xD0, 0xD0, 0x20, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD2, 0x06, 0x06, 0x07,
	0x40, 0x40, 0x40, 0xD0, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x30, 0xD2, 0xD2, 0x06, 0x07, 0x07,
	0x01, 0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x30, 0x30, 0x30, 0xD2, 0x06, 0x07, 0x07, 0x08,
	0x00, 0x01, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x05, 0x06, 0x07, 0x08,
	0x01, 0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0x71, 0x06, 0x06, 0x07, 0x07, 0x08,
	0x01, 0x60, 0x70, 0x70, 0xE0, 0x61, 0x71, 0x71, 0x71, 0x71, 0xE2, 0xE2, 0xE2, 0x07, 0x07, 0x08,
	0x01, 0x01, 0x70, 0x70, 0xE0, 0xE0, 0x80, 0x80, 0x80, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0x06, 0x07,
	0x01, 0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x80, 0xE1, 0xE1, 0xE2, 0x06, 0x07, 0x08,
	0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08,
	0x01, 0x01, 0x02, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0x30, 0x30, 0xD1, 0xD1, 0x20, 0x20, 0x11,
	0x01, 0x01, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0x05, 0x06, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0x05, 0x06, 0x06, 0x06, 0x07,
	0x01, 0x08, 0x10, 0x11, 0x50, 0x52, 0x01, 0x04, 0x08, 0x04, 0x80, 0xE2, 0x08, 0xE2, 0x80, 0xC0,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0xD1, 0xD1, 0xD1, 0xD1, 0x06, 0x06,
	0x01, 0x01, 0x40, 0x10, 0xD0, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD1, 0x06, 0x06, 0x07,
	0x01, 0x40, 0x40, 0x40, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x30, 0xD2, 0xD2, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x30, 0x30, 0x05, 0x06, 0x06, 0x07, 0x07,
	0x00, 0x01, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0x71, 0x05, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x01, 0x60, 0x70, 0x70, 0x61, 0x71, 0x71, 0x71, 0x71, 0x71, 0xE2, 0xE2, 0x06, 0x07, 0x07,
	0x01, 0x01, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0x80, 0x80, 0xE1, 0xE1, 0xE1, 0xE2, 0xE2, 0x06, 0x07,
	0x01, 0x01, 0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0xE1, 0xE1, 0xE1, 0x06, 0x06, 0x07,
	0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x08,
	0x01, 0x01, 0x02, 0x40, 0x02, 0x40, 0xD0, 0xD0, 0xD0, 0x30, 0x30, 0xD1, 0xD1, 0x20, 0x20, 0x11,
	0x01, 0x01, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x08, 0x10, 0x11, 0x01, 0x52, 0x01, 0x04, 0x08, 0x04, 0x90, 0xE1, 0x07, 0xE1, 0x90, 0xC0,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x20, 0xD1, 0xD1, 0xD1, 0x05, 0x06,
	0x01, 0x01, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0xD1, 0x05, 0x06, 0x06,
	0x01, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x30, 0xD2, 0x06, 0x06, 0x06,
	0x01, 0x01, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x30, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x00, 0x01, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x05, 0x05, 0x06, 0x07,
	0x01, 0x01, 0x60, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0x05, 0x05, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x60, 0x70, 0x70, 0x61, 0x61, 0x71, 0x71, 0x71, 0x71, 0xE2, 0xE2, 0x06, 0x06, 0x07,
	0x01, 0x01, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0x80, 0x80, 0xE1, 0xE1, 0xE1, 0xE1, 0x05, 0x06, 0x06,
	0x01, 0x01, 0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0xE1, 0xE1, 0xE1, 0x05, 0x06, 0x07,
	0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07,
	0x01, 0x01, 0x01, 0x40, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0x30, 0x30, 0xD1, 0x20, 0x20, 0x20, 0x10,
	0x01, 0x01, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x04, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x01, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0x05, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x01, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE1, 0x05, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x07, 0x10, 0x11, 0x01, 0x51, 0x01, 0x04, 0x07, 0x04, 0x90, 0xE1, 0x07, 0xE1, 0x90, 0xC0,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD1, 0xD1, 0x05, 0x06,
	0x01, 0x01, 0x01, 0x40, 0x10, 0xD0, 0xD0, 0xD0, 0x20, 0x20, 0xD1, 0xD1, 0xD1, 0x05, 0x05, 0x06,
	0x01, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0x41, 0x41, 0x30, 0x30, 0x30, 0x05, 0x05, 0x06, 0x06,
	0x00, 0x01, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x05, 0x05, 0x05, 0x06, 0x06,
	0x00, 0x01, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x04, 0x04, 0x05, 0x06, 0x06,
	0x00, 0x01, 0x60, 0x60, 0x60, 0x70, 0x61, 0x61, 0x61, 0x61, 0x61, 0x05, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x01, 0x60, 0x70, 0x70, 0x70, 0x61, 0x71, 0x71, 0x71, 0x71, 0xE1, 0x05, 0x06, 0x06, 0x06,
	0x01, 0x01, 0x60, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0x80, 0x80, 0xE1, 0xE1, 0xE1, 0x05, 0x05, 0x06,
	0x01, 0x01, 0x01, 0x01, 0x70, 0x90, 0x90, 0x90, 0x90, 0x90, 0xE0, 0xE1, 0xE1, 0x05, 0x06, 0x06,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x40, 0x02, 0x02, 0xD0, 0x30, 0x30, 0xD1, 0x20, 0x20, 0x20, 0x10,
	0x01, 0x01, 0x01, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x04, 0x04, 0x05, 0x05, 0x06,
	0x01, 0x01, 0x01, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06,
	0x01, 0x01, 0x02, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06,
	0x01, 0x07, 0x10, 0x11, 0x01, 0x51, 0x01, 0x03, 0x07, 0x03, 0x90, 0xE1, 0x06, 0xE1, 0x90, 0xC0,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD1, 0xD1, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0xD1, 0xD1, 0x05, 0x05,
	0x01, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0x41, 0x41, 0x41, 0x30, 0xD1, 0xD1, 0x05, 0x05, 0x06,
	0x00, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x05, 0x05, 0x05, 0x06,
	0x00, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x04, 0x04, 0x05, 0x05, 0x06,
	0x00, 0x01, 0x60, 0x60, 0x60, 0x70, 0x70, 0x61, 0x61, 0x61, 0x61, 0x04, 0x05, 0x05, 0x05, 0x06,
	0x01, 0x01, 0x60, 0x70, 0x70, 0x70, 0x61, 0x61, 0x61, 0x71, 0x71, 0xE1, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x01, 0x01, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE1, 0xE1, 0xE1, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x90, 0x90, 0x90, 0x90, 0x90, 0xE0, 0xE0, 0xE1, 0x05, 0x05, 0x06,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x30, 0xD1, 0xD0, 0xD0, 0xD0, 0x10, 0x10,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x01, 0x06, 0x10, 0x11, 0x01, 0x51, 0x01, 0x03, 0x06, 0x03, 0x90, 0xE1, 0x06, 0xE1, 0x90, 0xC0,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD1, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0x41, 0x41, 0xD1, 0xD1, 0x05, 0x05, 0x05,
	0x00, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x00, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x03, 0x04, 0x04, 0x05, 0x05,
	0x00, 0x01, 0x01, 0x60, 0x60, 0x60, 0x70, 0x70, 0x61, 0x61, 0x61, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x00, 0x01, 0x60, 0x60, 0x70, 0x70, 0x70, 0x61, 0x61, 0x61, 0xE1, 0xE1, 0x05, 0x05, 0x05, 0x06,
	0x01, 0x01, 0x01, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE1, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x90, 0x90, 0x90, 0xE0, 0xE0, 0xE0, 0xE1, 0x04, 0x05, 0x05,
	0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x41, 0xD0, 0xD0, 0xD0, 0xD0, 0x10, 0x10,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0xC0, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x01, 0x06, 0x01, 0x11, 0x01, 0x51, 0x01, 0x03, 0x06, 0x03, 0x90, 0xE1, 0x05, 0xE1, 0x90, 0xC0,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x04, 0x05,
	0x00, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x00, 0x01, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40, 0x40, 0x03, 0x04, 0x04, 0x04, 0x05,
	0x00, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0xE0, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x00, 0x01, 0x60, 0x60, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x60, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x90, 0x90, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x05,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x10, 0x10,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x10, 0x10, 0xC0, 0xC0, 0xC0, 0x03, 0x04, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0x03, 0x04, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x70, 0xE0, 0xE0, 0xE0, 0x03, 0x04, 0x04, 0x04, 0x05,
	0x01, 0x05, 0x01, 0x10, 0x01, 0x51, 0x01, 0x03, 0x05, 0x03, 0xE0, 0xE0, 0x05, 0xE0, 0xE0, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD0, 0xD0, 0xD0, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04,
	0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x04,
	0x00, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0x04, 0x04, 0x04, 0x05,
	0x00, 0x00, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40, 0x40, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x00, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05,
	0x00, 0x01, 0x01, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x04, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x90, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x04,
	0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x10, 0x10,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x10, 0x10, 0x10, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0xD0, 0xD0, 0xD0, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x70, 0x70, 0xE0, 0xE0, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x01, 0x05, 0x01, 0x10, 0x01, 0x51, 0x01, 0x03, 0x05, 0x03, 0xE0, 0xE0, 0x05, 0xE0, 0xE0, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD0, 0xD0, 0x03, 0x03, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x03, 0x03, 0x04,
	0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x03, 0x04, 0x04,
	0x00, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xD0, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x00, 0x00, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x00, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x00, 0x01, 0x01, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0x04, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xE0, 0x03, 0x03, 0x04,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0xE0, 0xE0, 0xE0, 0x03, 0x04, 0x04,
	0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0xD0, 0xD0, 0xD0, 0xD0, 0x10, 0x10, 0x10,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x10, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x01, 0x04, 0x01, 0x10, 0x00, 0x50, 0x01, 0x02, 0x04, 0x02, 0xE0, 0xE0, 0x04, 0xE0, 0xE0, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x40, 0x40, 0x02, 0x02, 0xD0, 0xD0, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xD0, 0xD0, 0xD0, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x00, 0x00, 0x01, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40, 0x40, 0x03, 0x03, 0x03, 0x04,
	0x00, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x03, 0x03, 0x03, 0x03, 0x04,
	0x00, 0x01, 0x01, 0x01, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE0, 0x03, 0x03, 0x03, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04,
	0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x02, 0x10, 0x10,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x01, 0x04, 0x01, 0x10, 0x00, 0x50, 0x01, 0x02, 0x04, 0x02, 0x02, 0x03, 0x04, 0x03, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x02, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x70, 0x70, 0x70, 0x70, 0x70, 0x03, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x60, 0x70, 0x70, 0x70, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x01,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03,
	0x01, 0x03, 0x01, 0x10, 0x00, 0x50, 0x01, 0x02, 0x03, 0x02, 0x02, 0x02, 0x03, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x03,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x03, 0x03,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x50, 0x50, 0x50, 0x50, 0x50, 0x02, 0x02, 0x02, 0x02, 0x03,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x70, 0x02, 0x02, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x02, 0x02, 0x01, 0x01, 0x01,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03,
	0x01, 0x03, 0x01, 0x10, 0x00, 0x50, 0x01, 0x02, 0x03, 0x02, 0x01, 0x02, 0x03, 0x02, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x50, 0x50, 0x50, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x60, 0x01, 0x60, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x60, 0x60, 0x60, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x02, 0x00, 0x01, 0x00, 0x50, 0x00, 0x01, 0x02, 0x01, 0x01, 0x02, 0x02, 0x02, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x00, 0x02, 0x00, 0x01, 0x00, 0x50, 0x00, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x50, 0x50, 0x51, 0x51, 0xF4, 0x52, 0x52, 0x52, 0x53, 0x53, 0x53, 0x54, 0x54,
	0x01, 0x50, 0x50, 0x50, 0x51, 0x51, 0xF4, 0x52, 0x52, 0x53, 0x53, 0x54, 0x55, 0x56, 0x56, 0x57,
	0x50, 0x51, 0x51, 0xF4, 0x52, 0x52, 0x53, 0x53, 0x54, 0x55, 0x55, 0x56, 0x56, 0x57, 0x57, 0x57,
	0x51, 0xF4, 0x52, 0x53, 0x54, 0x54, 0x55, 0x55, 0x56, 0x57, 0x57, 0x57, 0x57, 0x57, 0xF5, 0xF5,
	0x50, 0x51, 0xF4, 0x52, 0x53, 0x54, 0x55, 0x55, 0x56, 0x56, 0x57, 0x57, 0x57, 0x57, 0xF5, 0xF5,
	0x01, 0x50, 0x51, 0xF4, 0x52, 0x53, 0x53, 0x54, 0x54, 0x55, 0x56, 0x56, 0x57, 0x57, 0x57, 0xF5,
	0x50, 0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x54, 0x55, 0x55, 0x56, 0x57, 0x57, 0x57, 0xF5, 0xF5,
	0x50, 0x50, 0xF4, 0x52, 0x53, 0x53, 0x54, 0x55, 0x55, 0x56, 0x56, 0x57, 0x57, 0x57, 0xF5, 0xF5,
	0x50, 0x50, 0x51, 0x51, 0xF4, 0x52, 0x52, 0x53, 0x53, 0x54, 0x54, 0x55, 0x56, 0x56, 0x57, 0x57,
	0x00, 0x01, 0x01, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0xF5,
	0x54, 0x54, 0x55, 0x55, 0x56, 0x56, 0x56, 0x57, 0x57, 0x57, 0x57, 0xF5, 0xF5, 0xF5, 0xF5, 0xF5,
	0x50, 0x51, 0x51, 0xF4, 0xF4, 0x52, 0x52, 0x52, 0x52, 0x57, 0x56, 0x55, 0x54, 0x54, 0x53, 0x52,
	0x50, 0x50, 0x50, 0x51, 0x51, 0xF4, 0x52, 0x52, 0x52, 0x53, 0x54, 0x55, 0x55, 0x56, 0x57, 0x57,
	0x50, 0x50, 0x51, 0xF4, 0x52, 0x52, 0x53, 0x54, 0x54, 0x55, 0x55, 0x56, 0x56, 0x57, 0x57, 0x57,
	0x50, 0x50, 0x51, 0xF4, 0x52, 0x52, 0x52, 0x53, 0x53, 0x54, 0x54, 0x55, 0x56, 0x56, 0x57, 0x57,
	0x50, 0xF5, 0x50, 0x52, 0x50, 0x55, 0x50, 0x54, 0xF5, 0x54, 0x52, 0x55, 0xF5, 0x55, 0x52, 0x52,
	0xAF, 0xAF, 0xAE, 0xAD, 0xAC, 0xAB, 0xAA, 0xAA, 0xA9, 0xA8, 0xA7, 0xA6, 0xA5, 0xA4, 0xA3, 0xA2,
	0xF1, 0xAE, 0xAD, 0xAC, 0xAB, 0xAB, 0xAA, 0xA9, 0xA8, 0xA6, 0xA4, 0xA2, 0x0F, 0x0D, 0x0A, 0x07,
	0xAD, 0xAB, 0xAA, 0xA9, 0xA8, 0xA7, 0xA5, 0xA4, 0xA3, 0xA1, 0x0E, 0x0D, 0x0B, 0x09, 0x07, 0x05,
	0xAB, 0xAA, 0xA8, 0xA6, 0xA4, 0xA2, 0xF7, 0x0E, 0x0C, 0x0A, 0x09, 0x08, 0x07, 0x05, 0xF0, 0x03,
	0xAE, 0xAB, 0xA9, 0xA7, 0xA5, 0xA3, 0xA1, 0x0D, 0x0C, 0x0B, 0x09, 0x08, 0x06, 0x05, 0x03, 0x02,
	0xAE, 0xAD, 0xAB, 0xAA, 0xA8, 0xA7, 0xA5, 0xA3, 0xA2, 0x0F, 0x0D, 0x0B, 0x09, 0x07, 0x05, 0x03,
	0xAE, 0xAC, 0xAA, 0xA9, 0xA7, 0xA5, 0xA3, 0xA1, 0x0F, 0x0D, 0x0C, 0x0A, 0x08, 0x06, 0xF0, 0x02,
	0xAE, 0xAC, 0xAA, 0xA8, 0xA6, 0xA4, 0xA2, 0x0F, 0x0E, 0x0D, 0x0B, 0x09, 0x07, 0x06, 0x04, 0x02,
	0xAD, 0xAD, 0xAB, 0xAB, 0xAA, 0xA9, 0xA8, 0xA6, 0xA5, 0xA4, 0xA2, 0x0F, 0x0D, 0x0B, 0x08, 0x06,
	0xF1, 0xF1, 0xAE, 0xAE, 0xAD, 0xAD, 0xAC, 0xAB, 0xAB, 0xA8, 0xA6, 0xA3, 0x0F, 0x0B, 0x08, 0x04,
	0xA2, 0xA1, 0xF7, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x08, 0x07, 0x06, 0x05, 0x04, 0x02, 0x01, 0x00,
	0xAC, 0xAB, 0xAB, 0xAA, 0xAA, 0xA9, 0xA8, 0xA8, 0xA7, 0x09, 0x0B, 0x0E, 0xA1, 0xA3, 0xA6, 0xA8,
	0xAE, 0xAD, 0xAC, 0xAB, 0xAA, 0xAA, 0xA9, 0xA8, 0xA7, 0xA5, 0xA3, 0xA1, 0x0E, 0x0C, 0x09, 0x07,
	0xAD, 0xAC, 0xAA, 0xA9, 0xA8, 0xA7, 0xA5, 0xA4, 0xA2, 0xA1, 0x0E, 0x0D, 0x0B, 0x09, 0x07, 0x05,
	0xAD, 0xAC, 0xAB, 0xAA, 0xA9, 0xA8, 0xA7, 0xA5, 0xA4, 0xA3, 0xA1, 0x0E, 0x0C, 0x0A, 0x08, 0x06,
	0xAC, 0x00, 0xAC, 0xA7, 0xAC, 0x0E, 0xAC, 0xA2, 0x00, 0xA2, 0xA8, 0x0F, 0x03, 0x0F, 0xA8, 0xA8,
}; // colormap
