#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 nie jest zainstalowany"},
    {TR_NO_PATCH_MESSAGE,
        "Twoja instalacja Cezara 3 nie ma zainstalowanej łatki 1.0.1.0."
        "Łatkę możesz pobrać z:\n."
        URL_PATCHES "\n"
        "Kontynuujesz na własne ryzyko."},
    {TR_MISSING_FONTS_TITLE, "Brakuje czcionek"},
    {TR_MISSING_FONTS_MESSAGE,
        "Twoja instalacja Cezara 3 wymaga dodatkowych czcionek."
        "Możesz je pobrać dla własnego języka z:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Edytor nie jest zainstalowany"},
    {TR_NO_EDITOR_MESSAGE,
        "Twoja instalacja Cezara 3 nie ma plików edytora"
        "Możesz je pobrać z:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Nieprawidłowy folder językowy"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Wybrany folder nie zawiera poprawnego pakietu językowego"
        "Proszę sprawdzić błędy w pliku log"},
    {TR_BUILD_ALL_TEMPLES, "Całość"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Anuluj"},
    {TR_BUTTON_RESET_DEFAULTS, "Ustaw domyślne"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Skróty klawiszowe"},
    {TR_CONFIG_TITLE, "Julius - konfiguracja"},
    {TR_CONFIG_LANGUAGE_LABEL, "Język:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(domyślny)"},
    {TR_CONFIG_DISPLAY_SCALE, "Skala wyświetlacza:"},
    {TR_CONFIG_CURSOR_SCALE, "Skala kursora:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Zmiany interfejsu użytkownika"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Zmiany gry"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Odgrywaj film wprowadzający"},
    {TR_CONFIG_SIDEBAR_INFO, "Dodatkowe informacje w panelu sterowania"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Płynne przewijanie"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Wyłącz przeciąganie mapy prawym przyciskiem"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Wyłącz przewijanie mapy na krawędzi okna"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Pokaż wybrany obszar przy oczyszczaniu terenu"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Pozwól na budowę kolejno każdej ze świątyń"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Pokaż zasięg przy budowie rezerwuarów, fontann i studni"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Pokaż rozmiar budowy przy przeciąganiu kursorem"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Podświetl legion przy najechaniu kursorem"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Włącz boczny panel wojskowy"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Napraw błąd z imigracją na najwyższym poziomie trudności"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Napraw 100-letnie duchy"},
    {TR_HOTKEY_TITLE, "Julius - konfiguracja skrótów klawiszowych"},
    {TR_HOTKEY_LABEL, "Skrót klawiszowy"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternatywny"},
    {TR_HOTKEY_HEADER_ARROWS, "Strzałki kierunkowe"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globalne skróty klawiszowe"},
    {TR_HOTKEY_HEADER_CITY, "Miejskie skróty klawiszowe"},
    {TR_HOTKEY_HEADER_ADVISORS, "Doradcy"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Widoki"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Miejskie miejsca skoku"},
    {TR_HOTKEY_HEADER_EDITOR, "Edytor"},
    {TR_HOTKEY_HEADER_BUILD, "Skróty klawiszowe budynków"},
    {TR_HOTKEY_ARROW_UP, "Góra"},
    {TR_HOTKEY_ARROW_DOWN, "Dół"},
    {TR_HOTKEY_ARROW_LEFT, "Lewo"},
    {TR_HOTKEY_ARROW_RIGHT, "Prawo"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Przełącz pełny ekran"},
    {TR_HOTKEY_CENTER_WINDOW, "Wycentruj okno"},
    {TR_HOTKEY_RESIZE_TO_640, "Zmień rozmiar okna do 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Zmień rozmiar okna do 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Zmień rozmiar okna do 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Zapisz zrzut ekranu"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Zapisz zrzut ekranu miasta"},
    {TR_HOTKEY_BUILD_CLONE, "Sklonuj budynek pod kursorem"},
    {TR_HOTKEY_LOAD_FILE, "Wczytaj plik"},
    {TR_HOTKEY_SAVE_FILE, "Zapisz plik"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Zwiększ prędkość gry"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Zmniejsz prędkość gry"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Pauza"},
    {TR_HOTKEY_CYCLE_LEGION, "Przełącz między legionami"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Obróć mapę w lewo"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Obróć mapę w prawo"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Doradca zatrudnienia"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Doradca legionów"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Doradca imperialny"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Doradca wyników"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Doradca handlowy"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Doradca populacji"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Doradca zdrowia"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Doradca edukacji"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Doradca rozrywki"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Doradca religijny"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Doradca finansowy"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Główny doradca"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Przełącz między widokami"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Pokaż widok wody"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Pokaż widok pożarów"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Pokaż widok zniszczenia"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Pokaż widok zbrodni"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Pokaż widok problemów"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Przejdź do punktu skoku 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Przejdź do punktu skoku 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Przejdź do punktu skoku 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Przejdź do punktu skoku 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Ustaw punkt skoku 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Ustaw punkt skoku 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Ustaw punkt skoku 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Ustaw punkt skoku 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Przełącz informacje o bitwach"},
    {TR_HOTKEY_EDIT_TITLE, "Wprowadź skrót"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Ta kombinacja klawiszowa już jest wyznaczona dla tej czynności:"},
    {TR_HOTKEY_DUPLICATE_TITLE, "Klawisz już użyty"},
    {TR_WARNING_SCREENSHOT_SAVED, "Zapisano zrzut ekranu: "}, // TODO: Google translate
};

void translation_polish(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
