extern "C"
{


#include <stdint.h>

// In C++, const implies static, so we need to specify extern
#ifdef __cplusplus
#define BUFFLINKAGE extern
#else
#define BUFFLINKAGE
#endif

/***********************************************************************
CGA 80-column font (80x25 chars for a 640x200 mode, 8x8 pixels for each)
Currently not used
***********************************************************************/
#if 0
BUFFLINKAGE const uint8_t g_cga_8x8TextFont[256*8*8] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,1,1,0,
1,0,0,0,0,0,0,1,
1,0,1,0,0,1,0,1,
1,0,0,0,0,0,0,1,
1,0,1,1,1,1,0,1,
1,0,0,1,1,0,0,1,
1,0,0,0,0,0,0,1,
0,1,1,1,1,1,1,0,

0,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,0,

0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,

0,0,0,1,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,0,0,1,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,0,0,0,0,1,0,
0,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,0,0,1,1,0,0,1,
1,0,1,1,1,1,0,1,
1,0,1,1,1,1,0,1,
1,0,0,1,1,0,0,1,
1,1,0,0,0,0,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,1,1,1,1,
0,0,0,0,0,1,1,1,
0,0,0,0,1,1,1,1,
0,1,1,1,1,1,0,1,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,

0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,

0,0,1,1,1,1,1,1,
0,0,1,1,0,0,1,1,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,0,0,0,0,0,

0,1,1,1,1,1,1,1,
0,1,1,0,0,0,1,1,
0,1,1,1,1,1,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,0,
1,1,0,0,0,0,0,0,

1,0,0,1,1,0,0,1,
0,1,0,1,1,0,1,0,
0,0,1,1,1,1,0,0,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
0,0,1,1,1,1,0,0,
0,1,0,1,1,0,1,0,
1,0,0,1,1,0,0,1,

1,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,0,0,0,
1,1,1,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,1,0,
0,0,0,0,1,1,1,0,
0,0,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,1,1,1,1,1,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,

0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,0,0,0,0,0,

0,0,1,1,1,1,1,0,
0,1,1,0,0,0,1,1,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,1,1,1,1,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,

0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,0,0,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,1,
0,1,1,0,0,1,1,0,
0,0,1,0,0,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
1,1,1,1,1,1,1,1,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,1,1,0,1,1,0,
1,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,0,
0,1,1,0,0,0,1,0,
0,1,1,0,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,0,0,0,
0,1,1,0,0,0,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,0,
0,1,1,0,0,0,1,0,
0,1,1,0,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,1,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,

1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,1,1,0,
1,1,1,0,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,1,1,0,
1,1,1,0,0,1,1,0,
1,1,1,1,0,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
1,0,1,1,0,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,0,1,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,

1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,

1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,

1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
1,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,1,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,1,1,0,
1,1,0,0,0,0,1,1,
0,0,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,0,0,0,

0,1,1,1,1,1,1,0,
1,1,0,0,0,0,1,1,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,1,1,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,1,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,1,1,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,

0,0,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,

1,1,0,0,0,0,1,1,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,0,0,1,1,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,

1,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,0,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,1,1,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,1,

0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,0,1,1,0,0,
1,1,1,1,1,1,0,0,
1,1,0,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,0,0,0,0,1,1,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,1,1,0,
0,0,1,1,0,0,1,1,
0,1,1,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,0,1,1,1,1,

1,1,0,0,0,0,1,1,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,0,1,1,
0,0,1,1,0,1,1,1,
0,1,1,0,1,1,1,1,
1,1,0,0,1,1,1,1,
0,0,0,0,0,0,1,1,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,1,1,
0,1,1,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,0,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,0,0,1,1,
0,1,1,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,0,0,0,1,0,
1,0,0,0,1,0,0,0,
0,0,1,0,0,0,1,0,
1,0,0,0,1,0,0,0,
0,0,1,0,0,0,1,0,
1,0,0,0,1,0,0,0,
0,0,1,0,0,0,1,0,
1,0,0,0,1,0,0,0,

0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,

1,1,0,1,1,0,1,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,0,1,1,
1,1,1,0,1,1,1,0,
1,1,0,1,1,0,1,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,0,1,1,
1,1,1,0,1,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,

0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,0,1,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,0,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,1,1,1,1,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,1,0,0,

0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
};
#endif

/************************************************************************
EGA 80-column font (80x25 chars for a 640x350 mode, 8x14 pixels for each)
Currently not used
************************************************************************/
#if 0
BUFFLINKAGE const uint8_t g_ega_8x14TextFont[256*8*14] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,0,0,0,0,0,0,1,
1,0,1,0,0,1,0,1,
1,0,0,0,0,0,0,1,
1,0,0,0,0,0,0,1,
1,0,1,1,1,1,0,1,
1,0,0,1,1,0,0,1,
1,0,0,0,0,0,0,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,0,0,1,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,0,0,0,0,1,0,
0,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,0,0,1,1,0,0,1,
1,0,1,1,1,1,0,1,
1,0,1,1,1,1,0,1,
1,0,0,1,1,0,0,1,
1,1,0,0,0,0,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,0,
0,0,1,1,0,0,1,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,1,1,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,1,
0,1,1,0,0,0,1,1,
0,1,1,1,1,1,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,1,1,
0,0,1,1,1,1,0,0,
1,1,1,0,0,1,1,1,
0,0,1,1,1,1,0,0,
1,1,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,0,0,0,
1,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,1,0,
0,0,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,1,1,1,1,1,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,0,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,0,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,0,0,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
1,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
1,1,1,1,1,1,1,1,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,1,1,0,1,1,0,
1,1,1,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,1,0,
0,1,1,0,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,0,0,0,
0,1,1,0,0,0,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,1,0,
0,1,1,0,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,1,1,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,0,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,0,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,0,0,1,1,0,
1,1,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,1,1,1,1,1,1,0,
0,1,0,1,1,0,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,0,0,0,0,
0,0,0,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,0,0,1,1,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
1,1,0,0,0,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,0,0,1,1,0,
1,1,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,1,1,1,0,0,
1,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,1,1,1,0,
1,0,0,1,1,1,1,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,

0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,

1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,

0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,
0,0,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,0,0,1,1,
0,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
1,1,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
};
#endif

/******************************************************************************
VGA 80-column font (80x25 chars, 8x16 pixels for each; Later converted to 9x16)
See this for the conversion method, applying to
chars 192-223 in one way and to the rest differently:
http://support.microsoft.com/kb/59953
It is also briefly mentioned here:
http://vogons.zetafleet.com/viewtopic.php?p=156124
******************************************************************************/
BUFFLINKAGE const uint8_t g_vga_8x16TextFont[256*8*16] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,0,0,0,0,0,0,1,
1,0,1,0,0,1,0,1,
1,0,0,0,0,0,0,1,
1,0,0,0,0,0,0,1,
1,0,1,1,1,1,0,1,
1,0,0,1,1,0,0,1,
1,0,0,0,0,0,0,1,
1,0,0,0,0,0,0,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,0,0,1,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,0,0,0,0,1,0,
0,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,0,0,1,1,0,0,1,
1,0,1,1,1,1,0,1,
1,0,1,1,1,1,0,1,
1,0,0,1,1,0,0,1,
1,1,0,0,0,0,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,0,
0,0,1,1,0,0,1,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,1,1,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,1,
0,1,1,0,0,0,1,1,
0,1,1,1,1,1,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,0,1,1,
0,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,1,
1,1,1,0,0,1,1,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,1,1,
0,0,1,1,1,1,0,0,
1,1,1,0,0,1,1,1,
0,0,1,1,1,1,0,0,
1,1,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,1,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,1,1,0,
0,0,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,1,1,1,1,1,0,
0,0,0,1,1,1,1,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,0,0,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,1,
0,1,1,0,0,1,1,0,
0,0,1,0,0,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,0,0,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
1,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
1,1,1,1,1,1,1,1,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,1,0,
0,1,1,0,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,1,0,
0,1,1,0,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,0,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,0,0,1,1,0,
1,1,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,1,0,1,1,0,
1,1,0,1,1,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,0,0,1,1,0,0,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,1,1,1,1,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
1,1,0,0,0,0,1,1,
1,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,1,
1,1,0,0,0,0,1,1,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,1,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
1,1,1,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,1,1,1,1,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,1,1,1,0,
0,0,1,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,0,0,0,1,1,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,0,1,0,0,
0,1,1,0,0,0,0,0,
1,1,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,1,0,0,1,1,0,
1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,0,1,1,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,1,1,1,1,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
1,1,1,1,0,0,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,0,0,1,1,0,
1,1,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,1,1,1,1,0,
1,1,0,0,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,1,1,1,0,
1,0,0,1,1,0,1,1,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,1,1,0,
1,1,0,0,1,1,1,0,
1,0,0,1,0,1,1,0,
0,0,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,0,1,1,0,
0,1,1,0,1,1,0,0,
1,1,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,
0,0,0,1,0,0,0,1,
0,1,0,0,0,1,0,0,

0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,
0,1,0,1,0,1,0,1,
1,0,1,0,1,0,1,0,

1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,
1,1,0,1,1,1,0,1,
0,1,1,1,0,1,1,1,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,0,
0,0,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,0,0,0,
0,0,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,0,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,0,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
1,1,1,1,1,1,1,1,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,
0,0,1,1,0,1,1,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,

1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,
1,1,1,1,0,0,0,0,

0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,1,1,

1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,1,0,0,
0,1,1,1,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,1,1,0,0,
1,1,0,1,1,0,0,0,
1,1,0,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,1,1,1,1,0,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,1,1,1,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
1,1,1,0,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,1,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,1,1,1,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,1,1,0,0,1,1,0,
0,0,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,
0,0,0,0,0,1,1,0,
0,1,1,1,1,1,1,0,
1,1,0,1,1,0,1,1,
1,1,0,1,1,0,1,1,
1,1,1,1,0,0,1,1,
0,1,1,1,1,1,1,0,
0,1,1,0,0,0,0,0,
1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
1,1,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,1,1,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
0,0,1,1,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,0,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,1,1,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,

0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,0,1,1,0,
1,1,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,1,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,1,1,1,1,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
0,0,0,0,1,1,0,0,
1,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,1,1,1,1,0,0,
0,0,0,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
1,1,0,1,1,0,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,1,1,0,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,1,1,1,0,0,0,0,
1,1,0,1,1,0,0,0,
0,0,1,1,0,0,0,0,
0,1,1,0,0,0,0,0,
1,1,0,0,1,0,0,0,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,

0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
};

}
