/**
 * @file textdat.cpp
 *
 * Implementation of all dialog texts.
 */
#include "textdat.h"
#include "utils/language.h"

namespace devilution {

/* todo: move text out of struct */

/** Contains the data related to each speech ID. */
const Speech Speeches[] = {
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ " Ahh, the story of our King, is it? The tragic fall of Leoric was a harsh blow to this land. The people always loved the King, and now they live in mortal fear of him. The question that I keep asking myself is how he could have fallen so far from the Light, as Leoric had always been the holiest of men. Only the vilest powers of Hell could so utterly destroy a man from within..."),
	    true, TSFX_STORY1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "The village needs your help, good master! Some months ago King Leoric's son, Prince Albrecht, was kidnapped. The King went into a rage and scoured the village for his missing child. With each passing day, Leoric seemed to slip deeper into madness. He sought to blame innocent townsfolk for the boy's disappearance and had them brutally executed. Less than half of us survived his insanity...\n \nThe King's Knights and Priests tried to placate him, but he turned against them and sadly, they were forced to kill him. With his dying breath the King called down a terrible curse upon his former followers. He vowed that they would serve him in darkness forever...\n \nThis is where things take an even darker twist than I thought possible! Our former King has risen from his eternal sleep and now commands a legion of undead minions within the Labyrinth. His body was buried in a tomb three levels beneath the Cathedral. Please, good master, put his soul at ease by destroying his now cursed form..."),
	    true, TSFX_TAVERN21 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "As I told you, good master, the King was entombed three levels below. He's down there, waiting in the putrid darkness for his chance to destroy this land..."),
	    true, TSFX_TAVERN22 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden (Quest End) */ "The curse of our King has passed, but I fear that it was only part of a greater evil at work. However, we may yet be saved from the darkness that consumes our land, for your victory is a good omen. May Light guide you on your way, good master."),
	    true, TSFX_TAVERN23 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "The loss of his son was too much for King Leoric. I did what I could to ease his madness, but in the end it overcame him. A black curse has hung over this kingdom from that day forward, but perhaps if you were to free his spirit from his earthly prison, the curse would be lifted..."),
	    true, TSFX_HEALER1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "I don't like to think about how the King died. I like to remember him for the kind and just ruler that he was. His death was so sad and seemed very wrong, somehow."),
	    true, TSFX_BMAID1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I made many of the weapons and most of the armor that King Leoric used to outfit his knights. I even crafted a huge two-handed sword of the finest mithril for him, as well as a field crown to match. I still cannot believe how he died, but it must have been some sinister force that drove him insane!"),
	    true, TSFX_SMITH1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "I don't care about that. Listen, no skeleton is gonna be MY king. Leoric is King. King, so you hear me? HAIL TO THE KING!"),
	    true, TSFX_DRUNK1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "The dead who walk among the living follow the cursed King. He holds the power to raise yet more warriors for an ever growing army of the undead. If you do not stop his reign, he will surely march across this land and slay all who still live here."),
	    true, TSFX_WITCH1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "Look, I'm running a business here. I don't sell information, and I don't care about some King that's been dead longer than I've been alive. If you need something to use against this King of the undead, then I can help you out..."),
	    true, TSFX_PEGBOY1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by The Skeleton King (Hostile) */ "The warmth of life has entered my tomb. Prepare yourself, mortal, to serve my Master for eternity!"),
	    false, USFX_SKING1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "I see that this strange behavior puzzles you as well. I would surmise that since many demons fear the light of the sun and believe that it holds great power, it may be that the rising sun depicted on the sign you speak of has led them to believe that it too holds some arcane powers. Hmm, perhaps they are not all as smart as we had feared..."),
	    true, TSFX_STORY2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "Master, I have a strange experience to relate. I know that you have a great knowledge of those monstrosities that inhabit the labyrinth, and this is something that I cannot understand for the very life of me... I was awakened during the night by a scraping sound just outside of my tavern. When I looked out from my bedroom, I saw the shapes of small demon-like creatures in the inn yard. After a short time, they ran off, but not before stealing the sign to my inn. I don't know why the demons would steal my sign but leave my family in peace... 'tis strange, no?"),
	    true, TSFX_TAVERN24 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden (Quest End) */ "Oh, you didn't have to bring back my sign, but I suppose that it does save me the expense of having another one made. Well, let me see, what could I give you as a fee for finding it? Hmmm, what have we here... ah, yes! This cap was left in one of the rooms by a magician who stayed here some time ago. Perhaps it may be of some value to you."),
	    true, TSFX_TAVERN25 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "My goodness, demons running about the village at night, pillaging our homes - is nothing sacred? I hope that Ogden and Garda are all right. I suppose that they would come to see me if they were hurt..."),
	    true, TSFX_HEALER2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "Oh my! Is that where the sign went? My Grandmother and I must have slept right through the whole thing. Thank the Light that those monsters didn't attack the inn."),
	    true, TSFX_BMAID2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "Demons stole Ogden's sign, you say? That doesn't sound much like the atrocities I've heard of - or seen. \n \nDemons are concerned with ripping out your heart, not your signpost."),
	    true, TSFX_SMITH2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "You know what I think? Somebody took that sign, and they gonna want lots of money for it. If I was Ogden... and I'm not, but if I was... I'd just buy a new sign with some pretty drawing on it. Maybe a nice mug of ale or a piece of cheese..."),
	    true, TSFX_DRUNK2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "No mortal can truly understand the mind of the demon. \n \nNever let their erratic actions confuse you, as that too may be their plan."),
	    true, TSFX_WITCH2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "What - is he saying I took that? I suppose that Griswold is on his side, too. \n \nLook, I got over simple sign stealing months ago. You can't turn a profit on a piece of wood."),
	    true, TSFX_PEGBOY2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Snotspill (Hostile) */ "Hey - You that one that kill all! You get me Magic Banner or we attack! You no leave with life! You kill big uglies and give back Magic. Go past corner and door, find uglies. You give, you go!"),
	    true, USFX_SNOT1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Snotspill (Hostile) */ "You kill uglies, get banner. You bring to me, or else..."),
	    true, USFX_SNOT2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Snotspill (Hostile) */ "You give! Yes, good! Go now, we strong. We kill all with big Magic!"),
	    true, USFX_SNOT3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "This does not bode well, for it confirms my darkest fears. While I did not allow myself to believe the ancient legends, I cannot deny them now. Perhaps the time has come to reveal who I am.\n \nMy true name is Deckard Cain the Elder, and I am the last descendant of an ancient Brotherhood that was dedicated to safeguarding the secrets of a timeless evil. An evil that quite obviously has now been released.\n \nThe Archbishop Lazarus, once King Leoric's most trusted advisor, led a party of simple townsfolk into the Labyrinth to find the King's missing son, Albrecht. Quite some time passed before they returned, and only a few of them escaped with their lives.\n \nCurse me for a fool! I should have suspected his veiled treachery then. It must have been Lazarus himself who kidnapped Albrecht and has since hidden him within the Labyrinth. I do not understand why the Archbishop turned to the darkness, or what his interest is in the child, unless he means to sacrifice him to his dark masters!\n \nThat must be what he has planned! The survivors of his 'rescue party' say that Lazarus was last seen running into the deepest bowels of the labyrinth. You must hurry and save the prince from the sacrificial blade of this demented fiend!"),
	    true, TSFX_STORY36 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "You must hurry and rescue Albrecht from the hands of Lazarus. The prince and the people of this kingdom are counting on you!"),
	    true, TSFX_STORY37 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "Your story is quite grim, my friend. Lazarus will surely burn in Hell for his horrific deed. The boy that you describe is not our prince, but I believe that Albrecht may yet be in danger. The symbol of power that you speak of must be a portal in the very heart of the labyrinth.\n \nKnow this, my friend - The evil that you move against is the dark Lord of Terror. He is known to mortal men as Diablo. It was he who was imprisoned within the Labyrinth many centuries ago and I fear that he seeks to once again sow chaos in the realm of mankind. You must venture through the portal and destroy Diablo before it is too late!"),
	    true, TSFX_STORY38 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "Lazarus was the Archbishop who led many of the townspeople into the labyrinth. I lost many good friends that day, and Lazarus never returned. I suppose he was killed along with most of the others. If you would do me a favor, good master - please do not talk to Farnham about that day."),
	    true, TSFX_TAVERN1 },
	{ "", true, TSFX_STORY38 },
	{ "", true, TSFX_STORY38 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "I was shocked when I heard of what the townspeople were planning to do that night. I thought that of all people, Lazarus would have had more sense than that. He was an Archbishop, and always seemed to care so much for the townsfolk of Tristram. So many were injured, I could not save them all..."),
	    true, TSFX_HEALER3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "I remember Lazarus as being a very kind and giving man. He spoke at my mother's funeral, and was supportive of my grandmother and myself in a very troubled time. I pray every night that somehow, he is still alive and safe."),
	    true, TSFX_BMAID3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I was there when Lazarus led us into the labyrinth. He spoke of holy retribution, but when we started fighting those hellspawn, he did not so much as lift his mace against them. He just ran deeper into the dim, endless chambers that were filled with the servants of darkness!"),
	    true, TSFX_SMITH3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "They stab, then bite, then they're all around you. Liar! LIAR! They're all dead! Dead! Do you hear me? They just keep falling and falling... their blood spilling out all over the floor... all his fault..."),
	    true, TSFX_DRUNK3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "I did not know this Lazarus of whom you speak, but I do sense a great conflict within his being. He poses a great danger, and will stop at nothing to serve the powers of darkness which have claimed him as theirs."),
	    true, TSFX_WITCH3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "Yes, the righteous Lazarus, who was sooo effective against those monsters down there. Didn't help save my leg, did it? Look, I'll give you a free piece of advice. Ask Farnham, he was there."),
	    true, TSFX_PEGBOY3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Lazarus (Hostile) */ "Abandon your foolish quest. All that awaits you is the wrath of my Master! You are too late to save the child. Now you will join him in Hell!"),
	    false, USFX_LAZ1 },
	{ "", false, USFX_LAZ1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "Hmm, I don't know what I can really tell you about this that will be of any help. The water that fills our wells comes from an underground spring. I have heard of a tunnel that leads to a great lake - perhaps they are one and the same. Unfortunately, I do not know what would cause our water supply to be tainted."),
	    true, TSFX_STORY4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "I have always tried to keep a large supply of foodstuffs and drink in our storage cellar, but with the entire town having no source of fresh water, even our stores will soon run dry. \n \nPlease, do what you can or I don't know what we will do."),
	    true, TSFX_TAVERN2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "I'm glad I caught up to you in time! Our wells have become brackish and stagnant and some of the townspeople have become ill drinking from them. Our reserves of fresh water are quickly running dry. I believe that there is a passage that leads to the springs that serve our town. Please find what has caused this calamity, or we all will surely perish."),
	    true, TSFX_HEALER20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "Please, you must hurry. Every hour that passes brings us closer to having no water to drink. \n \nWe cannot survive for long without your help."),
	    true, TSFX_HEALER21 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "What's that you say - the mere presence of the demons had caused the water to become tainted? Oh, truly a great evil lurks beneath our town, but your perseverance and courage gives us hope. Please take this ring - perhaps it will aid you in the destruction of such vile creatures."),
	    true, TSFX_HEALER22 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "My grandmother is very weak, and Garda says that we cannot drink the water from the wells. Please, can you do something to help us?"),
	    true, TSFX_BMAID4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "Pepin has told you the truth. We will need fresh water badly, and soon. I have tried to clear one of the smaller wells, but it reeks of stagnant filth. It must be getting clogged at the source."),
	    true, TSFX_SMITH4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "You drink water?"), true, TSFX_DRUNK4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "The people of Tristram will die if you cannot restore fresh water to their wells. \n \nKnow this - demons are at the heart of this matter, but they remain ignorant of what they have spawned."),
	    true, TSFX_WITCH4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "For once, I'm with you. My business runs dry - so to speak - if I have no market to sell to. You better find out what is going on, and soon!"),
	    true, TSFX_PEGBOY4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "A book that speaks of a chamber of human bones? Well, a Chamber of Bone is mentioned in certain archaic writings that I studied in the libraries of the East. These tomes inferred that when the Lords of the underworld desired to protect great treasures, they would create domains where those who died in the attempt to steal that treasure would be forever bound to defend it. A twisted, but strangely fitting, end?"),
	    true, TSFX_STORY7 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "I am afraid that I don't know anything about that, good master. Cain has many books that may be of some help."),
	    true, TSFX_TAVERN5 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "This sounds like a very dangerous place. If you venture there, please take great care."),
	    true, TSFX_HEALER5 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "I am afraid that I haven't heard anything about that. Perhaps Cain the Storyteller could be of some help."),
	    true, TSFX_BMAID6 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I know nothing of this place, but you may try asking Cain. He talks about many things, and it would not surprise me if he had some answers to your question."),
	    true, TSFX_SMITH7 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "Okay, so listen. There's this chamber of wood, see. And his wife, you know - her - tells the tree... cause you gotta wait. Then I says, that might work against him, but if you think I'm gonna PAY for this... you... uh... yeah."),
	    true, TSFX_DRUNK7 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "You will become an eternal servant of the dark lords should you perish within this cursed domain. \n \nEnter the Chamber of Bone at your own peril."),
	    true, TSFX_WITCH7 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "A vast and mysterious treasure, you say? Maybe I could be interested in picking up a few things from you... or better yet, don't you need some rare and expensive supplies to get you through this ordeal?"),
	    true, TSFX_PEGBOY7 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "It seems that the Archbishop Lazarus goaded many of the townsmen into venturing into the Labyrinth to find the King's missing son. He played upon their fears and whipped them into a frenzied mob. None of them were prepared for what lay within the cold earth... Lazarus abandoned them down there - left in the clutches of unspeakable horrors - to die."),
	    true, TSFX_STORY10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "Yes, Farnham has mumbled something about a hulking brute who wielded a fierce weapon. I believe he called him a butcher."),
	    true, TSFX_TAVERN8 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "By the Light, I know of this vile demon. There were many that bore the scars of his wrath upon their bodies when the few survivors of the charge led by Lazarus crawled from the Cathedral. I don't know what he used to slice open his victims, but it could not have been of this world. It left wounds festering with disease and even I found them almost impossible to treat. Beware if you plan to battle this fiend..."),
	    true, TSFX_HEALER8 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "When Farnham said something about a butcher killing people, I immediately discounted it. But since you brought it up, maybe it is true."),
	    true, TSFX_BMAID8 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I saw what Farnham calls the Butcher as it swathed a path through the bodies of my friends. He swung a cleaver as large as an axe, hewing limbs and cutting down brave men where they stood. I was separated from the fray by a host of small screeching demons and somehow found the stairway leading out. I never saw that hideous beast again, but his blood-stained visage haunts me to this day."),
	    true, TSFX_SMITH10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham (*sad face*) */ "Big! Big cleaver killing all my friends. Couldn't stop him, had to run away, couldn't save them. Trapped in a room with so many bodies... so many friends... NOOOOOOOOOO!"),
	    true, TSFX_DRUNK10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "The Butcher is a sadistic creature that delights in the torture and pain of others. You have seen his handiwork in the drunkard Farnham. His destruction will do much to ensure the safety of this village."),
	    true, TSFX_WITCH10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "I know more than you'd think about that grisly fiend. His little friends got a hold of me and managed to get my leg before Griswold pulled me out of that hole. \n \nI'll put it bluntly - kill him before he kills you and adds your corpse to his collection."),
	    true, TSFX_PEGBOY10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wounded Townsman (Dying) */ "Please, listen to me. The Archbishop Lazarus, he led us down here to find the lost prince. The bastard led us into a trap! Now everyone is dead... killed by a demon he called the Butcher. Avenge us! Find this Butcher and slay him so that our souls may finally rest..."),
	    true, TSFX_WOUND },
	{ "", true, USFX_CLEAVER },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "You recite an interesting rhyme written in a style that reminds me of other works. Let me think now - what was it?\n \n...Darkness shrouds the Hidden. Eyes glowing unseen with only the sounds of razor claws briefly scraping to torment those poor souls who have been made sightless for all eternity. The prison for those so damned is named the Halls of the Blind..."),
	    true, TSFX_STORY12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "I never much cared for poetry. Occasionally, I had cause to hire minstrels when the inn was doing well, but that seems like such a long time ago now. \n \nWhat? Oh, yes... uh, well, I suppose you could see what someone else knows."),
	    true, TSFX_TAVERN10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "This does seem familiar, somehow. I seem to recall reading something very much like that poem while researching the history of demonic afflictions. It spoke of a place of great evil that... wait - you're not going there are you?"),
	    true, TSFX_HEALER10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "If you have questions about blindness, you should talk to Pepin. I know that he gave my grandmother a potion that helped clear her vision, so maybe he can help you, too."),
	    true, TSFX_BMAID10 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I am afraid that I have neither heard nor seen a place that matches your vivid description, my friend. Perhaps Cain the Storyteller could be of some help."),
	    true, TSFX_SMITH12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "Look here... that's pretty funny, huh? Get it? Blind - look here?"),
	    true, TSFX_DRUNK12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "This is a place of great anguish and terror, and so serves its master well. \n \nTread carefully or you may yourself be staying much longer than you had anticipated."),
	    true, TSFX_WITCH12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "Lets see, am I selling you something? No. Are you giving me money to tell you about this? No. Are you now leaving and going to talk to the storyteller who lives for this kind of thing? Yes."),
	    true, TSFX_PEGBOY11 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "You claim to have spoken with Lachdanan? He was a great hero during his life. Lachdanan was an honorable and just man who served his King faithfully for years. But of course, you already know that.\n \nOf those who were caught within the grasp of the King's Curse, Lachdanan would be the least likely to submit to the darkness without a fight, so I suppose that your story could be true. If I were in your place, my friend, I would find a way to release him from his torture."),
	    true, TSFX_STORY13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "You speak of a brave warrior long dead! I'll have no such talk of speaking with departed souls in my inn yard, thank you very much."),
	    true, TSFX_TAVERN11 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "A golden elixir, you say. I have never concocted a potion of that color before, so I can't tell you how it would effect you if you were to try to drink it. As your healer, I strongly advise that should you find such an elixir, do as Lachdanan asks and DO NOT try to use it."),
	    true, TSFX_HEALER11 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "I've never heard of a Lachdanan before. I'm sorry, but I don't think that I can be of much help to you."),
	    true, TSFX_BMAID11 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "If it is actually Lachdanan that you have met, then I would advise that you aid him. I dealt with him on several occasions and found him to be honest and loyal in nature. The curse that fell upon the followers of King Leoric would fall especially hard upon him."),
	    true, TSFX_SMITH13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ " Lachdanan is dead. Everybody knows that, and you can't fool me into thinking any other way. You can't talk to the dead. I know!"),
	    true, TSFX_DRUNK13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "You may meet people who are trapped within the Labyrinth, such as Lachdanan. \n \nI sense in him honor and great guilt. Aid him, and you aid all of Tristram."),
	    true, TSFX_WITCH13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "Wait, let me guess. Cain was swallowed up in a gigantic fissure that opened beneath him. He was incinerated in a ball of hellfire, and can't answer your questions anymore. Oh, that isn't what happened? Then I guess you'll be buying something or you'll be on your way."),
	    true, TSFX_PEGBOY12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Lachdanan (in despair) */ "Please, don't kill me, just hear me out. I was once Captain of King Leoric's Knights, upholding the laws of this land with justice and honor. Then his dark Curse fell upon us for the role we played in his tragic death. As my fellow Knights succumbed to their twisted fate, I fled from the King's burial chamber, searching for some way to free myself from the Curse. I failed...\n \nI have heard of a Golden Elixir that could lift the Curse and allow my soul to rest, but I have been unable to find it. My strength now wanes, and with it the last of my humanity as well. Please aid me and find the Elixir. I will repay your efforts - I swear upon my honor."),
	    true, USFX_LACH1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Lachdanan (in despair) */ "You have not found the Golden Elixir. I fear that I am doomed for eternity. Please, keep trying..."),
	    true, USFX_LACH2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Lachdanan (Quest End) */ "You have saved my soul from damnation, and for that I am in your debt. If there is ever a way that I can repay you from beyond the grave I will find it, but for now - take my helm. On the journey I am about to take I will have little use for it. May it protect you against the dark powers below. Go with the Light, my friend..."),
	    true, USFX_LACH3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "Griswold speaks of The Anvil of Fury - a legendary artifact long searched for, but never found. Crafted from the metallic bones of the Razor Pit demons, the Anvil of Fury was smelt around the skulls of the five most powerful magi of the underworld. Carved with runes of power and chaos, any weapon or armor forged upon this Anvil will be immersed into the realm of Chaos, imbedding it with magical properties. It is said that the unpredictable nature of Chaos makes it difficult to know what the outcome of this smithing will be..."),
	    true, TSFX_STORY14 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "Don't you think that Griswold would be a better person to ask about this? He's quite handy, you know."),
	    true, TSFX_TAVERN12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "If you had been looking for information on the Pestle of Curing or the Silver Chalice of Purification, I could have assisted you, my friend. However, in this matter, you would be better served to speak to either Griswold or Cain."),
	    true, TSFX_HEALER12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "Griswold's father used to tell some of us when we were growing up about a giant anvil that was used to make mighty weapons. He said that when a hammer was struck upon this anvil, the ground would shake with a great fury. Whenever the earth moves, I always remember that story."),
	    true, TSFX_BMAID12 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "Greetings! It's always a pleasure to see one of my best customers! I know that you have been venturing deeper into the Labyrinth, and there is a story I was told that you may find worth the time to listen to...\n \nOne of the men who returned from the Labyrinth told me about a mystic anvil that he came across during his escape. His description reminded me of legends I had heard in my youth about the burning Hellforge where powerful weapons of magic are crafted. The legend had it that deep within the Hellforge rested the Anvil of Fury! This Anvil contained within it the very essence of the demonic underworld...\n \nIt is said that any weapon crafted upon the burning Anvil is imbued with great power. If this anvil is indeed the Anvil of Fury, I may be able to make you a weapon capable of defeating even the darkest lord of Hell! \n \nFind the Anvil for me, and I'll get to work!"),
	    true, TSFX_SMITH21 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "Nothing yet, eh? Well, keep searching. A weapon forged upon the Anvil could be your best hope, and I am sure that I can make you one of legendary proportions."),
	    true, TSFX_SMITH22 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I can hardly believe it! This is the Anvil of Fury - good work, my friend. Now we'll show those bastards that there are no weapons in Hell more deadly than those made by men! Take this and may Light protect you."),
	    true, TSFX_SMITH23 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "Griswold can't sell his anvil. What will he do then? And I'd be angry too if someone took my anvil!"),
	    true, TSFX_DRUNK14 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "There are many artifacts within the Labyrinth that hold powers beyond the comprehension of mortals. Some of these hold fantastic power that can be used by either the Light or the Darkness. Securing the Anvil from below could shift the course of the Sin War towards the Light."),
	    true, TSFX_WITCH14 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "If you were to find this artifact for Griswold, it could put a serious damper on my business here. Awwww, you'll never find it."),
	    true, TSFX_PEGBOY13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "The Gateway of Blood and the Halls of Fire are landmarks of mystic origin. Wherever this book you read from resides it is surely a place of great power.\n \nLegends speak of a pedestal that is carved from obsidian stone and has a pool of boiling blood atop its bone encrusted surface. There are also allusions to Stones of Blood that will open a door that guards an ancient treasure...\n \nThe nature of this treasure is shrouded in speculation, my friend, but it is said that the ancient hero Arkaine placed the holy armor Valor in a secret vault. Arkaine was the first mortal to turn the tide of the Sin War and chase the legions of darkness back to the Burning Hells.\n \nJust before Arkaine died, his armor was hidden away in a secret vault. It is said that when this holy armor is again needed, a hero will arise to don Valor once more. Perhaps you are that hero..."),
	    true, TSFX_STORY15 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "Every child hears the story of the warrior Arkaine and his mystic armor known as Valor. If you could find its resting place, you would be well protected against the evil in the Labyrinth."),
	    true, TSFX_TAVERN13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "Hmm... it sounds like something I should remember, but I've been so busy learning new cures and creating better elixirs that I must have forgotten. Sorry..."),
	    true, TSFX_HEALER13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "The story of the magic armor called Valor is something I often heard the boys talk about. You had better ask one of the men in the village."),
	    true, TSFX_BMAID13 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "The armor known as Valor could be what tips the scales in your favor. I will tell you that many have looked for it - including myself. Arkaine hid it well, my friend, and it will take more than a bit of luck to unlock the secrets that have kept it concealed oh, lo these many years."),
	    true, TSFX_SMITH14 },
	{ N_(/* TRANSLATORS: Quest dialog "spoken" by Farnham */ "Zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz..."), true, TSFX_DRUNK15 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "Should you find these Stones of Blood, use them carefully. \n \nThe way is fraught with danger and your only hope rests within your self trust."),
	    true, TSFX_WITCH15 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "You intend to find the armor known as Valor? \n \nNo one has ever figured out where Arkaine stashed the stuff, and if my contacts couldn't find it, I seriously doubt you ever will either."),
	    true, TSFX_PEGBOY14 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "I know of only one legend that speaks of such a warrior as you describe. His story is found within the ancient chronicles of the Sin War...\n \nStained by a thousand years of war, blood and death, the Warlord of Blood stands upon a mountain of his tattered victims. His dark blade screams a black curse to the living; a tortured invitation to any who would stand before this Executioner of Hell.\n \nIt is also written that although he was once a mortal who fought beside the Legion of Darkness during the Sin War, he lost his humanity to his insatiable hunger for blood."),
	    true, TSFX_STORY18 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "I am afraid that I haven't heard anything about such a vicious warrior, good master. I hope that you do not have to fight him, for he sounds extremely dangerous."),
	    true, TSFX_TAVERN16 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "Cain would be able to tell you much more about something like this than I would ever wish to know."),
	    true, TSFX_HEALER16 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "If you are to battle such a fierce opponent, may Light be your guide and your defender. I will keep you in my thoughts."),
	    true, TSFX_BMAID16 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "Dark and wicked legends surrounds the one Warlord of Blood. Be well prepared, my friend, for he shows no mercy or quarter."),
	    true, TSFX_SMITH17 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "Always you gotta talk about Blood? What about flowers, and sunshine, and that pretty girl that brings the drinks. Listen here, friend - you're obsessive, you know that?"),
	    true, TSFX_DRUNK17 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "His prowess with the blade is awesome, and he has lived for thousands of years knowing only warfare. I am sorry... I can not see if you will defeat him."),
	    true, TSFX_WITCH18 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "I haven't ever dealt with this Warlord you speak of, but he sounds like he's going through a lot of swords. Wouldn't mind supplying his armies..."),
	    true, TSFX_PEGBOY17 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Warlord of Blood (Hostile) */ "My blade sings for your blood, mortal, and by my dark masters it shall not be denied."),
	    false, USFX_WARLRD1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "Griswold speaks of the Heaven Stone that was destined for the enclave located in the east. It was being taken there for further study. This stone glowed with an energy that somehow granted vision beyond that which a normal man could possess. I do not know what secrets it holds, my friend, but finding this stone would certainly prove most valuable."),
	    true, TSFX_STORY20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "The caravan stopped here to take on some supplies for their journey to the east. I sold them quite an array of fresh fruits and some excellent sweetbreads that Garda has just finished baking. Shame what happened to them..."),
	    true, TSFX_TAVERN18 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "I don't know what it is that they thought they could see with that rock, but I will say this. If rocks are falling from the sky, you had better be careful!"),
	    true, TSFX_HEALER18 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian */ "Well, a caravan of some very important people did stop here, but that was quite a while ago. They had strange accents and were starting on a long journey, as I recall. \n \nI don't see how you could hope to find anything that they would have been carrying."),
	    true, TSFX_BMAID18 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "Stay for a moment - I have a story you might find interesting. A caravan that was bound for the eastern kingdoms passed through here some time ago. It was supposedly carrying a piece of the heavens that had fallen to earth! The caravan was ambushed by cloaked riders just north of here along the roadway. I searched the wreckage for this sky rock, but it was nowhere to be found. If you should find it, I believe that I can fashion something useful from it."),
	    true, TSFX_SMITH24 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "I am still waiting for you to bring me that stone from the heavens. I know that I can make something powerful out of it."),
	    true, TSFX_SMITH25 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold(Quest End) */ "Let me see that - aye... aye, it is as I believed. Give me a moment...\n \nAh, Here you are. I arranged pieces of the stone within a silver ring that my father left me. I hope it serves you well."),
	    true, TSFX_SMITH26 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "I used to have a nice ring; it was a really expensive one, with blue and green and red and silver. Don't remember what happened to it, though. I really miss that ring..."),
	    true, TSFX_DRUNK19 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "The Heaven Stone is very powerful, and were it any but Griswold who bid you find it, I would prevent it. He will harness its powers and its use will be for the good of us all."),
	    true, TSFX_WITCH20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "If anyone can make something out of that rock, Griswold can. He knows what he is doing, and as much as I try to steal his customers, I respect the quality of his work."),
	    true, TSFX_PEGBOY18 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain */ "The witch Adria seeks a black mushroom? I know as much about Black Mushrooms as I do about Red Herrings. Perhaps Pepin the Healer could tell you more, but this is something that cannot be found in any of my stories or books."),
	    true, TSFX_STORY21 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden */ "Let me just say this. Both Garda and I would never, EVER serve black mushrooms to our honored guests. If Adria wants some mushrooms in her stew, then that is her business, but I can't help you find any. Black mushrooms... disgusting!"),
	    true, TSFX_TAVERN19 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "The witch told me that you were searching for the brain of a demon to assist me in creating my elixir. It should be of great value to the many who are injured by those foul beasts, if I can just unlock the secrets I suspect that its alchemy holds. If you can remove the brain of a demon when you kill it, I would be grateful if you could bring it to me."),
	    true, TSFX_HEALER26 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin */ "Excellent, this is just what I had in mind. I was able to finish the elixir without this, but it can't hurt to have this to study. Would you please carry this to the witch? I believe that she is expecting it."),
	    true, TSFX_HEALER27 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "I think Ogden might have some mushrooms in the storage cellar. Why don't you ask him?"),
	    true, TSFX_BMAID19 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold */ "If Adria doesn't have one of these, you can bet that's a rare thing indeed. I can offer you no more help than that, but it sounds like... a huge, gargantuan, swollen, bloated mushroom! Well, good hunting, I suppose."),
	    true, TSFX_SMITH19 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham */ "Ogden mixes a MEAN black mushroom, but I get sick if I drink that. Listen, listen... here's the secret - moderation is the key!"),
	    true, TSFX_DRUNK20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "What do we have here? Interesting, it looks like a book of reagents. Keep your eyes open for a black mushroom. It should be fairly large and easy to identify. If you find it, bring it to me, won't you?"),
	    true, TSFX_WITCH22 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "It's a big, black mushroom that I need. Now run off and get it for me so that I can use it for a special concoction that I am working on."),
	    true, TSFX_WITCH23 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "Yes, this will be perfect for a brew that I am creating. By the way, the healer is looking for the brain of some demon or another so he can treat those who have been afflicted by their poisonous venom. I believe that he intends to make an elixir from it. If you help him find what he needs, please see if you can get a sample of the elixir for me."),
	    true, TSFX_WITCH24 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria */ "Why have you brought that here? I have no need for a demon's brain at this time. I do need some of the elixir that the Healer is working on. He needs that grotesque organ that you are holding, and then bring me the elixir. Simple when you think about it, isn't it?"),
	    true, TSFX_WITCH25 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria (Quest End) */ "What? Now you bring me that elixir from the healer? I was able to finish my brew without it. Why don't you just keep it..."),
	    true, TSFX_WITCH26 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt */ "I don't have any mushrooms of any size or color for sale. How about something a bit more useful?"),
	    true, TSFX_PEGBOY19 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain (currently unused) */ "So, the legend of the Map is real. Even I never truly believed any of it! I suppose it is time that I told you the truth about who I am, my friend. You see, I am not all that I seem...\n \nMy true name is Deckard Cain the Elder, and I am the last descendant of an ancient Brotherhood that was dedicated to keeping and safeguarding the secrets of a timeless evil. An evil that quite obviously has now been released...\n \nThe evil that you move against is the dark Lord of Terror - known to mortal men as Diablo. It was he who was imprisoned within the Labyrinth many centuries ago. The Map that you hold now was created ages ago to mark the time when Diablo would rise again from his imprisonment. When the two stars on that map align, Diablo will be at the height of his power. He will be all but invincible...\n \nYou are now in a race against time, my friend! Find Diablo and destroy him before the stars align, for we may never have a chance to rid the world of his evil again!"),
	    true, TSFX_STORY22 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain (currently unused) */ "Our time is running short! I sense his dark power building and only you can stop him from attaining his full might."),
	    true, TSFX_STORY23 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Cain (currently unused) */ "I am sure that you tried your best, but I fear that even your strength and will may not be enough. Diablo is now at the height of his earthly power, and you will need all your courage and strength to defeat him. May the Light protect and guide you, my friend. I will help in any way that I am able."),
	    true, TSFX_STORY24 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Ogden (currently unused) */ "If the witch can't help you and suggests you see Cain, what makes you think that I would know anything? It sounds like this is a very serious matter. You should hurry along and see the storyteller as Adria suggests."),
	    true, TSFX_TAVERN20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Pepin (currently unused) */ "I can't make much of the writing on this map, but perhaps Adria or Cain could help you decipher what this refers to. \n \nI can see that it is a map of the stars in our sky, but any more than that is beyond my talents."),
	    true, TSFX_HEALER19 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gillian (currently unused) */ "The best person to ask about that sort of thing would be our storyteller. \n \nCain is very knowledgeable about ancient writings, and that is easily the oldest looking piece of paper that I have ever seen."),
	    true, TSFX_BMAID20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Griswold (currently unused) */ "I have never seen a map of this sort before. Where'd you get it? Although I have no idea how to read this, Cain or Adria may be able to provide the answers that you seek."),
	    true, TSFX_SMITH20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Farnham (currently unused) */ "Listen here, come close. I don't know if you know what I know, but you have really got somethin' here. That's a map."),
	    true, TSFX_DRUNK21 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Adria (currently unused) */ "Oh, I'm afraid this does not bode well at all. This map of the stars portends great disaster, but its secrets are not mine to tell. The time has come for you to have a very serious conversation with the Storyteller..."),
	    true, TSFX_WITCH21 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Wirt (currently unused) */ "I've been looking for a map, but that certainly isn't it. You should show that to Adria - she can probably tell you what it is. I'll say one thing; it looks old, and old usually means valuable."),
	    true, TSFX_PEGBOY20 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gharbad the Weak */ "Pleeeease, no hurt. No Kill. Keep alive and next time good bring to you."),
	    true, USFX_GARBUD1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gharbad the Weak */ "Something for you I am making. Again, not kill Gharbad. Live and give good. \n \nYou take this as proof I keep word..."),
	    true, USFX_GARBUD2 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gharbad the Weak */ "Nothing yet! Almost done. \n \nVery powerful, very strong. Live! Live! \n \nNo pain and promise I keep!"),
	    true, USFX_GARBUD3 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Gharbad the Weak (Hostile) */ "This too good for you. Very Powerful! You want - you take!"),
	    true, USFX_GARBUD4 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Zhar the Mad (annoyed / Hostile) */ "What?! Why are you here? All these interruptions are enough to make one insane. Here, take this and leave me to my work. Trouble me no more!"),
	    true, USFX_ZHAR1 },
	{ N_(/* TRANSLATORS: Quest dialog spoken by Zhar the Mad (Hostile) */ "Arrrrgh! Your curiosity will be the death of you!!!"), true, USFX_ZHAR2 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain */ "Hello, my friend. Stay awhile and listen..."), false, TSFX_STORY25 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "While you are venturing deeper into the Labyrinth you may find tomes of great knowledge hidden there. \n \nRead them carefully for they can tell you things that even I cannot."),
	    true, TSFX_STORY26 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "I know of many myths and legends that may contain answers to questions that may arise in your journeys into the Labyrinth. If you come across challenges and questions to which you seek knowledge, seek me out and I will tell you what I can."),
	    true, TSFX_STORY27 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "Griswold - a man of great action and great courage. I bet he never told you about the time he went into the Labyrinth to save Wirt, did he? He knows his fair share of the dangers to be found there, but then again - so do you. He is a skilled craftsman, and if he claims to be able to help you in any way, you can count on his honesty and his skill."),
	    true, TSFX_STORY28 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "Ogden has owned and run the Rising Sun Inn and Tavern for almost four years now. He purchased it just a few short months before everything here went to hell. He and his wife Garda do not have the money to leave as they invested all they had in making a life for themselves here. He is a good man with a deep sense of responsibility."),
	    true, TSFX_STORY29 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "Poor Farnham. He is a disquieting reminder of the doomed assembly that entered into the Cathedral with Lazarus on that dark day. He escaped with his life, but his courage and much of his sanity were left in some dark pit. He finds comfort only at the bottom of his tankard nowadays, but there are occasional bits of truth buried within his constant ramblings."),
	    true, TSFX_STORY30 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "The witch, Adria, is an anomaly here in Tristram. She arrived shortly after the Cathedral was desecrated while most everyone else was fleeing. She had a small hut constructed at the edge of town, seemingly overnight, and has access to many strange and arcane artifacts and tomes of knowledge that even I have never seen before."),
	    true, TSFX_STORY31 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "The story of Wirt is a frightening and tragic one. He was taken from the arms of his mother and dragged into the labyrinth by the small, foul demons that wield wicked spears. There were many other children taken that day, including the son of King Leoric. The Knights of the palace went below, but never returned. The Blacksmith found the boy, but only after the foul beasts had begun to torture him for their sadistic pleasures."),
	    true, TSFX_STORY33 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "Ah, Pepin. I count him as a true friend - perhaps the closest I have here. He is a bit addled at times, but never a more caring or considerate soul has existed. His knowledge and skills are equaled by few, and his door is always open."),
	    true, TSFX_STORY34 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Cain (Gossip) */ "Gillian is a fine woman. Much adored for her high spirits and her quick laugh, she holds a special place in my heart. She stays on at the tavern to support her elderly grandmother who is too sick to travel. I sometimes fear for her safety, but I know that any man in the village would rather die than see her harmed."),
	    true, TSFX_STORY35 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden */ "Greetings, good master. Welcome to the Tavern of the Rising Sun!"),
	    false, TSFX_TAVERN36 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Many adventurers have graced the tables of my tavern, and ten times as many stories have been told over as much ale. The only thing that I ever heard any of them agree on was this old axiom. Perhaps it will help you. You can cut the flesh, but you must crush the bone."),
	    true, TSFX_TAVERN37 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Griswold the blacksmith is extremely knowledgeable about weapons and armor. If you ever need work done on your gear, he is definitely the man to see."),
	    true, TSFX_TAVERN38 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Farnham spends far too much time here, drowning his sorrows in cheap ale. I would make him leave, but he did suffer so during his time in the Labyrinth."),
	    true, TSFX_TAVERN39 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Adria is wise beyond her years, but I must admit - she frightens me a little. \n \nWell, no matter. If you ever have need to trade in items of sorcery, she maintains a strangely well-stocked hut just across the river."),
	    true, TSFX_TAVERN40 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "If you want to know more about the history of our village, the storyteller Cain knows quite a bit about the past."),
	    true, TSFX_TAVERN41 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Wirt is a rapscallion and a little scoundrel. He was always getting into trouble, and it's no surprise what happened to him. \n \nHe probably went fooling about someplace that he shouldn't have been. I feel sorry for the boy, but I don't abide the company that he keeps."),
	    true, TSFX_TAVERN43 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Pepin is a good man - and certainly the most generous in the village. He is always attending to the needs of others, but trouble of some sort or another does seem to follow him wherever he goes..."),
	    true, TSFX_TAVERN44 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Ogden (Gossip) */ "Gillian, my Barmaid? If it were not for her sense of duty to her grand-dam, she would have fled from here long ago. \n \nGoodness knows I begged her to leave, telling her that I would watch after the old woman, but she is too sweet and caring to have done so."),
	    true, TSFX_TAVERN45 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin */ "What ails you, my friend?"), false, TSFX_HEALER37 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "I have made a very interesting discovery. Unlike us, the creatures in the Labyrinth can heal themselves without the aid of potions or magic. If you hurt one of the monsters, make sure it is dead or it very well may regenerate itself."),
	    true, TSFX_HEALER38 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "Before it was taken over by, well, whatever lurks below, the Cathedral was a place of great learning. There are many books to be found there. If you find any, you should read them all, for some may hold secrets to the workings of the Labyrinth."),
	    true, TSFX_HEALER39 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "Griswold knows as much about the art of war as I do about the art of healing. He is a shrewd merchant, but his work is second to none. Oh, I suppose that may be because he is the only blacksmith left here."),
	    true, TSFX_HEALER40 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "Cain is a true friend and a wise sage. He maintains a vast library and has an innate ability to discern the true nature of many things. If you ever have any questions, he is the person to go to."),
	    true, TSFX_HEALER41 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "Even my skills have been unable to fully heal Farnham. Oh, I have been able to mend his body, but his mind and spirit are beyond anything I can do."),
	    true, TSFX_HEALER42 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "While I use some limited forms of magic to create the potions and elixirs I store here, Adria is a true sorceress. She never seems to sleep, and she always has access to many mystic tomes and artifacts. I believe her hut may be much more than the hovel it appears to be, but I can never seem to get inside the place."),
	    true, TSFX_HEALER43 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "Poor Wirt. I did all that was possible for the child, but I know he despises that wooden peg that I was forced to attach to his leg. His wounds were hideous. No one - and especially such a young child - should have to suffer the way he did."),
	    true, TSFX_HEALER45 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "I really don't understand why Ogden stays here in Tristram. He suffers from a slight nervous condition, but he is an intelligent and industrious man who would do very well wherever he went. I suppose it may be the fear of the many murders that happen in the surrounding countryside, or perhaps the wishes of his wife that keep him and his family where they are."),
	    true, TSFX_HEALER46 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Pepin (Gossip) */ "Ogden's barmaid is a sweet girl. Her grandmother is quite ill, and suffers from delusions. \n \nShe claims that they are visions, but I have no proof of that one way or the other."),
	    true, TSFX_HEALER47 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian */ "Good day! How may I serve you?"), false, TSFX_BMAID31 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "My grandmother had a dream that you would come and talk to me. She has visions, you know and can see into the future."),
	    true, TSFX_BMAID32 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "The woman at the edge of town is a witch! She seems nice enough, and her name, Adria, is very pleasing to the ear, but I am very afraid of her. \n \nIt would take someone quite brave, like you, to see what she is doing out there."),
	    true, TSFX_BMAID33 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "Our Blacksmith is a point of pride to the people of Tristram. Not only is he a master craftsman who has won many contests within his guild, but he received praises from our King Leoric himself - may his soul rest in peace. Griswold is also a great hero; just ask Cain."),
	    true, TSFX_BMAID34 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "Cain has been the storyteller of Tristram for as long as I can remember. He knows so much, and can tell you just about anything about almost everything."),
	    true, TSFX_BMAID35 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "Farnham is a drunkard who fills his belly with ale and everyone else's ears with nonsense. \n \nI know that both Pepin and Ogden feel sympathy for him, but I get so frustrated watching him slip farther and farther into a befuddled stupor every night."),
	    true, TSFX_BMAID36 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "Pepin saved my grandmother's life, and I know that I can never repay him for that. His ability to heal any sickness is more powerful than the mightiest sword and more mysterious than any spell you can name. If you ever are in need of healing, Pepin can help you."),
	    true, TSFX_BMAID37 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "I grew up with Wirt's mother, Canace. Although she was only slightly hurt when those hideous creatures stole him, she never recovered. I think she died of a broken heart. Wirt has become a mean-spirited youngster, looking only to profit from the sweat of others. I know that he suffered and has seen horrors that I cannot even imagine, but some of that darkness hangs over him still."),
	    true, TSFX_BMAID39 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Gillian (Gossip) */ "Ogden and his wife have taken me and my grandmother into their home and have even let me earn a few gold pieces by working at the inn. I owe so much to them, and hope one day to leave this place and help them start a grand hotel in the east."),
	    true, TSFX_BMAID40 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold */ "Well, what can I do for ya?"), false, TSFX_SMITH44 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "If you're looking for a good weapon, let me show this to you. Take your basic blunt weapon, such as a mace. Works like a charm against most of those undying horrors down there, and there's nothing better to shatter skinny little skeletons!"),
	    true, TSFX_SMITH45 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "The axe? Aye, that's a good weapon, balanced against any foe. Look how it cleaves the air, and then imagine a nice fat demon head in its path. Keep in mind, however, that it is slow to swing - but talk about dealing a heavy blow!"),
	    true, TSFX_SMITH46 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "Look at that edge, that balance. A sword in the right hands, and against the right foe, is the master of all weapons. Its keen blade finds little to hack or pierce on the undead, but against a living, breathing enemy, a sword will better slice their flesh!"),
	    true, TSFX_SMITH47 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "Your weapons and armor will show the signs of your struggles against the Darkness. If you bring them to me, with a bit of work and a hot forge, I can restore them to top fighting form."),
	    true, TSFX_SMITH48 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "While I have to practically smuggle in the metals and tools I need from caravans that skirt the edges of our damned town, that witch, Adria, always seems to get whatever she needs. If I knew even the smallest bit about how to harness magic as she did, I could make some truly incredible things."),
	    true, TSFX_SMITH49 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "Gillian is a nice lass. Shame that her gammer is in such poor health or I would arrange to get both of them out of here on one of the trading caravans."),
	    true, TSFX_SMITH50 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "Sometimes I think that Cain talks too much, but I guess that is his calling in life. If I could bend steel as well as he can bend your ear, I could make a suit of court plate good enough for an Emperor!"),
	    true, TSFX_SMITH51 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "I was with Farnham that night that Lazarus led us into Labyrinth. I never saw the Archbishop again, and I may not have survived if Farnham was not at my side. I fear that the attack left his soul as crippled as, well, another did my leg. I cannot fight this battle for him now, but I would if I could."),
	    true, TSFX_SMITH52 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "A good man who puts the needs of others above his own. You won't find anyone left in Tristram - or anywhere else for that matter - who has a bad thing to say about the healer."),
	    true, TSFX_SMITH53 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "That lad is going to get himself into serious trouble... or I guess I should say, again. I've tried to interest him in working here and learning an honest trade, but he prefers the high profits of dealing in goods of dubious origin. I cannot hold that against him after what happened to him, but I do wish he would at least be careful."),
	    true, TSFX_SMITH55 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Griswold (Gossip) */ "The Innkeeper has little business and no real way of turning a profit. He manages to make ends meet by providing food and lodging for those who occasionally drift through the village, but they are as likely to sneak off into the night as they are to pay him. If it weren't for the stores of grains and dried meats he kept in his cellar, why, most of us would have starved during that first year when the entire countryside was overrun by demons."),
	    true, TSFX_SMITH56 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham */ "Can't a fella drink in peace?"), false, TSFX_DRUNK27 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "The gal who brings the drinks? Oh, yeah, what a pretty lady. So nice, too."),
	    true, TSFX_DRUNK28 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "Why don't that old crone do somethin' for a change. Sure, sure, she's got stuff, but you listen to me... she's unnatural. I ain't never seen her eat or drink - and you can't trust somebody who doesn't drink at least a little."),
	    true, TSFX_DRUNK29 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "Cain isn't what he says he is. Sure, sure, he talks a good story... some of 'em are real scary or funny... but I think he knows more than he knows he knows."),
	    true, TSFX_DRUNK30 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "Griswold? Good old Griswold. I love him like a brother! We fought together, you know, back when... we... Lazarus...  Lazarus... Lazarus!!!"),
	    true, TSFX_DRUNK31 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "Hehehe, I like Pepin. He really tries, you know. Listen here, you should make sure you get to know him. Good fella like that with people always wantin' help. Hey, I guess that would be kinda like you, huh hero? I was a hero too..."),
	    true, TSFX_DRUNK32 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "Wirt is a kid with more problems than even me, and I know all about problems. Listen here - that kid is gotta sweet deal, but he's been there, you know? Lost a leg! Gotta walk around on a piece of wood. So sad, so sad..."),
	    true, TSFX_DRUNK34 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "Ogden is the best man in town. I don't think his wife likes me much, but as long as she keeps tappin' kegs, I'll like her just fine. Seems like I been spendin' more time with Ogden than most, but he's so good to me..."),
	    true, TSFX_DRUNK35 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "I wanna tell ya sumthin', 'cause I know all about this stuff. It's my specialty. This here is the best... theeeee best! That other ale ain't no good since those stupid dogs..."),
	    true, TSFX_DRUNK23 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "No one ever lis... listens to me. Somewhere - I ain't too sure - but somewhere under the church is a whole pile o' gold. Gleamin' and shinin' and just waitin' for someone to get it."),
	    true, TSFX_DRUNK24 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "I know you gots your own ideas, and I know you're not gonna believe this, but that weapon you got there - it just ain't no good against those big brutes! Oh, I don't care what Griswold says, they can't make anything like they used to in the old days..."),
	    true, TSFX_DRUNK25 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Farnham (Gossip) */ "If I was you... and I ain't... but if I was, I'd sell all that stuff you got and get out of here. That boy out there... He's always got somethin good, but you gotta give him some gold or he won't even show you what he's got."),
	    true, TSFX_DRUNK26 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria */ "I sense a soul in search of answers..."), false, TSFX_WITCH38 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "Wisdom is earned, not given. If you discover a tome of knowledge, devour its words. Should you already have knowledge of the arcane mysteries scribed within a book, remember - that level of mastery can always increase."),
	    true, TSFX_WITCH39 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "The greatest power is often the shortest lived. You may find ancient words of power written upon scrolls of parchment. The strength of these scrolls lies in the ability of either apprentice or adept to cast them with equal ability. Their weakness is that they must first be read aloud and can never be kept at the ready in your mind. Know also that these scrolls can be read but once, so use them with care."),
	    true, TSFX_WITCH40 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "Though the heat of the sun is beyond measure, the mere flame of a candle is of greater danger. No energies, no matter how great, can be used without the proper focus. For many spells, ensorcelled Staves may be charged with magical energies many times over. I have the ability to restore their power - but know that nothing is done without a price."),
	    true, TSFX_WITCH41 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "The sum of our knowledge is in the sum of its people. Should you find a book or scroll that you cannot decipher, do not hesitate to bring it to me. If I can make sense of it I will share what I find."),
	    true, TSFX_WITCH42 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "To a man who only knows Iron, there is no greater magic than Steel. The blacksmith Griswold is more of a sorcerer than he knows. His ability to meld fire and metal is unequaled in this land."),
	    true, TSFX_WITCH43 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "Corruption has the strength of deceit, but innocence holds the power of purity. The young woman Gillian has a pure heart, placing the needs of her matriarch over her own. She fears me, but it is only because she does not understand me."),
	    true, TSFX_WITCH44 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "A chest opened in darkness holds no greater treasure than when it is opened in the light. The storyteller Cain is an enigma, but only to those who do not look. His knowledge of what lies beneath the cathedral is far greater than even he allows himself to realize."),
	    true, TSFX_WITCH45 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "The higher you place your faith in one man, the farther it has to fall. Farnham has lost his soul, but not to any demon. It was lost when he saw his fellow townspeople betrayed by the Archbishop Lazarus. He has knowledge to be gleaned, but you must separate fact from fantasy."),
	    true, TSFX_WITCH46 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "The hand, the heart and the mind can perform miracles when they are in perfect harmony. The healer Pepin sees into the body in a way that even I cannot. His ability to restore the sick and injured is magnified by his understanding of the creation of elixirs and potions. He is as great an ally as you have in Tristram."),
	    true, TSFX_WITCH47 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "There is much about the future we cannot see, but when it comes it will be the children who wield it. The boy Wirt has a blackness upon his soul, but he poses no threat to the town or its people. His secretive dealings with the urchins and unspoken guilds of nearby towns gain him access to many devices that cannot be easily found in Tristram. While his methods may be reproachful, Wirt can provide assistance for your battle against the encroaching Darkness."),
	    true, TSFX_WITCH49 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Adria (Gossip) */ "Earthen walls and thatched canopy do not a home create. The innkeeper Ogden serves more of a purpose in this town than many understand. He provides shelter for Gillian and her matriarch, maintains what life Farnham has left to him, and provides an anchor for all who are left in the town to what Tristram once was. His tavern, and the simple pleasures that can still be found there, provide a glimpse of a life that the people here remember. It is that memory that continues to feed their hopes for your success."),
	    true, TSFX_WITCH50 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt */ "Pssst... over here..."), false, TSFX_PEGBOY32 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "Not everyone in Tristram has a use - or a market - for everything you will find in the labyrinth. Not even me, as hard as that is to believe. \n \nSometimes, only you will be able to find a purpose for some things."),
	    true, TSFX_PEGBOY33 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "Don't trust everything the drunk says. Too many ales have fogged his vision and his good sense."),
	    true, TSFX_PEGBOY34 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "In case you haven't noticed, I don't buy anything from Tristram. I am an importer of quality goods. If you want to peddle junk, you'll have to see Griswold, Pepin or that witch, Adria. I'm sure that they will snap up whatever you can bring them..."),
	    true, TSFX_PEGBOY35 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "I guess I owe the blacksmith my life - what there is of it. Sure, Griswold offered me an apprenticeship at the smithy, and he is a nice enough guy, but I'll never get enough money to... well, let's just say that I have definite plans that require a large amount of gold."),
	    true, TSFX_PEGBOY36 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "If I were a few years older, I would shower her with whatever riches I could muster, and let me assure you I can get my hands on some very nice stuff. Gillian is a beautiful girl who should get out of Tristram as soon as it is safe. Hmmm... maybe I'll take her with me when I go..."),
	    true, TSFX_PEGBOY37 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "Cain knows too much. He scares the life out of me - even more than that woman across the river. He keeps telling me about how lucky I am to be alive, and how my story is foretold in legend. I think he's off his crock."),
	    true, TSFX_PEGBOY38 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "Farnham - now there is a man with serious problems, and I know all about how serious problems can be. He trusted too much in the integrity of one man, and Lazarus led him into the very jaws of death. Oh, I know what it's like down there, so don't even start telling me about your plans to destroy the evil that dwells in that Labyrinth. Just watch your legs..."),
	    true, TSFX_PEGBOY39 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "As long as you don't need anything reattached, old Pepin is as good as they come. \n \nIf I'd have had some of those potions he brews, I might still have my leg..."),
	    true, TSFX_PEGBOY40 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "Adria truly bothers me. Sure, Cain is creepy in what he can tell you about the past, but that witch can see into your past. She always has some way to get whatever she needs, too. Adria gets her hands on more merchandise than I've seen pass through the gates of the King's Bazaar during High Festival."),
	    true, TSFX_PEGBOY42 },
	{ N_(/* TRANSLATORS: Neutral dialog spoken by Wirt (Gossip) */ "Ogden is a fool for staying here. I could get him out of town for a very reasonable price, but he insists on trying to make a go of it with that stupid tavern. I guess at the least he gives Gillian a place to work, and his wife Garda does make a superb Shepherd's pie..."),
	    true, TSFX_PEGBOY43 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "Beyond the Hall of Heroes lies the Chamber of Bone. Eternal death awaits any who would seek to steal the treasures secured within this room. So speaks the Lord of Terror, and so it is written."),
	    true, PS_WARR1 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "...and so, locked beyond the Gateway of Blood and past the Hall of Fire, Valor awaits for the Hero of Light to awaken..."),
	    true, PS_WARR10 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "I can see what you see not.\nVision milky then eyes rot.\nWhen you turn they will be gone,\nWhispering their hidden song.\nThen you see what cannot be,\nShadows move where light should be.\nOut of darkness, out of mind,\nCast down into the Halls of the Blind."),
	    true, PS_WARR11 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "The armories of Hell are home to the Warlord of Blood. In his wake lay the mutilated bodies of thousands. Angels and men alike have been cut down to fulfill his endless sacrifices to the Dark ones who scream for one thing - blood."),
	    true, PS_WARR12 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "Beyond the Hall of Heroes lies the Chamber of Bone. Eternal death awaits any who would seek to steal the treasures secured within this room. So speaks the Lord of Terror, and so it is written."),
	    true, PS_WARR1 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "...and so, locked beyond the Gateway of Blood and past the Hall of Fire, Valor awaits for the Hero of Light to awaken..."),
	    true, PS_WARR10 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "I can see what you see not.\nVision milky then eyes rot.\nWhen you turn they will be gone,\nWhispering their hidden song.\nThen you see what cannot be,\nShadows move where light should be.\nOut of darkness, out of mind,\nCast down into the Halls of the Blind."),
	    true, PS_WARR11 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "The armories of Hell are home to the Warlord of Blood. In his wake lay the mutilated bodies of thousands. Angels and men alike have been cut down to fulfill his endless sacrifices to the Dark ones who scream for one thing - blood."),
	    true, PS_WARR12 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "Beyond the Hall of Heroes lies the Chamber of Bone. Eternal death awaits any who would seek to steal the treasures secured within this room. So speaks the Lord of Terror, and so it is written."),
	    true, PS_WARR1 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "...and so, locked beyond the Gateway of Blood and past the Hall of Fire, Valor awaits for the Hero of Light to awaken..."),
	    true, PS_WARR10 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "I can see what you see not.\nVision milky then eyes rot.\nWhen you turn they will be gone,\nWhispering their hidden song.\nThen you see what cannot be,\nShadows move where light should be.\nOut of darkness, out of mind,\nCast down into the Halls of the Blind."),
	    true, PS_WARR11 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "The armories of Hell are home to the Warlord of Blood. In his wake lay the mutilated bodies of thousands. Angels and men alike have been cut down to fulfill his endless sacrifices to the Dark ones who scream for one thing - blood."),
	    true, PS_WARR12 },
	{ "", false, TSFX_COW1 },
	{ "", false, TSFX_COW2 },
	/*
	{ "", false, TSFX_COW3 },
	{ "", false, TSFX_COW4 },
	{ "", false, TSFX_COW5 },
	{ "", false, TSFX_COW6 },
	{ "", false, TSFX_COW7 },
	{ "", false, TSFX_COW8 },
*/
	{ N_(/* TRANSLATORS: Book read aloud */ "Take heed and bear witness to the truths that lie herein, for they are the last legacy of the Horadrim. There is a war that rages on even now, beyond the fields that we know - between the utopian kingdoms of the High Heavens and the chaotic pits of the Burning Hells. This war is known as the Great Conflict, and it has raged and burned longer than any of the stars in the sky. Neither side ever gains sway for long as the forces of Light and Darkness constantly vie for control over all creation."),
	    true, PS_NAR1 },
	{ N_(/* TRANSLATORS: Book read aloud */ "Take heed and bear witness to the truths that lie herein, for they are the last legacy of the Horadrim. When the Eternal Conflict between the High Heavens and the Burning Hells falls upon mortal soil, it is called the Sin War. Angels and Demons walk amongst humanity in disguise, fighting in secret, away from the prying eyes of mortals. Some daring, powerful mortals have even allied themselves with either side, and helped to dictate the course of the Sin War."),
	    true, PS_NAR2 },
	{ N_(/* TRANSLATORS: Book read aloud */ "Take heed and bear witness to the truths that lie herein, for they are the last legacy of the Horadrim. Nearly three hundred years ago, it came to be known that the Three Prime Evils of the Burning Hells had mysteriously come to our world. The Three Brothers ravaged the lands of the east for decades, while humanity was left trembling in their wake. Our Order - the Horadrim - was founded by a group of secretive magi to hunt down and capture the Three Evils once and for all.\n \nThe original Horadrim captured two of the Three within powerful artifacts known as Soulstones and buried them deep beneath the desolate eastern sands. The third Evil escaped capture and fled to the west with many of the Horadrim in pursuit. The Third Evil - known as Diablo, the Lord of Terror - was eventually captured, his essence set in a Soulstone and buried within this Labyrinth.\n \nBe warned that the soulstone must be kept from discovery by those not of the faith. If Diablo were to be released, he would seek a body that is easily controlled as he would be very weak - perhaps that of an old man or a child."),
	    true, PS_NAR3 },
	{ N_(/* TRANSLATORS: Book read aloud */ "So it came to be that there was a great revolution within the Burning Hells known as The Dark Exile. The Lesser Evils overthrew the Three Prime Evils and banished their spirit forms to the mortal realm. The demons Belial (the Lord of Lies) and Azmodan (the Lord of Sin) fought to claim rulership of Hell during the absence of the Three Brothers. All of Hell polarized between the factions of Belial and Azmodan while the forces of the High Heavens continually battered upon the very Gates of Hell."),
	    true, PS_NAR4 },
	{ N_(/* TRANSLATORS: Book read aloud */ "Many demons traveled to the mortal realm in search of the Three Brothers. These demons were followed to the mortal plane by Angels who hunted them throughout the vast cities of the East. The Angels allied themselves with a secretive Order of mortal magi named the Horadrim, who quickly became adept at hunting demons. They also made many dark enemies in the underworlds."),
	    true, PS_NAR5 },
	{ N_(/* TRANSLATORS: Book read aloud */ "So it came to be that the Three Prime Evils were banished in spirit form to the mortal realm and after sewing chaos across the East for decades, they were hunted down by the cursed Order of the mortal Horadrim. The Horadrim used artifacts called Soulstones to contain the essence of Mephisto, the Lord of Hatred and his brother Baal, the Lord of Destruction. The youngest brother - Diablo, the Lord of Terror - escaped to the west.\n \nEventually the Horadrim captured Diablo within a Soulstone as well, and buried him under an ancient, forgotten Cathedral. There, the Lord of Terror sleeps and awaits the time of his rebirth. Know ye that he will seek a body of youth and power to possess - one that is innocent and easily controlled. He will then arise to free his Brothers and once more fan the flames of the Sin War..."),
	    true, PS_NAR6 },
	{ N_(/* TRANSLATORS: Book read aloud */ "All praises to Diablo - Lord of Terror and Survivor of The Dark Exile. When he awakened from his long slumber, my Lord and Master spoke to me of secrets that few mortals know. He told me the kingdoms of the High Heavens and the pits of the Burning Hells engage in an eternal war. He revealed the powers that have brought this discord to the realms of man. My lord has named the battle for this world and all who exist here the Sin War."),
	    true, PS_NAR7 },
	{ N_(/* TRANSLATORS: Book read aloud */ "Glory and Approbation to Diablo - Lord of Terror and Leader of the Three. My Lord spoke to me of his two Brothers, Mephisto and Baal, who were banished to this world long ago. My Lord wishes to bide his time and harness his awesome power so that he may free his captive brothers from their tombs beneath the sands of the east. Once my Lord releases his Brothers, the Sin War will once again know the fury of the Three."),
	    true, PS_NAR8 },
	{ N_(/* TRANSLATORS: Book read aloud */ "Hail and Sacrifice to Diablo - Lord of Terror and Destroyer of Souls. When I awoke my Master from his sleep, he attempted to possess a mortal's form. Diablo attempted to claim the body of King Leoric, but my Master was too weak from his imprisonment. My Lord required a simple and innocent anchor to this world, and so found the boy Albrecht to be perfect for the task. While the good King Leoric was left maddened by Diablo's unsuccessful possession, I kidnapped his son Albrecht and brought him before my Master. I now await Diablo's call and pray that I will be rewarded when he at last emerges as the Lord of this world."),
	    true, PS_NAR9 },
	{ N_(/* TRANSLATORS: Neutral Text spoken by Ogden */ "Thank goodness you've returned!\nMuch has changed since you lived here, my friend. All was peaceful until the dark riders came and destroyed our village. Many were cut down where they stood, and those who took up arms were slain or dragged away to become slaves - or worse. The church at the edge of town has been desecrated and is being used for dark rituals. The screams that echo in the night are inhuman, but some of our townsfolk may yet survive. Follow the path that lies between my tavern and the blacksmith shop to find the church and save who you can. \n \nPerhaps I can tell you more if we speak again. Good luck."),
	    true, TSFX_TAVERN0 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "Beyond the Hall of Heroes lies the Chamber of Bone. Eternal death awaits any who would seek to steal the treasures secured within this room. So speaks the Lord of Terror, and so it is written."),
	    true, PS_WARR1 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "...and so, locked beyond the Gateway of Blood and past the Hall of Fire, Valor awaits for the Hero of Light to awaken..."),
	    true, PS_WARR10 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "I can see what you see not.\nVision milky then eyes rot.\nWhen you turn they will be gone,\nWhispering their hidden song.\nThen you see what cannot be,\nShadows move where light should be.\nOut of darkness, out of mind,\nCast down into the Halls of the Blind."),
	    true, PS_WARR11 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "The armories of Hell are home to the Warlord of Blood. In his wake lay the mutilated bodies of thousands. Angels and men alike have been cut down to fulfill his endless sacrifices to the Dark ones who scream for one thing - blood."),
	    true, PS_WARR12 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "Beyond the Hall of Heroes lies the Chamber of Bone. Eternal death awaits any who would seek to steal the treasures secured within this room. So speaks the Lord of Terror, and so it is written."),
	    true, PS_WARR1 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "...and so, locked beyond the Gateway of Blood and past the Hall of Fire, Valor awaits for the Hero of Light to awaken..."),
	    true, PS_WARR10 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "I can see what you see not.\nVision milky then eyes rot.\nWhen you turn they will be gone,\nWhispering their hidden song.\nThen you see what cannot be,\nShadows move where light should be.\nOut of darkness, out of mind,\nCast down into the Halls of the Blind."),
	    true, PS_WARR11 },
	{ N_(/* TRANSLATORS: Quest text spoken aloud from a book by player */ "The armories of Hell are home to the Warlord of Blood. In his wake lay the mutilated bodies of thousands. Angels and men alike have been cut down to fulfill his endless sacrifices to the Dark ones who scream for one thing - blood."),
	    true, PS_WARR12 },
	{ N_(/* TRANSLATORS: Quest text spoken by Adria */ "Maintain your quest.  Finding a treasure that is lost is not easy.  Finding a treasure that is hidden less so.  I will leave you with this.  Do not let the sands of time confuse your search."),
	    true, TSFX_WITCH19 },
	{ N_(/* TRANSLATORS: Quest text spoken by Griswold */ "A what?!  This is foolishness.  There's no treasure buried here in Tristram.  Let me see that!!  Ah, Look these drawings are inaccurate.  They don't match our town at all.  I'd keep my mind on what lies below the cathedral and not what lies below our topsoil."),
	    true, TSFX_SMITH18 },
	{ N_(/* TRANSLATORS: Quest text spoken by Pepin */ "I really don't have time to discuss some map you are looking for.  I have many sick people that require my help and yours as well."),
	    true, TSFX_HEALER17 },
	{ N_(/* TRANSLATORS: Quest text spoken by Adria */ "The once proud Iswall is trapped deep beneath the surface of this world.  His honor stripped and his visage altered.  He is trapped in immortal torment.  Charged to conceal the very thing that could free him."),
	    true, TSFX_WITCH9 },
	{ N_(/* TRANSLATORS: Quest text spoken by Ogden */ "I'll bet that Wirt saw you coming and put on an act just so he could laugh at you later when you were running around the town with your nose in the dirt.  I'd ignore it."),
	    true, TSFX_TAVERN17 },
	{ N_(/* TRANSLATORS: Quest text spoken by Cain */ "There was a time when this town was a frequent stop for travelers from far and wide.  Much has changed since then.  But hidden caves and buried treasure are common fantasies of any child.  Wirt seldom indulges in youthful games.  So it may just be his imagination."),
	    true, TSFX_STORY19 },
	{ N_(/* TRANSLATORS: Quest text spoken by Farnham */ "Listen here.  Come close.  I don't know if you know what I know, but you've have really got something here.  That's a map."),
	    true, TSFX_DRUNK21 },
	{ N_(/* TRANSLATORS: Quest text spoken by Gillian */ "My grandmother often tells me stories about the strange forces that inhabit the graveyard outside of the church.  And it may well interest you to hear one of them.  She said that if you were to leave the proper offering in the cemetary, enter the cathedral to pray for the dead, and then return, the offering would be altered in some strange way.  I don't know if this is just the talk of an old sick woman, but anything seems possible these days."),
	    true, TSFX_BMAID27 },
	{ N_(/* TRANSLATORS: Quest text spoken by Wirt */ "Hmmm.  A vast and mysterious treasure you say.  Mmmm.  Maybe I could be interested in picking up a few things from you.  Or better yet, don't you need some rare and expensive supplies to get you through this ordeal?"),
	    true, TSFX_PEGBOY7 },
	{ N_(/* TRANSLATORS: Quest text spoken by Adria */ "The once proud Iswall is trapped deep beneath the surface of this world.  His honor stripped and his visage altered.  He is trapped in immortal torment.  Charged to conceal the very thing that could free him."),
	    true, TSFX_WITCH9 },
	{ N_(/* TRANSLATORS: Neutral text spoken by Farmer (Gossip) */ "So, you're the hero everyone's been talking about. Perhaps you could help a poor, simple farmer out of a terrible mess? At the edge of my orchard, just south of here, there's a horrible thing swelling out of the ground! I can't get to my crops or my bales of hay, and my poor cows will starve. The witch gave this to me and said that it would blast that thing out of my field. If you could destroy it, I would be forever grateful. I'd do it myself, but someone has to stay here with the cows..."),
	    true, TSFX_FARMER1 },
	{ N_(/* TRANSLATORS: Neutral text spoken by Farmer (Gossip) */ "I knew that it couldn't be as simple as that witch made it sound. It's a sad world when you can't even trust your neighbors."),
	    true, TSFX_FARMER2 },
	{ N_(/* TRANSLATORS: Neutral text spoken by Farmer (Gossip) */ "Is it gone? Did you send it back to the dark recesses of Hades that spawned it? You what? Oh, don't tell me you lost it! Those things don't come cheap, you know. You've got to find it, and then blast that horror out of our town."),
	    true, TSFX_FARMER3 },
	{ N_(/* TRANSLATORS: Neutral text spoken by Farmer (Gossip) */ "I heard the explosion from here! Many thanks to you, kind stranger. What with all these things comin' out of the ground, monsters taking over the church, and so forth, these are trying times. I am but a poor farmer, but here -- take this with my great thanks."),
	    true, TSFX_FARMER4 },
	{ N_(/* TRANSLATORS: Neutral text spoken by Farmer (Gossip) */ "Oh, such a trouble I have...maybe...No, I couldn't impose on you, what with all the other troubles. Maybe after you've cleansed the church of some of those creatures you could come back... and spare a little time to help a poor farmer?"),
	    true, TSFX_FARMER5 },
	{ N_(/* TRANSLATORS: Quest text spoken by Little Girl */ "Waaaah! (sniff) Waaaah! (sniff)"), true, TSFX_TEDDYBR1 },
	{ N_(/* TRANSLATORS: Quest text spoken by Little Girl */ "I lost Theo!  I lost my best friend!  We were playing over by the river, and Theo said he wanted to go look at the big green thing.  I said we shouldn't, but we snuck over there, and then suddenly this BUG came out!  We ran away but Theo fell down and the bug GRABBED him and took him away!"),
	    true, TSFX_TEDDYBR2 },
	{ N_(/* TRANSLATORS: Quest text spoken by Little Girl */ "Didja find him?  You gotta find Theodore, please!  He's just little.  He can't take care of himself!  Please!"),
	    true, TSFX_TEDDYBR3 },
	{ N_(/* TRANSLATORS: Quest text spoken by Little Girl (Quest End) */ "You found him!  You found him!  Thank you!  Oh Theo, did those nasty bugs scare you?  Hey!  Ugh!  There's something stuck to your fur!  Ick!  Come on, Theo, let's go home!  Thanks again, hero person!"),
	    true, TSFX_TEDDYBR4 },
	{ N_(/* TRANSLATORS: Quest text spoken by Defiler (Hostile) */ "We have long lain dormant, and the time to awaken has come.  After our long sleep, we are filled with great hunger.  Soon, now, we shall feed..."),
	    true, USFX_DEFILER6 },
	{ N_(/* TRANSLATORS: Quest text spoken by Defiler (Hostile) */ "Have you been enjoying yourself, little mammal?  How pathetic. Your little world will be no challenge at all."),
	    true, USFX_DEFILER2 },
	{ N_(/* TRANSLATORS: Quest text spoken by Defiler (Hostile) */ "These lands shall be defiled, and our brood shall overrun the fields that men call home.  Our tendrils shall envelop this world, and we will feast on the flesh of its denizens.  Man shall become our chattel and sustenance."),
	    true, USFX_DEFILER7 },
	{ N_(/* TRANSLATORS: Quest text spoken by Defiler (Hostile) */ "Ah, I can smell you...you are close! Close! Ssss...the scent of blood and fear...how enticing..."),
	    true, USFX_DEFILER4 },
	{ "", true, USFX_DEFILER8 },
	{ "", true, USFX_NAKRUL1 },
	{ "", true, USFX_NAKRUL2 },
	{ "", true, USFX_NAKRUL3 },
	{ "", true, USFX_NAKRUL4 },
	{ "", true, USFX_NAKRUL5 },
	{ N_(/* TRANSLATORS: Quest text spoken by Narrator */ "And in the year of the Golden Light, it was so decreed that a great Cathedral be raised.  The cornerstone of this holy place was to be carved from the translucent stone Antyrael, named for the Angel who shared his power with the Horadrim.  \n \nIn the Year of Drawing Shadows, the ground shook and the Cathedral shattered and fell.  As the building of catacombs and castles began and man stood against the ravages of the Sin War, the ruins were scavenged for their stones.  And so it was that the cornerstone vanished from the eyes of man. \n \nThe stone was of this world -- and of all worlds -- as the Light is both within all things and beyond all things. Light and unity are the products of this holy foundation, a unity of purpose and a unity of possession."),
	    true, PS_NARATR3 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Moo."), true, TSFX_COWSUT1 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "I said, Moo."), true, TSFX_COWSUT2 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Look I'm just a cow, OK?"), true, TSFX_COWSUT3 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "All right, all right.  I'm not really a cow.  I don't normally go around like this; but, I was sitting at home minding my own business and all of a sudden these bugs & vines & bulbs & stuff started coming out of the floor... it was horrible!  If only I had something normal to wear, it wouldn't be so bad.  Hey!  Could you go back to my place and get my suit for me?  The brown one, not the gray one, that's for evening wear.  I'd do it myself, but I don't want anyone seeing me like this.  Here, take this, you might need it... to kill those things that have overgrown everything.  You can't miss my house, it's just south of the fork in the river... you know... the one with the overgrown vegetable garden."),
	    true, TSFX_COWSUT4 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "What are you wasting time for?  Go get my suit!  And hurry!  That Holstein over there keeps winking at me!"),
	    true, TSFX_COWSUT5 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Hey, have you got my suit there?  Quick, pass it over!  These ears itch like you wouldn't believe!"),
	    true, TSFX_COWSUT6 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "No no no no!  This is my GRAY suit!  It's for evening wear!  Formal occasions!  I can't wear THIS.  What are you, some kind of weirdo?  I need the BROWN suit."),
	    true, TSFX_COWSUT7 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Ahh, that's MUCH better.  Whew!  At last, some dignity!  Are my antlers on straight?  Good.  Look, thanks a lot for helping me out.  Here, take this as a gift; and, you know... a little fashion tip... you could use a little... you could use a new... yknowwhatImean?  The whole adventurer motif is just so... retro.  Just a word of advice, eh?  Ciao."),
	    true, TSFX_COWSUT8 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Look.  I'm a cow.  And you, you're monster bait. Get some experience under your belt!  We'll talk..."),
	    true, TSFX_COWSUT9 },
	{ "", true, TSFX_TRADER1 },
	{ N_(/* TRANSLATORS: Quest text spoken by Farmer */ "It must truly be a fearsome task I've set before you. If there was just some way that I could... would a flagon of some nice, fresh milk help?"),
	    true, TSFX_FARMER2A },
	{ N_(/* TRANSLATORS: Quest text spoken by Farmer */ "Oh, I could use your help, but perhaps after you've saved the catacombs from the desecration of those beasts."),
	    true, TSFX_FARMER6 },
	{ N_(/* TRANSLATORS: Quest text spoken by Farmer */ "I need something done, but I couldn't impose on a perfect stranger. Perhaps after you've been here a while I might feel more comfortable asking a favor."),
	    true, TSFX_FARMER7 },
	{ N_(/* TRANSLATORS: Quest text spoken by Farmer */ "I see in you the potential for greatness.  Perhaps sometime while you are fulfilling your destiny, you could stop by and do a little favor for me?"),
	    true, TSFX_FARMER8 },
	{ N_(/* TRANSLATORS: Quest text spoken by Farmer */ "I think you could probably help me, but perhaps after you've gotten a little more powerful. I wouldn't want to injure the village's only chance to destroy the menace in the church!"),
	    true, TSFX_FARMER9 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Me, I'm a self-made cow.  Make something of yourself, and... then we'll talk."),
	    true, TSFX_COWSUT10 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "I don't have to explain myself to every tourist that walks by!  Don't you have some monsters to kill?  Maybe we'll talk later.  If you live..."),
	    true, TSFX_COWSUT11 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "Quit bugging me.  I'm looking for someone really heroic.  And you're not it.  I can't trust you, you're going to get eaten by monsters any day now... I need someone who's an experienced hero."),
	    true, TSFX_COWSUT12 },
	{ N_(/* TRANSLATORS: Quest text spoken by Complete Nut */ "All right, I'll cut the bull.  I didn't mean to steer you wrong.  I was sitting at home, feeling moo-dy, when things got really un-stable; a whole stampede of monsters came out of the floor!  I just cowed.  I just happened to be wearing this Jersey when I ran out the door, and now I look udderly ridiculous.  If only I had something normal to wear, it wouldn't be so bad.  Hey!  Can you go back to my place and get my suit for me?  The brown one, not the gray one, that's for evening wear.  I'd do it myself, but I don't want anyone seeing me like this.  Here, take this, you might need it... to kill those things that have overgrown everything.  You can't miss my house, it's just south of the fork in the river... you know... the one with the overgrown vegetable garden."),
	    true, TSFX_COWSUT4A },
	{ N_(/* TRANSLATORS: Quest text spoken by Unknown, Maybe Farmer */ "Cloudy and cooler today.  Casting the nets of necromancy across the void landed two new subspecies of flying horror; a good day's work.  Must remember to order some more bat guano and black candles from Adria; I'm running a bit low."),
	    true, USFX_SKLJRN1 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book */ "I have tried spells, threats, abjuration and bargaining with this foul creature -- to no avail.  My methods of enslaving lesser demons seem to have no effect on this fearsome beast."),
	    true, PS_NARATR6 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book */ "My home is slowly becoming corrupted by the vileness of this unwanted prisoner.  The crypts are full of shadows that move just beyond the corners of my vision.  The faint scrabble of claws dances at the edges of my hearing. They are searching, I think, for this journal."),
	    true, PS_NARATR7 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book */ "In its ranting, the creature has let slip its name -- Na-Krul.  I have attempted to research the name, but the smaller demons have somehow destroyed my library.  Na-Krul... The name fills me with a cold dread.  I prefer to think of it only as The Creature rather than ponder its true name."),
	    true, PS_NARATR8 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book */ "The entrapped creature's howls of fury keep me from gaining much needed sleep.  It rages against the one who sent it to the Void, and it calls foul curses upon me for trapping it here.  Its words fill my heart with terror, and yet I cannot block out its voice."),
	    true, PS_NARATR5 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book */ "My time is quickly running out.  I must record the ways to weaken the demon, and then conceal that text, lest his minions find some way to use my knowledge to free their lord.  I hope that whoever finds this journal will seek the knowledge."),
	    true, PS_NARATR9 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book */ "Whoever finds this scroll is charged with stopping the demonic creature that lies within these walls.  My time is over. Even now, its hellish minions claw at the frail door behind which I hide.  \n \nI have hobbled the demon with arcane magic and encased it within great walls, but I fear that will not be enough. \n \nThe spells found in my three grimoires will provide you protected entrance to his domain, but only if cast in their proper sequence.  The levers at the entryway will remove the barriers and free the demon; touch them not!  Use only these spells to gain entry or his power may be too great for you to defeat."),
	    true, PS_NARATR4 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book by player */ "In Spiritu Sanctum."), true, PS_WARR54 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book by player */ "Praedictum Otium."), true, PS_WARR55 },
	{ N_(/* TRANSLATORS: Quest text read aloud from book by player */ "Efficio Obitus Ut Inimicus."), true, PS_WARR56 },
	{ N_("In Spiritu Sanctum."), true, PS_WARR54 },
	{ N_("Praedictum Otium."), true, PS_WARR55 },
	{ N_("Efficio Obitus Ut Inimicus."), true, PS_WARR56 },
	{ N_("In Spiritu Sanctum."), true, PS_WARR54 },
	{ N_("Praedictum Otium."), true, PS_WARR55 },
	{ N_("Efficio Obitus Ut Inimicus."), true, PS_WARR56 },
	{ N_("In Spiritu Sanctum."), true, PS_WARR54 },
	{ N_("Praedictum Otium."), true, PS_WARR55 },
	{ N_("Efficio Obitus Ut Inimicus."), true, PS_WARR56 },
	{ N_("In Spiritu Sanctum."), true, PS_WARR54 },
	{ N_("Praedictum Otium."), true, PS_WARR55 },
	{ N_("Efficio Obitus Ut Inimicus."), true, PS_WARR56 },
	/**
	{ N_("Please help....! I barely escaped from....... The Butcher...! He killed.... My wife... My children! I beg of you...... In the name of God......... Avenge them........."), true, TSFX_DEADGUY },
	{ N_("*retching* Listen, listen. I don't even like worms. Don't tell me about yer worms! I don't want yer worms! Nope, no thanks! *slight hiccup/gag* No worms for me."), true, TSFX_DRUNK5 },
	{ N_("*SNORE*"), true, TSFX_DRUNK6 },
	{ N_("Sounds like a good idea to me. Ya better get started right awaaay."), true, TSFX_DRUNK8 },
	{ N_("*laugh* Did you ever hear I love that King tale? I love that one."), true, TSFX_DRUNK9 },
	{ N_("(Crying) No, you can't make me go back there. I won't let you take me. Too much pain, too many dead. Can't... get the blood out of my eyes... my mouth... *wails*"), true, TSFX_DRUNK11 },
	{ N_("You're gonna hunt down a demon? Is that what you said? I know I didn't hear that 'cuz nobody hunts down a demon, no! Nobody!"), true, TSFX_DRUNK16 },
	{ N_("Hey, lemme see that. *blows nose* Thanks!"), true, TSFX_DRUNK18 },
	{ N_("Hey you there, come here, listen up. You know about the island where angels watch? Pick the right rocks, but you better shield your eyes; shield everything! I know, 'cause I been there and... Mmmm, ale."), true, TSFX_DRUNK22 },
	{ N_("I haven't ever see a priest around here. If I did I'd kick him right in the *BBBBUUURRRPPP* Can't even keep a church free of those Hell spawn - bastards. What good are they, those holy men? Liars! Liars!"), true, TSFX_DRUNK33 },
	{ N_("Wait, before you say anything, my grandmother had a dream with giant, slithering creatures in it. She also saw Pepin running from a house in the town. Do you think this means anything?"),
	    true, TSFX_BMAID5 },
	{ N_("This is something that is far beyond anything I have ever learned. I can only think of one person in all of Tristram who could help you... Cain, of course."),
	    true, TSFX_BMAID7 },
	{ N_("How could you even think of going back to that place? What could be so important?"),
	    true, TSFX_BMAID9 },
	{ N_("Those are the words of a drunkard. I don't see how they could be true."),
	    true, TSFX_BMAID14 },
	{ N_("I heard that the priest Tremain was going to perform an exorcism, but I didn't go. I don't see why we all have to spend every moment captive to what is lurking underneath our town. I know that many have died at the hands of these monsters, but we need to try to go on. I know that you have come here to free Tristram from the clutches of darkness, and I hope that one day we can live in peace again."),
	    true, TSFX_BMAID15 },
	{ N_("A treasure map? Do you have it with you? Let me see... Hmm, it looks like this is pretty old, and some of the buildings in the town are not on this map. Oh, I wish I could go and look for the treasure with you, but I have to start work soon."),
	    true, TSFX_BMAID17 },
	{ N_("Beg pardon, but have you heard what has been happening? Some of the men have vanished from the village. Dica's sons, Inaius and Roof, claim to have seen strange lights(= blood stars) glowing deep within the woods a few days ago, but no one has heard from them since. I, too, have seen a crimson shimmering from beyond the ash groves, but I've been too afraid to approach it. I fear that Ogden or our healer Pepin may be next. Won't you please find out what has happened?"),
	    true, TSFX_BMAID21 },
	{ N_("Have you looked into what has caused the strange lights yet? There are more men missing since last we spoke, and I'm beginning to fear that soon we may all vanish."),
	    true, TSFX_BMAID22 },
	{ N_("Demons that assume the form of beautiful women, you say? That's horrible! Thank the Light that you solved this mystery before any more of our men were lured to their deaths. Thank you for keeping us safe from the powers of darkness once again."),
	    true, TSFX_BMAID23 },
	{ N_("Pray your pardon, but I've something to tell you that you may find interesting. It was the strangest thing. While drinking at the tavern, Farnham was rambling about something called Azurewrath. He also said something about a fallen angel. It was hard to understand him because he was very drunk and disoriented, but I seem to remember something about a key in a barrel. He also kept covering his face and repeating the word 'Izual' over and over again."),
	    true, TSFX_BMAID24 },
	{ N_("You know, now that I think about it... maybe it wasn't a key in a barrel, but a barrel that was the key. Does that make any more sense?"),
	    true, TSFX_BMAID25 },
	{ N_("Azurewrath and Izual. I don't know why I didn't remember that story earlier. I've heard it often enough from my grandmother and Cain the Storyteller. Well, I hope that my information was still more of a help than a hindrance. May Light guide you, my friend."),
	    true, TSFX_BMAID26 },
	{ N_("I know that my grandmother’s story seems strange, but the graveyard does have many mysteries surrounding it. It couldn’t hurt you to put something there and see what happens, could it? Maybe you will find out something that will help us all."),
	    true, TSFX_BMAID28 },
	{ N_("My grandmother had a dream about you last night, she said that in her dream you used your bare hands to defeat one of those foul monsters that lurk under the church. When it died, it exploded into fabulous treasure! Although she was a bit frightened by her dream, she was able to describe the beast quite clearly to me."),
	    true, TSFX_BMAID29 },
	{ N_("My grandmother had that exact same dream again. She said you are quite brave and seemed very pleased with your prize."),
	    true, TSFX_BMAID30 },
	{ N_("I really don't know much about the priest Tremain. He never visits the tavern, preferring to keep to the company of Pepin and Cain. Perhaps it is because they, too, have more scholarly pursuits."),
	    true, TSFX_BMAID38 },
	{ N_("Roof and Inaius are missing? Light protect us! Is there no place that is safe? Our only hope of returning to a peaceful life rests in you. Please, you must find those boys and bring them home to their family."),
	    true, TSFX_HEALER4 },
	{ N_("Horazon was insane. There are forces with which one does not interfere. It would not surprise me if you found only the charred remains of this damned fool."),
	    true, TSFX_HEALER6 },
	{ N_("Farnham is often confused, but he speaks a powerful name when the word Izual passes his lips. Cain would be able to tell you in much greater detail the legend of this warrior."),
	    true, TSFX_HEALER7 },
	{ N_("I suppose it isn't beyond the realm of possibility if you could bear being in that room again. Your description of the atrocities committed there would be enough to keep me far from it."),
	    true, TSFX_HEALER9 },
	{ N_("For once I can vouch for Farnham's extraordinary claim. There are many mentions in the books that I have been reading about a place of great healing where warriors of light would go to mend the wounds sustained in the Sin War. If you could find this place it would most assuredly be to the benefit of us all."),
	    true, TSFX_HEALER14 },
	{ N_("I was asked to assist in the exorcism. My skills were able to ease the poor man's suffering as Tremain drove the demon from his body. While I was treating him for an exceptionally high fever, he spoke of a place of searing heat. The tortured fellow cried out about Hell and falling into a pit of flame. I could not make any sense of it, and thankfully he soon recovered."),
	    true, TSFX_HEALER15 },
	{ N_("Good hero, a moment of your time please. While attending one of the townsfolk who had taken quite ill, I noticed something odd about his home. There were strange sounds and a sickly sweet smell rising from the cellar. Thinking perhaps these fumes had something to do with his sickness. In his cellar were monstrous worms shifting and squirming up from the underground. I beg of you, slay these creatures before they can make their way into the town. I left the door to his house open for you. It is the one opposite of mine."),
	    true, TSFX_HEALER23 },
	{ N_("I fear that the worms could soon overrun the village. I know that they are coming up from under the house that is opposite mine. Just the thought of those slimy beasts oozing into my house makes me want to be ill. Please, rid us of them."),
	    true, TSFX_HEALER24 },
	{ N_("Once again you have saved this humble town from the encroaching evil. We are, as always, forever in your debt."),
	    true, TSFX_HEALER25 },
	{ N_("My friend, I must speak with you. While going to help a sick villager I came upon a demon in the town. I fled from the house and accidentally left the door open in my haste. I pray that the vial creature is still in there. Please help us before it comes for us all."),
	    true, TSFX_HEALER28 },
	{ N_("These creatures must be banished from our town. To my shame I left the door open, but that should make all the easier for you to find the house."),
	    true, TSFX_HEALER29 },
	{ N_("Once again the town is in your debt. It is only your strength and force of will that can leads us out of this evil time."),
	    true, TSFX_HEALER30 },
	{ N_("Once again I require your strong arm and quick quirks to aid the people of this town. I am in need of certain reagents to help fight the plagues that the demons have unleashed on the land by their very presence. If you could gather these few items, it will save many lives!"),
	    true, TSFX_HEALER31 },
	{ N_("The diseases spread quickly and many are dying. Please, help me by finding the reagents so that I can use it to make an antidote."),
	    true, TSFX_HEALER32 },
	{ N_("Thank you so much! You bring hope and light to this dark and troubled times. I wish for you to have this in the hopes that will aid you in your battle against the darkness."),
	    true, TSFX_HEALER33 },
	{ N_("I know that I ask much of you, but I must now ask that you find a pool of clear water. Take these containers, fill them and return them me as soon as you can. With the clear water I can create an elixir of wondrous power that will benefit us all."),
	    true, TSFX_HEALER34 },
	{ N_("Have you brought what I need? The clear water will allow me to create a very power elixir, fill the containers that I gave you and return with them."),
	    true, TSFX_HEALER35 },
	{ N_("Very good, my friend! Very good! Just give a minute to mix these ingredients... Perfect! Here is some of the elixir as promised."),
	    true, TSFX_HEALER36 },
	{ N_("His Holiness is a wondrous man of great knowledge and understanding. He has shown me many cures for rare and deadly diseases. He brings me books and reagents for my work whenever he can. But I fear that he may some day take on a task that is too great even for him."),
	    true, TSFX_HEALER44 },
	{ N_("I've seen no such things in my shop, but I will keep a close watch for them. Perhaps if they come this way, they won't take kindly to the fires of my forge."),
	    true, TSFX_SMITH5 },
	{ N_("I admit that I too have seen these strange lights, but I have not felt pulled towards them. I'll be sure to steer clear of them and will tell everyone that visits here to do likewise."),
	    true, TSFX_SMITH6 },
	{ N_("A bold tale indeed! My limited time beneath the cathedral leaves me poorly equipped to offer you any help with this. But, as always, you'll find Cain well versed in legends and folklore."),
	    true, TSFX_SMITH8 },
	{ N_("The blade Azurewrath... It's legend! It was cast by the angelic weaponsmith Cinadide and tempered within the fires of judgment! Whoever wields this weapon will find the legions of Hell at his feet! If you found this blade, I would begin to truly believe that you could end the nightmare that has befallen our town."),
	    true, TSFX_SMITH9 },
	{ N_("When I found Wirt, he was very near a room that sounds like the vile pit you've described. The stench of death was heavy in the air and, consumed as I was with getting the lad to safety, I did not go further than I had to. If he claims to know something of that place, I would not discount his word easily."),
	    true, TSFX_SMITH11 },
	{ N_("Farnham speaks of a place that exists, at least in legend. Warriors would go to a place at the edge of Hell to gird themselves for battle against the armies of darkness. If the stories are true, untold treasures could lie upon this island of the sunless sea."),
	    true, TSFX_SMITH15 },
	{ N_("Ah, you speak of an ancient and evil weapon. Tread lightly in this area, for the legends of Shadowfang are as black as a moonless winter night. Crafted within the Hellforge, Shadowfang can rend the very soul from whoever it strikes. I do not envy you if is in your mind to defeat the one who wields it. May light protect you, brave hero."),
	    true, TSFX_SMITH16 },
	{ N_("I'm in luck! A caravan has stopped just outside of the village and is taking supplies to the lands of the East. Certain items will bring a special price... if you can get them for me."),
	    true, TSFX_SMITH27 },
	{ N_("We can both turn a nice profit if you can deliver the right goods to me. What do you say?"),
	    true, TSFX_SMITH28 },
	{ N_("You're just in time. The caravan is leaving tonight! Here's your cut, friend."),
	    true, TSFX_SMITH29 },
	{ N_("I believe that I may have found a way to greatly improve some weapons. If you can bring me what I need, I'd be willing to try out my idea and, if it works, it's yours!"),
	    true, TSFX_SMITH30 },
	{ N_("I still think I can improve the right weapon!"),
	    true, TSFX_SMITH31 },
	{ N_("Let me just do this... and this... and this. Ah, it works! Take this back and give it a try."),
	    true, TSFX_SMITH32 },
	{ N_("I'm working on a method for strengthening armor. Unfortunately, I don't have what I need just now. If you could possibly bring me what I require, the first one is yours!"),
	    true, TSFX_SMITH33 },
	{ N_("I still think I can strengthen the right armor. You know what you need to bring me."),
	    true, TSFX_SMITH34 },
	{ N_("Good find! See if this works any better for you."),
	    true, TSFX_SMITH35 },
	{ N_("If you come across any enchanted equipment, I could try to learn how it was crafted and then use those methods for my own creations. I should probably start with something easy."),
	    true, TSFX_SMITH36 },
	{ N_("I still think that I can strip the knowledge of enchantments... if you bring me a certain item."),
	    true, TSFX_SMITH37 },
	{ N_("Thank you, oh great and mighty customer... err... uhh... champion! This will take some study... Done!"),
	    true, TSFX_SMITH38 },
	{ N_("Keep your eyes open for a figurine made of iron. I have uncovered some old records concerning a specific type of figurine and the secrets of metalcrafting that it holds."),
	    true, TSFX_SMITH39 },
	{ N_("I know that the right figurine could be quite powerful. If you see what I'm looking for, get it and bring it to me straight away!"),
	    true, TSFX_SMITH40 },
	{ N_("The secrets of this metal are fantastic! Oh, how I could make the right item gleam with power."),
	    true, TSFX_SMITH41 },
	{ N_("If you deliver to me the right item so I can combine it with this metal, I could craft something worthy of the warriors of Heaven!"),
	    true, TSFX_SMITH42 },
	{ N_("Your efforts are not in vain. It seems that all is as I had hoped. I trust you will find this useful in your battles below?"),
	    true, TSFX_SMITH43 },
	{ N_("Haha, they have you hunting worms now? What's next? Leaf collecting? Picking up mushrooms? Look, friend, you have a whole church full of demons over there to worry about. I don't see how a few little worms could be so bad."),
	    1, 5, TSFX_PEGBOY5 },
	{ N_("You know, I've been looking for those lights, but I can't find them. If Gillian says they're there, I believe her, but I have yet to see them for myself."),
	    1, 5, TSFX_PEGBOY6 },
	{ N_("The care and feeding of demons is definitely not an interest of mine. Here is a piece of friendly advice - if you get the chance, kill anything you see down there."),
	    1, 5, TSFX_PEGBOY8 },
	{ N_("If you were to find any trace of Izual or the blade Azurewrath, even I would be impressed. That is definitely one of a kind."),
	    1, 5, TSFX_PEGBOY9 },
	{ N_("This is one time that you should listen to Farnham. I have heard of this place, and I know a few sorcerers who have tried to create a portal to get there."),
	    1, 5, TSFX_PEGBOY15 },
	{ N_("I don't know who this Fleshdoom is, but I have heard rumors of an ebon blade that cleaves a soul from the body. Even I would not try to sell that thing, no matter what the profit. If you find it, you should do as Tremain says and destroy it as quickly as possible."),
	    1, 5, TSFX_PEGBOY16 },
	{ N_("Here over... pssst... Chamber butcher the from spell portal town the cast! Saying am I what see?!"),
	    1, 5, TSFX_PEGBOY21 },
	{ N_("Yet out it figured you haven't?! Understand could you even so simple it make to tried I! Chamber butcher the from spell portal town the cast!"),
	    1, 5, TSFX_PEGBOY22 },
	{ N_("Hmm, where is that stupid map? It was supposed to be between the rock and the tree before the bridge. It should be right... Oh, hello there... didn't, uh, see you standing there..."),
	    1, 5, TSFX_PEGBOY23 },
	{ N_("Rock? Tree? Bridge? I have no idea what you're talking about."),
	    1, 5, TSFX_PEGBOY24 },
	{ N_("Look, I know my prices are high, but one of my contacts had an... accident, and I need some help refilling my more mundane inventory. I'll trade you a quality item if you can just complete this little list for me."),
	    1, 5, TSFX_PEGBOY25 },
	{ N_("Listen, I'll make it worth your time if you will get me what I asked you for. Besides, you know you want to find out what I'm going to give you in return."),
	    1, 5, TSFX_PEGBOY26 },
	{ N_("Thanks! This should hold me over until I can find a new errand boy. Too bad you're so busy. Oh yeah, here's your part of the bargain."),
	    1, 5, TSFX_PEGBOY27 },
	{ N_("Pssst... over here... I have something very special for sale today! I'm not exactly sure what it is, but I can just tell that it's great. I'm gonna offer you a bargain - a thousand gold takes it. Right now, no questions, and no returns!"),
	    1, 5, TSFX_PEGBOY28 },
	{ N_("Hey, you! Yeah, I'm talking to you! I... acquired this strange book. I know it must do something big, but you need a crystal eyepiece to read it, so it's useless to me. However, I would be willing to trade you this rare and mystical tome, uh, for just a few things."),
	    1, 5, TSFX_PEGBOY29 },
	{ N_("Look, this very special book that I have can be yours for so little. Don't tell anyone what a great deal I'm giving you or it would ruin my reputation."),
	    1, 5, TSFX_PEGBOY30 },
	{ N_("Amazing, you actually found everything I wanted! Well, here's the book, but you're going to have to find a crystal eyepiece to read it. Good luck!"),
	    1, 5, TSFX_PEGBOY31 },
	{ N_("Yeah, Tremain! He gets around, doesn't he? Or haven't you heard? My friends in some of the other towns say that he passes through, picking up a few books here, a pinch of bat claw there. Never seems to have the problems most do getting in and out of Tristram, that's for sure."),
	    1, 5, TSFX_PEGBOY41 },
	{ N_("All I can do now is pray for us all."),
	    1, 5, TSFX_PRIEST0 },
	{ N_("I seek a champion to undertake a serious duty, and the people of this town speak well of your courage and skill. The Archbishop Lazarus, once King Leoric's most trusted advisor and a member of our order, has taken the path of evil. Not long ago, Lazarus led a party of simple townsfolk into the labyrinth to find the king's missing son, Albrecht. Only a few of them escaped with their lives. Curse me for a fool! I should have suspected his veiled treachery then! For I have learned that it was Lazarus himself who kidnapped Leoric's son and has since hidden him within the labyrinth. I still don't understand why the Archbishop has turned to the darkness, or what his interest is in Albrecht. Unless... he means to sacrifice him at the full moon. That must be what he has planned! The survivors of his rescue party say that Lazarus was last seen in the deepest bowels of the labyrinth, some sixteen levels beneath the Cathedral. You must hurry, and save the prince from the sacrificial blade of this demented fiend!"),
	    1, 5, TSFX_PRIEST1 },
	{ N_("Why do you delay?! Time is of the essence! The prince and the people of this kingdom are counting on you!"),
	    1, 5, TSFX_PRIEST2 },
	{ N_("So, Lazarus has paid the price for his betrayal and justice is served! For your services this day, I bestow this mace unto you. Its name is Lightforge, and it is the holiest of our order's artifacts. As I am the last of this order, I entrust it to you. May the Light guide you."),
	    1, 5, TSFX_PRIEST3 },
	{ N_("This is terrible! Lazarus will surely burn in Hell for his horrific deed! Although the boy that you describe may not be our prince, I believe that Albrecht may yet be in danger. Whatever vile power lies beneath the ground, has assuredly secured its foothold in our world. All I can do now is pray for us all."),
	    1, 5, TSFX_PRIEST4 },
	{ N_("I have had a most disturbing experience that I must share with you, my friend. Earlier today, I was called upon to help one of the men that escaped from the labyrinth. He was deranged, violent, and kept lashing out at all of those who tried to calm him. I suspected that he was possessed by some sort of demonic entity, and so began to drive the evil from within him. After many hours, I was able to exorcise a demon who called himself Fleshdoom, but the hellion fled into the labyrinth. You may think that I am mad, but after speaking with the man and battling with Fleshdoom, I believe that the labyrinth has somehow become a gateway to the underworld. As you descend deeper, you may find yourself upon the doorstep of Hell itself. Finally, the man who was possessed retained memories of an ancient demonblade named Shadowfang. If you find the demon Fleshdoom, beware this foul sword. While I fear the dangers below grow even greater, you must find Fleshdoom and slay him. Bring the sword to me and I can destroy it, but do not wield it. For its power can corrupt, absolutely."),
	    1, 5, TSFX_PRIEST5 },
	{ N_("Fleshdoom's demise is a great good to the world, yet Shadowfang remains! It must be found and destroyed! Do not attempt to use the demonblade, champion. It will corrupt and madden any mortal who wields it. I alone can end its dark evil."),
	    1, 5, TSFX_PRIEST6 },
	{ N_("Light be praised! You found the cursed demonblade! Only its destruction can ensure the safety of us all! Wait... what treachery is this?! Ow, it burns! Hellfire, consuming me! You must take this, to the Hellforge and cast it in before-NOOOOOOO!"),
	    1, 5, TSFX_PRIEST7 },
	{ N_("The evil that you move against is the Dark Lord of Terror, known to mortal man as... Diablo. It was he who was imprisoned within the labyrinth many centuries ago. Find Diablo... or we may never have a chance to rid the world of his evil again!"),
	    1, 5, TSFX_STORY0 },
	{ N_("Yes, you speak of Lazarus, one who was once well-respected in our land. Even before King Leoric descended into madness and lost his son, the Archishop Lazarus was acting... strangely. Lazarus seemed to be motivated by unseen forces, clinging to shadows, and acting out some dark plan that was not his own."),
	    1, 5, TSFX_STORY3 },
	{ N_("Worms that rise up from the ground? Many of the ancient writings speak of poisonous insects, and foul creatures of the skies and seas, plaguing mankind. It is no surprise that the very earth would offer up a similar peril, now that the denizens of the underworld are upon us."),
	    1, 5, TSFX_STORY5 },
	{ N_("While the barmaid may seem a bit confused at times, it is true that men have been disappearing from the village. It reminds me of ancient writings about a demonic temptress called Andariel. Known as the Maiden of Anguish, her thirst for mortal blood was so great, that she sought to learn a spell to breach the mortal realm. By seducing one of the dark sorcerers of the netherworld, Andariel took the knowledge she needed and so began to lure mortal men into her dark corner of Hell. If these legends are true, she's not a creature to be taken lightly."),
	    1, 5, TSFX_STORY6 },
	{ N_("So, you seek knowledge concerning the wars of Hell, do you? Cryptic tomes speak of great battles that determined which of the demonic lords are to rule over Hell. They also mention a bitter rivalry between two of these lords - Azmodan, who led the Horned Death against the armies of Light, and Belial, known as the Lord of Lies. Their hatred of each other is eternal - the reasons for their loathing, lost even to themselves. Tales abound, that the mad wizard Horazon somehow trapped the lieutenants of these two Lords of Hell within his sanctum. There can be no more dangerous a path to tread, than the one that falls alongside of demons. Should you also seek this path, watch your life, and your soul - very carefully - my friend."),
	    1, 5, TSFX_STORY8 },
	{ N_("Farnham has taken to drinking quite heavily since his encounters in the labyrinth. But within the ramblings of this drunken man, rests a legend well steeped in myth and mystery. Sit for a moment, my friend, and let me tell you of Izual and Azurewrath. The saga of Izual takes place during the lost battles in Hell. Izual was an angel who was given charge of the holy ruin blade, Azurewrath. Leading a daring assault on the Hellforge, Izual was set upon by hundreds of blackened demons, and was fatally wounded! The fiends cast the dying angel into a dark pit, where the powers of chaos transformed him, as he drowned in a whirlpool of burning blood! Evil possessed Izual! The feathers of his wings burned away to reveal leathery skin, and horns ripped through the flesh of his head! When he finally arose from that black pit, Izual was an angel no more! Transformed into a creature of evil, he was once again given charge of Azurewrath, assuring that the blade would never again be used against the denizens of Hell!"),
	    1, 5, TSFX_STORY9 },
	{ N_("You must've been speaking with Wirt! His is a sad story indeed. That poor child was taken into the labyrinth by the demons, ripped from the very arms of his mother, Canace. May her soul rest in peace. The boy managed to escape, but only after they had chewed off his leg, and he has not been quite sane since. He often speaks in riddles, but his knowledge of the labyrinth... may hold some truth."),
	    1, 5, TSFX_STORY11 },
	{ N_("Hmm, an island, where angels watched? Although Farnham's memory is often cloudy these days, that does seem familiar. Perhaps the ancient chronicles of the Sin War can help us... Ah, yes, here is something. In a time long-forgotten, a sea of blue rested on the edge of the fiery netherworld. This was an oasis for those who acted as the watchmen over the gates of Hell. Angels and warriors of Light could use this place to heal themselves, and gather their strength. It was also a staging area where they could train and prepare for the Sin War. Legends speak of a trinity of rocks that hide the path to this island of the sunless sea."),
	    1, 5, TSFX_STORY16 },
	{ N_("The priest Tremain is a holy man from an ancient order. Their dealings with the evil forces at work are well respected, and well documented. I, too, have heard legends that speak of the cursed demonblade called Shadowfang. It is said to consume the tortured souls of its victims. These souls are trapped within its ebon blade and augment its unholy power. I have also read of a great Hellforge, where even the mightiest weapon could be created... or destroyed. Tread carefully when dealing with Shadowfang and its master, lest you be drawn into the sword as well!"),
	    1, 5, TSFX_STORY17 },
	{ N_("That sounds quite disgusting, and I'm afraid that I haven't heard anything about any worms. Perhaps Cain the Storyteller could be of some help."),
	    1, 5, TSFX_TAVERN3 },
	{ N_("Gillian has been going on and on about strange lights in the trees, but I haven't been able to make heads nor tails of her story. I certainly haven't seen any strange lights, and if I did, they would be the least of my worries."),
	    1, 5, TSFX_TAVERN4 },
	{ N_("These sound like dark creatures indeed. I am ignorant to matters of this nature, but I would assume that our storyteller may know of such legends."),
	    1, 5, TSFX_TAVERN6 },
	{ N_("There is an old story of an angel named Izual, but I don't remember much more than that."),
	    1, 5, TSFX_TAVERN7 },
	{ N_("Wirt is talking backwards again? I hate it when he does that! I don't have time to help you decipher his riddle, but I will tell you one thing - don't get involved with that rapscallion."),
	    1, 5, TSFX_TAVERN9 },
	{ N_("You know, sometimes I wonder how much faith you can put into what Farnham says. He spends so much time reliving his memories of the labyrinth and just being plain drunk, that he doesn't always make much sense. I guess you could ask around, though."),
	    1, 5, TSFX_TAVERN14 },
	{ N_("I saw the exorcism! It was incredible how Tremain drove the evil spirit from that man's racked and tortured body! I pray that something that horrific never happens to anyone here ever again."),
	    1, 5, TSFX_TAVERN15 },
	{ N_("Your brave tales of fighting demons have reminded me of something, good master. A traveller passed through here some time ago. He was quite proud of a very unique weapon he held, and while becoming quite drunk, boasted of its power. I never saw him again, and I suspect that he ventured too close to the Cathedral."),
	    1, 5, TSFX_TAVERN26 },
	{ N_("Have you ever seen that traveller I told you about? The one with the enchanted weapon? Well, I suppose that he left our village as so many others have, or he must be dead."),
	    1, 5, TSFX_TAVERN27 },
	{ N_("Yes, that is certainly the weapon that he wore. You know, I've been thinking about something else that traveller said. He inferred that the true powers of the weapon would be unleashed only when it tasted the blood of a very specific kind of creature."),
	    1, 5, TSFX_TAVERN28 },
	{ N_("Were the stories the traveller told us true? Oh, I see you don't know yet. Well, I clearly recall that he said by slaying a certain monster, the weapon you found would become something quite special."),
	    1, 5, TSFX_TAVERN29 },
	{ N_("While I understand that your purpose may be of a higher calling, surely some well-earned gold would be welcomed. Some townspeople from a nearby village have offered a reward for the destruction of a creature that razed their homes and property. They demand positive proof that the creature has been slain, and I can only think of one way to do that."),
	    1, 5, TSFX_TAVERN30 },
	{ N_("You can say whatever you want, but without proof I cannot give you the reward."),
	    1, 5, TSFX_TAVERN31 },
	{ N_("Oh, disgusting! But certainly proof enough for anyone. Here's your reward as promised."),
	    1, 5, TSFX_TAVERN32 },
	{ N_("Good master, a moment of your time, please? My tavern was broken into during the night. No one was hurt but many items were stolen, including a chest belonging to a mysterious wanderer who once stayed here. I found the body of a thief near the Cathedral with telltale wounds from one of the creatures below mocking his broken body. Some of the stolen goods were near the body, but the chest, and the key to open it, were nowhere in sight. If you should find those keys while on your brave crusade, you should recover them. Then, if you find the chest, you can open it and see what secrets it contains. Perhaps it will be something that can help you on your quests."),
	    1, 5, TSFX_TAVERN33 },
	{ N_("Remember, good master, the chest is locked and is useless without the key. If you do find the chest and get the key, you should see what's inside. I don't expect the owner back here again."),
	    1, 5, TSFX_TAVERN34 },
	{ N_("I see that you have found the key - now you just need to find the chest that it belongs to."),
	    1, 5, TSFX_TAVERN35 },
	{ N_("Seek out the domicile to which Pepin the Healer has directed you. It is there that your missions will become clear, and your methods evident."),
	    1, 5, TSFX_WITCH5 },
	{ N_("The succubus is a demon that feasts upon the essence of mortal men. You will find that Andariel has quite an appetite. The town will soon be devoid of any adult males, unless you stop her feeding now."),
	    1, 5, TSFX_WITCH6 },
	{ N_("You must destroy the two demons that Horazon has trapped within his sanctum at all costs! Should they escape from their imprisonment, they will create a link to this world that will make what lies below the Cathedral seem like a children's tale."),
	    1, 5, TSFX_WITCH8 },
	{ N_("The lair of the Butcher is steeped in demonic power, and casting any spell or passage there could cause unexpected results."),
	    1, 5, TSFX_WITCH11 },
	{ N_("This legendary place is real and great rewards await you should you find it. Nothing more can I say."),
	    1, 5, TSFX_WITCH16 },
	{ N_("You must be ever watchful, for Fleshdoom is an enemy who is both cruel and quick. His ebon blade is composed of the essence of evil. If you can destroy both of them, it would do much to weaken his dark master."),
	    1, 5, TSFX_WITCH17 },
	{ N_("Hello, good friend, I have been working on a means to increase the strength of my potions. I believe that I could brew better potions if you could just find me the correct reagents."),
	    1, 5, TSFX_WITCH27 },
	{ N_("Remember, with the correct reagents, my potions are more powerful."),
	    1, 5, TSFX_WITCH28 },
	{ N_("Excellent! Just a pinch should do it... Ahh, here is a sample."),
	    1, 5, TSFX_WITCH29 },
	{ N_("It seems that there are many uses for the scrolls which are found beneath the church. I should be able to scribe a book of magic if I had enough of the proper scrolls to study."),
	    1, 5, TSFX_WITCH30 },
	{ N_("Remember, with enough scrolls, I can create a book of magic for you."),
	    1, 5, TSFX_WITCH31 },
	{ N_("Yes, I can see that when I combine these scrolls just so... I will teach what I have learned so that you may also know more secrets of this magic."),
	    1, 5, TSFX_WITCH32 },
	{ N_("I have a quest for you if you are brave enough to accept it. Great power can be found in some of the devices that may be hidden below the church. With the right ones, I could work wonders!"),
	    1, 5, TSFX_WITCH33 },
	{ N_("Remember, the right device in my hands can become quite powerful."),
	    1, 5, TSFX_WITCH34 },
	{ N_("This is amazing! The mystic energies in this crystal are powerful, but unfocused. If you could find for me a specific staff to channel its power through..."),
	    1, 5, TSFX_WITCH35 },
	{ N_("The crystal holds a magic that is strong, but you need to find the correct staff with which to focus its energy!"),
	    1, 5, TSFX_WITCH36 },
	{ N_("Hand me that staff and stand back! Vita te chlorum an duriam! Ahhhh, it is complete."),
	    1, 5, TSFX_WITCH37 },
	{ N_("Faith is absolute belief in the unseen. The priest Tremain is from a holy order long asleep in this land. He keeps a promise and a charge issued ages ago and sustains a union with realms that even my vision cannot reach. He knows much, but not as much as he believes."),
	    1, 5, TSFX_WITCH48 },
*/
};
} // namespace devilution
