/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import layout.SpringUtilities;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.eyecandy.TranslucentJTextField;
import net.yura.lobby.model.PlayerInfo;

public class PlayerInfoWindow
extends JDialog
implements ActionListener {
    private Connection connection;
    private String name;
    private JComponent top;
    private JPanel center;
    private JPanel bottom;
    private JTextField nameField;
    private JButton setNick;
    private JButton saveButton;
    private List playerInfoObjects;

    public PlayerInfoWindow(Component owner, Connection con, boolean model) {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, owner), model);
        this.connection = con;
        this.top = new Box(1);
        this.getContentPane().add((Component)this.top, "North");
        this.center = new JPanel(new SpringLayout());
        this.center.add(new JLabel("Loading..."));
        this.getContentPane().add(new JScrollPane(this.center));
        this.nameField = new JTextField();
        this.nameField.setColumns(15);
        JButton closeButton = new JButton("close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(closeButton);
        this.bottom = new JPanel();
        this.bottom.add(closeButton);
        this.getContentPane().add((Component)this.bottom, "South");
        this.setNick = new JButton("set nick");
        this.setNick.setActionCommand("setNick");
        this.setNick.addActionListener(this);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PlayerInfoWindow.this.setVisible(false);
            }
        });
    }

    public void setUsername(String name) {
        this.name = name;
        this.setTitle("Info: " + name);
        this.nameField.setText(name);
    }

    public void showPanels(boolean me, boolean mod) {
        this.top.removeAll();
        if (me) {
            JPanel normal = new JPanel();
            normal.add(new JLabel("Nickname:"));
            normal.add(this.nameField);
            normal.add(this.setNick);
            this.top.add(normal);
        } else if (mod) {
            this.top.add(this.makeAdminPanel("renameUser", "REQUEST_RENAME_USER", "oldName", new Param("newName", String.class, this.name)));
            this.top.add(this.makeAdminPanel("setUserType", "REQUEST_SET_USER_TYPE", "username", new Param("userType", Integer.TYPE, "int")));
            this.top.add(this.makeAdminPanel("resignUserFromAllGames", "REQUEST_RESIGN_FROM_ALL_GAMES", "username", new Param[0]));
            this.top.add(this.makeAdminPanel("flagUser", "REQUEST_FLAG_USER", "username", new Param[0]));
        }
    }

    public void updateInfo(List list) {
        this.playerInfoObjects = list;
        this.center.removeAll();
        boolean edit = false;
        for (int c = 0; c < list.size(); ++c) {
            PlayerInfo playerInfo = (PlayerInfo)list.get(c);
            this.center.add(new JLabel(playerInfo.getLabel(), 11));
            TranslucentJTextField valueTextBox = new TranslucentJTextField(1.0f);
            valueTextBox.setText(playerInfo.getInfo());
            if (playerInfo.getCanEdit()) {
                edit = true;
            } else {
                valueTextBox.setEditable(false);
                valueTextBox.setBorder(null);
            }
            this.center.add(valueTextBox);
        }
        if (this.saveButton == null && edit) {
            this.saveButton = new JButton("Save");
            this.saveButton.setActionCommand("save");
            this.saveButton.addActionListener(this);
            this.bottom.add(this.saveButton);
        } else if (this.saveButton != null && !edit) {
            this.bottom.remove(this.saveButton);
            this.saveButton = null;
        }
        SpringUtilities.makeCompactGrid(this.center, list.size(), 2, 3, 3, 10, 3);
        this.center.revalidate();
        this.center.repaint();
        this.bottom.revalidate();
        this.bottom.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("close")) {
            this.setVisible(false);
        } else if (ae.getActionCommand().equals("save")) {
            ArrayList<PlayerInfo> list = new ArrayList<PlayerInfo>();
            for (int c = 0; c < this.playerInfoObjects.size(); ++c) {
                PlayerInfo playerInfo = (PlayerInfo)this.playerInfoObjects.get(c);
                if (!playerInfo.getCanEdit()) continue;
                Component component = this.center.getComponent((c + 1) * 2 - 1);
                if (component instanceof JTextComponent) {
                    playerInfo.setInfo(((JTextComponent)component).getText());
                }
                list.add(playerInfo);
            }
            this.setVisible(false);
        } else if (ae.getActionCommand().equals("setNick")) {
            this.connection.setNick(this.nameField.getText());
        } else {
            System.err.println("unknown action " + ae.getActionCommand());
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.connection.getPlayerInfo(this.name);
        }
    }

    private JPanel makeAdminPanel(String label, final String command, final String usernameParamName, final Param ... param) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(label + " ("));
        final JTextField[] boxes = new JTextField[param.length];
        for (int c = 0; c < param.length; ++c) {
            if (c != 0) {
                panel.add(new JLabel(","));
            }
            panel.add(new JLabel(param[c].name + "="));
            JTextField box = new JTextField(param[c].hint);
            box.setMinimumSize(new Dimension(100, box.getMinimumSize().height));
            box.setPreferredSize(new Dimension(100, box.getPreferredSize().height));
            boxes[c] = box;
            panel.add(box);
        }
        panel.add(new JLabel(")"));
        JButton action = new JButton(label);
        panel.add(action);
        action.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(usernameParamName, PlayerInfoWindow.this.name);
                for (int c = 0; c < param.length; ++c) {
                    if (param[c].clas == String.class) {
                        params.put(param[c].name, boxes[c].getText());
                        continue;
                    }
                    if (param[c].clas == Integer.TYPE) {
                        params.put(param[c].name, Integer.parseInt(boxes[c].getText()));
                        continue;
                    }
                    throw new IllegalStateException("unknown param type " + param[c].clas);
                }
                PlayerInfoWindow.this.connection.sendAdminCommand(command, params);
            }
        });
        return panel;
    }

    static class Param {
        public final String name;
        public final Class clas;
        public final String hint;

        public Param(String name, Class clas, String hint) {
            this.name = name;
            this.clas = clas;
            this.hint = hint;
        }
    }
}

