/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class SimplePreferences
extends Preferences {
    private final File file;
    private final String description;
    private final Properties prop = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimplePreferences(File file, String description) {
        this.file = file;
        this.description = description;
        if (description.contains("\n")) {
            throw new IllegalArgumentException("can not have new line in description");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.prop.load(inputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void put(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public String get(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    public void remove(String key) {
        this.prop.remove(key);
    }

    public void clear() throws BackingStoreException {
        this.prop.clear();
    }

    public void putInt(String key, int value) {
        this.prop.setProperty(key, String.valueOf(value));
    }

    public int getInt(String key, int defaultValue) {
        return Integer.parseInt(this.prop.getProperty(key, String.valueOf(defaultValue)));
    }

    public void putLong(String key, long value) {
        this.prop.setProperty(key, String.valueOf(value));
    }

    public long getLong(String key, long defaultValue) {
        return Long.parseLong(this.prop.getProperty(key, String.valueOf(defaultValue)));
    }

    public void putBoolean(String key, boolean value) {
        this.prop.setProperty(key, String.valueOf(value));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.prop.getProperty(key, String.valueOf(defaultValue)));
    }

    public void putFloat(String key, float value) {
        this.prop.setProperty(key, String.valueOf(value));
    }

    public float getFloat(String key, float defaultValue) {
        return Float.parseFloat(this.prop.getProperty(key, String.valueOf(defaultValue)));
    }

    public void putDouble(String key, double value) {
        this.prop.setProperty(key, String.valueOf(value));
    }

    public double getDouble(String key, double defaultValue) {
        return Double.parseDouble(this.prop.getProperty(key, String.valueOf(defaultValue)));
    }

    public void putByteArray(String key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        throw new UnsupportedOperationException();
    }

    public String[] keys() throws BackingStoreException {
        return this.prop.keySet().toArray(new String[0]);
    }

    public String toString() {
        return this.prop.toString();
    }

    public void flush() throws BackingStoreException {
        try {
            this.prop.store(new FileOutputStream(this.file), this.description);
        }
        catch (Exception ex) {
            throw new BackingStoreException(ex);
        }
    }

    public void sync() throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public String[] childrenNames() throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public Preferences parent() {
        throw new UnsupportedOperationException();
    }

    public Preferences node(String s) {
        throw new UnsupportedOperationException();
    }

    public boolean nodeExists(String s) throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public void removeNode() throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public String name() {
        throw new UnsupportedOperationException();
    }

    public String absolutePath() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserNode() {
        throw new UnsupportedOperationException();
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
        throw new UnsupportedOperationException();
    }
}

