/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Component;

public class Icon {
    protected int px;
    protected int py;
    protected int width;
    protected int height;
    private Object image;

    public Icon() {
    }

    public Icon(Image img) {
        this.initImage(img);
    }

    public Icon(String imageName) {
        this.initImage(Application.createImage(imageName));
    }

    private void initImage(Image img) {
        this.image = img;
        if (img != null) {
            this.height = img.getHeight();
            this.width = img.getWidth();
        } else {
            this.width = -1;
            this.height = -1;
        }
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics2D g, int x, int y) {
        if (this.image instanceof Image) {
            g.drawRegion((Image)this.image, this.px, this.py, this.width, this.height, x, y);
        }
    }

    public Image getImage() {
        if (this.image instanceof Image) {
            Image img = (Image)this.image;
            if (this.px == 0 && this.py == 0 && this.width == img.getWidth() && this.height == img.getHeight()) {
                return img;
            }
            img = Image.createImage((Image)img, (int)this.px, (int)this.py, (int)this.width, (int)this.height, (int)0);
            this.image = img;
            this.px = 0;
            this.py = 0;
            return img;
        }
        return null;
    }

    public Icon getSubimage(int x, int y, int w, int h) {
        Icon i = new Icon((Image)this.image);
        i.px = this.px + x;
        i.py = this.py + y;
        i.width = w;
        i.height = h;
        return i;
    }
}

