/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.border.EmptyBorder;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.plaf.Style;
import net.yura.mobile.logging.Logger;

public abstract class Component {
    protected int posX;
    protected int posY;
    protected int width;
    protected int height;
    protected boolean focusable = this.getDefaultEnabled();
    protected Component parent;
    private String name;
    protected Style theme;
    protected int background = 0;
    protected int foreground = 0;
    private Border border;
    private String tooltip;
    private boolean visible = true;
    protected int preferredWidth = -1;
    protected int preferredHeight = -1;
    public static final int FOCUS_GAINED = 1004;
    public static final int FOCUS_LOST = 1005;
    private ChangeListener focusListener;
    protected Window popup;
    public static final Border empty = new EmptyBorder(0, 0, 0, 0);
    int state = -1;

    public Component() {
        this.updateUI();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void addFocusListener(ChangeListener lis) {
        if (this.focusListener != null) {
            Logger.warn("trying to add a FocusListener when there is already one registered");
            Logger.dumpStack();
        }
        if (lis == null) {
            Logger.warn("trying to add a null FocusListener");
            Logger.dumpStack();
        }
        this.focusListener = lis;
    }

    public void removeFocusListener(ChangeListener lis) {
        if (lis == this.focusListener) {
            this.focusListener = null;
        } else {
            Logger.warn("trying to remove a FocusListener that is not registered");
            Logger.dumpStack();
        }
        if (lis == null) {
            Logger.warn("trying to remove a null FocusListener");
            Logger.dumpStack();
        }
    }

    public ChangeListener[] getFocusListeners() {
        ChangeListener[] changeListenerArray;
        if (this.focusListener == null) {
            changeListenerArray = new ChangeListener[]{};
        } else {
            ChangeListener[] changeListenerArray2 = new ChangeListener[1];
            changeListenerArray = changeListenerArray2;
            changeListenerArray2[0] = this.focusListener;
        }
        return changeListenerArray;
    }

    public void setPreferredSize(int w, int h) {
        this.preferredWidth = w;
        this.preferredHeight = h;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setName(String n) {
        this.name = n;
        this.updateUI();
    }

    public String getName() {
        return this.name == null ? this.getDefaultName() : this.name;
    }

    protected abstract String getDefaultName();

    protected abstract boolean getDefaultEnabled();

    public boolean isFocusOwner() {
        Window myWindow = this.getWindow();
        return myWindow != null && myWindow.isFocused() && myWindow.getFocusOwner() == this;
    }

    public void requestFocusInWindow() {
        Window w = this.getWindow();
        if (w != null) {
            w.setFocusedComponent(this);
        }
    }

    public boolean isFocusable() {
        if (!this.isVisible()) {
            return false;
        }
        return this.focusable;
    }

    public void setFocusable(boolean selectable) {
        boolean old = this.focusable;
        this.focusable = selectable;
        Window w = this.getWindow();
        if (w != null) {
            w.setupFocusedComponent();
        }
        if (old != this.focusable) {
            this.repaint();
        }
    }

    public void transferFocus(int direction) {
        ((Panel)this.parent).breakOutAction(this, direction, true, false);
    }

    public void add(Component component) {
        this.addImpl(component, null, -1);
    }

    public void add(Component component, int constraint) {
        this.addImpl(component, new Integer(constraint), -1);
    }

    public void add(Component component, Object constraint) {
        this.addImpl(component, constraint, -1);
    }

    public void insert(Component component, int index) {
        this.addImpl(component, null, index);
    }

    public void insert(Component component, Object constraint, int index) {
        this.addImpl(component, constraint, index);
    }

    protected void addImpl(Component component, Object cons, int index) {
        if (component instanceof Window) {
            throw new RuntimeException("trying to add a window to a Component: " + component + " to " + this);
        }
        if (component.parent != null) {
            Logger.warn("this component already has a parent " + component + " PARENT=" + component.parent);
            Logger.dumpStack();
        }
        component.parent = this;
    }

    public void removeParent(Component p) {
        if (this.parent == p) {
            this.parent = null;
        }
    }

    public Component getParent() {
        return this.parent;
    }

    public Window getWindow() {
        return (Window)DesktopPane.getAncestorOfClass(Window.class, this);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLocation(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public void setBounds(int x, int y, int w, int h) {
        Border insets = this.getInsets();
        this.setLocation(x + insets.getLeft(), y + insets.getTop());
        this.setSize(w - (insets.getRight() + insets.getLeft()), h - (insets.getTop() + insets.getBottom()));
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXWithBorder() {
        Border insets = this.getInsets();
        return this.getX() - insets.getLeft();
    }

    public int getYWithBorder() {
        Border insets = this.getInsets();
        return this.getY() - insets.getTop();
    }

    public int getWidthWithBorder() {
        Border insets = this.getInsets();
        return this.getWidth() + insets.getRight() + insets.getLeft();
    }

    public int getHeightWithBorder() {
        Border insets = this.getInsets();
        return this.getHeight() + insets.getTop() + insets.getBottom();
    }

    public void paint(Graphics2D g) {
        this.paintBorder(g);
        int back = this.getBackground();
        if (!Graphics2D.isTransparent(back)) {
            g.setColor(back);
            g.fillRect(0, 0, this.width, this.height);
        }
        this.paintComponent(g);
    }

    protected void paintBorder(Graphics2D g) {
        Border b = this.getBorder();
        if (b != null) {
            b.paintBorder(this, g, this.width, this.height);
        }
    }

    public Border getInsets() {
        Border b = this.getBorder();
        return b == null ? empty : b;
    }

    public final int getBackground() {
        if (this.background != 0) {
            return this.background;
        }
        return this.theme.getBackground(this.getCurrentState());
    }

    public final Border getBorder() {
        if (this.border != null) {
            return this.border;
        }
        return this.theme.getBorder(this.getCurrentState());
    }

    public final int getForeground() {
        if (this.foreground != 0) {
            return this.foreground;
        }
        int f = this.theme.getForeground(this.getCurrentState());
        if (f != 0 || this.parent == null) {
            return f;
        }
        return this.parent.getForeground();
    }

    public abstract void paintComponent(Graphics2D var1);

    public boolean processKeyEvent(KeyEvent keypad) {
        return false;
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent buttons) {
        Window popup = this.getPopupIfTriggered(type, buttons);
        if (popup != null && !popup.isVisible()) {
            popup.show(this, x + this.getXOnScreen(), y + this.getYOnScreen());
            return;
        }
        if (this.focusable) {
            if (type == 1 && !this.isFocusOwner() && this.isVisible()) {
                this.requestFocusInWindow();
            }
        } else if (this.parent != null) {
            this.parent.processMouseEvent(type, this.posX + x, this.posY + y, buttons);
        }
    }

    protected Window getPopupIfTriggered(int mouseEventType, KeyEvent buttons) {
        return mouseEventType == 2 && buttons.isDownKey(-51) ? this.getPopupMenu() : null;
    }

    public void processMultitouchEvent(int[] type, int[] x, int[] y) {
        if (this.parent != null) {
            for (int c = 0; c < type.length; ++c) {
                x[c] = x[c] + this.posX;
                y[c] = y[c] + this.posY;
            }
            this.parent.processMultitouchEvent(type, x, y);
        }
    }

    public boolean consumesMotionEvents() {
        if (this.parent != null) {
            return this.parent.consumesMotionEvents();
        }
        return false;
    }

    public void run() throws InterruptedException {
    }

    public void animate() {
    }

    public void focusGained() {
        if (this.focusListener != null) {
            this.focusListener.changeEvent(this, 1004);
        }
        this.makeVisible();
        this.repaint();
    }

    public void focusLost() {
        if (this.focusListener != null) {
            this.focusListener.changeEvent(this, 1005);
        }
        this.repaint();
    }

    public void makeVisible() {
        Border insets = this.getInsets();
        this.scrollRectToVisible(-insets.getLeft(), -insets.getTop(), this.getWidthWithBorder(), this.getHeightWithBorder(), false);
    }

    public boolean isComponentVisible() {
        Border insets = this.getInsets();
        return this.isRectVisible(-insets.getLeft(), -insets.getTop(), this.getWidthWithBorder(), this.getHeightWithBorder());
    }

    protected abstract void workoutMinimumSize();

    public final void workoutPreferredSize() {
        this.workoutMinimumSize();
        if (this.getDefaultEnabled()) {
            int minimumTouchTarget = this.getDesktopPane().minimumTouchTarget;
            Border insets = this.getInsets();
            if (this.getWidthWithBorder() < minimumTouchTarget) {
                this.width = minimumTouchTarget - insets.getLeft() - insets.getRight();
            }
            if (this.getHeightWithBorder() < minimumTouchTarget) {
                this.height = minimumTouchTarget - insets.getTop() - insets.getBottom();
            }
        }
        if (this.preferredWidth != -1) {
            this.width = this.preferredWidth;
        }
        if (this.preferredHeight != -1) {
            this.height = this.preferredHeight;
        }
    }

    public void setBackground(int a) {
        this.background = a;
    }

    public boolean isOpaque() {
        if (Graphics2D.isOpaque(this.getBackground())) {
            return true;
        }
        Border b = this.getBorder();
        if (b != null) {
            return b.isBorderOpaque();
        }
        return false;
    }

    public boolean isShowing() {
        return this.isVisible() && this.parent != null && this.parent.isShowing();
    }

    public void repaint() {
        this.getDesktopPane().repaintComponent(this);
    }

    public String toString() {
        return this.getName() + (this.popup != null ? "<pop=" + this.popup.toString() + ">" : "");
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public int getXOnScreen() {
        int x = this.posX;
        Component p = this.parent;
        while (p != null) {
            x += p.posX;
            p = p.parent;
        }
        return x;
    }

    public int getYOnScreen() {
        int y = this.posY;
        Component p = this.parent;
        while (p != null) {
            y += p.posY;
            p = p.parent;
        }
        return y;
    }

    public void wait(int a) throws InterruptedException {
        this.getDesktopPane().aniWait(this, a);
    }

    public void setForeground(int foreground) {
        this.foreground = foreground;
    }

    public boolean scrollRectToVisible(int x, int y, int w, int h, boolean smart) {
        if (this.parent != null) {
            return this.parent.scrollRectToVisible(this.posX + x, this.posY + y, w, h, smart);
        }
        return true;
    }

    public boolean isRectVisible(int x, int y, int w, int h) {
        if (this.parent != null) {
            return this.parent.isRectVisible(this.posX + x, this.posY + y, w, h);
        }
        return true;
    }

    public void updateUI() {
        this.theme = DesktopPane.getDefaultTheme(this);
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public void setToolTipText(String text) {
        this.tooltip = text;
    }

    public int getToolTipLocationX() {
        return 5;
    }

    public int getToolTipLocationY() {
        return 5;
    }

    public void revalidate() {
        this.getDesktopPane().revalidateComponent(this);
    }

    public void validate() {
    }

    public void setValue(Object obj) {
    }

    public Object getValue() {
        return null;
    }

    public void setState(int state) {
        this.state = state;
    }

    public final int getCurrentState() {
        return this.state == -1 ? this.getState() : this.state;
    }

    protected int getState() {
        int result = 0;
        if (!this.focusable) {
            result |= 2;
        }
        if (this.isFocusOwner()) {
            result |= 4;
        }
        return result;
    }

    public void setupState(Component component, boolean isSelected, boolean cellHasFocus) {
        this.state = 0;
        if (cellHasFocus) {
            this.state |= 4;
        } else if (component != null && !component.isFocusable()) {
            this.state |= 2;
        }
        if (isSelected) {
            this.state |= 8;
        }
    }

    public void computeVisibleRect(int[] v) {
        if (v[2] != 0) {
            if (this.parent != null) {
                this.parent.computeVisibleRect(v);
            }
        } else if (v[0] != 0 || v[1] != 0 || v[3] != 0) {
            throw new RuntimeException("if visible width is 0, all other values should be 0 values=[" + v[0] + " " + v[1] + " " + v[2] + " " + v[3] + "]");
        }
    }

    public int[] getVisibleRect() {
        int[] v = new int[4];
        Border insets = this.getInsets();
        int xs = this.getXOnScreen();
        int ys = this.getYOnScreen();
        v[0] = xs - insets.getLeft();
        v[1] = ys - insets.getTop();
        v[2] = this.getWidthWithBorder();
        v[3] = this.getHeightWithBorder();
        if (v[2] > 0 && v[3] > 0) {
            if (this.parent != null) {
                this.parent.computeVisibleRect(v);
            }
            if (v[2] > 0) {
                v[0] = v[0] - xs;
                v[1] = v[1] - ys;
            }
        } else {
            v[3] = 0;
            v[2] = 0;
            v[1] = 0;
            v[0] = 0;
        }
        if (!(v[2] > 0 && v[3] > 0 || v[0] == 0 && v[1] == 0 && v[2] == 0 && v[3] == 0)) {
            throw new RuntimeException("invalid result");
        }
        return v;
    }

    public DesktopPane getDesktopPane() {
        Window w = this.getWindow();
        if (w != null) {
            return w.getDesktopPane();
        }
        return DesktopPane.getDesktopPane();
    }

    public void setPopupMenu(Window component) {
        this.popup = component;
    }

    public Window getPopupMenu() {
        return this.popup;
    }
}

