/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.celleditor.TableCellEditor;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.CheckBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.RadioButton;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.Table;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.ImageUtil;

public class FileChooser
extends Frame
implements Runnable,
ActionListener {
    public static final String NO_FILE_SELECTED = "no_file_selected";
    private FileUtil fileSystemView;
    private SelectableFileRenderer thumbOptionRenderer;
    private List fileList;
    private GridList fileTable;
    private Window contextPopup;
    private ActionListener actionListener;
    private String action;
    private String dir;
    private int filter = 0;
    private boolean multiSelect;
    private Button doneButton;
    private ScrollPane scroll;
    private Vector files;
    private Vector lastFewImages;
    private int thumbSize;
    private RadioButton showAll;
    private RadioButton showNew;
    private RadioButton listView;
    private RadioButton gridView;
    private Label addressBar;
    private int hardImages = 15;
    private final Vector requestImage = new Vector();

    public FileChooser() {
        this(new FileUtil());
    }

    public FileChooser(FileUtil fileSystemView) {
        this.fileSystemView = fileSystemView;
        this.dir = fileSystemView.getRoots();
        this.setName("Dialog");
        this.addressBar = new Label(this.dir);
        this.scroll = new ScrollPane();
        Panel mainPanel = new Panel(new BorderLayout());
        mainPanel.add((Component)this.addressBar, 16);
        mainPanel.add(this.scroll);
        this.setContentPane(mainPanel);
        Menu mainMenu = new Menu((String)DesktopPane.get("menuText"));
        mainMenu.setActionCommand("mainMenu");
        mainMenu.addActionListener(this);
        this.doneButton = new Button();
        this.doneButton.setActionCommand("done");
        this.doneButton.addActionListener(this);
        mainMenu.add(this.doneButton);
        Menu showMenu = new Menu((String)DesktopPane.get("showText"));
        ButtonGroup group1 = new ButtonGroup();
        this.showAll = this.addMenuCheckBox(showMenu, group1, (String)DesktopPane.get("allText"), "show", true);
        this.showNew = this.addMenuCheckBox(showMenu, group1, (String)DesktopPane.get("newText"), "show", false);
        mainMenu.add(showMenu);
        Menu viewMenu = new Menu((String)DesktopPane.get("viewText"));
        ButtonGroup group2 = new ButtonGroup();
        this.listView = this.addMenuCheckBox(viewMenu, group2, (String)DesktopPane.get("listText"), "view", true);
        this.gridView = this.addMenuCheckBox(viewMenu, group2, (String)DesktopPane.get("gridText"), "view", false);
        mainMenu.add(viewMenu);
        Button close = new Button((String)DesktopPane.get("cancelText"));
        close.setActionCommand("cancel");
        close.addActionListener(this);
        close.setMnemonic(-11);
        MenuBar bar = new MenuBar();
        this.setMenuBar(bar);
        if (Application.getPlatform() == 12 || Application.getPlatform() == 10) {
            bar.add(close);
            bar.addGlue();
            bar.add(mainMenu);
        } else {
            bar.add(mainMenu);
            bar.addGlue();
            bar.add(close);
        }
        this.files = new Vector(0);
        this.lastFewImages = new Vector();
        this.thumbOptionRenderer = new SelectableFileRenderer();
        this.contextPopup = Menu.makePopup();
        MenuBar contextMenu = Menu.getPopupMenu(this.contextPopup);
        Button delButton = new Button((String)DesktopPane.get("deleteText"));
        delButton.setActionCommand("del");
        delButton.addActionListener(this);
        contextMenu.add(delButton);
    }

    public FileChooser(String string) {
        this();
        this.setCurrentDirectory(string);
    }

    public void doLayout() {
        this.calcThumbSize(this.width, this.height);
        super.doLayout();
        this.calcHardImages();
    }

    private void calcThumbSize(int w, int h) {
        if (this.gridView.isSelected()) {
            this.thumbSize = (h > w ? w : h) / 10 + XULLoader.adjustSizeToDensity(30);
            this.fileTable.setRowHeight(this.thumbSize + XULLoader.adjustSizeToDensity(5));
        } else {
            int extraPadding = 6;
            int rowHeight = this.thumbOptionRenderer.getFont().getHeight() + extraPadding;
            if (rowHeight < this.getDesktopPane().minimumTouchTarget) {
                rowHeight = this.getDesktopPane().minimumTouchTarget;
            }
            this.thumbSize = rowHeight - extraPadding;
            this.fileList.setFixedCellHeight(rowHeight);
        }
    }

    private void calcHardImages() {
        this.hardImages = this.gridView.isSelected() ? this.fileTable.getColumnCount() * this.getHeight() / this.fileTable.getRowHeight(0) : this.getHeight() / this.fileList.getFixedCellHeight();
        Logger.debug("hardImages = " + this.hardImages);
    }

    public void setCurrentDirectory(String string) {
        int index = string.indexOf("/../");
        while (index != -1) {
            string = string.substring(0, string.lastIndexOf(47, index - 1)) + string.substring(index + 3);
            index = string.indexOf("/../");
        }
        this.dir = string;
        this.addressBar.setText(this.dir);
    }

    private RadioButton addMenuCheckBox(Menu m, ButtonGroup g, String l, String a, boolean sel) {
        RadioButton rb = new RadioButton(l);
        if (sel) {
            rb.setSelected(true);
        }
        rb.setActionCommand(a);
        g.add(rb);
        m.add(rb);
        rb.addActionListener(this);
        return rb;
    }

    public void setMultiSelectionEnabled(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setShowRecent(boolean recent) {
        if (recent) {
            this.showNew.setSelected(true);
        } else {
            this.showAll.setSelected(true);
        }
    }

    public void setGridView(boolean g) {
        if (g) {
            this.gridView.setSelected(true);
        } else {
            this.listView.setSelected(true);
        }
    }

    public void setFileFilter(int f) {
        this.filter = f;
    }

    public void showDialog(ActionListener al, String action, String title, String approveButtonText) {
        this.actionListener = al;
        this.action = action;
        this.setTitle(title);
        this.doneButton.setText(approveButtonText);
        this.setMaximum(true);
        this.setUpView();
        this.setVisible(true);
        this.startFileLoadingThread();
    }

    private void setUpView() {
        this.scroll.removeAll();
        if (this.gridView.isSelected()) {
            if (this.fileTable == null) {
                this.fileTable = new GridList(10);
                SelectableFileRenderer editor = new SelectableFileRenderer();
                editor.addActionListener(this);
                editor.setActionCommand("tableClick");
                this.fileTable.setDefaultEditor(SelectableFile.class, editor);
                this.fileTable.setDefaultRenderer(SelectableFile.class, this.thumbOptionRenderer);
            }
            this.fileTable.setSelectedValues(this.multiSelect ? new Vector() : null);
            this.setFileList(this.files);
            this.scroll.add(this.fileTable);
        } else {
            if (this.fileList == null) {
                this.fileList = new List();
                this.fileList.setCellRenderer(this.thumbOptionRenderer);
                this.fileList.setActionCommand("listSelect");
                this.fileList.addActionListener(this);
                if (Application.getPlatform() == 8) {
                    this.fileList.setDoubleClick(true);
                }
            }
            this.fileList.setSelectedValues(this.multiSelect ? new Vector() : null);
            this.setFileList(this.files);
            this.scroll.add(this.fileList);
        }
        this.calcThumbSize(this.getWidth(), this.getHeight());
        this.revalidate();
        this.repaint();
    }

    private void setFileList(Vector files) {
        boolean empty = files.isEmpty();
        if (this.gridView.isSelected()) {
            this.fileTable.setListData(files);
            this.fileTable.setPopupMenu(empty ? null : this.contextPopup);
        } else {
            this.fileList.setListData(files);
            this.fileList.setPopupMenu(empty ? null : this.contextPopup);
        }
    }

    private void startFileLoadingThread() {
        this.files.removeAllElements();
        new Thread((Runnable)this, "File-Chooser").start();
    }

    private void startImageLoadingThread(SelectableFile file) {
        boolean doStart = this.requestImage.isEmpty();
        if (!this.requestImage.contains(file)) {
            this.requestImage.addElement(file);
        }
        if (doStart) {
            new Thread(this).start();
        }
    }

    private void yield() {
        try {
            Thread.yield();
            Thread.sleep(0L);
        }
        catch (InterruptedException ex) {
            Logger.info(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Logger.debug("FC START");
            Thread.currentThread().setPriority(1);
            if (this.files.isEmpty()) {
                this.requestImage.removeAllElements();
                Vector fileNames = this.fileSystemView.listFiles(this.dir, this.filter, this.showNew.isSelected());
                for (int c = 0; c < fileNames.size(); ++c) {
                    String name = (String)fileNames.elementAt(c);
                    SelectableFile tbo = new SelectableFile(name);
                    this.files.addElement(tbo);
                }
                if (this.gridView.isSelected()) {
                    this.fileTable.setSelectedIndex(-1);
                    this.setFileList(this.files);
                    if (!this.getDesktopPane().DEFAULT_NO_FOCUS) {
                        this.fileTable.setSelectedIndex(0);
                    }
                    this.fileTable.setLocation(this.scroll.getViewPortX(), this.scroll.getViewPortY());
                } else {
                    this.fileList.setSelectedIndex(-1);
                    this.setFileList(this.files);
                    if (!this.getDesktopPane().DEFAULT_NO_FOCUS) {
                        this.fileList.setSelectedIndex(0);
                    }
                    this.fileList.setLocation(this.scroll.getViewPortX(), this.scroll.getViewPortY());
                }
                this.revalidate();
                this.repaint();
                Logger.debug("FC END 1");
                return;
            }
            while (true) {
                SelectableFile file;
                Vector c = this.requestImage;
                synchronized (c) {
                    if (this.requestImage.isEmpty() || this.files.isEmpty()) {
                        Logger.debug("FC END 2");
                        return;
                    }
                    file = (SelectableFile)this.requestImage.firstElement();
                }
                String absoultePath = file.getAbsolutePath();
                this.yield();
                Image image = ImageUtil.getThumbnailFromFile(absoultePath);
                if (image == null) {
                    this.yield();
                    image = ImageUtil.getImageFromFile(absoultePath);
                }
                int th = this.thumbSize;
                if (image != null) {
                    this.yield();
                    image = ImageUtil.scaleImage(image, th, th);
                }
                Vector vector = this.requestImage;
                synchronized (vector) {
                    if (image != null) {
                        file.thumb = new WeakReference<Icon>(new Icon(image));
                    } else {
                        file.loadFailed = true;
                    }
                    file.currentThumbSize = th;
                    if (!this.requestImage.isEmpty()) {
                        this.requestImage.removeElementAt(0);
                    }
                }
                this.repaint();
            }
        }
        catch (Throwable t) {
            Logger.warn("fatal error in FileChooser thread", t);
            return;
        }
    }

    public Vector getSelectedFiles() {
        Vector<String> rs = new Vector<String>();
        Vector dataVector = this.gridView.isSelected() ? this.fileTable.getSelectedValues() : this.fileList.getSelectedValues();
        Enumeration en = dataVector.elements();
        while (en.hasMoreElements()) {
            SelectableFile tbOpt = (SelectableFile)en.nextElement();
            rs.addElement(tbOpt.getAbsolutePath());
        }
        return rs;
    }

    public String getSelectedFile() {
        SelectableFile tbOpt = this.gridView.isSelected() ? (SelectableFile)this.fileTable.getSelectedValue() : (SelectableFile)this.fileList.getSelectedValue();
        return tbOpt == null ? null : tbOpt.getAbsolutePath();
    }

    public void actionPerformed(String myaction) {
        if ("cancel".equals(myaction)) {
            this.setVisible(false);
            this.lastFewImages.removeAllElements();
            this.actionListener.actionPerformed(NO_FILE_SELECTED);
        } else if ("mainMenu".equals(myaction)) {
            if (this.fileTable != null) {
                this.fileTable.removeEditor();
            }
            this.doneButton.setFocusable(this.multiSelect && this.getSelectedFiles().size() > 0 || !this.multiSelect && this.getSelectedFile() != null && (this.filter == 1 || !FileUtil.isFileType(this.getSelectedFile(), 1)));
        } else if ("done".equals(myaction)) {
            this.actionListener.actionPerformed(this.action);
            this.setVisible(false);
            this.lastFewImages.removeAllElements();
        } else if ("view".equals(myaction)) {
            this.setUpView();
        } else if ("show".equals(myaction)) {
            this.startFileLoadingThread();
        } else if ("listSelect".equals(myaction)) {
            SelectableFile to = (SelectableFile)this.fileList.getSelectedValue();
            if (to != null) {
                if (FileUtil.isFileType(to.getAbsolutePath(), 1)) {
                    this.gotoDir(to);
                } else if (this.multiSelect) {
                    Vector selectedItems = this.fileList.getSelectedValues();
                    if (selectedItems.contains(to)) {
                        selectedItems.removeElement(to);
                    } else {
                        selectedItems.addElement(to);
                    }
                    this.fileList.repaint();
                } else {
                    this.actionPerformed("done");
                }
            }
        } else if ("tableClick".equals(myaction)) {
            SelectableFile to = (SelectableFile)this.fileTable.getSelectedValue();
            if (FileUtil.isFileType(to.getAbsolutePath(), 1)) {
                this.gotoDir(to);
            } else if (this.multiSelect) {
                Vector selectedItems = this.fileTable.getSelectedValues();
                if (selectedItems.contains(to)) {
                    selectedItems.removeElement(to);
                } else {
                    selectedItems.addElement(to);
                }
                this.fileTable.repaint();
            } else {
                this.actionPerformed("done");
            }
        } else if ("del".equals(myaction)) {
            Vector filesToDel = this.getSelectedFiles();
            for (int c = 0; c < filesToDel.size(); ++c) {
                String fileToDel = (String)filesToDel.elementAt(c);
                this.fileSystemView.deleteFile(fileToDel);
            }
            this.startFileLoadingThread();
        } else {
            Logger.warn("unknown action in file browser: " + myaction);
        }
    }

    private void gotoDir(SelectableFile to) {
        if (this.fileTable != null) {
            this.fileTable.removeEditor();
        }
        this.setCurrentDirectory(to.getAbsolutePath());
        this.startFileLoadingThread();
    }

    class SelectableFileRenderer
    extends CheckBox
    implements ListCellRenderer,
    TableCellEditor {
        private SelectableFile tbOption;
        private Icon folderIcon;
        private Icon unknownIcon;
        private Icon imageIcon;
        private Icon soundIcon;
        private Icon videoIcon;

        public SelectableFileRenderer() {
            this.setVerticalAlignment(32);
            this.setHorizontalAlignment(8);
        }

        public void paintComponent(Graphics2D g) {
            Icon img = this.tbOption.getIcon();
            if (img == null) {
                int id = FileUtil.getFileType(this.tbOption.getName());
                if (id == 1) {
                    img = this.folderIcon;
                } else if (id == 2) {
                    img = this.imageIcon;
                } else if (id == 3) {
                    img = this.soundIcon;
                } else if (id == 4) {
                    img = this.videoIcon;
                }
                if (img == null) {
                    img = this.unknownIcon;
                }
            }
            boolean dir = false;
            String name = this.tbOption.getName();
            int lastCharIdx = name.length() - 1;
            if (lastCharIdx >= 1 && name.charAt(lastCharIdx) == '/') {
                dir = true;
                name = name.substring(0, name.length() - 1);
            }
            g.setColor(this.getForeground());
            if (FileChooser.this.gridView.isSelected()) {
                this.paintIcon(g, dir, img, this.width, this.height);
                if (dir) {
                    g.setFont(this.font);
                    int length = this.font.getWidth(name);
                    if (length < this.width) {
                        g.drawString(name, (this.width - length) / 2, this.height - this.font.getHeight());
                    } else {
                        int offset = TextComponent.searchStringCharOffset(name, this.font, this.width - this.padding * 2 - this.font.getWidth(Label.extension));
                        g.drawString(name.substring(0, offset) + Label.extension, this.padding, this.height - this.font.getHeight());
                    }
                }
            } else {
                this.paintIcon(g, dir, img, FileChooser.this.thumbSize, this.height);
                g.setFont(this.font);
                g.drawString(name, FileChooser.this.thumbSize, (this.height - this.font.getHeight()) / 2);
            }
            if (FileChooser.this.multiSelect && !dir) {
                super.paintComponent(g);
            }
        }

        private void paintIcon(Graphics2D g, boolean dir, Icon img, int width, int height) {
            if (img != null) {
                img.paintIcon(this, g, (width - img.getIconWidth()) / 2, (height - img.getIconHeight()) / 2);
            } else {
                g.setFont(this.font);
                String folderIcon = dir ? "\ud83d\udcc1" : "\ud83d\udcc4";
                g.drawString(folderIcon, (width - this.font.getWidth(folderIcon)) / 2, (height - this.font.getHeight()) / 2);
            }
        }

        public Component getListCellRendererComponent(Component list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.tbOption = (SelectableFile)value;
            if (list instanceof GridList) {
                isSelected = ((GridList)list).isSelectedIndex(index);
            }
            this.setupState(list, isSelected, cellHasFocus);
            if (list != null) {
                list.setState(this.getCurrentState());
                this.setForeground(list.getForeground());
                list.setState(-1);
            }
            return this;
        }

        public Component getTableCellEditorComponent(Table table, Object value, boolean isSelected_IGNORE, int row, int column) {
            this.tbOption = (SelectableFile)value;
            GridList grid = (GridList)table;
            this.setSelected(grid.isSelectedIndex(grid.convertLin(row, column)));
            return this;
        }

        public Object getCellEditorValue() {
            return this.tbOption;
        }

        public String getDefaultName() {
            return "CheckBoxRenderer";
        }

        public void updateUI() {
            super.updateUI();
            this.folderIcon = (Icon)this.theme.getProperty("folderIcon", 0);
            this.unknownIcon = (Icon)this.theme.getProperty("unknownIcon", 0);
            this.imageIcon = (Icon)this.theme.getProperty("imageIcon", 0);
            this.soundIcon = (Icon)this.theme.getProperty("soundIcon", 0);
            this.videoIcon = (Icon)this.theme.getProperty("videoIcon", 0);
        }
    }

    class SelectableFile {
        private WeakReference thumb;
        private int currentThumbSize;
        private String filename;
        private boolean loadFailed;

        public SelectableFile(String name) {
            this.filename = name;
        }

        public String getAbsolutePath() {
            return FileChooser.this.dir + this.filename;
        }

        public String getName() {
            return this.filename;
        }

        public String getPath() {
            return FileChooser.this.dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Icon getIcon() {
            int type = FileUtil.getFileType(this.filename);
            if (type == 2) {
                Icon img;
                Vector vector = FileChooser.this.requestImage;
                synchronized (vector) {
                    Icon icon = img = this.currentThumbSize == FileChooser.this.thumbSize && this.thumb != null ? (Icon)this.thumb.get() : null;
                    if (img == null && !this.loadFailed) {
                        FileChooser.this.startImageLoadingThread(this);
                    }
                }
                if (img != null) {
                    if (!FileChooser.this.lastFewImages.contains(img)) {
                        FileChooser.this.lastFewImages.addElement(img);
                    }
                    if (FileChooser.this.lastFewImages.size() > FileChooser.this.hardImages) {
                        FileChooser.this.lastFewImages.removeElementAt(0);
                    }
                }
                return img;
            }
            return null;
        }
    }

    public static class GridList
    extends Table {
        private int widthUsed = -1;
        private Vector selected;

        public GridList(int cellSize) {
            this.setRowHeight(cellSize);
        }

        public String getDefaultName() {
            return "List";
        }

        public Object getSelectedValue() {
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            if (row == -1 && col == -1) {
                return null;
            }
            return this.getValueAt(row, col);
        }

        public int getSelectedIndex() {
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            if (row == -1 && col == -1) {
                return -1;
            }
            return this.convertLin(row, col);
        }

        public Vector getItems() {
            return this.dataVector;
        }

        public void setListData(Vector files) {
            this.dataVector = files;
        }

        private int convertLin(int rowIndex, int columnIndex) {
            return rowIndex * this.getColumnCount() + columnIndex;
        }

        public Class getColumnClass(int columnIndex) {
            return super.getColumnClass(0);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            int i = this.convertLin(rowIndex, columnIndex);
            if (i >= this.getSize()) {
                return null;
            }
            return this.getElementAt(i);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            int index = this.convertLin(rowIndex, columnIndex);
            return index < this.getSize();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.setElementAt(aValue, this.convertLin(rowIndex, columnIndex));
        }

        public int getColumnCount() {
            int cc = this.widthUsed / this.getRowHeight(0);
            return cc == 0 ? 1 : cc;
        }

        public int getRowCount() {
            int c = this.getColumnCount();
            return (this.getSize() + (c - 1)) / c;
        }

        public void setRowHeight(int h) {
            this.removeEditor();
            int index = this.getSelectedIndex();
            super.setRowHeight(h);
            this.setSelectedIndex(index);
        }

        protected void workoutMinimumSize() {
            if (this.getPreferredWidth() != -1) {
                this.widthUsed = this.width = this.getPreferredWidth();
                this.height = this.workoutHeight();
            } else if (this.widthUsed == -1) {
                this.width = this.getRowHeight(0);
                this.height = this.getRowHeight(0);
            } else {
                this.width = this.getRowHeight(0);
                this.height = this.workoutHeight();
            }
        }

        public void setSize(int w, int h) {
            super.setSize(w, h);
            if (this.width != this.widthUsed) {
                int oldh = this.height;
                this.removeEditor();
                int index = this.getSelectedIndex();
                this.widthUsed = this.width;
                this.setSelectedIndex(index);
                this.height = this.workoutHeight();
                if (this.height != oldh) {
                    DesktopPane.mySizeChanged(this);
                }
            }
        }

        public void setSelectedIndex(int a) {
            if (a == -1) {
                this.setSelectedCell(-1, -1);
            } else {
                this.setSelectedCell(a / this.getColumnCount(), a % this.getColumnCount());
            }
        }

        public Component prepareRenderer(int r, int c) {
            if (this.convertLin(r, c) >= this.getSize()) {
                return null;
            }
            return super.prepareRenderer(r, c);
        }

        private int[] getVisibleIndexs() {
            int[] v = this.getVisibleRect();
            int top = v[1];
            int bottom = v[1] + v[3] - 1;
            int h = this.getRowHeight(0);
            int row1 = top / h;
            int row2 = bottom / h;
            int rows = this.getRowCount();
            if (top > bottom || row1 < 0 && row2 < 0 || row1 >= rows && row2 >= rows) {
                row1 = -1;
                row2 = -1;
            } else {
                if (row1 < 0) {
                    row1 = 0;
                }
                if (row2 >= rows) {
                    row2 = rows - 1;
                }
            }
            if (!(v[2] > 0 && v[3] > 0 || row1 == -1 && row2 == -1)) {
                throw new RuntimeException("getVisibleIndexs wrong result " + row1 + " " + row2);
            }
            return new int[]{row1, row2};
        }

        public int getFirstVisibleIndex() {
            int r = this.getVisibleIndexs()[0];
            if (r == -1) {
                return -1;
            }
            return this.convertLin(r, 0);
        }

        public int getLastVisibleIndex() {
            int s;
            int r = this.getVisibleIndexs()[1];
            if (r == -1) {
                return -1;
            }
            int i = this.convertLin(r, this.getColumnCount() - 1);
            return i >= (s = this.getSize()) ? s - 1 : i;
        }

        public void fireActionPerformed() {
            if (this.editingRow >= 0 && this.editingColumn >= 0) {
                this.editCellAt(this.editingRow, this.editingColumn);
                if (this.editorComp instanceof Button) {
                    ((Button)this.editorComp).fireActionPerformed();
                }
            }
        }

        public Object getElementAt(int index) {
            return this.dataVector.elementAt(index);
        }

        public int getSize() {
            return this.dataVector.size();
        }

        public void setElementAt(Object object, int index) {
            this.dataVector.setElementAt(object, index);
        }

        public Vector getSelectedValues() {
            if (this.selected == null) {
                Vector<Object> v = new Vector<Object>(1);
                int current = this.getSelectedIndex();
                if (current >= 0) {
                    v.addElement(this.getElementAt(current));
                }
                return v;
            }
            return this.selected;
        }

        public void setSelectedValues(Vector v) {
            this.removeEditor();
            this.selected = v;
        }

        public boolean isSelectedIndex(int index) {
            return this.selected == null ? this.getSelectedIndex() == index : this.selected.contains(this.getElementAt(index));
        }

        public void clearSelection() {
            this.selected = null;
        }
    }
}

