/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Option;

public class Label
extends Component {
    public static String extension = "...";
    protected Font font;
    protected String string;
    protected Icon icon;
    protected int padding = XULLoader.adjustSizeToDensity(2);
    protected int gap = XULLoader.adjustSizeToDensity(2);
    protected int alignment;
    protected int textPosition;

    public Label() {
        this((String)null);
    }

    public Label(String text) {
        this.string = text == null ? "" : text;
        this.alignment = 6;
        this.textPosition = 10;
        this.updateUI();
    }

    public Label(Icon icon) {
        this();
        this.setIcon(icon);
        this.setHorizontalAlignment(1);
    }

    public Label(String text, Icon icon) {
        this(text);
        this.setIcon(icon);
    }

    protected String getDefaultName() {
        return "Label";
    }

    protected boolean getDefaultEnabled() {
        return false;
    }

    public void setMargin(int padding) {
        this.padding = padding;
    }

    public int getMargin() {
        return this.padding;
    }

    public void setText(String a) {
        String oldValue = this.string;
        this.string = a;
        if (this.string == null || oldValue == null || !this.string.equals(oldValue)) {
            this.repaint();
        }
    }

    public void setValue(Object obj) {
        String drawString = null;
        Icon image = null;
        String tip = null;
        if (obj instanceof Option) {
            Option option = (Option)obj;
            drawString = option.getValue();
            image = option.getIcon();
            tip = option.getToolTip();
        } else if (obj != null) {
            drawString = String.valueOf(obj);
        }
        this.setText(drawString);
        this.setIcon(image);
        this.setToolTipText(tip);
    }

    public String getText() {
        return this.string;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return (Icon)this.theme.getProperty("icon", 0);
    }

    public void setIcon(Icon icon) {
        Icon oldValue = this.icon;
        this.icon = icon;
        if (this.icon != oldValue) {
            this.repaint();
        }
    }

    public void setHorizontalTextPosition(int a) {
        this.textPosition = this.getVerticalTextPosition() | a;
    }

    public void setVerticalTextPosition(int a) {
        this.textPosition = a | this.getHorizontalTextPosition();
    }

    public void setHorizontalAlignment(int a) {
        this.alignment = this.getVerticalAlignment() | a;
    }

    public void setVerticalAlignment(int a) {
        this.alignment = a | this.getHorizontalAlignment();
    }

    public void setIconTextGap(int iconTextGap) {
        this.gap = iconTextGap;
    }

    public int getHorizontalTextPosition() {
        return (this.textPosition & 4) != 0 ? 4 : ((this.textPosition & 8) != 0 ? 8 : 1);
    }

    public int getVerticalTextPosition() {
        return (this.textPosition & 0x10) != 0 ? 16 : ((this.textPosition & 0x20) != 0 ? 32 : 2);
    }

    public int getHorizontalAlignment() {
        return (this.alignment & 4) != 0 ? 4 : ((this.alignment & 8) != 0 ? 8 : 1);
    }

    public int getVerticalAlignment() {
        return (this.alignment & 0x10) != 0 ? 16 : ((this.alignment & 0x20) != 0 ? 32 : 2);
    }

    protected void workoutMinimumSize() {
        int w = this.getCombinedWidth(this.getTextWidth(this.string), this.getIconWidth(this.getIcon()));
        int h = this.getCombinedHeight(this.getTextHeight(this.string), this.getIconHeight(this.getIcon()));
        if (w == 0 && h == 0) {
            this.width = 0;
            this.height = 0;
        } else {
            this.width = w + this.padding * 2;
            this.height = h + this.padding * 2;
            int max = this.getMaxWidth();
            if (this.width > max) {
                this.width = max;
            }
        }
    }

    public int getMaxWidth() {
        Border b = this.getInsets();
        int maxw = this.getDesktopPane().getWidth();
        if (maxw > 0) {
            int resonableTextLength = maxw - (b.getLeft() + b.getRight());
            int minimumIconWidth = this.getIconWidth(this.getIcon()) + this.padding * 2;
            return Math.max(resonableTextLength, minimumIconWidth);
        }
        return Integer.MAX_VALUE;
    }

    protected int getCombinedWidth(int textWidth, int iconWidth) {
        if ((this.textPosition & 1) != 0) {
            if (iconWidth <= 0 && this.font == null) {
                return 0;
            }
            if (iconWidth > 0) {
                return iconWidth > textWidth ? iconWidth : textWidth;
            }
        } else if (iconWidth > 0) {
            textWidth = (textWidth == 0 ? 0 : this.gap) + textWidth + iconWidth;
        }
        return textWidth;
    }

    protected int getCombinedHeight(int textHeight, int iconHeight) {
        if ((this.textPosition & 2) != 0 || (this.textPosition & 8) != 0 || (this.textPosition & 4) != 0) {
            if (iconHeight <= 0 && this.font == null) {
                return 0;
            }
            if (iconHeight > 0) {
                return iconHeight > textHeight ? iconHeight : textHeight;
            }
        } else if (iconHeight > 0) {
            textHeight = (textHeight == 0 ? 0 : this.gap) + textHeight + iconHeight;
        }
        return textHeight;
    }

    protected int getIconWidth(Icon icon) {
        return icon == null ? 0 : icon.getIconWidth();
    }

    protected int getIconHeight(Icon icon) {
        return icon == null ? 0 : icon.getIconHeight();
    }

    protected int getTextWidth(String string) {
        return this.font == null || string == null || "".equals(string) ? 0 : this.font.getWidth(string);
    }

    protected int getTextHeight(String string) {
        return this.font == null || string == null || "".equals(string) ? 0 : this.font.getHeight();
    }

    public void paintComponent(Graphics2D g) {
        int x = this.padding;
        int y = this.padding;
        int textWidth = this.getTextWidth(this.string);
        int iconWidth = this.getIconWidth(this.getIcon());
        int textHeight = this.getTextHeight(this.string);
        int iconHeight = this.getIconHeight(this.getIcon());
        int combinedWidth = this.getCombinedWidth(textWidth, iconWidth);
        int combinedHeight = this.getCombinedHeight(textHeight, iconHeight);
        int availableTextWidth = textWidth;
        if (availableTextWidth > 0 && combinedWidth > this.width - this.padding * 2) {
            combinedWidth = this.width - this.padding * 2;
            int n = availableTextWidth = (this.textPosition & 1) == 0 && iconWidth > 0 ? combinedWidth - iconWidth - this.gap : combinedWidth;
        }
        if ((this.alignment & 1) != 0) {
            x = (this.width - combinedWidth) / 2;
        } else if ((this.alignment & 8) != 0) {
            x = this.width - combinedWidth - this.padding;
        }
        if ((this.alignment & 2) != 0) {
            y = (this.height - combinedHeight) / 2;
        } else if ((this.alignment & 0x20) != 0) {
            y = this.height - combinedHeight - this.padding;
        }
        if (iconWidth > 0) {
            int ix = x;
            int iy = y;
            if ((this.textPosition & 1) != 0) {
                ix = x + (combinedWidth - iconWidth) / 2;
            } else if ((this.textPosition & 4) != 0 && availableTextWidth > 0) {
                ix = x + availableTextWidth + this.gap;
            }
            if ((this.textPosition & 2) != 0 || (this.textPosition & 8) != 0 || (this.textPosition & 4) != 0) {
                iy = y + (combinedHeight - iconHeight) / 2;
            } else if ((this.textPosition & 0x10) != 0 && availableTextWidth > 0) {
                iy = y + textHeight + this.gap;
            }
            this.paintIcon(g, ix, iy);
        }
        if (availableTextWidth > 0) {
            int tx = x;
            int ty = y;
            if ((this.textPosition & 1) != 0) {
                tx = x + (combinedWidth - availableTextWidth) / 2;
            } else if ((this.textPosition & 8) != 0 && iconWidth > 0) {
                tx = x + iconWidth + this.gap;
            }
            if ((this.textPosition & 2) != 0) {
                ty = y + (combinedHeight - textHeight) / 2;
            } else if ((this.textPosition & 0x20) != 0 && iconWidth > 0) {
                ty = y + combinedHeight - textHeight;
            }
            this.paintText(g, tx, ty, textWidth, availableTextWidth);
        }
    }

    protected void paintIcon(Graphics2D g, int x, int y) {
        this.getIcon().paintIcon(this, g, x, y);
    }

    protected void paintText(Graphics2D g, int x, int y, int textWidth, int availableTextWidth) {
        String drawString = this.string;
        if (textWidth > availableTextWidth) {
            int w = availableTextWidth - this.font.getWidth(extension);
            int a = TextArea.searchStringCharOffset(drawString, this.font, w);
            drawString = drawString.substring(0, a) + extension;
        }
        g.setColor(this.getForeground());
        g.setFont(this.font);
        g.drawString(drawString, x, y);
    }

    public void updateUI() {
        Integer margin;
        super.updateUI();
        this.font = this.theme.getFont(0);
        Integer iconTextGap = (Integer)this.theme.getProperty("iconTextGap", 0);
        if (iconTextGap != null) {
            this.gap = iconTextGap;
        }
        if ((margin = (Integer)this.theme.getProperty("margin", 0)) != null) {
            this.padding = margin;
        }
    }

    public String toString() {
        return super.toString() + "(" + this.string + ")";
    }
}

