/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.cellrenderer.MenuItemRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.Window;

public class MenuBar
extends List
implements ActionListener {
    MenuBar owner;
    private int cols;
    private Border divider;
    private Border verticalDivider;

    public MenuBar() {
        this.setLayoutOrientation(3);
        this.setCellRenderer(new MenuItemRenderer());
        this.setActionCommand("activate");
        this.addActionListener(this);
        this.focusable = true;
    }

    public String getDefaultName() {
        return "MenuBar";
    }

    protected boolean getDefaultEnabled() {
        return false;
    }

    public boolean processKeyEvent(KeyEvent keyEvent) {
        if (this.getLayoutOrientation() == 0 && this.getSelectedValue() instanceof Menu && keyEvent.justPressedAction(5)) {
            this.fireActionPerformed();
            return true;
        }
        return super.processKeyEvent(keyEvent);
    }

    public boolean isVisible() {
        if (this.getDesktopPane().SOFT_KEYS && this.isFrameMenuBar() && !((Frame)this.getWindow()).isMaximum()) {
            return false;
        }
        return super.isVisible();
    }

    public void addImpl(Component button, Object cons, int index) {
        if (this.getItems().contains(button)) {
            throw new RuntimeException("can not add the same button twice: " + button);
        }
        super.addImpl(button, cons, index);
        if (index == -1) {
            super.addElement(button);
        } else {
            this.setSelectedIndex(-1);
            this.getItems().insertElementAt(button, index);
        }
        if (this.isFrameMenuBar() && button instanceof Button) {
            this.autoMnemonic();
        }
        if (button instanceof Button && button.getName().equals("Button")) {
            button.setName("MenuItem");
            ((Button)button).setHorizontalAlignment(4);
        }
    }

    public void addGlue() {
        Label glue = new Label();
        glue.setName("Glue");
        this.add(glue);
    }

    void autoMnemonic() {
        Button foundMenu = null;
        for (int c = 0; c < this.getSize(); ++c) {
            Object visibleItem = this.getElementAt(c);
            if (!(visibleItem instanceof Menu)) continue;
            if (foundMenu != null) {
                return;
            }
            foundMenu = (Menu)visibleItem;
        }
        if (foundMenu != null && foundMenu.getMnemonic() == 0) {
            foundMenu.setMnemonic(-12);
        }
    }

    public void removeAll() {
        while (super.getSize() > 0) {
            this.remove((Component)super.getElementAt(super.getSize() - 1));
        }
    }

    public void remove(Component c) {
        this.setSelectedIndex(-1);
        this.getItems().removeElement(c);
        c.removeParent(this);
    }

    public int getComponentCount() {
        return super.getSize();
    }

    public boolean removeElement(Object obj) {
        throw new RuntimeException("do not use this as it will fail on removing non-visible components, use remove() instead");
    }

    public void addElement(Object a) {
        throw new RuntimeException("do not use this as it will fail, use add() instead");
    }

    public void actionPerformed(String actionCommand) {
        if ("activate".equals(actionCommand)) {
            int index = this.getSelectedIndex();
            if (index >= 0) {
                Button button = (Button)this.getElementAt(index);
                Component comp = this.getRendererComponentFor(index);
                button.setBounds(comp.getXWithBorder(), comp.getYWithBorder(), comp.getWidthWithBorder(), comp.getHeightWithBorder());
                if (!(button instanceof Menu)) {
                    this.actionPerformed("close");
                }
                button.fireActionPerformed();
            }
        } else if ("close".equals(actionCommand)) {
            Window w;
            this.setSelectedIndex(-1);
            if (this.isFrameMenuBar() && (w = this.getWindow()).getFocusOwner() == this) {
                w.setFocusedComponent(null);
            }
            Window win = this.getWindow();
            if (win.closeOnFocusLost) {
                win.setVisible(false);
            }
            if (this.owner != null) {
                this.owner.actionPerformed("close");
            }
        } else {
            super.actionPerformed(actionCommand);
        }
    }

    public Button findMneonicButton(int mnu) {
        Vector items = this.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Button button1;
            Object component = items.elementAt(i);
            if (!(component instanceof Button)) continue;
            Button button = (Button)component;
            if (button.getMnemonic() == mnu) {
                if (button.isVisible()) {
                    Component comp = this.getRendererComponentFor(this.indexOf(button));
                    button.setBounds(comp.getXWithBorder(), comp.getYWithBorder(), comp.getWidthWithBorder(), comp.getHeightWithBorder());
                }
                return button;
            }
            if (!(component instanceof Menu) || (button1 = ((Menu)component).findMneonicButton(mnu)) == null) continue;
            return button1;
        }
        return null;
    }

    public void setSelectedIndex(int a) {
        if (a >= 0) {
            Component c;
            int current = this.getSelectedIndex();
            while ((c = (Component)this.getElementAt(a)) != null && !c.isFocusable()) {
                if (current > a) {
                    --a;
                    continue;
                }
                if (current >= a) continue;
                ++a;
            }
            if (c == null) {
                a = current;
            }
        }
        super.setSelectedIndex(a);
    }

    public void paintComponent(Graphics2D g) {
        DesktopPane dp = this.getDesktopPane();
        int off = 0;
        if (dp.SOFT_KEYS && this.isFrameMenuBar()) {
            Button b2;
            Button b1 = dp.getSelectedFrame().findMnemonicButton(-6);
            if (b1 != null) {
                off = b1.getWidthWithBorder();
            }
            if ((b2 = dp.getSelectedFrame().findMnemonicButton(-12)) != null) {
                off = b2.getWidthWithBorder();
            }
            if (dp.isSideSoftKeys()) {
                int minWidth = 0;
                ListCellRenderer renderer = this.getCellRenderer();
                int current = this.getSelectedIndex();
                int size = this.getSize();
                for (int i = 0; i < size; ++i) {
                    Object item = this.getElementAt(i);
                    Component c = renderer.getListCellRendererComponent(this, item, i, i == current, false);
                    c.workoutPreferredSize();
                    minWidth += c.getWidthWithBorder();
                }
                off = this.width - off - minWidth;
            }
        }
        g.translate(off, 0);
        super.paintComponent(g);
        g.translate(-off, 0);
        this.paintDividers(g);
    }

    protected Component getComponentFor(int i, int offset) {
        Component component = super.getComponentFor(i, offset);
        if ("Glue".equals(component.getName())) {
            int sizeComponentsAfterGlue = 0;
            for (int c = i + 1; c < this.getSize(); ++c) {
                Component comp = super.getComponentFor(c, offset);
                sizeComponentsAfterGlue += this.getLayoutOrientation() == 3 ? comp.getWidthWithBorder() : comp.getHeightWithBorder();
            }
            component.setSize(this.getLayoutOrientation() == 3 ? this.getWidth() - offset - sizeComponentsAfterGlue : component.getWidth(), this.getLayoutOrientation() == 0 ? this.getHeight() - offset - sizeComponentsAfterGlue : component.getHeight());
        }
        return component;
    }

    private boolean isFrameMenuBar() {
        Window w = this.getWindow();
        return w instanceof Frame && ((Frame)w).getMenuBar() == this;
    }

    public Object getElementAt(int index) {
        Vector items = this.getItems();
        int count = 0;
        for (int c = 0; c < items.size(); ++c) {
            if (!((Component)items.elementAt(c)).isVisible()) continue;
            if (count == index) {
                return items.elementAt(c);
            }
            ++count;
        }
        return null;
    }

    public int getSize() {
        Vector items = this.getItems();
        int count = 0;
        for (int c = 0; c < items.size(); ++c) {
            if (!((Component)items.elementAt(c)).isVisible()) continue;
            ++count;
        }
        return count;
    }

    private boolean firstMenu() {
        return this.owner != null && this.owner.isFrameMenuBar();
    }

    protected void workoutMinimumSize() {
        if (this.isFrameMenuBar()) {
            boolean focus = false;
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                Component item = (Component)this.getElementAt(i);
                if (!item.isFocusable()) continue;
                focus = true;
                break;
            }
            this.focusable = focus;
        }
        super.workoutMinimumSize();
    }

    protected void paintDividers(Graphics2D g) {
        int size = this.getSize();
        if (size == 0) {
            return;
        }
        int rows = size;
        if (this.divider != null) {
            int h = (this.getHeight() + this.getDividerHeight()) / rows;
            for (int c = 1; c < rows; ++c) {
                int x = this.divider.getLeft();
                int y = c * h;
                g.translate(x, y);
                this.divider.paintBorder(this, g, this.width, 0);
                g.translate(-x, -y);
            }
        }
    }

    private int getDividerHeight() {
        return this.divider != null ? this.divider.getTop() : 0;
    }

    private int getDividerWidth() {
        return this.verticalDivider != null ? this.verticalDivider.getLeft() : 0;
    }

    public void updateUI() {
        super.updateUI();
        this.divider = (Border)this.theme.getProperty("divider", 0);
        this.verticalDivider = (Border)this.theme.getProperty("verticalDivider", 0);
    }
}

