/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.celleditor.DefaultCellEditor;
import net.yura.mobile.gui.celleditor.TableCellEditor;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.components.Window;

public class Table
extends Panel {
    private Hashtable renderers;
    private Hashtable editors;
    private Vector colWidths = new Vector();
    protected int rowHeight = (int)((double)this.theme.getFont(0).getHeight() * 1.5);
    protected int editingRow = -1;
    protected int editingColumn = -1;
    protected TableCellEditor cellEditor;
    protected Component editorComp;
    private int intercellSpacing = 1;
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public Table() {
        this.renderers = new Hashtable();
        this.editors = new Hashtable();
        this.setDefaultRenderer(Object.class, new DefaultListCellRenderer());
        this.setDefaultEditor(Object.class, new DefaultCellEditor(new TextField()));
        this.dataVector = new Vector(0);
    }

    public String getDefaultName() {
        return "Table";
    }

    protected boolean getDefaultEnabled() {
        return true;
    }

    public Table(Vector data, Vector names) {
        this();
        this.dataVector = data;
        this.columnIdentifiers = names;
    }

    public void breakOutAction(Component component, int direction, boolean scrolltothere, boolean forceFocus) {
        boolean done;
        boolean bl = done = this.editorComp != null && component == this.editorComp ? this.moveSelection(direction) : false;
        if (!done) {
            super.breakOutAction(component, direction, scrolltothere, forceFocus);
        }
    }

    private boolean moveSelection(int d) {
        if (d == 6) {
            if (this.editingRow < this.getRowCount() - 1 && this.isCellEditable(this.editingRow + 1, this.editingColumn)) {
                this.setSelectedCell(this.editingRow + 1, this.editingColumn);
                return true;
            }
        } else if (d == 1) {
            if (this.editingRow > 0 && this.isCellEditable(this.editingRow - 1, this.editingColumn)) {
                this.setSelectedCell(this.editingRow - 1, this.editingColumn);
                return true;
            }
        } else if (d == 5) {
            if (this.editingColumn < this.getColumnCount() - 1 && this.isCellEditable(this.editingRow, this.editingColumn + 1)) {
                this.setSelectedCell(this.editingRow, this.editingColumn + 1);
                return true;
            }
        } else if (d == 2 && this.editingColumn > 0 && this.isCellEditable(this.editingRow, this.editingColumn - 1)) {
            this.setSelectedCell(this.editingRow, this.editingColumn - 1);
            return true;
        }
        return false;
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (!this.focusable) {
            return;
        }
        if (type == 1 || type == 6) {
            int x1 = 0;
            int y1 = 0;
            int currentRow = -1;
            int currentCol = -1;
            for (int c = 0; c < this.getRowCount(); ++c) {
                if ((y1 += this.getRowHeight(c)) <= y) continue;
                currentRow = c;
                break;
            }
            for (int a = 0; a < this.getColumnCount(); ++a) {
                if ((x1 += this.getColumnWidth(a)) <= x) continue;
                currentCol = a;
                break;
            }
            if (currentCol == -1 || currentRow == -1) {
                return;
            }
            if (this.isCellEditable(currentRow, currentCol)) {
                if (type == 1) {
                    this.editCellAt(currentRow, currentCol);
                    if (this.editorComp != null && x >= this.editorComp.getXWithBorder() && y >= this.editorComp.getYWithBorder() && x < this.editorComp.getXWithBorder() + this.editorComp.getWidthWithBorder() && y < this.editorComp.getYWithBorder() + this.editorComp.getHeightWithBorder()) {
                        this.getDesktopPane().pointerPressed(x + this.getXOnScreen(), y + this.getYOnScreen());
                    }
                } else {
                    this.setSelectedCell(currentRow, currentCol);
                }
            }
        }
    }

    public void setSelectedCell(int pRow, int pCol) {
        this.removeEditor();
        this.editingRow = pRow;
        this.editingColumn = pCol;
        if (this.editingRow == -1 || this.editingColumn == -1 || this.width <= 0 || this.height <= 0) {
            return;
        }
        int x = this.getCellX(this.editingColumn);
        int y = this.getCellY(this.editingRow);
        int currentRowHeight = this.getRowHeight(this.editingRow);
        int currentColWidth = this.getColumnWidth(this.editingColumn);
        this.scrollRectToVisible(x, y, currentColWidth, currentRowHeight, false);
        this.repaint();
    }

    public void focusGained() {
        super.focusGained();
        if (this.editorComp != null) {
            this.editorComp.requestFocusInWindow();
        } else if (this.editingColumn == -1 && this.editingRow == -1 && this.getColumnCount() > 0 && this.getRowCount() > 0) {
            this.editingRow = 0;
            this.editingColumn = 0;
        }
    }

    public boolean processKeyEvent(KeyEvent event) {
        int key = event.getIsDownKey();
        if (key == 0) {
            return true;
        }
        int action = event.getKeyAction(key);
        if (action == 1 || action == 6 || action == 2 || action == 5) {
            return this.moveSelection(action);
        }
        if (key != 0) {
            if (this.editingRow == -1 || this.editingColumn == -1) {
                return false;
            }
            this.editCellAt(this.editingRow, this.editingColumn);
            if (!(this.editorComp == null || this.editorComp instanceof TextComponent && action == 8)) {
                this.editorComp.processKeyEvent(event);
            }
        }
        return true;
    }

    public int getCellX(int col) {
        int x = 0;
        for (int a = 0; a < col; ++a) {
            x += this.getColumnWidth(a);
        }
        return x;
    }

    public int getCellY(int row) {
        int y = 0;
        for (int c = 0; c < row; ++c) {
            y += this.getRowHeight(c);
        }
        return y;
    }

    public void editCellAt(int row, int column) {
        this.removeEditor();
        this.editingRow = row;
        this.editingColumn = column;
        if (this.isCellEditable(this.editingRow, this.editingColumn)) {
            this.cellEditor = this.getCellEditor(this.editingRow, this.editingColumn);
            this.editorComp = this.cellEditor.getTableCellEditorComponent(this, this.getValueAt(this.editingRow, this.editingColumn), true, this.editingRow, this.editingColumn);
            Component editParent = this.editorComp.getParent();
            if (editParent instanceof Table) {
                ((Table)editParent).removeEditor();
            }
            this.add(this.editorComp);
            this.doLayout();
            if (this.getWindow().getFocusOwner() == this) {
                this.editorComp.requestFocusInWindow();
            }
        }
        this.repaint();
    }

    public void removeEditor() {
        if (this.cellEditor != null) {
            this.setValueAt(this.cellEditor.getCellEditorValue(), this.editingRow, this.editingColumn);
            Window w = this.getWindow();
            boolean editorCurrentlyFocused = w != null && w.getFocusOwner() == this.editorComp;
            this.editorComp = null;
            this.cellEditor = null;
            if (editorCurrentlyFocused) {
                this.requestFocusInWindow();
            }
            this.removeAll();
        }
    }

    public void paintComponent(Graphics2D g) {
        int x = 0;
        int y = 0;
        int his = this.intercellSpacing / 2;
        int cols = this.getColumnCount();
        int rowc = this.getRowCount();
        boolean editOpen = this.getComponents().size() == 1;
        boolean good1 = false;
        for (int r = 0; r < rowc; ++r) {
            int currentRowHeight = this.getRowHeight(r);
            if (y < g.getClipY() + g.getClipHeight() && y + currentRowHeight > g.getClipY()) {
                good1 = true;
                boolean good2 = false;
                for (int c = 0; c < cols; ++c) {
                    int currentColWidth = this.getColumnWidth(c);
                    if (x < g.getClipX() + g.getClipWidth() && x + currentColWidth > g.getClipX()) {
                        Component comp;
                        good2 = true;
                        if (!(editOpen && this.editingRow == r && this.editingColumn == c || (comp = this.prepareRenderer(r, c)) == null)) {
                            comp.setBounds(x + his, y + his, currentColWidth - this.intercellSpacing, currentRowHeight - this.intercellSpacing);
                            int xoff = comp.getX();
                            int yoff = comp.getY();
                            g.translate(xoff, yoff);
                            comp.paint(g);
                            g.translate(-xoff, -yoff);
                        }
                    } else if (good2) break;
                    x += currentColWidth;
                }
            } else if (good1) break;
            y += currentRowHeight;
            x = 0;
        }
    }

    public Component prepareRenderer(int r, int c) {
        Object object = this.getValueAt(r, c);
        ListCellRenderer renderer = this.getCellRenderer(r, c);
        boolean sel = this.editingRow == r && this.editingColumn == c;
        Component comp = renderer.getListCellRendererComponent(this, object, r * this.getColumnCount() + c, sel, sel && this.isFocusOwner());
        return comp;
    }

    protected void workoutMinimumSize() {
        super.workoutMinimumSize();
        this.height = this.workoutHeight();
        int w = 0;
        for (int c = 0; c < this.colWidths.size(); ++c) {
            Integer i = (Integer)this.colWidths.elementAt(c);
            if (i == null) continue;
            w += i.intValue();
        }
        this.width = w;
    }

    protected int workoutHeight() {
        int h = 0;
        int r = this.getRowCount();
        for (int a = 0; a < r; ++a) {
            h += this.getRowHeight(a);
        }
        return h;
    }

    public void doLayout() {
        if (this.editorComp != null) {
            int x = this.getCellX(this.editingColumn);
            int y = this.getCellY(this.editingRow);
            int currentRowHeight = this.getRowHeight(this.editingRow);
            int currentColWidth = this.getColumnWidth(this.editingColumn);
            this.editorComp.setBounds(x + this.intercellSpacing / 2, y + this.intercellSpacing / 2, currentColWidth - this.intercellSpacing, currentRowHeight - this.intercellSpacing);
        }
    }

    public void setDefaultEditor(Class columnClass, TableCellEditor editor) {
        this.editors.put(columnClass, editor);
        Enumeration elements = this.renderers.elements();
        while (elements.hasMoreElements()) {
            if (elements.nextElement() != editor) continue;
            throw new RuntimeException("can not use the same instance for editor and renderer");
        }
    }

    public void setDefaultRenderer(Class columnClass, ListCellRenderer renderer) {
        this.renderers.put(columnClass, renderer);
        Enumeration elements = this.editors.elements();
        while (elements.hasMoreElements()) {
            if (elements.nextElement() != renderer) continue;
            throw new RuntimeException("can not use the same instance for editor and renderer");
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor currentEditor = (TableCellEditor)this.editors.get(this.getColumnClass(column));
        if (currentEditor == null) {
            currentEditor = (TableCellEditor)this.editors.get(Object.class);
        }
        return currentEditor;
    }

    public ListCellRenderer getCellRenderer(int row, int column) {
        ListCellRenderer renderer = (ListCellRenderer)this.renderers.get(this.getColumnClass(column));
        if (renderer == null) {
            renderer = (ListCellRenderer)this.renderers.get(Object.class);
        }
        return renderer;
    }

    public String getToolTipText() {
        if (this.editingRow != -1 && this.editingColumn != -1) {
            Component c = this.prepareRenderer(this.editingRow, this.editingColumn);
            return c == null ? null : c.getToolTipText();
        }
        return super.getToolTipText();
    }

    public int getToolTipLocationX() {
        if (this.editingRow != -1 && this.editingColumn != -1) {
            Component c = this.prepareRenderer(this.editingRow, this.editingColumn);
            return this.getCellX(this.editingColumn) + c.getToolTipLocationX();
        }
        return super.getToolTipLocationX();
    }

    public int getToolTipLocationY() {
        if (this.editingRow != -1 && this.editingColumn != -1) {
            Component c = this.prepareRenderer(this.editingRow, this.editingColumn);
            return this.getCellY(this.editingRow) + c.getToolTipLocationY();
        }
        return super.getToolTipLocationY();
    }

    public int getSelectedRow() {
        return this.editingRow;
    }

    public int getSelectedColumn() {
        return this.editingColumn;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    public void setColumnWidth(int col, int colHeight) {
        while (this.colWidths.size() <= col) {
            this.colWidths.addElement(null);
        }
        this.colWidths.setElementAt(new Integer(colHeight), col);
    }

    public int getColumnWidth(int c) {
        Integer i;
        if (this.colWidths.size() > c && (i = (Integer)this.colWidths.elementAt(c)) != null) {
            return i;
        }
        int others = 0;
        int numset = 0;
        for (c = 0; c < this.colWidths.size(); ++c) {
            Integer i2 = (Integer)this.colWidths.elementAt(c);
            if (i2 == null) continue;
            others += i2.intValue();
            ++numset;
        }
        int count = this.getColumnCount();
        return (this.width - others) / (count - numset);
    }

    public int getRowHeight(int row) {
        return this.rowHeight;
    }

    public void setIntercellSpacing(int w) {
        this.intercellSpacing = w;
    }

    public int getIntercellSpacing() {
        return this.intercellSpacing;
    }

    public Class getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Vector)this.dataVector.elementAt(rowIndex)).elementAt(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ((Vector)this.dataVector.elementAt(rowIndex)).setElementAt(aValue, columnIndex);
    }

    public int getColumnCount() {
        if (this.columnIdentifiers == null) {
            if (this.dataVector.size() == 0) {
                return 0;
            }
            return ((Vector)this.dataVector.elementAt(0)).size();
        }
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int columnIndex) {
        return (String)this.columnIdentifiers.elementAt(columnIndex);
    }

    public int getRowCount() {
        return this.dataVector.size();
    }
}

