/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.logging.Logger;

public class TextArea
extends TextComponent {
    protected int[] lines;
    private int widthUsed = -1;
    private int lineSpacing;
    private boolean wrap;
    private int caretPixelOffset;
    private boolean doNotUpdateCaretPixelOffset;

    public TextArea() {
        this("");
    }

    public TextArea(String text) {
        super(text, 1000, 0);
    }

    public void setLineWrap(boolean w) {
        this.wrap = w;
        this.lines = null;
        this.widthUsed = -1;
    }

    public boolean getLineWrap() {
        return this.wrap;
    }

    public void paintComponent(Graphics2D g) {
        int f = this.getForeground();
        if (!Graphics2D.isTransparent(f)) {
            int[] lines = this.lines;
            String text = this.getDisplayString();
            int y = 0;
            int x = 0;
            g.setColor(f);
            int lineHeight = this.font.getHeight() + this.lineSpacing;
            int startLine = Math.max(0, (g.getClipY() - y) / lineHeight);
            int endLine = Math.min(lines.length + 1, startLine + g.getClipHeight() / lineHeight + 1);
            y += lineHeight * startLine;
            int beginIndex = startLine >= endLine ? 0 : (startLine == 0 ? 0 : lines[startLine - 1]);
            for (int i = startLine; i < endLine; ++i) {
                int lastCaretIndex;
                int lastDrawIndex = lastCaretIndex = i == lines.length ? text.length() : lines[i];
                if (lastCaretIndex > 0 && i != lines.length) {
                    --lastCaretIndex;
                    if (text.charAt(lastDrawIndex - 1) == '\n') {
                        --lastDrawIndex;
                    }
                }
                String line = text.substring(beginIndex, lastDrawIndex);
                g.setFont(this.font);
                g.drawString(line, x, y);
                if (this.showCaret && this.caretPosition >= beginIndex && this.caretPosition <= lastCaretIndex) {
                    int w = TextArea.getStringWidth(this.font, text.substring(beginIndex, this.caretPosition));
                    g.drawLine(w, y, w, y + lineHeight - 1);
                }
                if (i == endLine - 1) continue;
                y += lineHeight;
                beginIndex = lines[i];
            }
        }
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void append(String a) {
        String newtext = this.getText() + a;
        if (this.lines == null || this.lines.length == 0) {
            this.setText(newtext);
        } else if (a.length() > 0) {
            int length = this.text.length();
            this.text.append(a);
            this.changedUpdate(length, a.length());
            this.setCaretPosition(this.text.length());
        }
    }

    protected void changedUpdate(int offset, int length) {
        if (this.lines == null) {
            return;
        }
        String text = this.getText();
        int startPos = -1;
        int c = 0;
        while (c < this.lines.length - 1 && this.lines[c + 1] < offset) {
            startPos = c++;
        }
        int[] l2 = this.getLines(text, this.font, startPos == -1 ? 0 : this.lines[startPos], this.wrap ? this.width : Integer.MAX_VALUE);
        if (startPos == -1) {
            this.setupHeight(l2);
        } else {
            int[] l3 = new int[startPos + 1 + l2.length];
            System.arraycopy(this.lines, 0, l3, 0, startPos + 1);
            System.arraycopy(l2, 0, l3, startPos + 1, l2.length);
            this.setupHeight(l3);
        }
    }

    public boolean processKeyEvent(KeyEvent keyEvent) {
        boolean result = super.processKeyEvent(keyEvent);
        if (keyEvent.getJustReleasedKey() != 0) {
            return false;
        }
        if (!result) {
            int line;
            if (keyEvent.isDownAction(1)) {
                int line2 = this.getLineOfOffset(this.caretPosition);
                if (line2 != 0) {
                    this.autoAccept();
                    this.doNotUpdateCaretPixelOffset = true;
                    this.gotoLine(line2 - 1, this.caretPixelOffset);
                    return true;
                }
            } else if (keyEvent.isDownAction(6) && (line = this.getLineOfOffset(this.caretPosition)) != this.lines.length) {
                this.autoAccept();
                this.doNotUpdateCaretPixelOffset = true;
                this.gotoLine(line + 1, this.caretPixelOffset);
                return true;
            }
        }
        return result;
    }

    private void gotoLine(int line, int xPixelOffset) {
        int startOfLineOffset = line == 0 ? 0 : this.lines[line - 1];
        String text = this.getText() + " ";
        text = text.substring(startOfLineOffset, line == this.lines.length ? text.length() : this.lines[line]);
        int mid = TextArea.searchStringCharOffset(text, this.font, xPixelOffset);
        this.setCaretPosition(startOfLineOffset + mid);
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (this.focusable) {
            int lineHeight = this.font.getHeight() + this.lineSpacing;
            int line = y / lineHeight;
            if (line > this.lines.length) {
                line = this.lines.length;
            } else if (line < 0) {
                line = 0;
            }
            this.gotoLine(line, x);
        }
    }

    public int getLineOfOffset(int offset) {
        int line = 0;
        for (int c = 0; c < this.lines.length && offset >= this.lines[c]; ++c) {
            line = c + 1;
        }
        return line;
    }

    public void setCaretPosition(int a) {
        super.setCaretPosition(a);
        if (this.lines == null) {
            return;
        }
        int line = this.getLineOfOffset(this.caretPosition);
        int lineHeight = this.font.getHeight() + this.lineSpacing;
        int pos = this.caretPosition - (line == 0 ? 0 : this.lines[line - 1]);
        String text = this.getText();
        int offset = line == 0 ? 0 : this.lines[line - 1];
        text = text.substring(offset, offset + pos);
        int xoffset = TextArea.getStringWidth(this.font, text);
        if (!this.doNotUpdateCaretPixelOffset) {
            this.caretPixelOffset = xoffset;
        } else {
            this.doNotUpdateCaretPixelOffset = false;
        }
        this.scrollRectToVisible(xoffset, line * lineHeight, lineHeight, lineHeight, false);
    }

    protected void workoutMinimumSize() {
        if (this.wrap) {
            if (this.getPreferredWidth() > -1) {
                this.width = this.getPreferredWidth();
                if (this.width != this.widthUsed) {
                    this.lines = this.getLines(this.getText(), this.font, 0, this.width);
                    this.widthUsed = this.width;
                }
                this.height = this.getMinHeight();
            } else {
                this.width = 10;
                this.height = this.lines == null ? 10 : this.getMinHeight();
            }
        } else {
            if (this.lines == null) {
                this.lines = this.getLines(this.getText(), this.font, 0, Integer.MAX_VALUE);
            }
            this.width = this.getMinWidth();
            this.height = this.getMinHeight();
        }
    }

    public void setSize(int wi, int h) {
        super.setSize(wi, h);
        if (this.wrap && this.widthUsed != this.width) {
            this.setupHeight(this.getLines(this.getText(), this.font, 0, this.width));
        }
    }

    private void setupHeight(int[] ln) {
        int oldh = this.height;
        this.lines = ln;
        this.widthUsed = this.width;
        this.height = this.getMinHeight();
        if (oldh != this.height || !this.wrap && this.getMinWidth() != this.width) {
            DesktopPane.mySizeChanged(this);
        }
    }

    private int getMinWidth() {
        int width1 = 0;
        String text = this.getDisplayString();
        int beginIndex = 0;
        for (int i = 0; i <= this.lines.length; ++i) {
            int lastIndex = i == this.lines.length ? text.length() : this.lines[i];
            int w1 = TextArea.getStringWidth(this.font, text.substring(beginIndex, i != this.lines.length ? lastIndex - 1 : lastIndex)) + 1;
            if (width1 < w1) {
                width1 = w1;
            }
            beginIndex = lastIndex;
        }
        return width1;
    }

    private int getMinHeight() {
        return (this.lines.length + 1) * this.font.getHeight() + this.lines.length * this.lineSpacing;
    }

    public String getDefaultName() {
        return "TextArea";
    }

    public int[] getLines(String str, Font f, int startPos, int w) {
        return TextArea.getLines(str, f, startPos, w, w);
    }

    public static int[] getLines(String str, Font f, int startPos, int startW, int w) {
        Logger.debug("getLines start=" + startPos + " w=" + w + " stringLength=" + str.length());
        Vector<Integer> parts = new Vector<Integer>();
        int wordStart = startPos;
        int lineStart = startPos;
        while (true) {
            int currentLineLength;
            int wordEnd = w == Integer.MAX_VALUE ? -1 : str.indexOf(32, wordStart);
            int lineEnd = str.indexOf(10, wordStart);
            int end = wordEnd == -1 && lineEnd == -1 ? str.length() : (wordEnd == -1 ? lineEnd : (lineEnd == -1 ? wordEnd : (wordEnd < lineEnd ? wordEnd : lineEnd)));
            int n = currentLineLength = w == Integer.MAX_VALUE ? -1 : TextArea.getStringWidth(f, str.substring(lineStart, end));
            if (currentLineLength > w && lineStart == wordStart) {
                int a = TextArea.searchStringCharOffset(str.substring(lineStart, end), f, startW);
                int c = lineStart + (a < 1 && startW >= w ? 1 : a);
                parts.addElement(new Integer(c));
                wordStart = c;
                lineStart = c;
            } else if (currentLineLength > startW) {
                parts.addElement(new Integer(wordStart));
                lineStart = wordStart;
            } else {
                if (wordEnd == -1 && lineEnd == -1) break;
                if (end == lineEnd) {
                    parts.addElement(new Integer(end + 1));
                    wordStart = end + 1;
                    lineStart = end + 1;
                } else {
                    wordStart = end + 1;
                }
            }
            if (startW == w || parts.size() <= 0) continue;
            startW = w;
        }
        int[] array = new int[parts.size()];
        for (int c = 0; c < array.length; ++c) {
            array[c] = (Integer)parts.elementAt(c);
        }
        return array;
    }

    public static int getStringWidth(Font f, String s) {
        return f.getWidth(s);
    }
}

