/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.Layout;

public class BorderLayout
implements Layout {
    public void layoutPanel(Panel panel) {
        Vector components = panel.getComponents();
        Hashtable cons = panel.getConstraints();
        int top = 0;
        int bottom = 0;
        int right = 0;
        int left = 0;
        block12: for (int c = 0; c < components.size(); ++c) {
            Integer pos;
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible() || (pos = (Integer)cons.get(comp)) == null) continue;
            switch (pos) {
                case 16: {
                    top = comp.getHeightWithBorder();
                    continue block12;
                }
                case 32: {
                    bottom = comp.getHeightWithBorder();
                    continue block12;
                }
                case 8: {
                    right = comp.getWidthWithBorder();
                    continue block12;
                }
                case 4: {
                    left = comp.getWidthWithBorder();
                    continue block12;
                }
            }
        }
        int width = panel.getWidth();
        int height = panel.getHeight();
        block13: for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            Integer pos = (Integer)cons.get(comp);
            int p = pos == null ? 0 : pos;
            switch (p) {
                case 16: {
                    comp.setBounds(0, 0, width, top);
                    continue block13;
                }
                case 32: {
                    comp.setBounds(0, height - bottom, width, bottom);
                    continue block13;
                }
                case 8: {
                    comp.setBounds(width - right, top, right, height - top - bottom);
                    continue block13;
                }
                case 4: {
                    comp.setBounds(0, top, left, height - top - bottom);
                    continue block13;
                }
                default: {
                    comp.setBounds(left, top, width - right - left, height - top - bottom);
                }
            }
        }
    }

    public int getPreferredHeight(Panel panel) {
        Vector components = panel.getComponents();
        Hashtable cons = panel.getConstraints();
        int h1 = 0;
        int h2 = 0;
        block6: for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            Integer pos = (Integer)cons.get(comp);
            int p = pos == null ? 0 : pos;
            switch (p) {
                case 16: {
                    h2 += comp.getHeightWithBorder();
                    continue block6;
                }
                case 32: {
                    h2 += comp.getHeightWithBorder();
                    continue block6;
                }
                case 8: {
                    if (h1 >= comp.getHeightWithBorder()) continue block6;
                    h1 = comp.getHeightWithBorder();
                    continue block6;
                }
                case 4: {
                    if (h1 >= comp.getHeightWithBorder()) continue block6;
                    h1 = comp.getHeightWithBorder();
                    continue block6;
                }
                default: {
                    if (h1 >= comp.getHeightWithBorder()) continue block6;
                    h1 = comp.getHeightWithBorder();
                }
            }
        }
        return h1 + h2;
    }

    public int getPreferredWidth(Panel panel) {
        Vector components = panel.getComponents();
        Hashtable cons = panel.getConstraints();
        int w1 = 0;
        int w2 = 0;
        block6: for (int c = 0; c < components.size(); ++c) {
            Component comp = (Component)components.elementAt(c);
            if (!comp.isVisible()) continue;
            Integer pos = (Integer)cons.get(comp);
            int p = pos == null ? 0 : pos;
            switch (p) {
                case 16: {
                    if (w1 >= comp.getWidthWithBorder()) continue block6;
                    w1 = comp.getWidthWithBorder();
                    continue block6;
                }
                case 32: {
                    if (w1 >= comp.getWidthWithBorder()) continue block6;
                    w1 = comp.getWidthWithBorder();
                    continue block6;
                }
                case 8: {
                    w2 += comp.getWidthWithBorder();
                    continue block6;
                }
                case 4: {
                    w2 += comp.getWidthWithBorder();
                    continue block6;
                }
                default: {
                    w2 += comp.getWidthWithBorder();
                }
            }
        }
        return Math.max(w1, w2);
    }
}

