/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.plaf;

import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Component;

public class MetalIcon
extends Icon {
    private int type;
    private int foreground;
    private int background;

    public MetalIcon(int size, int type, int fore, int back) {
        this.width = size;
        this.height = size;
        this.type = type;
        this.foreground = fore;
        this.background = back;
    }

    public void paintIcon(Component c, Graphics2D g, int x, int y) {
        int fcolor = this.foreground == 0 ? c.getForeground() : this.foreground;
        g.setColor(fcolor);
        if (this.type == 1) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.setColor(this.background);
            g.fillRect(x, y, w, h);
            g.setColor(fcolor);
            g.drawRect(x, y, w - 1, h - 1);
            if ((c.getCurrentState() & 8) != 0) {
                for (int pad = 3; pad < 6; ++pad) {
                    g.drawLine(x + pad, y + h / 2, x + w / 3, y + h - pad);
                    g.drawLine(x + w / 3, y + h - pad, x + w - pad, y + pad);
                }
            }
        } else if (this.type == 0) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.setColor(this.background);
            g.fillArc(x, y, w, h, 0, 360);
            g.setColor(fcolor);
            g.drawArc(x, y, w - 1, h - 1, 0, 360);
            if ((c.getCurrentState() & 8) != 0) {
                int w2 = w / 4;
                int h2 = h / 4;
                g.fillArc(x + w2, y + h2, w - w2 * 2, h - h2 * 2, 0, 360);
            }
        } else if (this.type == 2) {
            g.drawLine(x, (c.getHeight() - this.height) / 2, x, this.height);
            this.drawSelectionArrow(c, g, x, y, 0);
        } else if (this.type == 3 || this.type == 14) {
            g.setColor(fcolor);
            int gp = 2;
            int iconHeight = this.height - gp * 2;
            int iconWidth = iconHeight / 2;
            int side = x + (this.width / 2 - iconWidth / 2);
            g.fillTriangle(side, y + gp + iconHeight / 2 + 1, side + iconWidth, y + gp + iconHeight, side + iconWidth, y + gp);
        } else if (this.type == 4 || this.type == 13) {
            g.setColor(fcolor);
            int gp = 2;
            int iconHeight = this.height - gp * 2;
            int iconWidth = iconHeight / 2;
            int side = x + (this.width / 2 - iconWidth / 2);
            g.fillTriangle(side + iconWidth, y + gp + iconHeight / 2 + 1, side, y + gp + iconHeight, side, y + gp);
        } else if (this.type == 11) {
            g.setColor(fcolor);
            int gp = 2;
            int iconWidth = this.width - gp * 2;
            int iconHeight = iconWidth / 2;
            int top = y + (this.height / 2 - iconHeight / 2);
            g.fillTriangle(x + gp + iconWidth / 2 + 1, top, x + gp + iconWidth, top + iconHeight, x + gp, top + iconHeight);
        } else if (this.type == 12) {
            g.setColor(fcolor);
            int gp = 2;
            int iconWidth = this.width - gp * 2;
            int iconHeight = iconWidth / 2;
            int top = y + (this.height / 2 - iconHeight / 2);
            g.fillTriangle(x + gp + iconWidth / 2 + 1, top + iconHeight, x + gp + iconWidth, top, x + gp, top);
        }
    }

    private void drawSelectionArrow(Component c, Graphics2D g, int x, int y, int transformation) {
        g.translate(x, y);
        int trans = g.getTransform();
        g.setTransform(transformation);
        int gp = 2;
        int iconWidth = this.width - gp * 2;
        int iconHeight = iconWidth / 2;
        int top = this.height / 2 - iconHeight / 2;
        g.fillTriangle(gp + iconWidth / 2 + 1, top + iconHeight, gp + iconWidth, top, gp, top);
        g.setTransform(trans);
        g.translate(-x, -y);
    }
}

