/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import net.yura.mobile.gui.Application;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.logging.Logger;

public class ClipboardManager
implements ServiceLink.TaskHandler {
    private static ClipboardManager instance = new ClipboardManager();

    private ClipboardManager() {
        if (Application.getPlatform() == 2) {
            ServiceLink link = ServiceLink.getInstance();
            link.registerForTask("GetClipboardTextError", this);
            link.registerForTask("PutClipboardText", this);
        }
    }

    public void handleTask(ServiceLink.Task task) {
        String strMethod = task.getMethod();
        if (!"GetClipboardTextError".equals(strMethod) && "PutClipboardText".equals(strMethod)) {
            String string = (String)task.getObject();
        }
    }

    public static ClipboardManager getInstance() {
        return instance;
    }

    public String getText() {
        if (Application.getPlatform() == 2) {
            ServiceLink link = ServiceLink.getInstance();
            if (link.isConnected()) {
                link.sendTask(new ServiceLink.Task("GetClipboardText", null));
            }
        } else {
            Application application = Application.getInstance();
            application.platformRequest("clipboard://get", null);
            return System.getProperty("clipboard.text");
        }
        return null;
    }

    public void setText(String text) {
        if (Application.getPlatform() == 2) {
            ServiceLink link = ServiceLink.getInstance();
            if (link.isConnected()) {
                link.sendTask(new ServiceLink.Task("PutClipboardText", text));
            }
        } else {
            Application application = Application.getInstance();
            try {
                application.platformRequest("clipboard://put/" + text);
            }
            catch (Exception ex) {
                Logger.warn("cant put " + text, ex);
            }
        }
    }
}

