/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.io.SocketClient;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.QueueProcessorThread;
import net.yura.mobile.util.Url;

public abstract class HTTPClient
extends QueueProcessorThread {
    public HTTPClient() {
        this(2);
    }

    public HTTPClient(int num) {
        super("HTTPClient", num);
    }

    public void makeRequest(Request request) {
        this.addToInbox(request);
    }

    protected abstract void onError(Request var1, int var2, Hashtable var3, Exception var4);

    protected abstract void onResult(Request var1, int var2, Hashtable var3, InputStream var4, long var5) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Object arg0) {
        Hashtable<String, String> headers;
        int respCode;
        OutputStream os;
        InputStream is;
        HttpConnection httpConn;
        boolean getpost;
        Request request;
        block28: {
            request = (Request)arg0;
            if (request.aborted) {
                return;
            }
            String url = request.url;
            getpost = false;
            if (request.params != null && request.params.size() > 0) {
                getpost = true;
            }
            httpConn = null;
            is = null;
            os = null;
            respCode = 0;
            headers = new Hashtable<String, String>();
            if ((!request.post || request.postData != null) && getpost) {
                String getpostString = Url.toQueryString(request.params);
                url = url.indexOf(63) >= 0 ? url + "&" + getpostString : url + "?" + getpostString;
            }
            if (SocketClient.connectAppend != null) {
                url = url + SocketClient.connectAppend;
            }
            httpConn = (HttpConnection)Connector.open((String)url);
            request.activeConnection = (Connection)httpConn;
            if (!request.aborted) break block28;
            FileUtil.close(httpConn);
            request.activeConnection = null;
            FileUtil.close(is);
            FileUtil.close(httpConn);
            return;
        }
        try {
            String key;
            boolean post = request.post || request.postData != null;
            httpConn.setRequestMethod(post ? "POST" : "GET");
            if (request.headers != null) {
                Enumeration e = request.headers.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement().toString();
                    httpConn.setRequestProperty(key, request.headers.get(key).toString());
                }
            }
            if (post) {
                try {
                    os = httpConn.openOutputStream();
                    if (request.postData != null) {
                        os.write(request.postData);
                    } else if (request.post && getpost) {
                        OutputStreamWriter w = new OutputStreamWriter(os);
                        Url.writeQueryString(request.params, w);
                        ((Writer)w).flush();
                    }
                    os.flush();
                }
                finally {
                    FileUtil.close(os);
                }
            }
            respCode = httpConn.getResponseCode();
            int i = 0;
            while (true) {
                if ((key = httpConn.getHeaderFieldKey(i)) == null) {
                    if (i > 0) {
                        break;
                    }
                } else {
                    headers.put(key, httpConn.getHeaderField(i));
                }
                ++i;
            }
            switch (respCode) {
                case 200: {
                    is = httpConn.openInputStream();
                    this.onResult(request, respCode, headers, is, httpConn.getLength());
                    break;
                }
                case 303: {
                    request.post = false;
                    request.postData = null;
                }
                case 302: 
                case 307: {
                    request.url = httpConn.getHeaderField("Location");
                    if (request.url != null && request.redirects > 0) {
                        this.addToInbox(request);
                        --request.redirects;
                        break;
                    }
                }
                default: {
                    this.onError(request, respCode, headers, null);
                }
            }
        }
        catch (Exception ex) {
            block30: {
                try {
                    if (request.aborted) break block30;
                    this.onError(request, respCode, headers, ex);
                }
                catch (Throwable throwable) {
                    request.activeConnection = null;
                    FileUtil.close(is);
                    FileUtil.close(httpConn);
                    throw throwable;
                }
            }
            request.activeConnection = null;
            FileUtil.close(is);
            FileUtil.close(httpConn);
        }
        request.activeConnection = null;
        FileUtil.close(is);
        FileUtil.close(httpConn);
    }

    public static class Request {
        public String url;
        public Hashtable headers;
        public Hashtable params;
        public boolean post;
        public Object id;
        public int redirects = 5;
        public byte[] postData;
        public boolean aborted = false;
        private Connection activeConnection = null;

        public String toString() {
            return (this.post ? "POST" : "GET") + " " + this.url + " query=" + this.params + " headers=" + this.headers + " id=" + this.id + " redirection-limit=" + this.redirects + " postData=" + this.postData;
        }

        public void abort() {
            this.aborted = true;
            Logger.debug("Aborting request " + this.url);
            FileUtil.close(this.activeConnection);
        }
    }
}

