/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.audio;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import net.yura.domination.audio.AudioSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAudio
implements AudioSystem,
ThreadFactory,
PlayerListener {
    private static final Logger LOGGER = Logger.getLogger(SimpleAudio.class.getName());
    Map<String, Player> currentMusicPlayers = new HashMap<String, Player>();
    private int consecutiveStartErrors;
    private boolean fatalAudioSystemError;
    private final ThreadPoolExecutor musicThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this);
    private final ThreadPoolExecutor soundThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this);

    @Override
    public Thread newThread(Runnable r) {
        Thread th = Executors.defaultThreadFactory().newThread(r);
        th.setName("SimpleAudioStartStopThread");
        return th;
    }

    private Player getPlayer(String fileName) throws IOException, MediaException {
        Player player = Manager.createPlayer("file:///android_asset/" + fileName);
        return player;
    }

    @Override
    public void playerUpdate(Player player, String s, Object o) {
        if ("endOfMedia".equals(s)) {
            player.close();
        }
    }

    @Override
    public void play(final String fileName) {
        if (this.fatalAudioSystemError) {
            return;
        }
        this.purge(this.soundThread.getQueue(), fileName);
        this.soundThread.execute(new Runnable(){

            public void run() {
                Player player = null;
                try {
                    player = SimpleAudio.this.getPlayer(fileName);
                    player.addPlayerListener(SimpleAudio.this);
                    player.start();
                    SimpleAudio.this.consecutiveStartErrors = 0;
                }
                catch (Exception ex) {
                    SimpleAudio.this.startError(fileName, player, ex);
                }
                catch (Error oom) {
                    SimpleAudio.this.startError(fileName, player, oom);
                }
            }

            public String toString() {
                return fileName;
            }
        });
    }

    @Override
    public void start(final String fileName) {
        if (this.fatalAudioSystemError) {
            return;
        }
        this.purge(this.musicThread.getQueue(), fileName);
        this.musicThread.execute(new Runnable(){

            public void run() {
                Player player = null;
                try {
                    player = SimpleAudio.this.getPlayer(fileName);
                    player.setLoopCount(-1);
                    SimpleAudio.this.currentMusicPlayers.put(fileName, player);
                    player.start();
                    SimpleAudio.this.consecutiveStartErrors = 0;
                }
                catch (Exception ex) {
                    SimpleAudio.this.startError(fileName, player, ex);
                }
                catch (Error oom) {
                    SimpleAudio.this.startError(fileName, player, oom);
                }
            }

            public String toString() {
                return fileName;
            }
        });
    }

    private void startError(String fileName, Player player, Throwable ex) {
        ++this.consecutiveStartErrors;
        if (ex instanceof Error) {
            this.fatalAudioSystemError = true;
        }
        if (this.consecutiveStartErrors > 10) {
            this.fatalAudioSystemError = true;
        }
        LOGGER.log(Level.INFO, "unable to play " + fileName, ex);
        try {
            this.currentMusicPlayers.remove(fileName);
            if (player != null) {
                player.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void stop(final String audioFile) {
        try {
            this.musicThread.execute(new Runnable(){

                public void run() {
                    try {
                        Player player = SimpleAudio.this.currentMusicPlayers.remove(audioFile);
                        if (player != null) {
                            player.stop();
                            player.close();
                        } else {
                            LOGGER.log(Level.INFO, "unable to stop, not found: " + audioFile);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "unable to stop " + audioFile, ex);
                    }
                }
            });
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private void purge(BlockingQueue<Runnable> q, String name) {
        try {
            Iterator it = q.iterator();
            while (it.hasNext()) {
                Runnable r = (Runnable)it.next();
                if (!name.equals(r.toString())) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException fallThrough) {
            for (Object r : q.toArray()) {
                if (!name.equals(r.toString())) continue;
                q.remove(r);
            }
        }
    }

    protected void finalize() {
        this.musicThread.shutdown();
        this.soundThread.shutdown();
    }
}

