/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompatUtil {
    public static Hashtable asHashtable(Map map) {
        return map instanceof Hashtable ? (Hashtable)map : new Hashtable(map);
    }

    public static Vector asVector(Collection list) {
        return list instanceof Vector ? (Vector)list : new Vector(list);
    }

    public static void setLambda(Object obj, String setter, String lambdaClass, final Runnable lambda) {
        try {
            Class<?> someInterface = Class.forName(lambdaClass);
            Object instance = Proxy.newProxyInstance(someInterface.getClassLoader(), new Class[]{someInterface}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    lambda.run();
                    return null;
                }
            });
            Method setAboutHandler = obj.getClass().getMethod(setter, someInterface);
            setAboutHandler.invoke(obj, instance);
        }
        catch (Throwable th) {
            Logger.getLogger(JavaCompatUtil.class.getName()).log(Level.INFO, "unable to call", th);
        }
    }

    public static String replaceAll(String string, String notregex, String replacement) {
        return string.replaceAll(JavaCompatUtil.quote(notregex), JavaCompatUtil.quoteReplacement(replacement));
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String join(Collection list, String delimiter) {
        Iterator i = list.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            Object e = i.next();
            sb.append(e);
            if (!i.hasNext()) {
                return sb.toString();
            }
            sb.append(delimiter);
        }
    }

    public static String listToCsv(List<String> listOfStrings, char separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listOfStrings.size() - 1; ++i) {
            sb.append(listOfStrings.get(i));
            sb.append(separator);
        }
        if (listOfStrings.size() > 0) {
            sb.append(listOfStrings.get(listOfStrings.size() - 1));
        }
        return sb.toString();
    }
}

