/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.NullCipher;
import javax.crypto.SealedObject;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.RiskController;
import net.yura.domination.engine.RiskListener;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.p2pclient.ChatClient;
import net.yura.domination.engine.p2pserver.ChatArea;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.mobile.util.Url;

public class Risk
extends Thread {
    public static final String STARTGAME_OPTION_MODE_DOMINATION = "domination";
    public static final String STARTGAME_OPTION_MODE_CAPITAL = "capital";
    public static final String STARTGAME_OPTION_MODE_SECRET_MISSION = "mission";
    public static final String STARTGAME_OPTION_CARD_INCREASING_SET = "increasing";
    public static final String STARTGAME_OPTION_CARD_FIXED_SET = "fixed";
    public static final String STARTGAME_OPTION_CARD_ITALIAN_LIKE_SET = "italianlike";
    public static final String STARTGAME_OPTION_AUTO_PLACE_ALL = "autoplaceall";
    public static final String STARTGAME_OPTION_RECYCLE_CARDS = "recycle";
    public static final String STARTGAME_OPTION_DEFENDER_DICE = "defenderdice=";
    private static final int DEFAULT_SHOW_DICE_SLEEP = 1000;
    private static final int DEFAULT_ROLL_DICE_SLEEP = 500;
    private static int SHOW_DICE_SLEEP = 1000;
    private static int ROLL_DICE_SLEEP = 500;
    private static final Logger logger = Logger.getLogger(Risk.class.getName());
    protected RiskGame game;
    protected RiskController controller;
    OnlineRisk onlinePlayClient;
    private ChatArea p2pServer;
    private int p2pPort = 4444;
    protected String myAddress;
    private ByteArrayOutputStream Undo = new ByteArrayOutputStream();
    protected boolean unlimitedLocalMode;
    private boolean autoplaceall;
    private boolean battle;
    private boolean replay;
    protected final List inbox = new Vector();
    protected ResourceBundle resb;
    protected Properties riskconfig;
    public static final String[] types = new String[]{"human", "ai easy", "ai easy", "ai easy", "ai average", "ai average"};
    public static final String[] names = new String[]{"player", "bob", "fred", "ted", "yura", "lala"};
    public static final String[] colors = new String[]{"cyan", "green", "magenta", "red", "blue", "yellow"};
    boolean running = true;
    final AIManager ai = new AIManager();
    boolean skipUndo;

    public Risk() {
        super(null, null, "DOMINATION-GAME-THREAD", 100000000L);
        this.resb = TranslationBundle.getBundle();
        try {
            String newName = System.getProperty("user.name");
            if (newName == null || "".equals(newName.trim())) {
                throw new Exception("bad user name");
            }
            for (int c = 0; c < names.length; ++c) {
                if (!names[c].equals(newName)) continue;
                throw new Exception("name already in use");
            }
            Risk.names[0] = newName;
        }
        catch (Throwable newName) {
            // empty catch block
        }
        this.riskconfig = new Properties();
        this.riskconfig.setProperty("default.autoplaceall", "false");
        this.riskconfig.setProperty("default.recycle", "true");
        for (int c = 0; c < names.length; ++c) {
            this.riskconfig.setProperty("default.player" + (c + 1) + ".type", types[c]);
            this.riskconfig.setProperty("default.player" + (c + 1) + ".color", colors[c]);
            this.riskconfig.setProperty("default.player" + (c + 1) + ".name", names[c]);
        }
        this.riskconfig.setProperty("p2p.host", "localhost");
        try {
            this.riskconfig.load(RiskUtil.openStream("game.ini"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RiskGame.setDefaultMapAndCards(this.riskconfig.getProperty("default.map", RiskGame.getDefaultMap()), this.riskconfig.getProperty("default.cards", RiskGame.getDefaultCards()));
        RiskGame.MAX_PLAYERS = Integer.parseInt(this.riskconfig.getProperty("game.players.max", String.valueOf(RiskGame.MAX_PLAYERS)));
        this.p2pPort = Integer.parseInt(this.riskconfig.getProperty("p2p.port", String.valueOf(this.p2pPort)));
        Risk.setShowDice(Boolean.parseBoolean(this.riskconfig.getProperty("game.dice.show", String.valueOf(Risk.isShowDice()))));
        AIManager.setWait(Integer.parseInt(this.riskconfig.getProperty("ai.wait", String.valueOf(AIManager.getWait()))));
        this.controller = new RiskController();
        this.start();
    }

    public Risk(String b, String c) {
        this();
        RiskGame.setDefaultMapAndCards(b, c);
    }

    public static void setShowDice(boolean show) {
        if (show) {
            SHOW_DICE_SLEEP = 1000;
            ROLL_DICE_SLEEP = 500;
        } else {
            SHOW_DICE_SLEEP = 0;
            ROLL_DICE_SLEEP = 0;
        }
    }

    public static boolean isShowDice() {
        return SHOW_DICE_SLEEP > 0 || ROLL_DICE_SLEEP > 0;
    }

    public String getRiskConfig(String a) {
        return this.riskconfig.getProperty(a);
    }

    public void addRiskListener(RiskListener o) {
        this.controller.addListener(o);
        this.setHelp();
    }

    public void deleteRiskListener(RiskListener o) {
        this.controller.deleteListener(o);
    }

    public void parser(String commandFromUI) {
        this.addToInbox(new GameCommand(1, commandFromUI));
    }

    public void parserFromNetwork(String m) {
        this.addToInbox(new GameCommand(2, m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parserAndWait(String uiCommand) throws InterruptedException {
        Object lock;
        GameCommand gCommand = new GameCommand(1, uiCommand);
        gCommand.notifier = lock = new Object();
        Object object = lock;
        synchronized (object) {
            this.addToInbox(gCommand);
            lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToInbox(Runnable m) {
        List list = this.inbox;
        synchronized (list) {
            this.inbox.add(m);
            this.inbox.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        List list = this.inbox;
        synchronized (list) {
            this.running = false;
            this.inbox.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myAddress = RiskUtil.createRandomUniqueAddress();
        Runnable message = null;
        while (this.running) {
            try {
                List list = this.inbox;
                synchronized (list) {
                    while (this.inbox.isEmpty()) {
                        if (!this.running) {
                            return;
                        }
                        try {
                            this.inbox.wait();
                        }
                        catch (InterruptedException e) {
                            System.err.println("InterruptedException in " + this.getName());
                        }
                    }
                    message = (Runnable)this.inbox.remove(0);
                }
                message.run();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "ERROR processing " + message, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFromUI(String message) {
        if (message.trim().length() == 0) {
            this.controller.sendMessage(">", false, false);
            this.getInput();
            return;
        }
        if (message.equals("ver")) {
            this.controller.sendMessage(">" + message, false, false);
            this.controller.sendMessage(RiskUtil.GAME_NAME + " Game Engine [Version " + RiskUtil.RISK_VERSION + "]", false, false);
            this.getInput();
        } else if (message.startsWith("rem ")) {
            this.controller.sendMessage(">" + message, false, false);
            this.getInput();
        } else if (this.game == null) {
            this.noGameParser(message);
        } else {
            String output;
            StringTokenizer StringT = new StringTokenizer(message);
            String input = StringT.nextToken();
            if (input.equals("closegame")) {
                if (!StringT.hasMoreTokens()) {
                    this.closeGame();
                    output = this.resb.getString("core.close.closed");
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "closegame");
                }
            } else if (input.equals("savegame")) {
                if (StringT.countTokens() >= 1) {
                    if (this.unlimitedLocalMode) {
                        String filename = RiskUtil.getAtLeastOne(StringT);
                        try {
                            RiskUtil.saveFile(filename, this.game);
                            output = this.resb.getString("core.save.saved");
                        }
                        catch (Exception ex) {
                            Level level = Level.WARNING;
                            if (ex.getMessage() != null && ex.getMessage().endsWith("open failed: ENOSPC (No space left on device)")) {
                                level = Level.INFO;
                            }
                            logger.log(level, "error saving game to file: " + filename, ex);
                            output = this.resb.getString("core.save.error.unable") + " " + ex;
                            this.showMessageDialog(output);
                        }
                    } else {
                        output = this.resb.getString("core.save.error.unable");
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "savegame filename");
                }
            } else if (input.equals("replay")) {
                if (!StringT.hasMoreTokens()) {
                    if (this.unlimitedLocalMode) {
                        try {
                            Vector replayCommands = this.game.getCommands();
                            this.saveGameToUndoObject();
                            this.game = new RiskGame();
                            this.replay = true;
                            for (String command : replayCommands) {
                                try {
                                    this.inGameParser(command);
                                }
                                catch (IllegalArgumentException error) {
                                    if (this.game.getCurrentPlayer() != null && this.game.getCurrentPlayer().getType() == 0) {
                                        logger.log(Level.INFO, "invalid replay user command: " + command, error);
                                        continue;
                                    }
                                    throw error;
                                }
                            }
                            output = "replay of game finished";
                        }
                        catch (Exception e) {
                            output = "error with replay " + e;
                            RiskUtil.printStackTrace(e);
                        }
                        finally {
                            this.replay = false;
                        }
                    } else {
                        output = "can only replay local games";
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "replay");
                }
            } else if (this.onlinePlayClient == null) {
                this.inGameParser(this.myAddress + " " + message);
                output = null;
            } else {
                this.onlinePlayClient.sendUserCommand(message);
                output = null;
            }
            if (output != null) {
                this.controller.sendMessage("game>" + message, false, false);
                this.controller.sendMessage(output, false, false);
                this.getInput();
            }
        }
    }

    private void noGameParser(String message) {
        String output;
        block50: {
            StringTokenizer StringT = new StringTokenizer(message);
            String input = StringT.nextToken();
            this.controller.sendMessage(">" + message, false, false);
            if (input.equals("newgame")) {
                if (!StringT.hasMoreTokens()) {
                    try {
                        this.game = new RiskGame();
                        this.unlimitedLocalMode = true;
                        this.controller.newGame(true);
                        this.setupPreviews(this.doesMapHaveMission());
                        output = this.resb.getString("core.newgame.created");
                    }
                    catch (Exception e) {
                        RiskUtil.printStackTrace(e);
                        output = this.resb.getString("core.newgame.error") + " " + e.toString();
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "newgame");
                }
            } else if (input.equals("loadgame")) {
                if (StringT.countTokens() >= 1) {
                    String filename = RiskUtil.getAtLeastOne(StringT);
                    try {
                        this.game = RiskGame.loadGame(filename);
                        if (this.game == null) {
                            throw new Exception("no game");
                        }
                        this.unlimitedLocalMode = true;
                        output = this.resb.getString("core.loadgame.loaded");
                        Player player = this.game.getCurrentPlayer();
                        if (player != null) {
                            this.saveGameToUndoObject();
                            output = output + System.getProperty("line.separator") + this.resb.getString("core.loadgame.currentplayer") + " " + player.getName();
                        }
                        if (this.game.getState() == 0) {
                            this.controller.newGame(true);
                            this.setupPreviews(this.doesMapHaveMission());
                            break block50;
                        }
                        this.controller.startGame(this.unlimitedLocalMode);
                    }
                    catch (Throwable ex) {
                        logger.log(filename.endsWith(".save") ? Level.WARNING : Level.INFO, "error loading game from file: " + filename, ex);
                        output = this.resb.getString("core.loadgame.error.load") + " " + ex;
                        this.showMessageDialog(output);
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "loadgame filename");
                }
            } else if (input.equals("join")) {
                if (StringT.countTokens() == 1) {
                    try {
                        this.onlinePlayClient = new ChatClient(this, this.myAddress, StringT.nextToken(), this.p2pPort);
                        this.game = new RiskGame();
                        this.unlimitedLocalMode = false;
                        this.controller.newGame(false);
                        this.setupPreviews(this.doesMapHaveMission());
                        output = this.resb.getString("core.join.created");
                    }
                    catch (UnknownHostException e) {
                        this.game = null;
                        output = this.resb.getString("core.join.error.unknownhost");
                    }
                    catch (ConnectException e) {
                        this.game = null;
                        output = this.resb.getString("core.join.error.connect");
                    }
                    catch (IllegalArgumentException e) {
                        this.game = null;
                        output = this.resb.getString("core.join.error.nothostname");
                    }
                    catch (IOException e) {
                        this.game = null;
                        output = this.resb.getString("core.join.error.002") + " " + e;
                    }
                    catch (AccessControlException e) {
                        this.game = null;
                        output = "AccessControlException:\n" + this.resb.getString("core.error.applet");
                    }
                    catch (Exception e) {
                        this.game = null;
                        output = this.resb.getString("core.join.error.create") + " " + e;
                    }
                    if (this.game == null) {
                        this.showMessageDialog(output);
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "join server");
                }
            } else if (input.equals("startserver")) {
                if (!StringT.hasMoreTokens()) {
                    if (this.p2pServer == null) {
                        try {
                            this.p2pServer = new ChatArea(this.controller, this.p2pPort);
                            output = this.resb.getString("core.startserver.started");
                            this.controller.serverState(true);
                        }
                        catch (Exception e) {
                            this.p2pServer = null;
                            output = this.resb.getString("core.startserver.error") + " " + e;
                            this.showMessageDialog(output);
                        }
                    } else {
                        output = this.resb.getString("core.startserver.error");
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "startserver");
                }
            } else if (input.equals("killserver")) {
                if (!StringT.hasMoreTokens()) {
                    if (this.p2pServer != null) {
                        try {
                            if (this.p2pServer != null) {
                                this.p2pServer.closeSocket();
                                this.p2pServer = null;
                            }
                            output = this.resb.getString("core.killserver.killed");
                            this.controller.serverState(false);
                        }
                        catch (Exception e) {
                            output = this.resb.getString("core.killserver.error") + " " + e.getMessage();
                        }
                    } else {
                        output = this.resb.getString("core.killserver.noserver");
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "killserver");
                }
            } else if (input.equals("play")) {
                if (StringT.countTokens() >= 1) {
                    String filename = RiskUtil.getAtLeastOne(StringT);
                    try {
                        URL url = new File(filename).toURI().toURL();
                        BufferedReader bufferin = new BufferedReader(new InputStreamReader(url.openStream()));
                        class Replay
                        extends Thread {
                            private Risk risk;
                            private BufferedReader bufferin;

                            public Replay(Risk r, BufferedReader in) {
                                super("Domination-Replay");
                                this.risk = r;
                                this.bufferin = in;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                int line = 0;
                                try {
                                    String input = this.bufferin.readLine();
                                    while (input != null) {
                                        ++line;
                                        try {
                                            this.risk.inGameParser(input);
                                        }
                                        catch (IllegalArgumentException error) {
                                            if (Risk.this.game.getCurrentPlayer() != null && Risk.this.game.getCurrentPlayer().getType() == 0) {
                                                logger.log(Level.INFO, "invalid script user command on line: " + line + " input: " + input, error);
                                            }
                                            throw error;
                                        }
                                        input = this.bufferin.readLine();
                                    }
                                }
                                catch (Exception error) {
                                    logger.log(Level.WARNING, "script error on line " + line, error);
                                }
                                finally {
                                    RiskUtil.close(this.bufferin);
                                }
                                Risk.this.replay = false;
                                Risk.this.getInput();
                            }
                        }
                        Replay replaythread = new Replay(this, bufferin);
                        this.replay = true;
                        this.game = new RiskGame();
                        this.unlimitedLocalMode = true;
                        this.controller.newGame(true);
                        this.setupPreviews(this.doesMapHaveMission());
                        replaythread.start();
                        output = "playing \"" + filename + "\"";
                    }
                    catch (Exception error) {
                        output = "unable to play \"" + filename + "\" " + error;
                    }
                } else {
                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "play filename");
                }
            } else {
                output = this.resb.getString("core.loadgame.nogame");
            }
        }
        this.controller.sendMessage(output, false, true);
        this.getInput();
    }

    protected void inGameParser(String message) {
        this.controller.sendDebug(message);
        boolean needInput = true;
        String output = null;
        StringTokenizer StringT = new StringTokenizer(message);
        String Addr = StringT.nextToken();
        if (!Addr.equals("ERROR")) {
            this.game.addCommand(message);
        }
        if (Addr.equals("ERROR")) {
            String Pname = StringT.nextToken();
            while (StringT.hasMoreTokens()) {
                Pname = Pname + " " + StringT.nextToken();
            }
            this.showMessageDialog(Pname);
        } else if (Addr.equals("LEAVE")) {
            int c;
            String id = StringT.nextToken();
            if (!(this.game.getCurrentPlayer() == null || this.game.getCurrentPlayer().getAddress().equals(id) && this.game.getCurrentPlayer().getType() == 0)) {
                needInput = false;
            }
            output = "someone has gone: ";
            Vector leavers = this.game.getPlayers();
            String newPlayerAddress = null;
            for (c = 0; c < leavers.size(); ++c) {
                if (((Player)leavers.get(c)).getAddress().equals(id)) continue;
                newPlayerAddress = ((Player)leavers.get(c)).getAddress();
                break;
            }
            for (c = 0; c < leavers.size(); ++c) {
                Player patc = (Player)leavers.get(c);
                if (!patc.getAddress().equals(id)) continue;
                if (patc.getType() == 0) {
                    output = output + patc.getName() + " ";
                    if (this.game.getState() == 0) {
                        if (this.game.delPlayer(patc.getName())) {
                            --c;
                            this.controller.delPlayer(patc.getName());
                            patc = null;
                        }
                    } else {
                        patc.setType(3);
                    }
                }
                if (patc == null || newPlayerAddress == null) continue;
                patc.setAddress(newPlayerAddress);
            }
        } else if (Addr.equals("DICE")) {
            int attSize = RiskGame.getNumber(StringT.nextToken());
            int defSize = RiskGame.getNumber(StringT.nextToken());
            output = this.resb.getString("core.dice.rolling") + System.getProperty("line.separator") + this.resb.getString("core.dice.results");
            int[] att = new int[attSize];
            output = output + " " + this.resb.getString("core.dice.attacker");
            for (int c = 0; c < attSize; ++c) {
                att[c] = RiskGame.getNumber(StringT.nextToken());
                output = output + " " + (att[c] + 1);
            }
            int[] def = new int[defSize];
            output = output + " " + this.resb.getString("core.dice.defender");
            for (int c = 0; c < defSize; ++c) {
                def[c] = RiskGame.getNumber(StringT.nextToken());
                output = output + " " + (def[c] + 1);
            }
            output = output + System.getProperty("line.separator");
            Country attacker = this.game.getAttacker();
            int[] result = this.game.battle(att, def);
            if (result[0] == 1) {
                output = output + JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.dice.result"), "{0}", String.valueOf(result[2])), "{1}", String.valueOf(result[1]));
                if (result[3] == 0) {
                    int n = attacker.getArmies() - 1;
                    output = output + System.getProperty("line.separator") + this.resb.getString("core.dice.notdefeated") + " ";
                    if (n > 0) {
                        if (n > 3) {
                            n = 3;
                        }
                        output = output + JavaCompatUtil.replaceAll(this.resb.getString("core.dice.attackagain"), "{0}", "" + n);
                    } else {
                        output = output + this.resb.getString("core.dice.noattackagain");
                    }
                } else {
                    output = output + System.getProperty("line.separator") + this.resb.getString("core.dice.defeated") + " ";
                    if (result[3] == 2) {
                        output = output + this.resb.getString("core.dice.eliminated") + " ";
                    }
                    if (result[4] == result[5]) {
                        int noa = this.game.moveAll();
                        int ma = this.game.moveArmies(noa);
                        output = output + JavaCompatUtil.replaceAll(this.resb.getString("core.dice.armiesmoved"), "{0}", String.valueOf(noa));
                        if (ma == 2) {
                            output = output + this.whoWon();
                        }
                    } else {
                        output = output + JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.dice.howmanyarmies"), "{0}", String.valueOf(result[4])), "{1}", String.valueOf(result[5]));
                    }
                }
                if (this.battle) {
                    boolean weAreAttacker = this.showHumanPlayerThereInfo(attacker.getOwner());
                    boolean defenderWon = result[3] == 0 && attacker.getArmies() == 1;
                    this.controller.showDiceResults(att, def, weAreAttacker, defenderWon ? -1 : result[3]);
                    try {
                        Thread.sleep(SHOW_DICE_SLEEP);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                output = this.resb.getString("core.dice.error.unabletoroll");
            }
            if (this.game.getState() != 4 && this.game.getState() != 10) {
                this.closeBattle();
            }
        } else if (Addr.equals("PLAYER")) {
            int index = Integer.parseInt(StringT.nextToken());
            Player p = this.game.setCurrentPlayer(index);
            this.controller.sendMessage("Game started", false, false);
            output = JavaCompatUtil.replaceAll(this.resb.getString("core.player.randomselected"), "{0}", p.getName());
            if (this.game.getGameMode() == 3 || this.autoplaceall) {
                needInput = false;
            } else {
                this.saveGameToUndoObject();
            }
        } else if (Addr.equals("CARD")) {
            if (StringT.hasMoreTokens()) {
                String name = StringT.nextToken();
                Card card = this.game.findCardAndRemoveIt(name);
                this.game.getCurrentPlayer().giveCard(card);
                if (this.showHumanCurrentPlayerInfo()) {
                    String cardName = name.equals("wildcard") ? name : card.getName() + " " + this.game.getCountryInt(Integer.parseInt(name)).getName();
                    this.controller.playerGotCard();
                    this.controller.sendMessage("You got a new card: \"" + cardName + "\"", false, false);
                }
            }
            Player newplayer = this.game.endGo();
            output = JavaCompatUtil.replaceAll(this.resb.getString("core.player.newselected"), "{0}", newplayer.getName());
            if (this.unlimitedLocalMode && this.game.getSetupDone() && newplayer.getName().equals("Theo")) {
                newplayer.addArmies(newplayer.getExtraArmies());
            }
            this.saveGameToUndoObject();
        } else if (Addr.equals("PLACE")) {
            Country c = this.game.getCountryInt(Integer.parseInt(StringT.nextToken()));
            this.game.placeArmy(c, 1);
            this.controller.sendMessage(JavaCompatUtil.replaceAll(this.resb.getString("core.place.oneplacedin"), "{0}", c.getName()), false, false);
            output = this.resb.getString("core.place.autoplaceok");
        } else if (Addr.equals("PLACEALL")) {
            for (int c = 0; c < this.game.getNoCountries(); ++c) {
                Country t = this.game.getCountryInt(Integer.parseInt(StringT.nextToken()));
                this.game.placeArmy(t, 1);
                this.controller.sendMessage(JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.place.getcountry"), "{0}", this.game.getCurrentPlayer().getName()), "{1}", t.getName()), false, false);
                this.game.endGo();
            }
            this.saveGameToUndoObject();
            this.controller.sendMessage("Auto place all successful.", false, false);
            output = JavaCompatUtil.replaceAll(this.resb.getString("core.player.newselected"), "{0}", this.game.getCurrentPlayer().getName());
        } else if (Addr.equals("MISSION")) {
            ArrayList m = new ArrayList(this.game.getMissions());
            Vector p = this.game.getPlayers();
            for (int c = 0; c < p.size(); ++c) {
                int i = RiskGame.getNumber(StringT.nextToken());
                ((Player)p.get(c)).setMission((Mission)m.get(i));
                m.remove(i);
            }
            output = null;
            needInput = false;
        } else if (Addr.equals("RENAME")) {
            Hashtable map = Url.toHashtable(message.substring(Addr.length() + 1));
            String oldName = (String)map.get("oldName");
            String newName = (String)map.get("newName");
            String newAddress = (String)map.get("newAddress");
            int newType = Integer.parseInt((String)map.get("newType"));
            try {
                this.renamePlayer(oldName, newName, newAddress, newType);
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
            }
        } else {
            block252: {
                Object c;
                String echo = message.substring(Addr.length() + 1);
                if (this.game != null && this.game.getCurrentPlayer() != null && this.game.getState() != 8) {
                    String typeString;
                    int type = this.game.getCurrentPlayer().getType();
                    String key = type == 0 ? "newgame.player.type.human" : "newgame.player.type." + this.ai.getCommandFromType(type) + "ai";
                    try {
                        typeString = this.resb.getString(key);
                    }
                    catch (MissingResourceException ex) {
                        typeString = key;
                    }
                    this.controller.sendMessage(this.game.getCurrentPlayer().getName() + "(" + typeString + ")>" + echo, false, false);
                } else {
                    this.controller.sendMessage("game>" + echo, false, false);
                }
                String input = StringT.nextToken();
                output = "";
                if (this.game.getState() == 0) {
                    String filename;
                    if (input.equals("choosemap")) {
                        if (StringT.countTokens() >= 1) {
                            filename = RiskUtil.getAtLeastOne(StringT);
                            try {
                                this.setMap(filename);
                            }
                            catch (Exception e) {
                                RiskUtil.streamOpener.getMap(filename, new Observer(){

                                    public void update(Observable observable, Object data) {
                                        if (data == RiskUtil.SUCCESS) {
                                            try {
                                                Risk.this.setMap(filename);
                                            }
                                            catch (Exception ex) {
                                                Risk.this.getMapError(ex.toString());
                                            }
                                        } else {
                                            Risk.this.getMapError(e.toString());
                                        }
                                    }
                                });
                            }
                            output = null;
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "choosemap filename");
                        }
                    } else if (input.equals("choosecards")) {
                        if (StringT.countTokens() >= 1) {
                            filename = RiskUtil.getAtLeastOne(StringT);
                            try {
                                boolean yesmissions = this.game.setCardsfile(filename);
                                this.controller.showCardsFile(this.game.getCardsFile(), yesmissions);
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.choosecards.chosen"), "{0}", filename);
                            }
                            catch (Exception e) {
                                output = this.resb.getString("core.choosecards.error.unable");
                            }
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "choosecards filename");
                        }
                    } else if (input.equals("newplayer")) {
                        if (StringT.countTokens() >= 3) {
                            String type = StringT.nextToken();
                            if (type.equals("ai")) {
                                type = type + " " + StringT.nextToken();
                            }
                            c = StringT.nextToken();
                            String name = "";
                            while (StringT.hasMoreTokens()) {
                                name = name + StringT.nextToken();
                                if (!StringT.hasMoreTokens()) continue;
                                name = name + " ";
                            }
                            int t = this.getType(type);
                            int color = ColorUtil.getColor((String)c);
                            if (color != 0 && t != -1 && !name.equals("") && (this.unlimitedLocalMode && this.game.addPlayer(t, name, color, "LOCALGAME") || !this.unlimitedLocalMode && this.game.addPlayer(t, name, color, Addr))) {
                                output = JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.newplayer.created"), "{0}", name), "{1}", (String)c);
                                this.controller.addPlayer(t, name, color, Addr);
                            } else {
                                output = this.resb.getString("core.newplayer.error.unable");
                            }
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "newplayer type (skill) color name");
                        }
                    } else if (input.equals("delplayer")) {
                        if (StringT.countTokens() >= 1) {
                            String name = RiskUtil.getAtLeastOne(StringT);
                            if (this.game.delPlayer(name)) {
                                this.controller.delPlayer(name);
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.delplayer.deleted"), "{0}", name);
                            } else {
                                output = this.resb.getString("core.delplayer.error.unable");
                            }
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "delplayer name");
                        }
                    } else if (input.equals("info")) {
                        if (!StringT.hasMoreTokens()) {
                            output = this.resb.getString("core.info.title") + "\n";
                            Vector players = this.game.getPlayers();
                            for (int a = 0; a < players.size(); ++a) {
                                output = output + this.resb.getString("core.info.player") + " " + ((Player)players.get(a)).getName() + "\n";
                            }
                            output = output + this.resb.getString("core.info.mapfile") + " " + this.game.getMapFile() + "\n";
                            output = output + this.resb.getString("core.info.cardsfile") + " " + this.game.getCardsFile();
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "info");
                        }
                    } else if (input.equals("autosetup")) {
                        if (!StringT.hasMoreTokens()) {
                            if (this.game.getPlayers().size() == 0) {
                                if (!this.replay) {
                                    for (int c2 = 1; c2 <= RiskGame.MAX_PLAYERS; ++c2) {
                                        String playerType = this.riskconfig.getProperty("default.player" + c2 + ".type");
                                        String playerColor = this.riskconfig.getProperty("default.player" + c2 + ".color");
                                        String playerName = this.riskconfig.getProperty("default.player" + c2 + ".name");
                                        if (playerType == null || playerColor == null || playerName == null) continue;
                                        this.parser("newplayer " + playerType + " " + playerColor + " " + playerName);
                                    }
                                    output = this.resb.getString("core.info.autosetup");
                                } else {
                                    output = "replay mode, nothing done";
                                }
                            } else {
                                output = this.resb.getString("core.info.autosetup.error");
                            }
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autosetup");
                        }
                    } else if (input.equals("startgame")) {
                        if (StringT.countTokens() >= 2 && StringT.countTokens() <= 5) {
                            int n = this.game.getPlayers().size();
                            int newgame_type = -1;
                            int newgame_cardType = -1;
                            boolean maxFiveCards = true;
                            boolean newgame_autoplaceall = false;
                            boolean newgame_recycle = false;
                            Integer defenderDice = null;
                            boolean minimumThreeArmies = true;
                            String crap = null;
                            while (StringT.hasMoreTokens()) {
                                String newOption = StringT.nextToken();
                                if (newOption.equals(STARTGAME_OPTION_MODE_DOMINATION)) {
                                    newgame_type = 0;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_MODE_CAPITAL)) {
                                    newgame_type = 2;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_MODE_SECRET_MISSION)) {
                                    newgame_type = 3;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_CARD_INCREASING_SET)) {
                                    newgame_cardType = 0;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_CARD_FIXED_SET)) {
                                    newgame_cardType = 1;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_CARD_ITALIAN_LIKE_SET)) {
                                    newgame_cardType = 2;
                                    minimumThreeArmies = false;
                                    maxFiveCards = false;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_AUTO_PLACE_ALL)) {
                                    newgame_autoplaceall = true;
                                    continue;
                                }
                                if (newOption.equals(STARTGAME_OPTION_RECYCLE_CARDS)) {
                                    newgame_recycle = true;
                                    continue;
                                }
                                if (newOption.startsWith(STARTGAME_OPTION_DEFENDER_DICE)) {
                                    defenderDice = Integer.parseInt(newOption.substring(STARTGAME_OPTION_DEFENDER_DICE.length()));
                                    continue;
                                }
                                crap = newOption;
                            }
                            if (crap == null) {
                                defenderDice = defenderDice == null ? (newgame_cardType == 2 ? 3 : 2) : defenderDice;
                                if (newgame_type != -1 && newgame_cardType != -1 && n >= 2 && n <= RiskGame.MAX_PLAYERS && defenderDice >= 1 && defenderDice <= 3) {
                                    this.autoplaceall = newgame_autoplaceall;
                                    try {
                                        this.game.startGame(newgame_type, newgame_cardType, newgame_recycle, maxFiveCards, defenderDice, minimumThreeArmies);
                                    }
                                    catch (Exception e) {
                                        RiskUtil.printStackTrace(e);
                                    }
                                }
                                if (this.game.getState() != 0) {
                                    this.controller.noInput();
                                    this.controller.startGame(this.unlimitedLocalMode);
                                    if (this.shouldGameCommand(Addr)) {
                                        this.gameCommand(Addr, "PLAYER", String.valueOf(this.game.getRandomPlayer()));
                                        if (this.game.getGameMode() == 3) {
                                            Random r = new Random();
                                            int a = this.game.getNoMissions();
                                            int b = this.game.getNoPlayers();
                                            StringBuffer outputa = new StringBuffer();
                                            for (int c3 = 0; c3 < b; ++c3) {
                                                if (outputa.length() != 0) {
                                                    outputa.append(' ');
                                                }
                                                outputa.append(r.nextInt(a));
                                                --a;
                                            }
                                            this.gameCommand(Addr, "MISSION", outputa.toString());
                                        }
                                        if (this.game.getGameMode() == 3 || this.autoplaceall) {
                                            List a = this.game.shuffleCountries();
                                            StringBuffer outputb = new StringBuffer();
                                            for (int c4 = 0; c4 < a.size(); ++c4) {
                                                if (outputb.length() != 0) {
                                                    outputb.append(' ');
                                                }
                                                outputb.append(((Country)a.get(c4)).getColor());
                                            }
                                            this.gameCommand(Addr, "PLACEALL", outputb.toString());
                                        }
                                    }
                                    output = null;
                                    needInput = false;
                                } else {
                                    output = newgame_type == 3 && this.game.getNoMissions() < this.game.getPlayers().size() ? "map does not have enough missions for players" : this.resb.getString("core.start.error.players");
                                }
                            } else {
                                output = "unknown option: " + crap;
                            }
                        } else {
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "startgame gametype cardtype (autoplaceall recycle)");
                        }
                    } else {
                        output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "newplayer, delplayer, startgame, choosemap, choosecards, info, autosetup");
                    }
                } else {
                    boolean aiPlayer = this.game.getCurrentPlayer().getType() != 0;
                    try {
                        String arg1;
                        String option;
                        String strSelected;
                        if (input.equals("undo")) {
                            if (this.game.getState() != 8 && aiPlayer) {
                                throw new IllegalArgumentException("ai is trying to call undo");
                            }
                            if (!StringT.hasMoreTokens()) {
                                if (this.unlimitedLocalMode) {
                                    try {
                                        if (this.game.getState() != 10 && this.Undo != null && this.Undo.size() != 0) {
                                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.Undo.toByteArray()));
                                            this.game = (RiskGame)in.readObject();
                                            output = this.resb.getString("core.undo.undone");
                                            break block252;
                                        }
                                        output = this.resb.getString("core.undo.error.unable");
                                    }
                                    catch (Exception e) {
                                        logger.log(Level.WARNING, this.resb.getString("core.loadgame.error.undo"), e);
                                    }
                                    break block252;
                                }
                                output = this.resb.getString("core.undo.error.network");
                                break block252;
                            }
                            output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "undo");
                            break block252;
                        }
                        if (input.equals("showmission")) {
                            output = !StringT.hasMoreTokens() ? (this.showHumanCurrentPlayerInfo() ? this.resb.getString("core.showmission.mission") + " " + this.getHumanPlayerMission() : this.resb.getString("core.showmission.error")) : JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "showmission");
                            break block252;
                        }
                        if (input.equals("showarmies")) {
                            if (!StringT.hasMoreTokens()) {
                                if (this.game.getState() != 0) {
                                    Country[] v = this.game.getCountries();
                                    output = this.resb.getString("core.showarmies.countries") + System.getProperty("line.separator");
                                    for (int c5 = 0; c5 < v.length; ++c5) {
                                        output = output + v[c5].getColor() + " " + v[c5].getName() + " - ";
                                        if (v[c5].getOwner() != null) {
                                            output = output + v[c5].getOwner().getName() + " (" + v[c5].getArmies() + ")";
                                            if (this.game.getGameMode() == 2 && this.game.getSetupDone() && this.game.getState() != 9) {
                                                Vector players = this.game.getPlayers();
                                                for (int a = 0; a < players.size(); ++a) {
                                                    if (((Player)players.get(a)).getCapital() == null || ((Player)players.get(a)).getCapital() != v[c5]) continue;
                                                    output = output + " " + JavaCompatUtil.replaceAll(this.resb.getString("core.showarmies.captial"), "{0}", ((Player)players.get(a)).getName());
                                                }
                                            }
                                            output = output + System.getProperty("line.separator");
                                            continue;
                                        }
                                        output = output + this.resb.getString("core.showarmies.noowner") + System.getProperty("line.separator");
                                    }
                                } else {
                                    output = this.resb.getString("core.showarmies.error.unable");
                                }
                            } else {
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "showarmies");
                            }
                            break block252;
                        }
                        if (input.equals("showcards")) {
                            if (!StringT.hasMoreTokens()) {
                                if (this.showHumanCurrentPlayerInfo()) {
                                    c = this.game.getCurrentPlayer().getCards();
                                    if (c.size() == 0) {
                                        output = this.resb.getString("core.showcards.nocards");
                                    } else {
                                        output = this.resb.getString("core.showcards.youhave");
                                        for (int a = 0; a < c.size(); ++a) {
                                            output = ((Card)c.get(a)).getName().equals("wildcard") ? output + " " + "wildcard" : output + " \"" + ((Card)c.get(a)).getName() + " " + ((Card)c.get(a)).getCountry().getName() + " (" + ((Card)c.get(a)).getCountry().getColor() + ")\"";
                                        }
                                    }
                                    output = this.game.getCardMode() == 1 ? output + "\n" + this.resb.getString("cards.fixed") : (this.game.getCardMode() == 2 ? output + "\n" + this.resb.getString("cards.italianlike") : output + "\n" + JavaCompatUtil.replaceAll(this.resb.getString("cards.nexttrade"), "{0}", String.valueOf(this.getNewCardState())));
                                } else {
                                    output = this.resb.getString("core.showcards.error.unable");
                                }
                            } else {
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "showcards");
                            }
                            break block252;
                        }
                        if (input.equals("autoendgo")) {
                            if (!StringT.hasMoreTokens()) {
                                strSelected = this.game.getCurrentPlayer().getAutoEndGo() ? "core.autoendgo.on" : "core.autoendgo.off";
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.autoendgo.setto"), "{0}", this.resb.getString(strSelected));
                            } else if (StringT.countTokens() == 1) {
                                option = StringT.nextToken();
                                if (option.equals("on")) {
                                    this.game.getCurrentPlayer().setAutoEndGo(true);
                                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.autoendgo.setto"), "{0}", this.resb.getString("core.autoendgo.on"));
                                } else if (option.equals("off")) {
                                    this.game.getCurrentPlayer().setAutoEndGo(false);
                                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.autoendgo.setto"), "{0}", this.resb.getString("core.autoendgo.off"));
                                } else {
                                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.autoendgo.error.unknown"), "{0}", option);
                                }
                            } else {
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autoendgo on/off");
                            }
                            break block252;
                        }
                        if (input.equals("autodefend")) {
                            if (!StringT.hasMoreTokens()) {
                                strSelected = this.game.getCurrentPlayer().getAutoDefend() ? "core.autodefend.on" : "core.autodefend.on";
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.autodefend.setto"), "{0}", this.resb.getString(strSelected));
                            } else if (StringT.countTokens() == 1) {
                                option = StringT.nextToken();
                                if (option.equals("on")) {
                                    this.game.getCurrentPlayer().setAutoDefend(true);
                                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.autodefend.setto"), "{0}", this.resb.getString("core.autodefend.on"));
                                } else if (option.equals("off")) {
                                    this.game.getCurrentPlayer().setAutoDefend(false);
                                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.autodefend.setto"), "{0}", this.resb.getString("core.autodefend.off"));
                                } else {
                                    output = JavaCompatUtil.replaceAll(this.resb.getString("core.autodefend.error.unknown"), "{0}", option);
                                }
                            } else {
                                output = JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autodefend on/off");
                            }
                            break block252;
                        }
                        if (this.game.getState() == 1) {
                            if (input.equals("trade")) {
                                if (StringT.countTokens() == 3) {
                                    int noa = 0;
                                    Card[] cards = this.game.getCards(StringT.nextToken(), StringT.nextToken(), StringT.nextToken());
                                    if (cards[0] != null && cards[1] != null && cards[2] != null) {
                                        noa = this.game.trade(cards[0], cards[1], cards[2]);
                                    }
                                    if (noa != 0) {
                                        output = JavaCompatUtil.replaceAll(this.resb.getString("core.trade.traded"), "{0}", "" + noa);
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.trade.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "trade card card card"));
                            }
                            if (input.equals("endtrade")) {
                                if (!StringT.hasMoreTokens()) {
                                    if (this.game.endTrade()) {
                                        output = this.resb.getString("core.trade.endtrade");
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.trade.end.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "endtrade"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "showcards, trade" + (this.game.canEndTrade() ? ", endtrade" : "")));
                        }
                        if (this.game.getState() == 2) {
                            if (input.equals("placearmies")) {
                                if (StringT.countTokens() == 2) {
                                    String country = StringT.nextToken();
                                    int c6 = RiskGame.getNumber(country);
                                    int num = RiskGame.getNumber(StringT.nextToken());
                                    Country t = c6 != -1 ? this.game.getCountryInt(c6) : null;
                                    if (!(t == null || num == -1 || this.game.getGameMode() == 1 && t.getOwner() == null || this.game.getGameMode() == 3 && t.getOwner() == null)) {
                                        int result = this.game.placeArmy(t, num);
                                        if (result != 0) {
                                            output = JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.place.placed"), "{0}", String.valueOf(num)), "{1}", t.getName());
                                            if (result == 2) {
                                                output = output + this.whoWon();
                                            }
                                            break block252;
                                        }
                                        throw new IllegalArgumentException(this.resb.getString("core.place.error.unable"));
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.place.error.invalid"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "placearmies country number"));
                            }
                            if (input.equals("autoplace")) {
                                if (!StringT.hasMoreTokens()) {
                                    if (this.shouldGameCommand(Addr)) {
                                        this.gameCommand(Addr, "PLACE", String.valueOf(this.game.getRandomCountry()));
                                    }
                                    needInput = false;
                                    output = null;
                                    break block252;
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "autoplace"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "showarmies, placearmies, autoplace"));
                        }
                        if (this.game.getState() == 3) {
                            if (input.equals("attack")) {
                                if (StringT.countTokens() == 2) {
                                    int a2;
                                    Country country2;
                                    arg1 = StringT.nextToken();
                                    String arg2 = StringT.nextToken();
                                    int a1 = RiskGame.getNumber(arg1);
                                    Country country1 = a1 != -1 ? this.game.getCountryInt(a1) : null;
                                    boolean a = this.game.attack(country1, country2 = (a2 = RiskGame.getNumber(arg2)) != -1 ? this.game.getCountryInt(a2) : null);
                                    if (a) {
                                        output = JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.attack.attacking"), "{0}", country2.getName()), "{1}", "" + country2.getArmies()), "{2}", country1.getName()), "{3}", "" + country1.getArmies()), "{4}", "" + this.game.getNoAttackDice());
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.attack.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "attack country country"));
                            }
                            if (input.equals("endattack")) {
                                if (!StringT.hasMoreTokens()) {
                                    if (this.game.endAttack()) {
                                        output = this.resb.getString("core.attack.end.ended");
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.attack.end.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "endattack"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "attack, endattack"));
                        }
                        if (this.game.getState() == 4) {
                            if (input.equals("roll")) {
                                if (StringT.countTokens() == 1) {
                                    int dice = RiskGame.getNumber(StringT.nextToken());
                                    if (dice != -1 && this.game.rollA(dice)) {
                                        if (this.battle) {
                                            this.controller.setNODAttacker(dice);
                                        }
                                        int n = this.game.getNoDefendDice();
                                        output = JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.roll.rolled"), "{0}", this.game.getCurrentPlayer().getName()), "{1}", "" + n);
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.roll.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "roll number"));
                            }
                            if (input.equals("retreat")) {
                                if (!StringT.hasMoreTokens()) {
                                    if (this.game.retreat()) {
                                        output = this.resb.getString("core.retreat.retreated");
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.retreat.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "retreat"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "roll, retreat"));
                        }
                        if (this.game.getState() == 5) {
                            if (input.equals("move")) {
                                if (StringT.countTokens() == 1) {
                                    String num = StringT.nextToken();
                                    int noa = num.equals("all") ? this.game.moveAll() : RiskGame.getNumber(num);
                                    int mov = this.game.moveArmies(noa);
                                    if (mov != 0) {
                                        output = JavaCompatUtil.replaceAll(this.resb.getString("core.move.moved"), "{0}", "" + noa);
                                        if (mov == 2) {
                                            output = output + this.whoWon();
                                        }
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.move.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "move number"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "move"));
                        }
                        if (this.game.getState() == 6) {
                            if (input.equals("movearmies")) {
                                if (StringT.countTokens() == 3) {
                                    int noa;
                                    int a2;
                                    Country country2;
                                    arg1 = StringT.nextToken();
                                    String arg2 = StringT.nextToken();
                                    int a1 = RiskGame.getNumber(arg1);
                                    Country country1 = a1 != -1 ? this.game.getCountryInt(a1) : null;
                                    if (this.game.moveArmy(country1, country2 = (a2 = RiskGame.getNumber(arg2)) != -1 ? this.game.getCountryInt(a2) : null, noa = RiskGame.getNumber(StringT.nextToken()))) {
                                        output = JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(this.resb.getString("core.tacmove.movedfromto"), "{0}", "" + noa), "{1}", country1.getName()), "{2}", country2.getName());
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.tacmove.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "movearmies country country number"));
                            }
                            if (input.equals("nomove")) {
                                if (!StringT.hasMoreTokens()) {
                                    if (this.game.noMove()) {
                                        output = this.resb.getString("core.tacmove.no.nomoves");
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.tacmove.no.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "nomove"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "movearmies, nomove"));
                        }
                        if (this.game.getState() == 7) {
                            if (input.equals("endgo")) {
                                if (!StringT.hasMoreTokens()) {
                                    needInput = false;
                                    output = null;
                                    this.controller.sendMessage(this.resb.getString("core.endgo.ended"), false, false);
                                    this.DoEndGo();
                                    break block252;
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "endgo"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "emdgo"));
                        }
                        if (this.game.getState() == 8) {
                            if (input.equals("continue")) {
                                if (!StringT.hasMoreTokens()) {
                                    if (this.game.continuePlay()) {
                                        output = this.resb.getString("core.continue.successful");
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.continue.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "continue"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.gameover.won"), "{0}", this.game.getCurrentPlayer().getName()));
                        }
                        if (this.game.getState() == 9) {
                            if (input.equals(STARTGAME_OPTION_MODE_CAPITAL)) {
                                if (StringT.countTokens() == 1) {
                                    String strCountry = StringT.nextToken();
                                    int nCountryId = RiskGame.getNumber(strCountry);
                                    Country t = nCountryId != -1 ? this.game.getCountryInt(nCountryId) : null;
                                    if (t != null && this.game.setCapital(t)) {
                                        output = this.showHumanCurrentPlayerInfo() ? JavaCompatUtil.replaceAll(this.resb.getString("core.capital.selected"), "{0}", t.getName()) : this.resb.getString("core.capital.hasbeenselected");
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.capital.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "capital country"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", STARTGAME_OPTION_MODE_CAPITAL));
                        }
                        if (this.game.getState() == 10) {
                            if (input.equals("roll")) {
                                if (StringT.countTokens() == 1) {
                                    int dice = RiskGame.getNumber(StringT.nextToken());
                                    if (dice != -1 && this.game.rollD(dice)) {
                                        if (this.battle) {
                                            this.controller.setNODDefender(dice);
                                            try {
                                                Thread.sleep(ROLL_DICE_SLEEP);
                                            }
                                            catch (InterruptedException nCountryId) {
                                                // empty catch block
                                            }
                                        }
                                        if (this.shouldGameCommand(Addr)) {
                                            int c7;
                                            int[] attackerResults = this.game.rollDice(this.game.getAttackerDice());
                                            int[] defenderResults = this.game.rollDice(this.game.getDefenderDice());
                                            String serverRoll = "";
                                            serverRoll = serverRoll + attackerResults.length + " ";
                                            serverRoll = serverRoll + defenderResults.length + " ";
                                            for (c7 = 0; c7 < attackerResults.length; ++c7) {
                                                serverRoll = serverRoll + attackerResults[c7] + " ";
                                            }
                                            for (c7 = 0; c7 < defenderResults.length; ++c7) {
                                                serverRoll = serverRoll + defenderResults[c7] + " ";
                                            }
                                            this.gameCommand(Addr, "DICE", serverRoll);
                                        }
                                        output = null;
                                        needInput = false;
                                        break block252;
                                    }
                                    throw new IllegalArgumentException(this.resb.getString("core.roll.error.unable"));
                                }
                                throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.syntax"), "{0}", "roll number"));
                            }
                            throw new IllegalArgumentException(JavaCompatUtil.replaceAll(this.resb.getString("core.error.incorrect"), "{0}", "roll"));
                        }
                        throw new IllegalStateException(this.resb.getString("core.error.unknownstate"));
                    }
                    catch (IllegalArgumentException ex) {
                        if (aiPlayer) {
                            logger.log(Level.WARNING, "bad command from ai: \"" + message + "\" player=" + this.game.getCurrentPlayer() + " state=" + this.game.getState(), ex);
                        }
                        if (this.replay) {
                            throw ex;
                        }
                        output = ex.getMessage();
                    }
                }
            }
            this.updateBattleState();
        }
        if (output != null) {
            if (this.game == null) {
                this.controller.sendMessage(output, false, true);
            } else if (this.game.getState() == 0) {
                this.controller.sendMessage(output, false, true);
            } else if (this.game.getState() == 8) {
                this.controller.sendMessage(output, true, true);
            } else if (this.game.getState() == 7) {
                if (this.game.getCurrentPlayer().getAutoEndGo()) {
                    this.controller.sendMessage(output, false, false);
                } else {
                    this.controller.sendMessage(output, true, true);
                }
            } else {
                this.controller.sendMessage(output, true, true);
            }
        }
        if (this.game != null && this.game.getState() == 7 && this.game.getCurrentPlayer().getAutoEndGo()) {
            needInput = false;
            this.DoEndGo();
        }
        if (needInput) {
            this.getInput();
        }
    }

    public void getInput() {
        if (!this.inbox.isEmpty()) {
            return;
        }
        this.setHelp();
        if (this.game == null) {
            this.controller.needInput(-1);
        } else if (this.game != null && this.game.getCurrentPlayer() != null && this.game.getState() != 8) {
            this.updateBattleState();
            if (this.game.getState() == 1) {
                this.controller.sendMessage(JavaCompatUtil.replaceAll(this.resb.getString("core.input.newarmies"), "{0}", this.game.getCurrentPlayer().getExtraArmies() + ""), false, false);
            } else if (this.game.getState() == 2) {
                this.controller.sendMessage(JavaCompatUtil.replaceAll(this.resb.getString("core.input.armiesleft"), "{0}", this.game.getCurrentPlayer().getExtraArmies() + ""), false, false);
            }
            if (this.shouldGameCommand(this.game.getCurrentPlayer().getAddress())) {
                if (this.game.getState() == 10 && this.game.getCurrentPlayer().getAutoDefend()) {
                    this.gameCommand(this.myAddress, this.myAddress, this.getBasicPassiveGo());
                } else if (this.game.getCurrentPlayer().getType() == 0) {
                    this.controller.needInput(this.game.getState());
                } else {
                    this.ai.play(this);
                }
            }
        } else {
            this.controller.needInput(this.game.getState());
        }
    }

    private void setMap(String filename) throws Exception {
        if (this.game.getState() == 0) {
            boolean yesmissions = this.game.setMapfile(filename);
            this.setupPreviews(yesmissions);
            String output = JavaCompatUtil.replaceAll(this.resb.getString("core.choosemap.mapselected"), "{0}", filename);
            this.controller.sendMessage(output, false, true);
        } else {
            this.controller.startGame(this.unlimitedLocalMode);
        }
    }

    private void getMapError(String exception) {
        String output = this.resb.getString("core.choosemap.error.unable") + " " + exception;
        this.controller.sendMessage(output, false, true);
        this.showMessageDialog(output);
    }

    private void setupPreviews(boolean yesmissions) {
        this.controller.showMapPic(this.game);
        this.controller.showCardsFile(this.game.getCardsFile(), yesmissions);
    }

    private boolean doesMapHaveMission() {
        Map cardsinfo = RiskUtil.loadInfo(this.game.getCardsFile(), true);
        String[] missions = (String[])cardsinfo.get("missions");
        return missions.length > 0;
    }

    public int getType(String type) {
        if ("human".equals(type)) {
            return 0;
        }
        if (type != null && type.startsWith("ai ")) {
            String aiType = type.substring(3);
            try {
                return this.ai.getTypeFromCommand(aiType);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.INFO, "can not find ai", ex);
                return -1;
            }
        }
        return -1;
    }

    public String getType(int type) {
        if (type == 0) {
            return "human";
        }
        return "ai " + this.ai.getCommandFromType(type);
    }

    private boolean showHumanPlayerThereInfo(Player p) {
        return this.game.getState() == 8 || p != null && p.getType() == 0 && (this.unlimitedLocalMode || this.myAddress.equals(p.getAddress()));
    }

    public boolean showHumanCurrentPlayerInfo() {
        Player currentPlayer = this.game.getCurrentPlayer();
        if (this.showHumanPlayerThereInfo(currentPlayer)) {
            return true;
        }
        if (this.getSingleLocalHumanPlayer() == currentPlayer) {
            return true;
        }
        for (Player player : this.game.getPlayers()) {
            if (player.getType() != 0 || !player.isAlive()) continue;
            return false;
        }
        return true;
    }

    void DoEndGo() {
        this.controller.noInput();
        String Addr = this.game.getCurrentPlayer().getAddress();
        if (this.shouldGameCommand(Addr)) {
            this.gameCommand(Addr, "CARD", this.game.getDesrvedCard());
        }
    }

    boolean shouldGameCommand(String Addr) {
        return !this.replay && (this.onlinePlayClient == null || this.myAddress.equals(Addr));
    }

    void gameCommand(String address, String gameCommandOrAddress, String options) {
        if (this.replay) {
            throw new IllegalStateException("game command sent during replay");
        }
        String fullCommand = gameCommandOrAddress + " " + options;
        if (this.onlinePlayClient == null) {
            this.inGameParser(fullCommand);
        } else {
            if (!address.equals(this.myAddress)) {
                throw new IllegalStateException("trying to send game command when not my address " + address + " " + this.myAddress);
            }
            this.onlinePlayClient.sendGameCommand(fullCommand);
        }
    }

    public void setReplay(boolean a) {
        this.replay = a;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public String getBasicPassiveGo() {
        return this.ai.getOutput(this.game, 3);
    }

    public String[] getAICommands() {
        return this.ai.getAICommands();
    }

    public String getCommandFromType(int type) {
        return this.ai.getCommandFromType(type);
    }

    public String whoWon() {
        Player winner = this.getWinner();
        boolean iWon = winner.getType() == 0 && (this.unlimitedLocalMode || this.myAddress.equals(winner.getAddress()));
        this.controller.gameOver(iWon);
        String text = System.getProperty("line.separator") + JavaCompatUtil.replaceAll(this.resb.getString("core.whowon.hehaswon"), "{0}", winner.getName());
        if (this.game.getGameMode() == 3) {
            text = text + System.getProperty("line.separator") + JavaCompatUtil.replaceAll(this.resb.getString("core.whowon.mission"), "{0}", winner.getMission().getDiscription());
        }
        return text;
    }

    public Player getWinner() {
        if (this.game.getState() == 8) {
            return this.game.getCurrentPlayer();
        }
        return null;
    }

    private void setHelp() {
        String help = "";
        if (this.game != null && this.game.getCurrentPlayer() != null) {
            String strId = null;
            int type = this.game.getCurrentPlayer().getType();
            strId = type == 0 ? "core.help.move.human" : "core.help.move.ai." + this.ai.getCommandFromType(type);
            try {
                help = JavaCompatUtil.replaceAll(this.resb.getString(strId), "{0}", this.game.getCurrentPlayer().getName()) + " ";
            }
            catch (MissingResourceException ex) {
                help = strId + ": (" + this.game.getCurrentPlayer().getName() + ") ";
            }
        }
        if (this.game == null) {
            help = this.resb.getString("core.help.newgame");
        } else if (this.game.getState() == 0) {
            help = this.resb.getString("core.help.createplayers");
        } else if (this.game.getState() == 1) {
            help = help + this.resb.getString("core.help.trade");
        } else if (this.game.getState() == 2) {
            help = this.game.getSetupDone() ? help + this.resb.getString("core.help.placearmies") : (this.game.NoEmptyCountries() ? help + this.resb.getString("core.help.placearmy") : help + this.resb.getString("core.help.placearmyempty"));
        } else if (this.game.getState() == 3) {
            help = help + this.resb.getString("core.help.attack");
        } else if (this.game.getState() == 4) {
            help = help + this.resb.getString("core.help.rollorretreat");
        } else if (this.game.getState() == 5) {
            help = help + this.resb.getString("core.help.youhavewon");
        } else if (this.game.getState() == 6) {
            help = help + this.resb.getString("core.help.fortifyposition");
        } else if (this.game.getState() == 7) {
            help = help + this.resb.getString("core.help.endgo");
        } else if (this.game.getState() == 8) {
            Player winrar = this.game.getCurrentPlayer();
            help = JavaCompatUtil.replaceAll(this.resb.getString("core.help.gameover"), "{0}", winrar == null ? "null" : winrar.getName());
        } else {
            help = this.game.getState() == 9 ? help + this.resb.getString("core.help.selectcapital") : (this.game.getState() == 10 ? help + this.resb.getString("core.help.defendyourself") : this.resb.getString("core.help.error.unknownstate"));
        }
        this.controller.setGameStatus(help);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGameToUndoObject() {
        if (this.skipUndo) {
            return;
        }
        if (this.unlimitedLocalMode) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = this.Undo;
                synchronized (byteArrayOutputStream) {
                    this.Undo.reset();
                    this.game.saveGame(this.Undo);
                }
            }
            catch (OutOfMemoryError e) {
                this.Undo.reset();
                this.skipUndo = true;
                logger.log(Level.INFO, this.resb.getString("core.loadgame.error.undo"), e);
            }
            catch (Throwable e) {
                this.Undo.reset();
                this.skipUndo = true;
                logger.log(Level.WARNING, this.resb.getString("core.loadgame.error.undo"), e);
            }
        }
    }

    public byte[] getLastSavedState() {
        return this.Undo.toByteArray();
    }

    public void setSkipUndo(boolean skip) {
        this.skipUndo = skip;
    }

    public void disconnected() {
        logger.info("disconnected from the server!!");
        this.controller.sendMessage(this.resb.getString("core.kicked.error.disconnected"), false, false);
        this.parser("closegame");
    }

    private void updateBattleState() {
        if (!(this.game.getState() != 4 && this.game.getState() != 10 || this.battle)) {
            Player attackingPlayer = this.game.getAttacker().getOwner();
            Player defendingPlayer = this.game.getDefender().getOwner();
            if (this.showHumanPlayerThereInfo(attackingPlayer) || this.showHumanPlayerThereInfo(defendingPlayer)) {
                this.controller.openBattle(this.game.getAttacker().getColor(), this.game.getDefender().getColor());
                if (this.game.getState() == 10) {
                    this.controller.setNODAttacker(this.game.getAttackerDice());
                }
                this.battle = true;
            }
        } else if (this.game.getState() != 4 && this.game.getState() != 10) {
            this.closeBattle();
        }
    }

    public void closeBattle() {
        if (this.battle) {
            this.controller.closeBattle();
            this.battle = false;
        }
    }

    public List getCurrentCards() {
        return this.game.getCurrentPlayer().getCards();
    }

    public int hasArmiesInt(int color) {
        return this.game.getCountryInt(color).getArmies();
    }

    public boolean canAttack(int nCountryFrom, int nCountryTo) {
        return this.game.getCountryInt(nCountryFrom).isNeighbours(this.game.getCountryInt(nCountryTo));
    }

    public boolean isOwnedCurrentPlayerInt(int name) {
        return this.game != null && this.game.getCurrentPlayer() != null && this.game.getCountryInt(name) != null && (this.game.getCountryInt(name).getOwner() == null || this.game.getCountryInt(name).getOwner() == this.game.getCurrentPlayer());
    }

    public String getHumanPlayerMission() {
        switch (this.game.getGameMode()) {
            case 0: {
                return this.resb.getString("core.mission.conquerworld");
            }
            case 2: {
                return this.resb.getString("core.mission.capturecapitals");
            }
            case 3: {
                Player human = this.getSingleLocalHumanPlayer();
                if (human != null) {
                    return human.getMission().getDiscription();
                }
                return this.game.getCurrentPlayer().getMission().getDiscription();
            }
        }
        return this.resb.getString("core.mission.error.cantshow");
    }

    public int[] getPlayerColors() {
        Country defender;
        RiskGame g = this.game;
        if (g == null) {
            return new int[0];
        }
        if (g.getState() == 10 && (defender = g.getDefender()) != null) {
            return new int[]{defender.getOwner().getColor()};
        }
        Vector Players = g.getPlayers();
        boolean setup = g.getSetupDone();
        int num = 0;
        int start = 0;
        for (int c = 0; c < Players.size(); ++c) {
            if (((Player)Players.get(c)).getNoTerritoriesOwned() > 0 || !setup) {
                ++num;
            }
            if ((Player)Players.get(c) != g.getCurrentPlayer()) continue;
            start = c;
        }
        int[] playerColors = new int[num];
        int current = 0;
        for (int c = start; c < Players.size(); ++c) {
            if (((Player)Players.get(c)).getNoTerritoriesOwned() > 0 || !setup) {
                playerColors[current] = ((Player)Players.get(c)).getColor();
                ++current;
            }
            if (current == num) break;
            if (c != Players.size() - 1) continue;
            c = -1;
        }
        return playerColors;
    }

    public int getCurrentPlayerColor() {
        if (this.game != null && this.game.getState() != 0) {
            return this.game.getCurrentPlayer().getColor();
        }
        return 0;
    }

    public int getColorOfOwner(int n) {
        return this.game.getCountryInt(n).getOwner().getColor();
    }

    public boolean canTrade(String c1, String c2, String c3) {
        if (this.game.getState() == 1) {
            Card[] cards = this.game.getCards(c1, c2, c3);
            if (cards[0] == null || cards[1] == null || cards[2] == null) {
                return false;
            }
            return this.game.checkTrade(cards[0], cards[1], cards[2]);
        }
        return false;
    }

    public int getNewCardState() {
        return this.game.getNewCardState();
    }

    public RiskGame getGame() {
        return this.game;
    }

    public boolean getLocalGame() {
        return this.unlimitedLocalMode;
    }

    public String getCountryName(int color) {
        Country t = this.game.getCountryInt(color);
        if (t == null) {
            return "";
        }
        return t.getName();
    }

    public Player getCountryCapital(int color) {
        Country t = this.game.getCountryInt(color);
        Vector players = this.game.getPlayers();
        for (Player player : players) {
            if (player.getCapital() != t) continue;
            return player;
        }
        return null;
    }

    public boolean getAutoEndGo() {
        if (this.game != null && this.game.getCurrentPlayer() != null) {
            return this.game.getCurrentPlayer().getAutoEndGo();
        }
        return false;
    }

    public boolean getAutoDefend() {
        if (this.game != null && this.game.getCurrentPlayer() != null) {
            return this.game.getCurrentPlayer().getAutoDefend();
        }
        return false;
    }

    public String getMyAddress() {
        return this.myAddress;
    }

    public Player getSingleLocalHumanPlayer() {
        RiskGame game = this.getGame();
        if (game == null || game.getState() == 0 || game.getState() == 8) {
            return null;
        }
        Vector players = game.getPlayers();
        String myAddress = this.getMyAddress();
        Player human1 = null;
        Player human2 = null;
        boolean tooMany1 = false;
        boolean tooMany2 = false;
        for (Player player : players) {
            if (!player.isAlive()) continue;
            if (player.getType() == 0) {
                if (human1 == null) {
                    human1 = player;
                } else {
                    tooMany1 = true;
                }
            }
            if (!myAddress.equals(player.getAddress())) continue;
            if (human2 == null) {
                human2 = player;
                continue;
            }
            tooMany2 = true;
        }
        if (human1 != null && !tooMany1) {
            return human1;
        }
        if (human2 != null && !tooMany2) {
            return human2;
        }
        return null;
    }

    public void showMessageDialog(String a) {
        this.controller.showMessageDialog(a);
    }

    private void closeGame() {
        boolean createNewAddress = false;
        if (this.onlinePlayClient != null) {
            this.onlinePlayClient.closeGame();
            this.onlinePlayClient = null;
            createNewAddress = true;
        }
        if (!this.inbox.isEmpty()) {
            logger.log(Level.INFO, "clearing commands " + this.inbox);
            this.inbox.clear();
        }
        if (this.game != null) {
            this.closeBattle();
            this.controller.closeGame();
            this.ai.closeGame();
            this.game = null;
        }
        if (createNewAddress) {
            this.myAddress = RiskUtil.createRandomUniqueAddress();
        }
    }

    public void newMemoryGame(RiskGame g, String map) {
        this.closeGame();
        try {
            NullCipher nullCipher = new NullCipher();
            this.game = (RiskGame)new SealedObject(g, nullCipher).getObject(nullCipher);
            this.game.loadMap(false, new BufferedReader(new StringReader(map)));
            for (int c = 1; c <= RiskGame.MAX_PLAYERS; ++c) {
                this.game.delPlayer("PLAYER" + c);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.controller.newGame(true);
        this.controller.showCardsFile("loaded from memory", this.game.getNoMissions() != 0);
        this.unlimitedLocalMode = true;
    }

    public void setOnlinePlay(OnlineRisk online) {
        this.onlinePlayClient = online;
        this.unlimitedLocalMode = this.onlinePlayClient == null;
    }

    public void setGame(RiskGame b) {
        if (this.game != null) {
            this.closeBattle();
            this.controller.closeGame();
            this.ai.closeGame();
        }
        this.inbox.clear();
        this.game = b;
        this.controller.startGame(this.unlimitedLocalMode);
        this.getInput();
    }

    private void renamePlayer(String name, String newName, String newAddress, int newType) {
        if ("".equals(name) || "".equals(newName) || "".equals(newAddress) || newType == -1) {
            throw new IllegalArgumentException("bad rename " + name + " " + newName + " " + newAddress + " " + newType);
        }
        Vector players = this.game.getPlayers();
        Player leaver = null;
        Player newNamePlayer = null;
        for (int c = 0; c < players.size(); ++c) {
            Player player = (Player)players.get(c);
            if (player.getName().equals(newName)) {
                newNamePlayer = player;
            }
            if (!player.getName().equals(name)) continue;
            leaver = player;
        }
        if (leaver == null) {
            throw new IllegalArgumentException("can not find player with name \"" + name + "\"");
        }
        if (newNamePlayer != null && !name.equals(newName)) {
            throw new IllegalArgumentException("can not rename \"" + name + "\". someone with new name \"" + newName + "\" is already in this game");
        }
        leaver.rename(newName);
        leaver.setType(newType);
        leaver.setAddress(newAddress);
        if (this.onlinePlayClient != null) {
            this.onlinePlayClient.playerRenamed(name, newName, newAddress, newType);
        }
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    public Player findEmptySpot() {
        if (this.game != null) {
            Vector players = this.game.getPlayers();
            for (int c = 0; c < players.size(); ++c) {
                Player player = (Player)players.get(c);
                if (player.getType() != 3 || !player.isAlive()) continue;
                return player;
            }
        }
        return null;
    }

    private class GameCommand
    implements Runnable {
        public static final int UI_COMMAND = 1;
        public static final int NETWORK_COMMAND = 2;
        final int type;
        final String command;
        Object notifier;

        public GameCommand(int t, String c) {
            this.type = t;
            this.command = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: {
                try {
                    if (this.type == 1) {
                        Risk.this.processFromUI(this.command);
                        break block12;
                    }
                    if (this.type == 2) {
                        Risk.this.inGameParser(this.command);
                        break block12;
                    }
                    throw new RuntimeException();
                }
                finally {
                    if (this.notifier != null) {
                        Object object = this.notifier;
                        synchronized (object) {
                            this.notifier.notifyAll();
                        }
                    }
                }
            }
        }

        public String toString() {
            return (this.type == 1 ? "UI" : "NETWORK") + " " + this.command;
        }
    }
}

