/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.ai.AI;
import net.yura.domination.engine.core.RiskGame;
import net.yura.util.Service;

public class AIManager {
    private static int wait = 500;
    private final Map<Integer, AI> ais = new HashMap<Integer, AI>();

    public static int getWait() {
        return wait;
    }

    public static void setWait(int w) {
        wait = w;
    }

    public AIManager() {
        Iterator providers = Service.providerClasses(AIManager.class);
        while (providers.hasNext()) {
            try {
                AI ai = (AI)((Class)providers.next()).newInstance();
                this.registerAI(ai);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            for (AI ai : ServiceLoader.load(AI.class)) {
                this.registerAI(ai);
            }
        }
        catch (Throwable ex) {
            Logger.getLogger(AIManager.class.getName()).info("ServiceLoader AIs not loaded " + ex);
        }
        if (this.ais.isEmpty()) {
            Logger.getLogger(AIManager.class.getName()).info("NO AIs FOUND!!!!");
        }
    }

    private void registerAI(AI ai) {
        int type = ai.getType();
        if (this.ais.get(type) != null) {
            throw new RuntimeException("more then 1 ai with same type: " + type);
        }
        this.ais.put(type, ai);
    }

    public int getTypeFromCommand(String command) {
        for (AI ai : this.ais.values()) {
            if (!ai.getCommand().equals(command)) continue;
            return ai.getType();
        }
        throw new IllegalArgumentException("unknown command: '" + command + "' not found in " + this.ais);
    }

    public String getCommandFromType(int type) {
        for (AI ai : this.ais.values()) {
            if (ai.getType() != type) continue;
            return ai.getCommand();
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    public String[] getAICommands() {
        String[] commands = new String[this.ais.size()];
        int c = 0;
        for (AI ai : this.ais.values()) {
            commands[c++] = ai.getCommand();
        }
        return commands;
    }

    public void play(Risk risk) {
        RiskGame game = risk.getGame();
        String output = this.getOutput(game, game.getCurrentPlayer().getType());
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        risk.parser(output);
    }

    public String getOutput(RiskGame game, int type) {
        AI usethisAI = this.ais.get(type);
        if (usethisAI == null) {
            throw new IllegalArgumentException("can not find ai for type " + type);
        }
        usethisAI.setGame(game);
        String output = null;
        switch (game.getState()) {
            case 1: {
                output = usethisAI.getTrade();
                break;
            }
            case 2: {
                output = usethisAI.getPlaceArmies();
                break;
            }
            case 3: {
                output = usethisAI.getAttack();
                break;
            }
            case 4: {
                output = usethisAI.getRoll();
                break;
            }
            case 5: {
                output = usethisAI.getBattleWon();
                break;
            }
            case 6: {
                output = usethisAI.getTacMove();
                break;
            }
            case 9: {
                output = usethisAI.getCapital();
                break;
            }
            case 10: {
                output = usethisAI.getAutoDefendString();
                break;
            }
            case 7: {
                output = "endgo";
                break;
            }
            case 8: {
                throw new IllegalStateException("AI error: game is over");
            }
            default: {
                throw new IllegalStateException("AI error: unknown state " + game.getState());
            }
        }
        if (output == null) {
            throw new NullPointerException("AI ERROR! output is null");
        }
        return output;
    }

    public void closeGame() {
        for (AI ai : this.ais.values()) {
            ai.setGame(null);
        }
    }
}

