/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import net.yura.domination.engine.ai.AI;
import net.yura.domination.engine.ai.logic.AICapital;
import net.yura.domination.engine.ai.logic.AIDomination;
import net.yura.domination.engine.ai.logic.AIMission;
import net.yura.domination.engine.core.RiskGame;

public abstract class AbstractAI
implements AI {
    private final AI domination;
    private final AI mission;
    private final AI capital;
    private AI current;

    public AbstractAI() {
        int type = this.getType();
        this.domination = new AIDomination(type);
        this.mission = new AIMission(type);
        this.capital = new AICapital(type);
    }

    public void setGame(RiskGame game) {
        if (game == null) {
            if (this.current != null) {
                this.current.setGame(null);
            }
        } else {
            int mode = game.getGameMode();
            this.current = mode == 2 ? this.capital : (mode == 3 ? this.mission : this.domination);
            this.current.setGame(game);
        }
    }

    public String getBattleWon() {
        return this.current.getBattleWon();
    }

    public String getTacMove() {
        return this.current.getTacMove();
    }

    public String getTrade() {
        return this.current.getTrade();
    }

    public String getPlaceArmies() {
        return this.current.getPlaceArmies();
    }

    public String getAttack() {
        return this.current.getAttack();
    }

    public String getRoll() {
        return this.current.getRoll();
    }

    public String getCapital() {
        return this.current.getCapital();
    }

    public String getAutoDefendString() {
        return this.current.getAutoDefendString();
    }
}

