/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.util.ResourceBundle;
import javax.microedition.lcdui.Image;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.Category;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapPreview;
import net.yura.mobile.gui.Animation;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.ProgressBar;
import net.yura.mobile.gui.layout.XULLoader;

public class MapRenderer
extends DefaultListCellRenderer {
    private static final int TOTAL_LINES_OF_TEXT = 5;
    String line1;
    String line2;
    private ProgressBar bar = new ProgressBar();
    private Component list;
    private String context;
    Image play;
    Image download;
    Icon loading;
    MapChooser chooser;
    Map map;
    ResourceBundle resb = TranslationBundle.getBundle();

    public MapRenderer(MapChooser chooser) {
        this.chooser = chooser;
        this.setName("ListRendererCollapsed");
        this.bar.workoutPreferredSize();
        this.play = Application.createImage("/ms_play.png");
        this.download = Application.createImage("/ms_download.png");
        this.loading = new Icon("/ms_icon_loading.png");
    }

    public void animate() {
        this.bar.animate();
        if (this.list != null) {
            this.list.repaint();
        }
    }

    public void setContext(String c) {
        this.context = c;
    }

    public String getContext() {
        return this.context;
    }

    public Component getListCellRendererComponent(Component list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
        this.list = list;
        this.line2 = null;
        this.map = null;
        String iconUrl = null;
        if (value instanceof Category) {
            Category category = (Category)value;
            this.line1 = category.getName();
            iconUrl = category.getIconURL();
        } else if (value instanceof Map) {
            String description;
            this.map = (Map)value;
            this.line1 = this.map.getName();
            String author = this.map.getAuthorName();
            if (author != null && !"".equals(author)) {
                this.line2 = this.resb.getString("mapchooser.by").replaceAll("\\{0\\}", author);
            }
            if ((description = this.map.getDescription()) != null && !"".equals(description)) {
                this.line2 = (this.line2 == null ? "" : this.line2 + "\n") + description;
            }
            if (this.line2 != null) {
                this.line2 = MapRenderer.getFirstLines(this.line2, 4);
            }
            iconUrl = this.map.getPreviewUrl();
        }
        if (iconUrl != null) {
            this.setIcon(MapPreview.getIconForMapOrCategory(value, this.context, iconUrl, this.chooser.client));
        } else {
            System.out.println("[MapRenderer] No PreviewUrl for map or category: " + value);
        }
        return c;
    }

    public void paintComponent(Graphics2D g) {
        Icon icon = this.getIcon();
        if (icon == null || icon.getImage() == null) {
            this.setIcon(this.loading);
        }
        super.paintComponent(g);
        int textx = this.padding + this.getIcon().getIconWidth() + this.gap;
        g.setFont(this.font);
        g.setColor(this.getForeground());
        g.drawString(this.line1, textx, this.line2 != null ? this.padding : (this.getHeight() - this.font.getHeight()) / 2);
        if (this.line2 != null) {
            int state = this.getCurrentState();
            if ((state & 4) == 0 && (state & 8) == 0) {
                this.list.setState(2);
                g.setColor(this.list.getForeground());
                this.list.setState(-1);
            }
            g.drawString(this.line2, textx, this.padding + this.getFont().getHeight() + this.gap);
        }
        if (this.map != null) {
            int gap = XULLoader.adjustSizeToDensity(5);
            String mapUID = MapPreview.getFileUID(this.map.getMapUrl());
            if (this.chooser.client.isDownloading(mapUID)) {
                int x = this.getWidth() - this.bar.getWidth() - gap;
                int y = gap;
                g.translate(x, y);
                this.bar.paintComponent(g);
                g.translate(-x, -y);
                Animation.registerAnimated(this);
            } else if (this.chooser.willDownload(this.map)) {
                g.drawImage(this.download, this.getWidth() - this.download.getWidth() - gap, gap);
            } else {
                g.drawImage(this.play, this.getWidth() - this.play.getWidth() - gap, gap);
            }
            int w = this.getWidth();
            if (w >= XULLoader.adjustSizeToDensity(768)) {
                if (this.map.getMapWidth() > 0) {
                    String size = "Size: " + this.map.getMapWidth() + "x" + this.map.getMapHeight();
                    g.drawString(size, textx + w / 2, this.padding);
                }
                if (this.map.getNumberOfDownloads() != null) {
                    String downloads = JavaCompatUtil.replaceAll(this.resb.getString("mapchooser.map.numberOfDownloads"), "{0}", this.map.getNumberOfDownloads());
                    g.drawString(downloads, textx + w / 2, this.padding + this.getFont().getHeight() + this.gap);
                }
            }
        }
        this.setIcon(icon);
    }

    public int getFixedCellHeight() {
        return this.padding * 2 + Math.max(this.loading.getIconHeight(), this.getFont().getHeight() * 5 + this.gap);
    }

    public static String getFirstLines(String input, int lines) {
        int lastchar = 0;
        for (int c = 0; c < lines; ++c) {
            int newline = input.indexOf(10, lastchar);
            if (newline < 0) {
                return input;
            }
            lastchar = newline + 1;
        }
        return input.substring(0, lastchar - 1) + "...";
    }
}

