/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.microedition.io.file.FileConnection;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.core.StatType;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.io.FileUtil;

public class MiniUtil {
    public static final String mapsdir = "file:///android_asset/maps/";
    private static String externalMapsDirUrl;
    private static File mapsDir;
    private static File savesDir;

    public static void showAbout() {
        if (Application.getPlatform() == 10) {
            Application.openURL("nativeNoResult://net.yura.domination.android.AboutActivity");
        } else {
            MiniUtil.showPlatformIndependentAbout();
        }
    }

    private static void showPlatformIndependentAbout() {
        ResourceBundle resb = TranslationBundle.getBundle();
        String text = MiniUtil.getAboutHtml();
        Button credits = new Button(resb.getString("about.tab.credits"));
        credits.setActionCommand("credits");
        credits.setName("SmallButton");
        Button license = new Button(resb.getString("about.tab.license"));
        license.setActionCommand("license");
        license.setName("SmallButton");
        Button changelog = new Button(resb.getString("about.tab.changelog"));
        changelog.setActionCommand("changelog");
        changelog.setName("SmallButton");
        Button ok = new Button(resb.getString("about.okbutton"));
        ok.setMnemonic(-11);
        ok.setName("SmallButton");
        OptionPane.showOptionDialog(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                try {
                    if ("license".equals(actionCommand)) {
                        RiskUtil.openDocs("gpl.txt");
                    } else if ("changelog".equals(actionCommand)) {
                        RiskUtil.openDocs("ChangeLog.txt");
                    } else if ("credits".equals(actionCommand)) {
                        RiskUtil.openDocs("help/game_credits.htm");
                    }
                }
                catch (Exception e) {
                    OptionPane.showMessageDialog(null, "Unable to open info: " + e.getMessage(), "Error", 0);
                }
            }
        }, text, "\ud83c\uddfa\ud83c\udde6 \ud83c\udff3\ufe0f\u200d\ud83c\udf08 " + resb.getString("about.title") + " \ud83c\udff3\ufe0f\u200d\ud83c\udf08 \ud83c\uddfa\ud83c\udde6", 0, 1, null, new Button[]{credits, license, changelog, ok}, ok);
    }

    public static String getAboutHtml() {
        String displayInfo;
        ResourceBundle resb = TranslationBundle.getBundle();
        int year = Calendar.getInstance().get(1);
        String copyright = resb.getString("about.copyright").replaceAll("\\{0\\}", String.valueOf(year));
        String author = resb.getString("about.author") + " Yura Mamyrin (yura@yura.net)";
        String c1 = "#DA4437";
        String c2 = "#F6971D";
        String c3 = "#F5EA3B";
        String c4 = "#65AF45";
        String c5 = "#4284F3";
        String c6 = "#7E3793";
        String externalMapDirUrl = MiniUtil.getExternalMapDir();
        String version = DominationMain.version;
        String versionName = System.getProperty("versionName");
        if (version != null && !version.equals(versionName)) {
            version = versionName + " (" + version + ")";
        }
        if (Application.getPlatform() == 12) {
            DesktopPane dp = DesktopPane.getDesktopPane();
            displayInfo = "<p>Screen scale: " + System.getProperty("display.scale") + " window: " + dp.getWidth() + "x" + dp.getHeight() + "</p>";
        } else {
            displayInfo = "<p>DPI: " + System.getProperty("display.dpi") + " Density: " + System.getProperty("display.density") + " Size: " + System.getProperty("display.size") + "</p>";
        }
        return "<html><div style=\"background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,   " + c1 + "), color-stop(16.7%, " + c1 + "), color-stop(16.7%," + c2 + "), color-stop(33.3%, " + c2 + "), color-stop(33.3%," + c3 + "), color-stop(50%,   " + c3 + "), color-stop(50%,  " + c4 + "), color-stop(66.7%, " + c4 + "), color-stop(66.7%," + c5 + "), color-stop(83.3%, " + c5 + "), color-stop(83.3%," + c6 + "), color-stop(100%,  " + c6 + "));height:30px;\"></div><h3>yura.net " + RiskUtil.GAME_NAME + "</h3><p>" + DominationMain.product + " " + resb.getString("about.version") + " " + version + (RiskUtil.isOldVersion() ? " OLD VERSION" : "") + ("true".equals(System.getProperty("debug")) ? " DEBUG" : "") + "</p><p>Game Engine:  " + RiskUtil.RISK_VERSION + "</p><p>" + author + "</p><p>" + copyright + "</p>" + displayInfo + "<p>Locale: " + Locale.getDefault() + " use: " + resb.getLocale() + "</p><p>Device: " + System.getProperty("microedition.platform") + "</p>" + (externalMapDirUrl == null ? "" : "<p>ExternalMapDir=<a href=\"" + externalMapDirUrl + "\">" + MiniUtil.getLabelForUrl(externalMapDirUrl) + "</a></p>") + "</html>";
    }

    private static String getLabelForUrl(String url) {
        if (url.startsWith("file:/")) {
            return JavaCompatUtil.replaceAll(url, "%20", " ");
        }
        try {
            FileConnection fileConnection = FileUtil.getReadFileConnection(url);
            return fileConnection.getName();
        }
        catch (Exception ex) {
            return url;
        }
    }

    public static String getStatsLabel(StatType statType, Player player) {
        String note = statType == StatType.COUNTRIES ? " (" + player.getNoTerritoriesOwned() + ")" : (statType == StatType.CARDS ? " (" + player.getCards().size() + ")" : "");
        return player.getName() + note;
    }

    public static List getFileList(String extension) {
        Enumeration files;
        Vector<String> result = new Vector<String>();
        String dotExtension = "." + extension;
        String externalMapDirUrl = MiniUtil.getExternalMapDir();
        if (externalMapDirUrl != null && (files = FileUtil.getDirectoryFiles(externalMapDirUrl)) != null) {
            while (files.hasMoreElements()) {
                String name = (String)files.nextElement();
                if (!name.endsWith(dotExtension)) continue;
                result.add(name);
            }
        }
        Enumeration en = FileUtil.getDirectoryFiles(mapsdir);
        while (en.hasMoreElements()) {
            String file = (String)en.nextElement();
            if (!file.endsWith(dotExtension) || result.contains(file)) continue;
            result.add(file);
        }
        String[] list = MiniUtil.getSaveMapDir().list();
        for (int c = 0; c < list.length; ++c) {
            String file = list[c];
            if (!file.endsWith(dotExtension) || result.contains(file)) continue;
            result.add(file);
        }
        return result;
    }

    public static InputStream openMapStream(String name) throws IOException {
        try {
            FileConnection fileConnection;
            String externalMapDirUrl = MiniUtil.getExternalMapDir();
            if (externalMapDirUrl != null && (fileConnection = FileUtil.getReadFileConnection(externalMapDirUrl + name)).exists()) {
                return fileConnection.openInputStream();
            }
        }
        catch (Exception ex1) {
            RiskUtil.printStackTrace(ex1);
        }
        try {
            File userMaps = MiniUtil.getSaveMapDir();
            File newFile = new File(userMaps, name);
            return new FileInputStream(newFile);
        }
        catch (Exception ex) {
            try {
                return FileUtil.getInputStreamFromFileConnector(mapsdir + name);
            }
            catch (Exception ex2) {
                IOException exception = new IOException(ex2.toString());
                exception.initCause(ex);
                throw exception;
            }
        }
    }

    public static String getExternalMapDir() {
        if (externalMapsDirUrl != null) {
            return externalMapsDirUrl;
        }
        String ExternalStorageDirectory = System.getProperty("ExternalStorageDirectory");
        if (ExternalStorageDirectory != null) {
            File userMaps = new File(new File(ExternalStorageDirectory), RiskUtil.GAME_NAME + " Maps");
            externalMapsDirUrl = userMaps.toURI().toString();
            return externalMapsDirUrl;
        }
        return null;
    }

    public static void setExternalMapDir(String url) {
        externalMapsDirUrl = url;
    }

    public static File getSaveMapDir() {
        if (mapsDir != null) {
            return mapsDir;
        }
        File userHome = new File(System.getProperty("user.home"));
        File userMaps = new File(userHome, "maps");
        if (!userMaps.isDirectory() && !userMaps.mkdirs()) {
            throw new RuntimeException("can not create dir " + userMaps);
        }
        mapsDir = userMaps;
        return userMaps;
    }

    public static File getSaveGameDir() {
        if (savesDir != null) {
            return savesDir;
        }
        File userHome = new File(System.getProperty("user.home"));
        File userMaps = new File(userHome, "saves");
        if (!userMaps.isDirectory() && !userMaps.mkdirs()) {
            throw new RuntimeException("can not create dir " + userMaps);
        }
        savesDir = userMaps;
        return userMaps;
    }

    public static String getSaveGameName(RiskGame game) {
        String file = game.getMapFile();
        if (file.endsWith(".map")) {
            file = file.substring(0, file.length() - 4);
        }
        return file;
    }

    public static void openHelp() {
        try {
            RiskUtil.openDocs("help/rules.htm");
        }
        catch (Exception e) {
            OptionPane.showMessageDialog(null, "Unable to open manual: " + e.getMessage(), "Error", 0);
        }
    }
}

