/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import android.graphics.ColorMatrix;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.microedition.lcdui.Image;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Player;
import net.yura.domination.mobile.PicturePanel;
import net.yura.domination.mobile.flashgui.GameWindow;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.TextPane;
import net.yura.mobile.gui.layout.BoxLayout;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardsDialog
extends Frame
implements ActionListener {
    private Risk myrisk;
    private PicturePanel pp;
    private Button tradeButton;
    private CardPanel extraArmiesCard;
    private Component NumArmies;
    private Image Infantry;
    private Image Cavalry;
    private Image Artillery;
    private Image Wildcard;
    private Player player;
    private Panel myCardsPanel;
    private Properties resb = GameWindow.resb;

    public CardsDialog(Risk r, PicturePanel p) {
        this.myrisk = r;
        this.pp = p;
        Image cards = Application.createImage("/cards.png");
        int w = cards.getWidth() / 4;
        int h = cards.getHeight();
        this.Cavalry = Image.createImage(cards, 0, 0, w, h, 0);
        this.Infantry = Image.createImage(cards, w, 0, w, h, 0);
        this.Artillery = Image.createImage(cards, w * 2, 0, w, h, 0);
        this.Wildcard = Image.createImage(cards, w * 3, 0, w, h, 0);
        XULLoader loader = GameWindow.getPanel("/cards.xml", this);
        this.setContentPane((Panel)loader.getRoot());
        this.setTitle(this.resb.getProperty("cards.title"));
        this.setMaximum(true);
        this.NumArmies = loader.find("NumArmies");
        this.myCardsPanel = (Panel)loader.find("myCardsPanel");
        this.myCardsPanel.setLayout(new BoxLayout(1));
        this.tradeButton = (Button)loader.find("tradeButton");
        if (Application.getPlatform() == 10 || Application.getPlatform() == 12) {
            TextPane cardsNote = (TextPane)loader.find("CardsNote");
            cardsNote.setText("<html>" + cardsNote.getText() + " <a href=\"graph\">" + this.resb.getString("game.button.statistics") + "</a>");
        }
    }

    public void setupNumArmies() {
        String text;
        if (this.myrisk.getGame().isRecycleCards() && this.myrisk.getGame().getCards().isEmpty() && !this.myrisk.getGame().getUsedCards().isEmpty()) {
            Logger.getLogger(CardsDialog.class.getName()).warning("IllegalState! we RecycleCards but have no cards, but do have usedcards");
        }
        int cardsMode = this.myrisk.getGame().getCardMode();
        int cardsWithPlayers = 0;
        for (Player player : this.myrisk.getGame().getPlayers()) {
            cardsWithPlayers += player.getCards().size();
        }
        if (this.myrisk.getGame().getCards().isEmpty() && this.myrisk.getGame().getUsedCards().isEmpty() && cardsWithPlayers == 0) {
            text = this.resb.getString("cards.no-cards-in-game");
        } else if (this.myrisk.getGame().getCards().isEmpty() && !this.myrisk.getGame().isRecycleCards() && !this.myrisk.getGame().canTrade()) {
            text = this.resb.getString("cards.no-cards-left");
        } else if (this.myrisk.getGame().getCards().isEmpty() && this.myrisk.getGame().isRecycleCards() && !this.myrisk.getGame().canTrade()) {
            text = this.resb.getString("cards.all-cards-with-players");
        } else if (cardsMode == 1 || cardsMode == 2) {
            List<CardPanel> cards = this.getSelectedCards();
            int trade = 0;
            if (cards.size() == 3) {
                trade = this.myrisk.getGame().getTradeAbsValue(cards.get(0).card.getName(), cards.get(1).card.getName(), cards.get(2).card.getName(), cardsMode);
            }
            text = trade > 0 ? JavaCompatUtil.replaceAll(this.resb.getString("cards.nexttrade"), "{0}", String.valueOf(trade)) : (cardsMode == 1 ? this.resb.getString("cards.fixed") : this.resb.getString("cards.italianlike"));
        } else {
            text = JavaCompatUtil.replaceAll(this.resb.getString("cards.nexttrade"), "{0}", String.valueOf(this.myrisk.getNewCardState()));
        }
        this.NumArmies.setValue(text);
    }

    List<CardPanel> getSelectedCards() {
        ArrayList<CardPanel> selected = new ArrayList<CardPanel>();
        Vector all = this.myCardsPanel.getComponents();
        for (CardPanel cp : all) {
            if (!cp.isSelected()) continue;
            selected.add(cp);
        }
        if (this.extraArmiesCard != null) {
            if (!selected.remove(this.extraArmiesCard)) {
                throw new IllegalStateException(selected + " does not contain " + this.extraArmiesCard);
            }
            selected.add(0, this.extraArmiesCard);
        }
        return selected;
    }

    @Override
    public void actionPerformed(String actionCommand) {
        if ("done".equals(actionCommand)) {
            this.setVisible(false);
        } else if ("trade".equals(actionCommand)) {
            GameSound.INSTANCE.playSound("cards_trade");
            List<CardPanel> cards2 = this.getSelectedCards();
            if (cards2.size() == 3) {
                try {
                    this.myrisk.parserAndWait("trade " + cards2.get(0).getCardName() + " " + cards2.get(1).getCardName() + " " + cards2.get(2).getCardName());
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                for (CardPanel cp : cards2) {
                    this.myCardsPanel.remove(cp);
                }
                this.extraArmiesCard = null;
                this.tradeButton.setFocusable(false);
                this.setupNumArmies();
                this.revalidate();
                this.repaint();
            }
        } else if ("graph".equals(actionCommand)) {
            if (Application.getPlatform() == 10) {
                Application.openURL("nativeNoResult://net.yura.domination.android.StatsActivity?graph=CARDS");
            } else if (Application.getPlatform() == 12) {
                Application.openURL("native://net.yura.domination.ios.StatsViewController?graph=CARDS");
            }
        } else {
            throw new RuntimeException("unknown command " + actionCommand);
        }
    }

    public void setup(Player player, boolean ct) {
        this.setTitle(this.resb.getProperty("cards.title") + " - " + player.getName());
        this.player = player;
        this.tradeButton.setVisible(ct);
        this.myCardsPanel.removeAll();
        this.extraArmiesCard = null;
        Vector cards = player.getCards();
        for (int c = 0; c < cards.size(); ++c) {
            CardPanel cp = new CardPanel((Card)cards.get(c));
            this.myCardsPanel.add(cp);
        }
        this.tradeButton.setFocusable(false);
        this.setupNumArmies();
    }

    boolean isOwnedPlayer(CardPanel cp) {
        return cp.card.getCountry() != null && this.player == cp.card.getCountry().getOwner();
    }

    class CardPanel
    extends Button {
        private Card card;

        public CardPanel(Card c) {
            this.card = c;
            int cardWidth = XULLoader.adjustSizeToDensity(68);
            this.setPreferredSize(cardWidth, -1);
            this.setName("Card");
        }

        public void paintComponent(Graphics2D g) {
            int imgSize = XULLoader.adjustSizeToDensity(50);
            if (!this.card.getName().equals("wildcard")) {
                Image i = CardsDialog.this.pp.getCountryImage(this.card.getCountry().getColor());
                int ownerColor = CardsDialog.this.player.getColor();
                ColorMatrix m = PicturePanel.RescaleOp(0.5f, -1.0f);
                m.preConcat(PicturePanel.gray);
                if (CardsDialog.this.isOwnedPlayer(this)) {
                    m.postConcat(PicturePanel.getMatrix(PicturePanel.colorWithAlpha(ownerColor, 100)));
                }
                if (i != null) {
                    g.getGraphics().setColorMatrix(m);
                    g.drawScaledImage(i, (this.getWidth() - imgSize) / 2, this.getHeight() / 2 - imgSize, imgSize, imgSize);
                    g.getGraphics().setColorMatrix(null);
                }
                if (this == CardsDialog.this.extraArmiesCard) {
                    g.setColor(ownerColor);
                    Font font = this.getFont();
                    g.setFont(font);
                    int w = font.getHeight();
                    int x = (this.getWidth() - w) / 2;
                    int y = this.getHeight() / 2 - imgSize / 2 - w / 2;
                    g.fillOval(x, y, w, w);
                    g.setColor(ColorUtil.getTextColorFor(ownerColor));
                    g.drawString("+2", x, y);
                }
            }
            Image img = this.getCardImage();
            g.drawImage(img, (this.getWidth() - img.getWidth()) / 2, (this.getHeight() - img.getHeight()) / 2);
        }

        Image getCardImage() {
            String name = this.card.getName();
            if ("Infantry".equals(name)) {
                return CardsDialog.this.Infantry;
            }
            if ("Cavalry".equals(name)) {
                return CardsDialog.this.Cavalry;
            }
            if ("Cannon".equals(name)) {
                return CardsDialog.this.Artillery;
            }
            return CardsDialog.this.Wildcard;
        }

        public String getCardName() {
            if (this.card.getName().equals("wildcard")) {
                return this.card.getName();
            }
            return String.valueOf(this.card.getCountry().getColor());
        }

        protected void toggleSelection() {
            this.setSelected(!this.isSelected());
        }

        public void fireActionPerformed() {
            super.fireActionPerformed();
            if (CardsDialog.this.myrisk.getGame().getCardMode() != 2) {
                if (!this.isSelected() && CardsDialog.this.extraArmiesCard == this) {
                    Component newSelected = null;
                    for (CardPanel cp : CardsDialog.this.myCardsPanel.getComponents()) {
                        if (!cp.isSelected() || !CardsDialog.this.isOwnedPlayer(cp)) continue;
                        newSelected = cp;
                        break;
                    }
                    CardsDialog.this.extraArmiesCard = newSelected;
                    if (newSelected != null) {
                        newSelected.repaint();
                    }
                } else if (this.isSelected() && CardsDialog.this.extraArmiesCard == null && CardsDialog.this.isOwnedPlayer(this)) {
                    CardsDialog.this.extraArmiesCard = this;
                }
            }
            List<CardPanel> trades = CardsDialog.this.getSelectedCards();
            CardsDialog.this.tradeButton.setFocusable(CardsDialog.this.tradeButton.isVisible() && trades.size() == 3 && CardsDialog.this.myrisk.canTrade(trades.get(0).getCardName(), trades.get(1).getCardName(), trades.get(2).getCardName()));
            CardsDialog.this.tradeButton.repaint();
            CardsDialog.this.setupNumArmies();
        }

        public String toString() {
            return this.card.toString();
        }
    }
}

