/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.yura.domination.audio.GameSound;
import net.yura.domination.audio.SimpleAudio;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.mobile.MiniUtil;
import net.yura.domination.mobile.RiskMiniIO;
import net.yura.domination.mobile.flashgui.MiniFlashRiskAdapter;
import net.yura.grasshopper.SimpleBug;
import net.yura.grasshopper.info.ApplicationInfoProvider;
import net.yura.grasshopper.info.LogList;
import net.yura.grasshopper.submitter.BugSubmitter;
import net.yura.grasshopper.util.StdOutErrLevel;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.plaf.SynthLookAndFeel;
import net.yura.mobile.gui.plaf.nimbus.NimbusLookAndFeel;
import net.yura.swingme.core.J2SELogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DominationMain
extends Application {
    private static final Logger logger = Logger.getLogger(DominationMain.class.getName());
    public static final String SAVE_EXTENSION = ".save";
    public static final String product = Application.getPlatform() == 12 ? "iOS-GUI" : (Application.getPlatform() == 10 ? "AndroidGUI" : "MiniGameGUI");
    public static final String version;
    public static Preferences appPreferences;
    public GooglePlayGameServices googlePlayGameServices;
    public Risk risk;
    public MiniFlashRiskAdapter adapter;
    private static Map<Integer, ActivityResultListener> nativeCalls;
    private static int nativeCallsCount;
    private Game pendingOpenGame;
    private static final String AUTO_SAVE_FILE_NAME = "auto.save";

    public DominationMain() {
        RiskUtil.streamOpener = new RiskMiniIO();
        try {
            SimpleBug.initLogFile(RiskUtil.GAME_NAME + " " + product, version, TranslationBundle.getBundle().getLocale().toString());
            BugSubmitter.setApplicationInfoProvider(new ApplicationInfoProvider(){

                public void addInfoForSubmit(Map map) {
                    RiskGame game;
                    Risk r = DominationMain.this.risk;
                    if (r != null && (game = r.getGame()) != null) {
                        map.put("gameLog", new LogList(game.getCommands()));
                    }
                    if (DominationMain.this.adapter != null && DominationMain.this.adapter.email != null) {
                        map.put("email", DominationMain.this.adapter.email);
                    }
                    map.put("lobbyID", MiniLobbyClient.getMyUUID());
                }

                public boolean ignoreError(LogRecord record) {
                    String message;
                    if (RiskUtil.isOldVersion()) {
                        return true;
                    }
                    if (DominationMain.this.risk != null && DesktopPane.getDesktopPane() == null) {
                        return true;
                    }
                    String loggerName = record.getLoggerName();
                    if ("DataScheduler".equals(loggerName)) {
                        return true;
                    }
                    String className = record.getSourceClassName();
                    String methodName = record.getSourceMethodName();
                    if ("java.net.InetAddress".equals(className) && "lookupHostByName".equals(methodName)) {
                        return true;
                    }
                    if ("java.net.InetAddress".equals(className) && "getByName".equals(methodName)) {
                        return true;
                    }
                    if ("java.net.AddressCache".equals(className) && "customTtl".equals(methodName)) {
                        return true;
                    }
                    if ("java.util.prefs.FileSystemPreferences".equals(className) && "loadCache".equals(methodName)) {
                        return true;
                    }
                    if (record.getLevel() == StdOutErrLevel.STDERR) {
                        if ("android.util.MiuiMultiWindowUtils".equals(className)) {
                            return true;
                        }
                        if ("android.view.ViewRootImpl".equals(className) && "getHostVisibility".equals(methodName)) {
                            return true;
                        }
                        if ("android.widget.directwriting.DirectWritingServiceBinder".equals(className) && "isBindableEditText".equals(methodName)) {
                            return true;
                        }
                        if ("android.widget.directwriting.DirectWritingServiceBinder".equals(className) && "unregisterCallback".equals(methodName)) {
                            return true;
                        }
                        if ("android.widget.directwriting.DirectWritingServiceBinder".equals(className) && "onStartRecognition".equals(methodName)) {
                            return true;
                        }
                        if ("com.samsung.android.content.clipboard.SemClipboardManager".equals(className) && "isEnabled".equals(methodName)) {
                            return true;
                        }
                        if ("com.android.webview.chromium.WebViewExtAmazon".equals(className) && "destroy".equals(methodName)) {
                            return true;
                        }
                        if ("android.app.Dialog".equals(className) && "show".equals(methodName)) {
                            return true;
                        }
                        if ("android.app.Dialog".equals(className) && "dismissDialog".equals(methodName)) {
                            return true;
                        }
                        if ("android.app.AlertDialog".equals(className) && "show".equals(methodName)) {
                            return true;
                        }
                    }
                    if ("rto value is too small:0".equals(message = record.getMessage()) || "/data/system/carrierinfo.prop: open failed: ENOENT (No such file or directory)".equals(message) || "isDataSchedulerEnabled():false".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/data/net.yura.domination/shared_prefs/net.yura.domination_preferences.xml.bak".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/data/net.yura.domination/shared_prefs/com.google.android.gcm.xml.bak".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/shared_prefs/net.yura.domination_preferences.xml.bak".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/shared_prefs/com.google.android.gcm.xml.bak".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/shared_prefs/com.google.android.gms.signin.xml.bak".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/shared_prefs/com.google.android.gms.appid.xml.bak".equals(message) || "remove failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/shared_prefs/FirebaseAppHeartBeat.xml.bak".equals(message) || "mkdir failed: EEXIST (File exists) : /data/user/0/net.yura.domination/cache/WebView/Crash Reports".equals(message) || "mkdir failed: EEXIST (File exists) : /data/data/net.yura.domination/cache/WebView/Crash Reports".equals(message) || "stat failed: ENOENT (No such file or directory) : /data/data/net.yura.domination/files/assetpacks".equals(message) || "stat failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/files/assetpacks".equals(message)) {
                        return true;
                    }
                    return message != null && (message.startsWith("remove failed: ENOENT (No such file or directory) : /data/data/net.yura.domination/files/.java/.userPrefs/net/yura/domination/mobile/flashgui/prefs-") || message.startsWith("remove failed: ENOENT (No such file or directory) : /data/user/0/net.yura.domination/files/.java/.userPrefs/net/yura/domination/mobile/flashgui/prefs-"));
                }
            });
        }
        catch (Throwable th) {
            System.out.println("Grasshopper not loaded");
            RiskUtil.printStackTrace(th);
        }
        J2SELogger.setupLogging();
    }

    @Override
    public void initialize(DesktopPane rootpane) {
        SynthLookAndFeel synth = null;
        try {
            if (Application.getPlatform() == 10) {
                synth = (SynthLookAndFeel)Class.forName("net.yura.android.plaf.AndroidLookAndFeel").newInstance();
            }
            if (Application.getPlatform() == 12) {
                synth = (SynthLookAndFeel)Class.forName("net.yura.ios.plaf.IOSLookAndFeel").newInstance();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "can not load theme", ex);
        }
        if (synth == null) {
            synth = new NimbusLookAndFeel();
        }
        InputStream themeData = Application.getResourceAsStream("/dom_synth.xml");
        try {
            synth.load(themeData);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            RiskUtil.close(themeData);
        }
        rootpane.setLookAndFeel(synth);
        MapChooser.loadThemeExtension();
        if ("true".equals(System.getProperty("debug"))) {
            Logger.getLogger("").addHandler(new Handler(){
                boolean open;

                public void publish(LogRecord record) {
                    if (record.getLevel().intValue() >= Level.WARNING.intValue() && !this.open) {
                        this.open = true;
                        try {
                            OptionPane.showMessageDialog(null, record.getMessage() + " " + record.getThrown(), "WARN", 2);
                        }
                        catch (Exception ex) {
                            RiskUtil.printStackTrace(ex);
                        }
                    }
                }

                public void flush() {
                }

                public void close() {
                }
            });
            if (Application.getPlatform() != 8) {
                Logger.getLogger("").setLevel(Level.ALL);
            }
            AIManager.setWait(5);
        }
        if (appPreferences != null) {
            String externalMapsUrl;
            String lang;
            String shouldDifferentiateWithoutColor;
            if (Application.getPlatform() == 10 && !"net.yura.android.AndroidPreferences".equals(appPreferences.getClass().getName())) {
                logger.warning("wrong Preferences class " + appPreferences.getClass());
            }
            if ("true".equalsIgnoreCase(shouldDifferentiateWithoutColor = System.getProperty("shouldDifferentiateWithoutColor")) && !DominationMain.containsKey("color_blind")) {
                appPreferences.putBoolean("color_blind", true);
                if (Application.getPlatform() == 10) {
                    DominationMain.flushPreferences();
                }
            }
            if ((lang = appPreferences.get("lang", null)) != null) {
                TranslationBundle.setLanguage(lang);
            }
            if ((externalMapsUrl = appPreferences.get("externalMapsDirUrl", null)) != null) {
                MiniUtil.setExternalMapDir(externalMapsUrl);
            }
        } else {
            System.out.println("can not load appPreferences as it is NULL!");
        }
        this.risk = new Risk();
        RiskSettings.loadSettingsFromPrefs(appPreferences);
        GameSound.INSTANCE.setAudioSystem(this.risk, new SimpleAudio());
        GameSound.INSTANCE.load("medieval");
        this.adapter = new MiniFlashRiskAdapter(this.risk);
        DesktopPane.invokeLater(new Runnable(){

            public void run() {
                File autoSaveFile = DominationMain.getAutoSaveFile();
                if (autoSaveFile.exists()) {
                    logger.info("Loading from autosave");
                    RiskUtil.rename(autoSaveFile, new File(autoSaveFile.getParent(), autoSaveFile.getName() + ".load"));
                    DominationMain.this.risk.parser("loadgame " + DominationMain.getAutoSaveFile() + ".load");
                } else {
                    DominationMain.this.adapter.openMainMenu();
                    if (DominationMain.this.hasPendingOpenLobby()) {
                        DominationMain.this.adapter.openLobby();
                    }
                }
                logger.info("UI STARTED");
            }
        });
        new Thread("Update-Version-Check"){

            public void run() {
                MapUpdateService.getInstance().init(MiniUtil.getFileList("map"), MapServerClient.MAP_PAGE);
            }
        }.start();
    }

    public static void quit() {
        if (DesktopPane.getDesktopPane() != null) {
            logger.info("UI QUIT");
            Application.exit();
        }
    }

    public static boolean getBoolean(String key, boolean deflt) {
        if (appPreferences == null) {
            return deflt;
        }
        return appPreferences.getBoolean(key, deflt);
    }

    public static String getString(String key, String defaultValue) {
        if (appPreferences == null) {
            return defaultValue;
        }
        return appPreferences.get(key, defaultValue);
    }

    public static void setAccounts(List<String> accounts) {
        if (!accounts.isEmpty() && appPreferences != null) {
            appPreferences.put("accounts", JavaCompatUtil.listToCsv(accounts, ','));
            DominationMain.flushPreferences();
        }
    }

    public static void setExternalMapsDir(String url) {
        MiniUtil.setExternalMapDir(url);
        if (appPreferences != null) {
            appPreferences.put("externalMapsDirUrl", url);
            DominationMain.flushPreferences();
        }
    }

    public static String getAccountsString() {
        String accounts = DominationMain.getString("accounts", null);
        if ("".equals(accounts)) {
            appPreferences.remove("accounts");
            DominationMain.flushPreferences();
            return null;
        }
        return accounts;
    }

    private static boolean containsKey(String key) {
        try {
            return Arrays.asList(appPreferences.keys()).contains(key);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void flushPreferences() {
        try {
            appPreferences.flush();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "can not flush prefs", ex);
        }
    }

    public void setGooglePlayGameServices(GooglePlayGameServices listener) {
        this.googlePlayGameServices = listener;
    }

    public static GooglePlayGameServices getGooglePlayGameServices() {
        DominationMain main = (DominationMain)Application.getInstance();
        return main == null ? null : main.googlePlayGameServices;
    }

    public static void openURL(String url, ActivityResultListener listener) {
        url = url + (url.indexOf(63) >= 0 ? "&" : "?") + "requestCode=" + ++nativeCallsCount;
        nativeCalls.put(nativeCallsCount, listener);
        Application.openURL(url);
    }

    @Override
    public void onResult(int requestCode, int resultCode, Object obj) {
        ActivityResultListener listener = nativeCalls.remove(requestCode);
        if (listener != null) {
            if (resultCode == -1) {
                listener.onActivityResult(obj);
            } else if (resultCode == 0) {
                listener.onCanceled();
            } else {
                logger.warning("unknown resultCode " + resultCode);
            }
        }
    }

    public boolean hasPendingOpenLobby() {
        return this.pendingOpenGame != null;
    }

    public void lobbyConnected() {
        if (this.pendingOpenGame != null) {
            this.adapter.lobby.playGame(this.pendingOpenGame);
            this.pendingOpenGame = null;
        }
    }

    public void pushNotificationsToken(String token) {
        if (Application.getPlatform() == 12) {
            MiniLobbyClient lobby;
            String apsEnvironment = System.getProperty("aps-environment");
            logger.info("Apple Push Token " + apsEnvironment + " " + token);
            if ("development".equals(apsEnvironment)) {
                token = "sandbox-" + token;
            }
            if ((lobby = this.adapter.lobby) != null) {
                lobby.mycom.setPushToken("APN", token);
            }
        }
    }

    public void openNotification(Map params) {
        String gameId = (String)params.get("gameId");
        String options = (String)params.get("options");
        if (gameId != null) {
            Game game = new Game();
            game.setId(Integer.parseInt(gameId));
            game.setOptions(options);
            MiniFlashRiskAdapter ui = this.adapter;
            if (ui != null) {
                if (ui.lobby != null) {
                    if (ui.lobby.whoAmI() != null) {
                        ui.lobby.playGame(game);
                    } else {
                        this.pendingOpenGame = game;
                        logger.warning("lobby open but we are not logged in yet");
                    }
                } else {
                    this.pendingOpenGame = game;
                    ui.openLobby();
                }
            } else {
                this.pendingOpenGame = game;
            }
        } else {
            logger.info("opened from notification, but no game info " + params);
        }
    }

    public static File getAutoSaveFile() {
        return new File(MiniUtil.getSaveGameDir(), AUTO_SAVE_FILE_NAME);
    }

    public boolean shouldSaveGame() {
        Risk risk = this.risk;
        return risk != null && risk.getGame() != null && risk.getLocalGame();
    }

    @Override
    protected void pauseApp() {
        File file;
        super.pauseApp();
        if (!this.shouldSaveGame() && (file = DominationMain.getAutoSaveFile()).exists()) {
            logger.info("[DominationMain] DELETING AUTOSAVE");
            file.delete();
        }
    }

    public void saveState() {
        if (this.shouldSaveGame()) {
            logger.info("[DominationMain] SAVING TO AUTOSAVE");
            try {
                Risk risk = this.risk;
                if (risk != null) {
                    File autoSaveFile = DominationMain.getAutoSaveFile();
                    File tempSaveFile = new File(autoSaveFile.getParent(), autoSaveFile.getName() + ".part");
                    risk.parserAndWait("savegame " + DominationMain.getAutoSaveFile() + ".part");
                    if (!tempSaveFile.exists() && MiniUtil.getSaveGameDir().getUsableSpace() < 1000L) {
                        return;
                    }
                    if (this.shouldSaveGame()) {
                        RiskUtil.rename(tempSaveFile, autoSaveFile);
                    }
                }
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "onSaveInstanceState AUTOSAVE Error", ex);
            }
        }
    }

    static {
        String versionCode = System.getProperty("versionCode");
        version = versionCode != null ? versionCode : RiskUtil.RISK_VERSION;
        appPreferences = Preferences.userNodeForPackage(DominationMain.class);
        nativeCalls = new HashMap<Integer, ActivityResultListener>();
        nativeCallsCount = 100000;
    }

    public static interface ActivityResultListener {
        public void onActivityResult(Object var1);

        public void onCanceled();
    }

    public static class CentreIcon
    extends Icon {
        Icon wrappedIcon;

        public CentreIcon(Icon icon, int w, int h) {
            this.wrappedIcon = icon;
            this.width = w;
            this.height = h;
        }

        public void paintIcon(Component c, Graphics2D g, int x, int y) {
            this.wrappedIcon.paintIcon(c, g, x + (this.getIconWidth() - this.wrappedIcon.getIconWidth()) / 2, y + (this.getIconHeight() - this.wrappedIcon.getIconHeight()) / 2);
        }
    }

    public static interface GooglePlayGameServices {
        public void beginUserInitiatedSignIn();

        public void signOut();

        public boolean isSignedIn();

        public void showAchievements();

        public void unlockAchievement(String var1);

        public void startGameGooglePlay(Game var1);

        public void setLobbyUsername(String var1);

        public void gameStarted(int var1);
    }
}

