/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.util.Hashtable;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Properties;
import net.yura.swingme.core.CoreUtil;

public class GamePreferences
implements ActionListener {
    private Properties resBundle = CoreUtil.wrap(TranslationBundle.getBundle());
    XULLoader loader;

    public GamePreferences() {
        try {
            this.loader = XULLoader.load(Application.getResourceAsStream("/preferences.xml"), this, this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void actionPerformed(String actionCommand) {
        if ("ok".equals(actionCommand)) {
            Hashtable results = this.loader.getFormData();
            Risk.setShowDice(Boolean.parseBoolean((String)results.get("game.dice.show")));
            AIManager.setWait(Integer.parseInt((String)results.get("ai.wait")));
            DominationMain.appPreferences.putBoolean("show_toasts", Boolean.parseBoolean((String)results.get("show_toasts")));
            DominationMain.appPreferences.putBoolean("color_blind", Boolean.parseBoolean((String)results.get("color_blind")));
            GameSound.INSTANCE.setSoundEnabled(Boolean.parseBoolean((String)results.get("audio.sound")));
            GameSound.INSTANCE.setMusicEnabled(Boolean.parseBoolean((String)results.get("audio.music")));
            RiskSettings.saveSettingsToPrefs(DominationMain.appPreferences);
        }
    }

    public static void showGamePreferences() {
        GamePreferences gp = new GamePreferences();
        gp.loader.setFormData(CoreUtil.asHashtable(DominationMain.appPreferences));
        OptionPane.showOptionDialog(gp, gp.loader.getRoot(), gp.resBundle.getProperty("swing.menu.options"), 2, -1, null, null, null);
    }
}

