/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.io.File;
import java.util.Locale;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mobile.MiniUtil;
import net.yura.domination.mobile.flashgui.BackgroundBorder;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.domination.mobile.flashgui.GameWindow;
import net.yura.domination.mobile.flashgui.MiniFlashRiskAdapter;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.FileChooser;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.util.Properties;
import net.yura.mobile.util.Url;

public class MainMenu
extends Frame
implements ActionListener {
    Properties resb = GameWindow.resb;
    public Risk myrisk;
    MiniFlashRiskAdapter controller;
    XULLoader mainMenu;
    FileChooser chooser;
    public static final Border background;

    public MainMenu(Risk risk, MiniFlashRiskAdapter controller) {
        this.myrisk = risk;
        this.controller = controller;
        this.setUndecorated(true);
        this.setMaximum(true);
        this.setBorder(background);
        this.setBackground(0xFFFFFF);
    }

    public void openMainMenu() {
        this.mainMenu = GameWindow.getPanel("/mainmenu.xml", this);
        this.setContentPane((Panel)this.mainMenu.getRoot());
        this.revalidate();
        this.setVisible(true);
        this.moveToBack();
    }

    public void setPlayGamesSingedIn(final boolean in) {
        DesktopPane.invokeLater(new Runnable(){

            public void run() {
                XULLoader mm = MainMenu.this.mainMenu;
                if (mm != null) {
                    Button showAchievements = (Button)mm.find("showAchievements");
                    Button signIn = (Button)mm.find("signIn");
                    Button signOut = (Button)mm.find("signOut");
                    if (showAchievements != null) {
                        showAchievements.setVisible(true);
                    }
                    if (signIn != null) {
                        signIn.setVisible(!in);
                    }
                    if (signOut != null) {
                        signOut.setVisible(in);
                    }
                    Window window = mm.getRoot().getWindow();
                    window.revalidate();
                    window.repaint();
                }
            }
        });
    }

    private void moveToBack() {
        Vector windows = this.getDesktopPane().getAllFrames();
        for (int c = 1; c < windows.size(); ++c) {
            this.getDesktopPane().setSelectedFrame((Window)windows.get(0));
        }
    }

    public void actionPerformed(String actionCommand) {
        GameSound.INSTANCE.playSound("online".equals(actionCommand) ? "lobby_start" : "menu_button");
        if ("new game".equals(actionCommand)) {
            this.myrisk.parser("newgame");
        } else if ("load game".equals(actionCommand)) {
            FileUtil fileSystemView = new FileUtil(){

                public String getRoots() {
                    return MiniUtil.getSaveGameDir() + "/";
                }

                public Vector listFiles(String dir, int filter, boolean recent) {
                    String[] saves = new File(dir).list();
                    Vector<String> result = new Vector<String>();
                    for (int c = 0; c < saves.length; ++c) {
                        if (!saves[c].endsWith(".save")) continue;
                        result.add(saves[c]);
                    }
                    return JavaCompatUtil.asVector(result);
                }

                public void deleteFile(String path) {
                    new File(path).delete();
                }
            };
            this.chooser = new FileChooser(fileSystemView);
            Panel contentPane = this.chooser.getContentPane();
            ((Component)contentPane.getComponents().get(0)).setVisible(false);
            MenuBar menuBar = this.chooser.getMenuBar();
            for (int c = 0; c < menuBar.getComponentCount(); ++c) {
                Component comp = (Component)menuBar.getItems().get(c);
                if (!(comp instanceof Menu)) continue;
                menuBar.remove(comp);
                break;
            }
            this.chooser.showDialog(this, "doLoad", this.resb.getProperty("mainmenu.loadgame.loadbutton"), this.resb.getProperty("mainmenu.loadgame.loadbutton"));
        } else if ("doLoad".equals(actionCommand)) {
            String file = this.chooser.getSelectedFile();
            this.chooser = null;
            if (file.endsWith(".save")) {
                this.myrisk.parser("loadgame " + file);
            }
        } else if ("no_file_selected".equals(actionCommand)) {
            this.chooser = null;
        } else if ("manual".equals(actionCommand)) {
            MiniUtil.openHelp();
        } else if ("about".equals(actionCommand)) {
            MiniUtil.showAbout();
        } else if ("quit".equals(actionCommand)) {
            DominationMain.quit();
        } else if ("donate".equals(actionCommand)) {
            try {
                RiskUtil.donate();
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
            }
        } else if ("online".equals(actionCommand)) {
            this.controller.openLobby();
        } else if ("join game".equals(actionCommand)) {
            OptionPane.showMessageDialog(null, "not done yet", "Error", 0);
        } else if ("start server".equals(actionCommand)) {
            OptionPane.showMessageDialog(null, "not done yet", "Error", 0);
        } else if ("feedback".equals(actionCommand)) {
            String email = "yura@yura.net";
            String url = "mailto:" + email + "?subject=" + Url.encode(RiskUtil.GAME_NAME + " " + RiskUtil.RISK_VERSION + " " + DominationMain.product + " " + DominationMain.version + " " + Locale.getDefault() + " Feedback").replace("+", "%20") + "&body=" + Url.encode("\n\n\nDevice: " + System.getProperty("http.agent") + "\nID: " + MiniLobbyClient.getMyUUID()).replace("+", "%20");
            try {
                Application.getInstance().platformRequest(url);
            }
            catch (Exception ex) {
                OptionPane.showMessageDialog(null, "Please email " + email, "contact", 1);
            }
        } else if ("signIn".equals(actionCommand)) {
            DominationMain.getGooglePlayGameServices().beginUserInitiatedSignIn();
        } else if ("signOut".equals(actionCommand)) {
            DominationMain.getGooglePlayGameServices().signOut();
            this.setPlayGamesSingedIn(false);
        } else if ("showAchievements".equals(actionCommand)) {
            DominationMain.getGooglePlayGameServices().showAchievements();
        } else {
            System.err.println("MainMenu unknown command: " + actionCommand);
        }
    }

    static {
        Image bkg = Application.createImage("/war_blood.png");
        background = bkg == null ? null : new BackgroundBorder(bkg);
    }
}

