/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.util.Collection;
import javax.microedition.lcdui.Image;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskListener;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.lobby.mini.MiniLobbyRisk;
import net.yura.domination.mobile.flashgui.BattleDialog;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.domination.mobile.flashgui.GameSetup;
import net.yura.domination.mobile.flashgui.GameWindow;
import net.yura.domination.mobile.flashgui.MainMenu;
import net.yura.domination.mobile.flashgui.MoveDialog;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Player;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Url;

public class MiniFlashRiskAdapter
implements RiskListener {
    private Risk myRisk;
    private MainMenu mainmenu;
    private GameSetup gameSetup;
    private GameWindow gameFrame;
    public MiniLobbyClient lobby;
    String googleAccountId;
    String googleAccountIdToken;
    String email;
    MoveDialog move;
    BattleDialog battle;

    public MiniFlashRiskAdapter(Risk risk) {
        this.myRisk = risk;
        risk.addRiskListener(this);
        this.email = DominationMain.getAccountsString();
    }

    public void openLobby() {
        this.lobby = new MiniLobbyClient(new MiniLobbyRisk(this.myRisk){

            public void openGameSetup(GameType gameType) {
                MiniFlashRiskAdapter.this.show("setup");
                String[] split = gameType.getOptions().split(",");
                String[] names = new String[split.length];
                for (int c = 0; c < names.length; ++c) {
                    names[c] = Url.decode(split[c]);
                }
                MiniFlashRiskAdapter.this.gameSetup.openNewGame(false, names, OnlineUtil.getDefaultOnlineGameName(this.lobby.whoAmI()));
            }

            public String getAppName() {
                String appNamePrefix = Application.getPlatform() == 10 ? "Android" : (Application.getPlatform() == 12 ? "iOS" : "Mobile");
                return appNamePrefix + RiskUtil.GAME_NAME;
            }

            public String getAppVersion() {
                return DominationMain.version;
            }

            public void connected(String username) {
                DominationMain dmain = (DominationMain)Application.getInstance();
                dmain.lobbyConnected();
                DominationMain.GooglePlayGameServices play = DominationMain.getGooglePlayGameServices();
                if (play != null) {
                    play.setLobbyUsername(username);
                }
            }

            public void loginGoogle() {
                DominationMain.getGooglePlayGameServices().beginUserInitiatedSignIn();
            }

            public void gameStarted(int id) {
                DominationMain.getGooglePlayGameServices().gameStarted(id);
            }

            public void showMessage(String fromwho, String message) {
                MiniLobbyClient.toast(fromwho != null ? fromwho + ": " + message : message);
            }

            public void updatePlayerList(Collection playersInGame, String whosTurn) {
            }

            public void addSpectator(Player player) {
            }

            public void removeSpectator(String player) {
            }

            public void renameSpectator(String oldname, String newname, int newtype) {
            }
        });
        this.updatePlayGamesInfo();
        this.lobby.connect("lobby.yura.net");
        Frame mapFrame = new Frame(this.lobby.getTitle()){

            public void setVisible(boolean b) {
                super.setVisible(b);
                if (!b) {
                    MiniFlashRiskAdapter.this.lobby = null;
                }
            }
        };
        mapFrame.setContentPane(this.lobby.getRoot());
        mapFrame.setMaximum(true);
        mapFrame.setVisible(true);
    }

    void createLobbyGame(String name, String options, int numPlayers, int timeout, String password) {
        Game game = new Game(name, options, numPlayers, timeout);
        game.setMagicWord(password);
        this.lobby.createNewGame(game);
    }

    boolean shouldShowClosePrompt() {
        return this.myRisk.getLocalGame() || this.amOnlinePlayer();
    }

    void addExtraButtons(Menu menu) {
        Button button;
        if (this.amOnlinePlayer()) {
            button = new Button(GameWindow.resb.getString("lobby.resign"), new Icon("/ic_menu_exit.png"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(String actionCommand) {
                    MiniFlashRiskAdapter.this.lobby.resignPrompt();
                }
            });
            menu.add(button);
        }
        if (this.lobby != null) {
            button = new Button(GameWindow.resb.getString("lobby.chat"), new Icon("/ic_menu_chat.png"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(String actionCommand) {
                    MiniFlashRiskAdapter.this.lobby.sendChatMessage();
                }
            });
            menu.add(button);
        }
    }

    private boolean amOnlinePlayer() {
        net.yura.domination.engine.core.Player player = this.lobby == null ? null : this.myRisk.getGame().getPlayer(this.lobby.whoAmI());
        return player != null && player.isAlive();
    }

    private void show(String what) {
        Logger.info("Opening " + what);
        if (this.mainmenu != null) {
            this.mainmenu.setVisible(false);
            this.mainmenu = null;
        }
        if (this.gameSetup != null) {
            this.gameSetup.setVisible(false);
            this.gameSetup = null;
        }
        if (this.gameFrame != null) {
            this.gameFrame.setVisible(false);
            this.gameFrame = null;
        }
        if ("menu".equals(what)) {
            this.mainmenu = new MainMenu(this.myRisk, this);
        } else if ("setup".equals(what)) {
            this.gameSetup = new GameSetup(this.myRisk, this);
        } else if ("game".equals(what)) {
            this.gameFrame = new GameWindow(this.myRisk, this);
        } else {
            throw new IllegalArgumentException("unknown " + what);
        }
    }

    public void openMainMenu() {
        this.show("menu");
        this.mainmenu.openMainMenu();
        this.updatePlayGamesInfo();
    }

    public void playGamesStateChanged(String id, String idToken, String email) {
        this.googleAccountId = id;
        this.googleAccountIdToken = idToken;
        this.email = email;
        this.updatePlayGamesInfo();
    }

    private void updatePlayGamesInfo() {
        DominationMain.GooglePlayGameServices nlc = DominationMain.getGooglePlayGameServices();
        if (nlc != null) {
            if (this.mainmenu != null) {
                this.mainmenu.setPlayGamesSingedIn(nlc.isSignedIn());
            }
            if (this.lobby != null) {
                this.lobby.setPlayGamesSingedIn(nlc.isSignedIn(), this.googleAccountId, this.googleAccountIdToken, this.email);
            }
        }
    }

    public void newGame(boolean t) {
        this.show("setup");
        this.gameSetup.openNewGame(t, null, null);
    }

    public void gameOver(boolean bln) {
    }

    public void closeGame() {
        if (this.move != null) {
            this.move.setVisible(false);
        }
        this.openMainMenu();
    }

    public void sendMessage(String output, boolean redrawNeeded, boolean repaintNeeded) {
        Logger.debug("Game: " + output);
        if (this.gameFrame != null) {
            this.gameFrame.mapRedrawRepaint(redrawNeeded, repaintNeeded);
        }
    }

    public void addPlayer(int type, String name, int color, String ip) {
        this.gameSetup.updatePlayers();
    }

    public void delPlayer(String name) {
        this.gameSetup.updatePlayers();
    }

    public void showMapPic(RiskGame p) {
        this.gameSetup.showMapPic(p.getMapFile());
    }

    public void showCardsFile(String c, boolean m) {
        this.gameSetup.showCardsFile(c, m);
    }

    public void startGame(boolean s) {
        this.show("game");
        this.gameFrame.startGame(s);
        this.gameFrame.setVisible(true);
    }

    public void needInput(int s) {
        if (s != 5 && this.move != null && this.move.isVisible()) {
            this.move.setVisible(false);
        }
        if (this.gameFrame != null) {
            this.gameFrame.needInput(s);
            switch (s) {
                case 4: {
                    this.battle.needInput(this.myRisk.getGame().getNoAttackDice(), true);
                    break;
                }
                case 10: {
                    this.battle.needInput(this.myRisk.getGame().getNoDefendDice(), false);
                    break;
                }
                case 5: {
                    if (this.move == null) {
                        this.move = new MoveDialog(this.myRisk){

                            public void setVisible(boolean b) {
                                super.setVisible(b);
                                if (!b) {
                                    MiniFlashRiskAdapter.this.move = null;
                                }
                            }
                        };
                    }
                    RiskGame game = this.myRisk.getGame();
                    int min = game.getMustMove();
                    int c1num = game.getAttacker().getColor();
                    int c2num = game.getDefender().getColor();
                    Image c1img = this.gameFrame.pp.getCountryImage(c1num);
                    Image c2img = this.gameFrame.pp.getCountryImage(c2num);
                    this.move.setupMove(min, c1num, c2num, c1img, c2img, false);
                    if (this.move.isVisible()) break;
                    this.move.setVisible(true);
                }
            }
        }
    }

    public void noInput() {
        if (this.gameFrame != null) {
            this.gameFrame.noInput();
        }
    }

    public void openBattle(int c1num, int c2num) {
        Image c1img = this.gameFrame.pp.getCountryImage(c1num);
        Image c2img = this.gameFrame.pp.getCountryImage(c2num);
        if (this.battle == null) {
            this.battle = new BattleDialog(this.myRisk);
        }
        this.battle.setup(c1num, c2num, c1img, c2img);
        this.battle.setVisible(true);
    }

    public void closeBattle() {
        this.battle.setVisible(false);
    }

    public void sendDebug(String a) {
    }

    public void serverState(boolean s) {
    }

    public void setGameStatus(String state) {
        if (this.gameFrame != null) {
            this.gameFrame.setGameStatus(state);
        }
    }

    public void setNODAttacker(int n) {
        if (this.battle.isVisible()) {
            this.battle.setNODAttacker(n);
        }
    }

    public void setNODDefender(int n) {
        if (this.battle.isVisible()) {
            this.battle.setNODDefender(n);
        }
    }

    public void playerGotCard() {
    }

    public void showDiceResults(int[] att, int[] def, boolean weAreAttacker, int result) {
        if (this.battle.isVisible()) {
            this.battle.showDiceResults(att, def);
        }
    }

    public void showMessageDialog(String a) {
        OptionPane.showMessageDialog(null, a, null, 1);
    }
}

