/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import android.graphics.ColorMatrix;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Player;
import net.yura.domination.mobile.PicturePanel;
import net.yura.domination.mobile.flashgui.GameWindow;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Slider;
import net.yura.mobile.gui.layout.Layout;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Properties;

public class MoveDialog
extends Frame
implements ActionListener,
ChangeListener {
    Font font;
    Properties resb = GameWindow.resb;
    Risk myrisk;
    Slider slider;
    Button cancelMove;
    Button moveb;
    int c1num;
    int c2num;
    Image c1img;
    Image c2img;
    public static int distanceFromCenter = XULLoader.adjustSizeToDensity(108);

    public MoveDialog(Risk risk) {
        this.myrisk = risk;
        this.slider = new Slider();
        this.slider.addChangeListener(this);
        this.cancelMove = new Button(this.resb.getProperty("move.cancel"));
        this.cancelMove.setActionCommand("close");
        Button moveall = new Button(this.resb.getProperty("move.moveall"));
        moveall.setActionCommand("all");
        this.moveb = new Button(this.resb.getProperty("move.move"));
        this.moveb.setActionCommand("move");
        Panel moveControl = new Panel();
        moveControl.add(moveall);
        moveControl.add(this.moveb);
        moveControl.add(this.cancelMove);
        this.cancelMove.addActionListener(this);
        moveall.addActionListener(this);
        this.moveb.addActionListener(this);
        Panel contentPane = this.getContentPane();
        contentPane.setLayout(new DialogLayout(this.getImageAreaHeight()));
        contentPane.add(this.slider);
        contentPane.add(moveControl);
        this.setMaximum(true);
        this.addWindowListener(this);
        this.setName("TransparentDialog");
        this.setForeground(-16777216);
        this.setBackground(-1442840576);
    }

    private int getImageAreaHeight() {
        return this.font.getHeight() * 5;
    }

    public void setupMove(int min, int c1num, int c2num, Image c1img, Image c2img, boolean tacmove) {
        this.c1num = c1num;
        this.c2num = c2num;
        this.c1img = c1img;
        this.c2img = c2img;
        if (tacmove) {
            this.setTitle(this.resb.getProperty("move.title.tactical"));
            this.cancelMove.setVisible(true);
            this.cancelMove.setMnemonic(-7);
        } else {
            this.setTitle(this.resb.getProperty("move.title.captured"));
            this.cancelMove.setVisible(false);
            this.cancelMove.setMnemonic(0);
        }
        int src = this.myrisk.hasArmiesInt(c1num);
        int max = src - 1;
        this.slider.setVisible(min != max);
        this.moveb.setVisible(min != max);
        this.slider.setMinimum(min);
        this.slider.setMaximum(max);
        this.slider.setValue(min);
        this.revalidate();
    }

    public void paintComponent(Graphics2D g) {
        int csrc = this.myrisk.hasArmiesInt(this.c1num);
        int cdes = this.myrisk.hasArmiesInt(this.c2num);
        int color = this.myrisk.getCurrentPlayerColor();
        int move = (Integer)this.slider.getValue();
        g.setFont(this.font);
        int imageAreaHeight = this.getImageAreaHeight();
        int heightOfComponents = ((DialogLayout)this.getContentPane().getLayout()).getHeightOfComponents(this.getContentPane());
        int xOffset = this.getContentPane().getWidth() / 2;
        int yOffset = (this.getContentPane().getHeight() - heightOfComponents) / 2 + imageAreaHeight / 2 + this.getContentPane().getY();
        MoveDialog.paintMove(g, xOffset, yOffset, this.c1img, this.c2img, color, color, this.myrisk.getCountryCapital(this.c1num), this.myrisk.getCountryCapital(this.c2num), this.myrisk.getCountryName(this.c1num), this.myrisk.getCountryName(this.c2num), csrc - move, cdes + move, move);
    }

    public static void paintMove(Graphics2D g, int xMiddle, int yMiddle, Image c1img, Image c2img, int color1, int color2, Player capital1, Player capital2, String name1, String name2, int noa1i, int noa2i, int move) {
        Font font = g.getFont();
        int fh = font.getHeight();
        int xC1 = xMiddle - distanceFromCenter;
        int xC2 = xMiddle + distanceFromCenter;
        g.getGraphics().setColorMatrix(MoveDialog.getMatrix(color1));
        MoveDialog.drawCountry(g, c1img, xC1, yMiddle);
        if (color1 != color2) {
            g.getGraphics().setColorMatrix(MoveDialog.getMatrix(color2));
        }
        MoveDialog.drawCountry(g, c2img, xC2, yMiddle);
        g.getGraphics().setColorMatrix(null);
        int size = Math.max(fh, XULLoader.adjustSizeToDensity(20));
        PicturePanel.drawArmy(g, color1, noa1i, xMiddle - distanceFromCenter, yMiddle, size, capital1);
        PicturePanel.drawArmy(g, color2, noa2i, xMiddle + distanceFromCenter, yMiddle, size, capital2);
        int xOffset = XULLoader.adjustSizeToDensity(70);
        int yOffset = XULLoader.adjustSizeToDensity(40);
        MoveDialog.drawArrow(g, xMiddle - xOffset, xMiddle + xOffset, yMiddle - yOffset, yMiddle + yOffset, PicturePanel.colorWithAlpha(color1, 150));
        if (move > 0) {
            g.setColor(ColorUtil.getTextColorFor(color1));
            g.drawString(Integer.toString(move), xMiddle - 7, yMiddle - fh / 2);
        }
        g.setColor(-1);
        int texty = yMiddle - distanceFromCenter / 2;
        g.drawString(name1, xC1 - font.getWidth(name1) / 2, texty);
        g.drawString(name2, xC2 - font.getWidth(name2) / 2, texty);
    }

    public static void drawArrow(Graphics2D g, int xStart, int xEnd, int yTop, int yBottom, int color) {
        int xMiddle = (xEnd + xStart) / 2;
        int[] xCoords = new int[]{xStart, xMiddle, xMiddle, xEnd, xMiddle, xMiddle, xStart};
        int yOffset = (yBottom - yTop) / 4;
        int[] yCoords = new int[]{yTop + yOffset, yTop + yOffset, yTop, yTop + yOffset * 2, yBottom, yBottom - yOffset, yBottom - yOffset};
        DirectGraphics g2 = DirectUtils.getDirectGraphics(g.getGraphics());
        g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, color);
    }

    public static void drawCountry(Graphics2D g, Image img, int x, int y) {
        if (img == null) {
            return;
        }
        int maxW = distanceFromCenter * 2;
        int maxH = distanceFromCenter;
        int w = XULLoader.adjustSizeToDensity(img.getWidth());
        int h = XULLoader.adjustSizeToDensity(img.getHeight());
        if (w > maxW || h > maxH) {
            double scale = Math.min((double)maxW / (double)w, (double)maxH / (double)h);
            w = (int)(scale * (double)w);
            h = (int)(scale * (double)h);
        }
        g.drawScaledImage(img, x - w / 2, y - h / 2, w, h);
    }

    static ColorMatrix getMatrix(int color) {
        ColorMatrix m = PicturePanel.RescaleOp(0.5f, -1.0f);
        m.preConcat(PicturePanel.gray);
        m.postConcat(PicturePanel.getMatrix(PicturePanel.colorWithAlpha(color, 100)));
        return m;
    }

    public void actionPerformed(String actionCommand) {
        boolean tacmove;
        boolean bl = tacmove = this.myrisk.getGame().getState() == 6;
        if ("all".equals(actionCommand)) {
            int src = this.myrisk.hasArmiesInt(this.c1num);
            if (tacmove) {
                GameSound.INSTANCE.playSound("move_tactical");
                this.go("movearmies " + this.c1num + " " + this.c2num + " " + (src - 1));
            } else {
                GameSound.INSTANCE.playSound("move_armies");
                this.go("move " + (src - 1));
            }
        } else if ("move".equals(actionCommand)) {
            int move = (Integer)this.slider.getValue();
            if (tacmove) {
                GameSound.INSTANCE.playSound("move_tactical");
                this.go("movearmies " + this.c1num + " " + this.c2num + " " + move);
            } else {
                GameSound.INSTANCE.playSound("move_armies");
                this.go("move " + move);
            }
        } else if ("close".equals(actionCommand)) {
            if (tacmove) {
                this.setVisible(false);
            }
        } else {
            System.out.println("Unknown command in MoveDialog " + actionCommand);
        }
    }

    public void changeEvent(Component source, int num) {
        this.repaint();
    }

    private void go(String input) {
        int gameState = this.myrisk.getGame().getState();
        if (gameState == 5 || gameState == 6) {
            this.setVisible(false);
        }
        this.myrisk.parser(input);
    }

    public void updateUI() {
        super.updateUI();
        this.font = this.theme.getFont(0);
    }

    public static class DialogLayout
    implements Layout {
        int imageAreaHeight;
        int gap;

        public DialogLayout(int imageAreaHeight) {
            this.imageAreaHeight = imageAreaHeight;
            this.gap = XULLoader.adjustSizeToDensity(7);
        }

        public void layoutPanel(Panel panel) {
            int heightOfComponents = this.getHeightOfComponents(panel);
            int yOffset = (panel.getHeight() - heightOfComponents) / 2 + this.imageAreaHeight + this.gap;
            int width = panel.getWidth();
            for (Component c : panel.getComponents()) {
                if (!c.isVisible()) continue;
                int w = c.getWidthWithBorder();
                if (w < heightOfComponents) {
                    w = heightOfComponents;
                }
                int h = c.getHeightWithBorder();
                c.setBounds((width - w) / 2, yOffset, w, h);
                yOffset = yOffset + h + this.gap;
            }
        }

        public int getPreferredHeight(Panel panel) {
            return 10;
        }

        public int getPreferredWidth(Panel panel) {
            return 10;
        }

        public int getHeightOfComponents(Panel panel) {
            int heightOfComponents = this.imageAreaHeight + this.gap * panel.getComponentCount();
            Vector comps = panel.getComponents();
            for (Component c : comps) {
                if (!c.isVisible()) continue;
                heightOfComponents += c.getHeightWithBorder();
            }
            return heightOfComponents;
        }
    }
}

