/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.mini;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.lcdui.Display;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.LobbyClient;
import net.yura.lobby.client.LobbyCom;
import net.yura.lobby.client.ProtoAccess;
import net.yura.lobby.client.PushLobbyClient;
import net.yura.lobby.gen.ProtoLobby;
import net.yura.lobby.mini.GameRenderer;
import net.yura.lobby.mini.MiniLobbyGame;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Player;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Option;
import net.yura.mobile.util.Url;
import net.yura.swingme.core.ViewChooser;

public class MiniLobbyClient
implements LobbyClient,
ActionListener {
    private static final Logger logger = Logger.getLogger(MiniLobbyClient.class.getName());
    public static final String LOBBY_SERVER = "lobby.yura.net";
    private static final String LOBBY_ID_FILE = ".lobby";
    XULLoader loader;
    net.yura.mobile.gui.components.List gameList;
    Window adminPopup;
    public final Connection mycom;
    final MiniLobbyGame game;
    String myusername;
    int playerType;
    GameType theGameType;
    int openGameId = -1;
    private final Queue<String> chatMessages = new LinkedList<String>();
    final net.yura.mobile.util.Properties resBundle;
    ActionListener closeListener;
    private List games = Collections.synchronizedList(new ArrayList());

    public MiniLobbyClient(MiniLobbyGame lobbyGame) {
        this.game = lobbyGame;
        this.game.addLobbyGameMoveListener(this);
        this.resBundle = this.game.getProperties();
        try {
            this.loader = XULLoader.load(Application.getResourceAsStream("/ms_lobby.xml"), this, this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.gameList = (net.yura.mobile.gui.components.List)this.loader.find("ResultList");
        GameRenderer r = new GameRenderer(this);
        this.gameList.setCellRenderer(r);
        this.gameList.setFixedCellHeight(Math.max(XULLoader.adjustSizeToDensity(50), r.getFixedCellHeight()));
        this.gameList.setFixedCellWidth(10);
        ComboBox box = (ComboBox)this.loader.find("listView");
        ViewChooser viewChooser = new ViewChooser(box.getItems().toArray(new Option[box.getItemCount()]));
        this.loader.swapComponent("listView", viewChooser);
        viewChooser.addActionListener(this);
        viewChooser.setActionCommand("filter");
        viewChooser.setStretchCombo(true);
        viewChooser.setName(null);
        this.adminPopup = this.gameList.getPopupMenu();
        this.gameList.setPopupMenu(null);
        String uuid = MiniLobbyClient.getMyUUID();
        this.mycom = new LobbyCom(uuid, lobbyGame.getAppName(), lobbyGame.getAppVersion());
        this.mycom.addEventListener(this);
    }

    public void connect(String server) {
        this.mycom.connect(server, 1964);
    }

    public void setPlayGamesSingedIn(boolean signedIn, String id, String idToken, String email) {
        Button joinPrivate = (Button)this.loader.find("loginGoogle");
        if (joinPrivate != null) {
            joinPrivate.setVisible(!signedIn);
            Panel root = this.getRoot();
            root.revalidate();
            root.repaint();
        }
        this.mycom.setEmail(email);
        this.mycom.setOAuthToken("googleIdToken", idToken);
    }

    public void removeBackButton() {
        Button button = (Button)this.loader.find("BackButton");
        button.setMnemonic(0);
        button.setVisible(false);
    }

    public void addCloseListener(ActionListener al) {
        this.closeListener = al;
    }

    public void destroy() {
        this.mycom.disconnect();
        this.game.lobbyShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getMyUUID() {
        Properties prop = new Properties();
        File lobbySettingsFile = new File(System.getProperty("user.home"), LOBBY_ID_FILE);
        FileInputStream lobbySettingsData = null;
        try {
            lobbySettingsData = new FileInputStream(lobbySettingsFile);
            prop.load(lobbySettingsData);
        }
        catch (Exception exception) {
            RiskUtil.close(lobbySettingsData);
        }
        catch (Throwable throwable) {
            RiskUtil.close(lobbySettingsData);
            throw throwable;
        }
        RiskUtil.close(lobbySettingsData);
        String uuid = prop.getProperty("uuid");
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            prop.setProperty("uuid", uuid);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(lobbySettingsFile);
                prop.store(fileOutputStream, "mini Lobby - DO NOT EDIT THIS FILE");
            }
            catch (Exception exception) {
                RiskUtil.close(fileOutputStream);
                catch (Throwable throwable) {
                    RiskUtil.close(fileOutputStream);
                    throw throwable;
                }
            }
            RiskUtil.close(fileOutputStream);
        }
        MiniLobbyClient.makeFileHidden(lobbySettingsFile);
        return uuid;
    }

    private static void makeFileHidden(File file) {
        String os;
        if (!file.isHidden() && (os = System.getProperty("os.name")) != null && os.toLowerCase().contains("windows")) {
            String jv = System.getProperty("java.version");
            if (jv != null && (jv.startsWith("1.5.") || jv.startsWith("1.6."))) {
                try {
                    Process p = Runtime.getRuntime().exec("attrib +H " + file.getAbsolutePath());
                    p.waitFor();
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "legacy can not set file properties", th);
                }
            } else {
                try {
                    Files.setAttribute(file.toPath(), "dos:hidden", true, LinkOption.NOFOLLOW_LINKS);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "can not set file properties", th);
                }
            }
        }
    }

    public Panel getRoot() {
        return (Panel)this.loader.getRoot();
    }

    public String getTitle() {
        return this.resBundle.getProperty("lobby.windowtitle");
    }

    public void actionPerformed(String actionCommand) {
        if ("listSelect".equals(actionCommand)) {
            final Game game = (Game)this.gameList.getSelectedValue();
            if (game != null) {
                int state = game.getState(this.whoAmI());
                this.game.gameActionPerformed(state);
                switch (state) {
                    case 1: {
                        if (game.getMagicWord() != null) {
                            final TextField passwordField = new TextField();
                            passwordField.setTitle(this.resBundle.getProperty("lobby.password"));
                            OptionPane.showConfirmDialog(new ActionListener(){

                                public void actionPerformed(String actionCommand) {
                                    if ("ok".equals(actionCommand)) {
                                        MiniLobbyClient.this.joinGame(game, passwordField.getText());
                                    }
                                }
                            }, passwordField, this.resBundle.getProperty("lobby.joinPrivateGame"), 2);
                            break;
                        }
                        if (game.getMaxPlayers() == game.getNumOfPlayers() + 1) {
                            OptionPane.showConfirmDialog(new ActionListener(){

                                public void actionPerformed(String actionCommand) {
                                    if ("ok".equals(actionCommand)) {
                                        MiniLobbyClient.this.joinGame(game, null);
                                    }
                                }
                            }, this.resBundle.getProperty("lobby.question.game-start"), this.resBundle.getProperty("lobby.question.title"), 2);
                            break;
                        }
                        this.joinGame(game, null);
                        break;
                    }
                    case 2: {
                        this.mycom.leaveGame(game.getId());
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.playGame(game);
                    }
                }
            }
        } else if ("create".equals(actionCommand)) {
            if (this.theGameType != null) {
                this.game.openGameSetup(this.theGameType);
            } else {
                logger.info("GameType is null, can not openGameSetup");
            }
        } else if ("setnick".equals(actionCommand)) {
            if (this.myusername != null) {
                final TextField nickField = new TextField();
                nickField.setText(this.myusername);
                OptionPane.showConfirmDialog(new ActionListener(){

                    public void actionPerformed(String actionCommand) {
                        if ("ok".equals(actionCommand)) {
                            MiniLobbyClient.this.mycom.setNick(nickField.getText());
                        }
                    }
                }, nickField, this.resBundle.getProperty("lobby.set-nickname"), 2);
            } else {
                logger.info("current username is null, can not set nick dialog");
            }
        } else if ("chat".equals(actionCommand)) {
            this.game.openChat();
        } else if ("close".equals(actionCommand)) {
            this.destroy();
            if (this.closeListener != null) {
                this.closeListener.actionPerformed("close");
            } else {
                this.getRoot().getWindow().setVisible(false);
            }
        } else if ("filter".equals(actionCommand)) {
            this.filter(false);
        } else if (!"login".equals(actionCommand) && !"register".equals(actionCommand)) {
            if ("loginGoogle".equals(actionCommand)) {
                this.game.loginGoogle();
            } else if ("renameGame".equals(actionCommand)) {
                if (this.playerType >= 3) {
                    final Game game = (Game)this.gameList.getSelectedValue();
                    final TextField gameNameField = new TextField();
                    gameNameField.setText(game.getName());
                    OptionPane.showConfirmDialog(new ActionListener(){

                        public void actionPerformed(String actionCommand) {
                            if ("ok".equals(actionCommand)) {
                                String newName = gameNameField.getText();
                                if (!game.getName().equals(newName)) {
                                    game.setName(newName);
                                    MiniLobbyClient.this.mycom.createNewGame(game);
                                }
                            }
                        }
                    }, gameNameField, "Rename Game", 2);
                } else {
                    logger.warning(actionCommand + " called when we are " + ProtoLobby.getPlayerTypeString(this.playerType) + " " + this.myusername);
                }
            } else if ("renameGame2".equals(actionCommand)) {
                if (this.playerType >= 3) {
                    Game game = (Game)this.gameList.getSelectedValue();
                    game.setName("game");
                    this.mycom.createNewGame(game);
                } else {
                    logger.warning(actionCommand + "called when we are " + this.playerType + " " + this.myusername);
                }
            } else if ("flagGame".equals(actionCommand)) {
                final Game game = (Game)this.gameList.getSelectedValue();
                if (game != null) {
                    final net.yura.mobile.gui.components.List players = new net.yura.mobile.gui.components.List(JavaCompatUtil.asVector(game.getPlayers()));
                    if (this.playerType >= 4) {
                        players.setCellRenderer(new DefaultListCellRenderer(){

                            public Component getListCellRendererComponent(Component listOrTable, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                Component c = super.getListCellRendererComponent(listOrTable, null, index, isSelected, cellHasFocus);
                                this.setText(GameRenderer.toAdminString((Player)value));
                                return c;
                            }
                        });
                    }
                    if (players.getSize() > 0) {
                        players.setSelectedIndex(0);
                    }
                    if (this.playerType >= 4) {
                        Button flagButton = new Button("set flagged");
                        flagButton.setActionCommand("flag");
                        Button clearButton = new Button("clear name");
                        clearButton.setActionCommand("clear");
                        Button cancel = new Button("Cancel");
                        cancel.setActionCommand("cancel");
                        cancel.setMnemonic(-7);
                        OptionPane.showOptionDialog(new ActionListener(){

                            public void actionPerformed(String actionCommand) {
                                Player player = (Player)players.getSelectedValue();
                                if (player != null) {
                                    if ("flag".equals(actionCommand)) {
                                        HashMap<String, Object> request = new HashMap<String, Object>();
                                        request.put("username", player.getName());
                                        request.put("userType", -1);
                                        MiniLobbyClient.this.mycom.sendAdminCommand("REQUEST_SET_USER_TYPE", request);
                                    } else if ("clear".equals(actionCommand)) {
                                        HashMap<String, String> request = new HashMap<String, String>();
                                        request.put("oldName", player.getName());
                                        request.put("newName", "");
                                        MiniLobbyClient.this.mycom.sendAdminCommand("REQUEST_RENAME_USER", request);
                                    }
                                }
                            }
                        }, new Object[]{game.getName(), players}, this.resBundle.getProperty("lobby.flagPlayer"), -1, 3, this.loader.loadIcon("/ms_flag.png"), new Button[]{flagButton, clearButton, cancel}, null);
                    } else {
                        OptionPane.showOptionDialog(new ActionListener(){

                            public void actionPerformed(String actionCommand) {
                                if ("yes".equals(actionCommand)) {
                                    Player player = (Player)players.getSelectedValue();
                                    HashMap<String, Object> request = new HashMap<String, Object>();
                                    request.put("game_id", game.getId());
                                    request.put("message", game.getName());
                                    if (player != null) {
                                        request.put("username", player.getName());
                                    }
                                    MiniLobbyClient.this.mycom.sendAdminCommand("REQUEST_FLAG_USER", request);
                                }
                            }
                        }, new Object[]{game.getName(), players}, this.resBundle.getProperty("lobby.flagPlayer"), 0, 3, this.loader.loadIcon("/ms_flag.png"), null, null);
                    }
                }
            } else if ("delGame".equals(actionCommand)) {
                final Game game = (Game)this.gameList.getSelectedValue();
                if (this.playerType >= 3) {
                    if (game.getNumOfPlayers() < game.getMaxPlayers()) {
                        this.mycom.delGame(game.getId());
                    } else if (this.playerType >= 4) {
                        OptionPane.showConfirmDialog(new ActionListener(){

                            public void actionPerformed(String actionCommand) {
                                if ("yes".equals(actionCommand)) {
                                    MiniLobbyClient.this.mycom.delGame(game.getId());
                                }
                            }
                        }, "Delete started game: " + game.getId(), this.resBundle.getProperty("lobby.question.title"), 0);
                    } else {
                        OptionPane.showMessageDialog(null, "game already started", "unable to delete", -1);
                    }
                } else {
                    logger.warning(actionCommand + " called when we are " + ProtoAccess.getPlayerTypeString(this.playerType) + " " + this.myusername);
                }
            } else {
                OptionPane.showMessageDialog(null, "unknown command: " + actionCommand, null, 1);
            }
        }
    }

    public void playGame(Game game) {
        if (this.openGameId == game.getId()) {
            return;
        }
        if (this.openGameId != -1) {
            this.closeGame();
        }
        this.openGameId = game.getId();
        this.game.prepareAndOpenGame(game);
        this.game.updatePlayerList(game.getPlayers(), game.getWhosTurn());
    }

    public void sendGameMessage(String messagefromgui) {
        this.mycom.sendGameMessage(this.openGameId, messagefromgui);
    }

    public void sendChatMessage() {
        final int gameId = this.openGameId;
        if (gameId == -1) {
            throw new IllegalStateException("no game open");
        }
        final TextField chatText = new TextField();
        StringBuilder messages = new StringBuilder();
        for (String message : this.chatMessages) {
            messages.append(message);
            messages.append('\n');
        }
        OptionPane.showConfirmDialog(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                String message = chatText.getText();
                if ("ok".equals(actionCommand) && !"".equals(message.trim())) {
                    MiniLobbyClient.this.sendChatMessage(gameId, message);
                }
            }
        }, new Object[]{messages.toString(), chatText}, this.resBundle.getProperty("lobby.chat"), 2);
    }

    public void sendChatMessage(int gameId, String message) {
        if (gameId == -1) {
            throw new IllegalArgumentException("invalid gameId " + gameId);
        }
        this.mycom.sendChat(gameId, message);
    }

    public void closeGame() {
        if (this.openGameId != -1) {
            this.mycom.closeGame(this.openGameId);
            this.openGameId = -1;
            this.chatMessages.clear();
        }
    }

    public void joinGame(Game game, String password) {
        this.requestNotificationAuthorization();
        this.mycom.joinGame(game.getId(), password);
    }

    public void createNewGame(Game game) {
        this.requestNotificationAuthorization();
        game.setType(this.theGameType);
        this.mycom.createNewGame(game);
    }

    private void requestNotificationAuthorization() {
        if (Application.getPlatform() == 12) {
            String iosNotificationSetting = System.getProperty("iosNotificationSetting");
            if ("ask".equals(iosNotificationSetting)) {
                OptionPane.showMessageDialog(new ActionListener(){

                    public void actionPerformed(String actionCommand) {
                        Application.openURL("notify://requestAuthorization");
                    }
                }, this.resBundle.getProperty("lobby.notification.authorization.request"), this.resBundle.getProperty("lobby.notification.authorization.title"), 1);
            }
        } else if (Application.getPlatform() == 10) {
            Application.openURL("notify://requestAuthorization");
        }
    }

    public void connected() {
        this.loader.find("ConnectingPanel").setVisible(false);
        this.loader.find("ConnectLog").setValue(" ");
        this.gameList.setVisible(true);
        if (Application.getPlatform() == 10) {
            Application.openURL("nativeNoResult://net.yura.domination.android.push.PushActivity");
        } else if (Application.getPlatform() == 12) {
            this.mycom.addPushEventListener(new PushLobbyClient(){

                public void registerDone() {
                    logger.info("ios getToken registerDone");
                }
            });
            Application.openURL("notify://getToken");
        }
        this.mycom.getGameTypes();
    }

    public void disconnected() {
        logger.info("disconnected openGame=" + this.openGameId);
        if (this.openGameId != -1) {
            this.openGameId = -1;
            this.chatMessages.clear();
            this.game.disconnected();
        }
    }

    public void connecting(String message) {
        logger.info("[MiniLobbyClient] " + message);
        this.loader.find("ConnectLog").setValue(message);
    }

    public void error(String error) {
        logger.info(error);
        OptionPane.showMessageDialog(null, error, "Lobby Error", 0);
    }

    public ClassLoader getClassLoader(GameType gameType) {
        return this.getClass().getClassLoader();
    }

    public void setUsername(String name, int type) {
        this.myusername = name;
        this.playerType = type;
        this.gameList.setPopupMenu(this.adminPopup);
        MenuBar rightCLickMenu = Menu.getPopupMenu(this.adminPopup);
        for (int c = 0; c < rightCLickMenu.getComponentCount(); ++c) {
            Button item = (Button)rightCLickMenu.getItems().get(c);
            if ("flagGame".equals(item.getActionCommand())) continue;
            item.setVisible(this.playerType >= 3);
        }
        MiniLobbyClient.toast(JavaCompatUtil.replaceAll(this.resBundle.getString("lobby.logged-in-as"), "{0}", name));
        this.game.connected(name);
    }

    public String whoAmI() {
        return this.myusername;
    }

    public void addGameType(List gametypes) {
        for (int c = 0; c < gametypes.size(); ++c) {
            GameType gametype = (GameType)gametypes.get(c);
            if (this.game.isMyGameType(gametype)) {
                this.theGameType = gametype;
                this.games.clear();
                this.filter(false);
                this.mycom.getGames(gametype);
                continue;
            }
            logger.info("ignore GameType: " + gametype);
        }
        if (this.theGameType == null) {
            this.error("Unable to find GameType in: " + gametypes);
        }
    }

    public void addOrUpdateGame(Game game) {
        int index;
        if (game.getId() == this.openGameId) {
            this.game.updatePlayerList(game.getPlayers(), game.getWhosTurn());
        }
        if ((index = Collections.binarySearch(this.games, game)) >= 0) {
            this.games.set(index, game);
            if (this.whoAmI().equals(game.getWhosTurn())) {
                MiniLobbyClient.notify(game, this.openGameId == game.getId());
            }
        } else {
            this.games.add(-index - 1, game);
        }
        this.filter(true);
        if (index < 0 && game.hasPlayer(this.whoAmI())) {
            this.gameList.ensureIndexIsVisible(-index - 1);
        }
    }

    public Game findGame(int id) {
        Game g = new Game();
        g.setId(id);
        int index = Collections.binarySearch(this.games, g);
        return index >= 0 ? (Game)this.games.get(index) : null;
    }

    public void resignPrompt() {
        OptionPane.showConfirmDialog(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                if ("ok".equals(actionCommand)) {
                    MiniLobbyClient.this.resign();
                }
            }
        }, this.resBundle.getProperty("lobby.question.game-resign"), this.resBundle.getProperty("lobby.question.title"), 2);
    }

    public void resign() {
        this.mycom.leaveGame(this.openGameId);
    }

    public void removeGame(int gameid) {
        Game found = null;
        for (int c = 0; c < this.games.size(); ++c) {
            Game game = (Game)this.games.get(c);
            if (gameid != game.getId()) continue;
            this.games.remove(c);
            found = game;
            break;
        }
        if (found != null) {
            this.filter(true);
        }
    }

    void filter(boolean update) {
        ViewChooser box = (ViewChooser)this.loader.find("listView");
        List newGameList = this.filter(this.games, box.getSelectedItem().getKey());
        Object selected = this.gameList.getSelectedValue();
        int visIndex = this.gameList.getFirstVisibleIndex();
        Object visItem = visIndex >= 0 && visIndex < this.gameList.getSize() ? this.gameList.getElementAt(visIndex) : null;
        this.gameList.setListData(JavaCompatUtil.asVector(newGameList));
        if (update) {
            int newIndex;
            if (selected != null && (newIndex = Collections.binarySearch(newGameList, selected)) >= 0) {
                this.gameList.setSelectedIndex(newIndex);
            }
            if (visItem != null) {
                Component view = ((ScrollPane)DesktopPane.getAncestorOfClass(ScrollPane.class, this.gameList)).getView();
                int newIndex2 = Collections.binarySearch(newGameList, visItem);
                if (newIndex2 > visIndex) {
                    view.setLocation(view.getX(), view.getY() - this.gameList.getFixedCellHeight());
                } else if (newIndex2 < visIndex) {
                    view.setLocation(view.getX(), view.getY() + this.gameList.getFixedCellHeight());
                }
            }
        } else {
            this.gameList.setSelectedIndex(-1);
            if (this.gameList.getSize() > 0) {
                this.gameList.ensureIndexIsVisible(0);
            }
        }
        this.getRoot().revalidate();
        this.getRoot().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List filter(List list, String filter) {
        List list2 = list;
        synchronized (list2) {
            if ("all".equals(filter)) {
                return new Vector(list);
            }
            Vector<Game> result = new Vector<Game>();
            for (int c = 0; c < list.size(); ++c) {
                Game game = (Game)list.get(c);
                if ("my".equals(filter)) {
                    if (!game.hasPlayer(this.myusername)) continue;
                    result.add(game);
                    continue;
                }
                if ("open".equals(filter)) {
                    if (game.getNumOfPlayers() >= game.getMaxPlayers()) continue;
                    result.add(game);
                    continue;
                }
                if (!"running".equals(filter) || game.getNumOfPlayers() != game.getMaxPlayers()) continue;
                result.add(game);
            }
            return result;
        }
    }

    public void gameStarted(int id) {
        this.game.gameStarted(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageForGame(int gameid, Object message) {
        if (gameid == this.openGameId) {
            if (message instanceof String) {
                String string = (String)message;
                if (string.equals("LOBBY_GAMEOVER")) return;
                this.game.stringForGame(string);
                return;
            }
            if (!(message instanceof byte[])) throw new RuntimeException("unknown object " + message);
            Object object = null;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream((byte[])message);
                ObjectInputStream oin = new ObjectInputStream(in);
                object = oin.readObject();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "serialization error for game: " + gameid, ex);
                this.error("unable to open game " + gameid + ": " + ex);
                this.closeGame();
            }
            catch (StackOverflowError error) {
                logger.log(Level.WARNING, "serialization StackOverflowError for game: " + gameid, error);
                this.error("device unable to open large game " + gameid + ": " + error);
                this.closeGame();
            }
            this.game.objectForGame(object);
            return;
        }
        logger.info("we got a message for game " + gameid + " but our game is " + this.openGameId);
    }

    public void addPlayer(int roomid, Player player) {
        if (roomid == this.openGameId) {
            this.game.addSpectator(player);
        }
    }

    public void removePlayer(int roomid, String player) {
        if (roomid == this.openGameId) {
            this.game.removeSpectator(player);
        }
    }

    public void renamePlayer(String oldname, String newname, int newtype) {
        this.game.renameSpectator(oldname, newname, newtype);
    }

    public void incomingChat(String fromwho, String message) {
        if (this.openGameId == -1) {
            MiniLobbyClient.toast(fromwho == null ? message : fromwho + ": " + message);
        } else {
            this.game.showMessage(fromwho, message);
        }
    }

    public void incomingChat(int roomid, String fromwho, String message) {
        if (this.openGameId == roomid) {
            if (fromwho != null) {
                if (this.chatMessages.size() >= 4) {
                    this.chatMessages.remove();
                }
                this.chatMessages.add(fromwho + ": " + message);
            }
            this.game.showMessage(fromwho, message);
        }
    }

    public Game getCurrentOpenGame() {
        if (this.openGameId == -1) {
            return null;
        }
        for (int c = 0; c < this.games.size(); ++c) {
            Game game = (Game)this.games.get(c);
            if (game.getId() != this.openGameId) continue;
            return game;
        }
        throw new IllegalStateException(this.openGameId + " not found in " + this.games);
    }

    public void privateMessage(String fromwho, String message) {
    }

    public void ping(long time) {
    }

    public void addPlayer(Player player) {
    }

    public void removePlayer(String player) {
    }

    public void setUserInfo(String user, List info) {
    }

    static void notify(Game game, boolean onlyBackground) {
        String title = game.getType().getName();
        String message = "It is your go: " + game.getName();
        int gameId = game.getId();
        String options = game.getOptions();
        String icon = "icon";
        Application.openURL("notify://dummyServer?title=" + Url.encode(title) + "&message=" + Url.encode(message) + "&icon=" + Url.encode(icon) + "&onlyBackground=" + onlyBackground + "&" + Url.encode("gameId") + "=" + Url.encode(String.valueOf(gameId)) + "&" + Url.encode("options") + "=" + Url.encode(options));
    }

    public static void toast(String message) {
        if (Display.getDisplay(Application.getInstance()).getCurrent() != null) {
            if (Application.getPlatform() == 10) {
                Application.openURL("toast://show?message=" + Url.encode(message));
            } else {
                DesktopPane.getDesktopPane().toast(message);
            }
        }
    }

    public static String getLastLines(String input, int lines) {
        int firstChar = 0;
        int currentEndOfLine = input.length();
        for (int i = 0; i < lines; ++i) {
            currentEndOfLine = input.lastIndexOf("\n", currentEndOfLine - 1);
            firstChar = currentEndOfLine + 1;
        }
        return input.substring(firstChar, input.length());
    }
}

