/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.UIManager;
import net.yura.grasshopper.info.ScreenShot;
import net.yura.grasshopper.submitter.BugSubmitter;

public class BugUIInfo {
    public static void uncaughtException(Thread t, Throwable e, Thread.UncaughtExceptionHandler system) {
    }

    public static String getLookAndFeel() {
        String commandLine;
        String info = "LookAndFeel=";
        try {
            info = info + UIManager.getLookAndFeel().toString();
        }
        catch (Throwable th) {
            info = info + th.toString();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        info = info + "\nScreenResolution=" + toolkit.getScreenResolution();
        info = info + "\nScreenSize=" + toolkit.getScreenSize();
        info = info + "\nMaximumWindowBounds=" + graphicsEnvironment.getMaximumWindowBounds();
        info = info + "\nCenterPoint=" + graphicsEnvironment.getCenterPoint();
        info = info + "\nScreenInsets=" + toolkit.getScreenInsets(graphicsConfiguration);
        info = info + "\nBounds=" + graphicsConfiguration.getBounds();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        for (int c = 0; c < graphicsDevices.length; ++c) {
            GraphicsConfiguration gc = graphicsDevices[c].getDefaultConfiguration();
            DisplayMode displayMode = graphicsDevices[c].getDisplayMode();
            info = info + "\nGraphicsDevice[" + c + "].IDstring=" + graphicsDevices[c].getIDstring();
            info = info + "\nGraphicsDevice[" + c + "].Type=" + graphicsDevices[c].getType();
            info = info + "\nGraphicsDevice[" + c + "].Bounds=" + gc.getBounds();
            info = info + "\nGraphicsDevice[" + c + "].ScreenInsets=" + toolkit.getScreenInsets(gc);
            info = info + "\nGraphicsDevice[" + c + "].DisplayChangeSupported=" + graphicsDevices[c].isDisplayChangeSupported();
            info = info + "\nGraphicsDevice[" + c + "].FullScreenSupported=" + graphicsDevices[c].isFullScreenSupported();
            info = info + "\nGraphicsDevice[" + c + "].PixelSize=" + gc.getColorModel().getPixelSize();
            info = info + "\nGraphicsDevice[" + c + "].RefreshRate=" + displayMode.getRefreshRate();
        }
        try {
            Mixer.Info[] devices = AudioSystem.getMixerInfo();
            Line.Info sourceInfo = new Line.Info(SourceDataLine.class);
            for (int i = 0; i < devices.length; ++i) {
                info = info + "\nmixer " + i + ": " + AudioSystem.getMixer(devices[i]).isLineSupported(sourceInfo) + " " + devices[i];
            }
        }
        catch (Throwable th) {
            info = info + "\ngetMixerInfo Error: " + th;
        }
        try {
            try {
                Class<?> phClass = Class.forName("java.lang.ProcessHandle");
                Class[] noClass = new Class[]{};
                Object[] noObject = new Object[]{};
                Object phInfo = phClass.getMethod("info", noClass).invoke(phClass.getMethod("current", noClass).invoke(null, noObject), noObject);
                Optional myCommandLine = (Optional)Class.forName("java.lang.ProcessHandle$Info").getMethod("commandLine", noClass).invoke(phInfo, noObject);
                if (!myCommandLine.isPresent()) {
                    throw new Exception("not present");
                }
                commandLine = myCommandLine.get().toString();
            }
            catch (Throwable th) {
                List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
                commandLine = args.toString();
            }
        }
        catch (Throwable th) {
            commandLine = th.toString();
        }
        info = info + "\ncommandLine: " + commandLine;
        return info;
    }

    public static ScreenShot[] getFrames() {
        Window[] frames;
        try {
            frames = Window.getWindows();
        }
        catch (Throwable th) {
            frames = Frame.getFrames();
        }
        Vector<ScreenShot> images = new Vector<ScreenShot>();
        for (int c = 0; c < frames.length; ++c) {
            Window frame = frames[c];
            if (!frame.isVisible()) continue;
            ScreenShot ss = new ScreenShot();
            images.add(ss);
            try {
                BufferedImage img = new BufferedImage(frame.getWidth(), frame.getHeight(), 4);
                try {
                    Graphics g = img.getGraphics();
                    frame.paintAll(g);
                    g.dispose();
                }
                catch (Throwable th) {
                    ss.setError(BugSubmitter.getStackTrace(th));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "PNG", out);
                ss.setEncodedData(out.toByteArray());
                ss.setFileType("png");
                continue;
            }
            catch (Throwable ex) {
                ss.setError(BugSubmitter.getStackTrace(ex));
            }
        }
        return images.toArray(new ScreenShot[images.size()]);
    }
}

