/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.submitter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogRecord;
import net.yura.grasshopper.info.ApplicationInfoProvider;
import net.yura.grasshopper.info.BugSystemInfo;
import net.yura.grasshopper.info.LogText;
import net.yura.grasshopper.submitter.BugSubmitterMultipart;
import net.yura.grasshopper.util.LimitedOutputStream;

public class BugSubmitter {
    public static final String TF_MAIL_URL;
    public static final String FORM_MAIL_URL;
    public static final String RECIPIENT;
    static ApplicationInfoProvider extraInfoProvider;
    private static final int MAX_PAYLOAD_SIZE = 1000000;

    private static String getSetting(Properties prop, String name) throws Exception {
        String result = prop.getProperty(name);
        if (result == null) {
            throw new Exception("can not get setting for: " + name);
        }
        return result;
    }

    public static void setApplicationInfoProvider(ApplicationInfoProvider aip) {
        extraInfoProvider = aip;
    }

    public static boolean shouldIgnoreError(LogRecord lrcd) {
        return extraInfoProvider != null && extraInfoProvider.ignoreError(lrcd);
    }

    public static String generateSubject(String errorSignature) {
        return "GRASSHOPPER " + BugSystemInfo.appName + " " + BugSystemInfo.version + " - " + errorSignature;
    }

    public static void submitBug(Object log, String errorSignature) {
        BugSubmitter.submitBug(log, null, errorSignature);
    }

    public static boolean submitBug(Object log, String email, String errorSignature) {
        return BugSubmitter.submitBug(log, email, BugSubmitter.generateSubject(errorSignature), errorSignature, BugSystemInfo.appName, BugSystemInfo.version, BugSystemInfo.locale);
    }

    public static boolean submitBug(Object log, String email, String subject, String errorSignature, String appName, String version, String locale) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (extraInfoProvider != null) {
            try {
                extraInfoProvider.addInfoForSubmit(map);
            }
            catch (Throwable th) {
                map.put("appInfoProviderError", BugSubmitter.getStackTrace(th));
            }
        }
        if (log instanceof Map) {
            map.putAll((Map)log);
        } else {
            map.put("log", log == null ? "null" : log);
        }
        map.put("appName", String.valueOf(appName));
        map.put("appVersion", String.valueOf(version));
        map.put("appLocale", String.valueOf(locale));
        map.put("grasshopperVersion", "2.15");
        map.putAll(BugSystemInfo.addSystemInfo());
        if (!map.containsKey("recipient")) {
            map.put("recipient", RECIPIENT);
        }
        map.put("subject", subject);
        if (email != null) {
            map.put("email", email);
        } else if (!map.containsKey("email")) {
            map.put("email", "no-email");
        }
        map.put("env_report", "REMOTE_HOST,HTTP_USER_AGENT");
        if (errorSignature != null) {
            map.put("errorSignature", errorSignature);
        }
        try {
            BugSubmitterMultipart.send(TF_MAIL_URL, map);
            System.out.println("[grasshopper] send ok");
            return true;
        }
        catch (Throwable th) {
            try {
                map.put("grasshopperError", BugSubmitter.getStackTrace(th));
                BugSubmitter.doPost(FORM_MAIL_URL, map);
                System.out.println("[grasshopper] send ok ish " + th);
                return true;
            }
            catch (Throwable th2) {
                System.out.println("[grasshopper] errors sending: " + th + " AND " + th2);
                return false;
            }
        }
    }

    public static String getStackTrace(Throwable th) {
        StringWriter error = new StringWriter();
        th.printStackTrace(new PrintWriter(error));
        return error.toString();
    }

    public static void doPost(String url, Map map) throws IOException {
        String line;
        URLConnection conn = new URL(url).openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new LimitedOutputStream(conn.getOutputStream(), 1000000L), "UTF-8");
        BugSubmitter.doPost(wr, map);
        wr.close();
        int code = 200;
        if (conn instanceof HttpURLConnection) {
            code = ((HttpURLConnection)conn).getResponseCode();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
        }
        rd.close();
        if (code / 100 != 2) {
            throw new IOException("http error " + code);
        }
    }

    public static void doPost(OutputStreamWriter getpostb, Map map) throws IOException {
        boolean firstDone = false;
        Iterator enu = BugSubmitter.getKeysLogTextLast(map).iterator();
        while (enu.hasNext()) {
            if (firstDone) {
                getpostb.append("&");
            } else {
                firstDone = true;
            }
            Object key = enu.next();
            getpostb.append(URLEncoder.encode(String.valueOf(key), "UTF-8"));
            getpostb.append("=");
            Object object = map.get(key);
            if (object instanceof LogText) {
                String line;
                while ((line = ((LogText)object).readLine()) != null) {
                    getpostb.append(URLEncoder.encode(line + "<br>\n", "UTF-8"));
                }
                continue;
            }
            String value = String.valueOf(object);
            value = value.replaceAll("\\n|\\r\\n", "<br>$0");
            getpostb.append(URLEncoder.encode(value, "UTF-8"));
        }
    }

    public static List getKeysLogTextLast(final Map map) {
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys, new Comparator(){

            public int compare(Object key1, Object key2) {
                if ("log".equals(key1) && !"log".equals(key2)) {
                    return 1;
                }
                if ("log".equals(key2) && !"log".equals(key1)) {
                    return -1;
                }
                Object value1 = map.get(key1);
                Object value2 = map.get(key2);
                if (value1 instanceof LogText && !(value2 instanceof LogText)) {
                    return 1;
                }
                if (value2 instanceof LogText && !(value1 instanceof LogText)) {
                    return -1;
                }
                return String.valueOf(key1).compareTo(String.valueOf(key2));
            }
        });
        return keys;
    }

    static {
        Properties settings = new Properties();
        String fileName = "/grasshopper.properties";
        InputStream settingsData = BugSubmitter.class.getResourceAsStream(fileName);
        try {
            settings.load(settingsData);
            TF_MAIL_URL = BugSubmitter.getSetting(settings, "url.tfMail");
            FORM_MAIL_URL = BugSubmitter.getSetting(settings, "url.formMail");
            RECIPIENT = BugSubmitter.getSetting(settings, "recipient");
        }
        catch (Exception ex) {
            ExceptionInInitializerError err = new ExceptionInInitializerError("can not load grasshopper settings from: " + fileName);
            err.initCause(ex);
            throw err;
        }
        finally {
            try {
                if (settingsData != null) {
                    settingsData.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

