/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends FilterOutputStream {
    private final long maxBytes;
    private long bytesWritten;

    public LimitedOutputStream(OutputStream out, long maxBytes) {
        super(out);
        this.maxBytes = maxBytes;
    }

    public void write(int b) throws IOException {
        if (this.ensureCapacity(1) > 0) {
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        int canWrite = this.ensureCapacity(b.length);
        if (canWrite == b.length) {
            this.out.write(b);
        } else {
            this.out.write(b, 0, canWrite);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, this.ensureCapacity(len));
    }

    private int ensureCapacity(int len) throws IOException {
        long newBytesWritten = this.bytesWritten + (long)len;
        if (newBytesWritten > this.maxBytes) {
            this.bytesWritten = this.maxBytes;
            return len - (int)(newBytesWritten - this.bytesWritten);
        }
        this.bytesWritten = newBytesWritten;
        return len;
    }
}

