/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TailOutputStream
extends FilterOutputStream {
    private final long skipBytes;
    private long bytesWritten;

    public TailOutputStream(OutputStream out, long skipBytes) {
        super(out);
        this.skipBytes = skipBytes;
    }

    public void write(int b) throws IOException {
        if (this.skipCapacity(1) == 0) {
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        int skip = this.skipCapacity(b.length);
        if (skip == 0) {
            this.out.write(b);
        } else {
            this.out.write(b, skip, b.length - skip);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int skip = this.skipCapacity(len);
        this.out.write(b, off + skip, len - skip);
    }

    private int skipCapacity(int len) throws IOException {
        long newBytesWritten = this.bytesWritten + (long)len;
        if (newBytesWritten > this.skipBytes) {
            this.bytesWritten = this.skipBytes;
            return len - (int)(newBytesWritten - this.bytesWritten);
        }
        this.bytesWritten = newBytesWritten;
        return len;
    }
}

