/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.util;

import java.io.IOException;
import java.io.OutputStream;
import net.yura.grasshopper.util.TailOutputStream;
import org.apache.http.entity.mime.content.ContentBody;

public class TruncatedContentBody
implements ContentBody {
    private final ContentBody body;
    private final long bytesToSkip;

    public TruncatedContentBody(ContentBody body, long bytesToSkip) {
        this.body = body;
        this.bytesToSkip = bytesToSkip;
        if (bytesToSkip >= body.getContentLength()) {
            throw new IllegalArgumentException("skipping " + bytesToSkip + " for " + body);
        }
    }

    public long getContentLength() {
        return this.body.getContentLength() - this.bytesToSkip;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.body.writeTo(new TailOutputStream(out, this.bytesToSkip));
    }

    public String getFilename() {
        return this.body.getFilename();
    }

    public String getCharset() {
        return this.body.getCharset();
    }

    public String getTransferEncoding() {
        return this.body.getTransferEncoding();
    }

    public String getMimeType() {
        return this.body.getMimeType();
    }

    public String getMediaType() {
        return this.body.getMediaType();
    }

    public String getSubType() {
        return this.body.getSubType();
    }
}

