/*
 * Decompiled with CFR 0.152.
 */
package collisionphysics;

import collisionphysics.Ball;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Country;
import net.yura.domination.guishared.MapPanel;

public class BallWorld
implements Runnable {
    private static final int UPDATE_RATE = 30;
    private static final float EPSILON_TIME = 0.01f;
    int[] box = new int[2];
    MapPanel panel;
    public Ball[] balls;
    boolean running;

    public BallWorld(Risk risk, MapPanel panel, int r) {
        Country[] v = risk.getGame().getCountries();
        int currentNumBalls = v.length;
        this.panel = panel;
        this.box[0] = panel.getMapWidth();
        this.box[1] = panel.getMapHeight();
        this.balls = new Ball[currentNumBalls];
        for (int c = 0; c < v.length; ++c) {
            this.balls[c] = new Ball(v[c].getX(), v[c].getY(), r, 2.0f, 270.0f);
        }
        this.running = true;
        new Thread(this).start();
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            long beginTimeMillis = System.currentTimeMillis();
            this.gameUpdate();
            this.panel.repaint();
            long timeTakenMillis = System.currentTimeMillis() - beginTimeMillis;
            long timeLeftMillis = 33L - timeTakenMillis;
            if (timeLeftMillis < 5L) {
                timeLeftMillis = 5L;
            }
            try {
                Thread.sleep(timeLeftMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void gameUpdate() {
        float tMin;
        int currentNumBalls = this.balls.length;
        float timeLeft = 1.0f;
        do {
            int i;
            tMin = timeLeft;
            for (i = 0; i < currentNumBalls; ++i) {
                for (int j = 0; j < currentNumBalls; ++j) {
                    if (i >= j) continue;
                    this.balls[i].intersect(this.balls[j], tMin);
                    if (!(this.balls[i].earliestCollisionResponse.t < tMin)) continue;
                    tMin = this.balls[i].earliestCollisionResponse.t;
                }
            }
            for (i = 0; i < currentNumBalls; ++i) {
                this.balls[i].intersect(this.box, tMin);
                if (!(this.balls[i].earliestCollisionResponse.t < tMin)) continue;
                tMin = this.balls[i].earliestCollisionResponse.t;
            }
            for (i = 0; i < currentNumBalls; ++i) {
                this.balls[i].update(tMin);
            }
        } while ((timeLeft -= tMin) > 0.01f);
    }
}

